% Performance Bounds and Suboptimal Policies for Multi-Period Investment 
% by Stephen Boyd, Mark T. Mueller, Brendan O'Donoghue, Yang Wang

% loads the data from 'data.mat' and performs
% the Monte Carlo simulations to estimate
% robustness to perturbations in the asset mean vector
% saves results to 'bump_data.mat'

% run this AFTER solving SDP

fprintf('*** Starting Monte Carlo perturbation simulations. ***\n')
fprintf('This can take up to an hour or more, depending on your machine.\n')
fprintf('You can run this with a different number of simulations by changing NUM_SIMULATIONS or NUM_PERTURBATIONS in the script.\n')
fprintf('The results are saved to bump_data.mat.\n')

clear data
load data
NUM_SIMULATIONS=5000 % change this to run different num of simuations per perturbation
N1=NUM_SIMULATIONS;

NUM_PERTURBATIONS=10 % total perturbations
tot_sim = NUM_PERTURBATIONS;

fprintf('\nStarting %i perturbations\n',tot_sim);

save_on=1; % set to 1 to save to bump_data.mat

randn('seed',1);rand('seed',1);

mu_nom=mu; % nominal log return means

out_cs=[];bumps=[];

for j=1:tot_sim
    fprintf('running perturbation %i \n',j);
    costs=zeros(N1,1);ts=0;
    %%%%%%%%
    su=costs;cash=costs;risk=costs;tot=costs;
    short=costs;quad=costs;abs_c=costs;short_pos=costs;
    long_pos=costs;tot_pos=costs;pos_val=costs;
    %%%%%%%%
    % perturb the asset returns:
    bump_fact=0.1;
    bump = bump_fact*0.03*(2*rand(n,1)-1);
    mu=mu_nom+bump;
    
    for i=1:N1
        if mod(i,1000)==0
            if save_on
                save bump_data;
            end
        end
        cs=0;
        %%%%%%%%
        su_t=0;cash_t=0;risk_t=0;tot_t=0;
        short_t=0;quad_t=0;abs_c_t=0;short_pos_t=0;
        long_pos_t=0;tot_pos_t=0;pos_val_t=0;
        %%%%%%%%
        
        x=x_init;
        
        for t=1:T
            params.x = x;
            if (t==T)
                u=x_term-x;% terminal portfolio condition
            else
                % apply optimal controller
                tic;
                u=J(:,:,t)*x+k(:,t);
                ts=ts+toc;
            end
            %%%%%%
            su_t=su_t+sum(u); % gross difference between asset sales and purchases
            cash_t=cash_t+sum(u) + sh'*pos(-x-u)+ kappa'*abs(u) + s'*u.^2; % gross cash
            short_t=short_t+sh'*pos(-x-u); % shorting cost
            quad_t=quad_t+s'*u.^2; % quadratic transaction cost
            abs_c_t=abs_c_t+kappa'*abs(u); % absolute value transaction cost
            risk_t=risk_t+lambda*(x+u)'*sigma*(x+u); % risk penalty fee
            tot_t=tot_t+sum(u) + sh'*pos(-x-u)+ kappa'*abs(u) + s'*u.^2 + lambda*(x+u)'*sigma*(x+u); % net cash
            short_pos_t=short_pos_t+sum(pos(-x-u)); % short position
            long_pos_t=long_pos_t+sum(pos(x+u)); % long position
            tot_pos_t=tot_pos_t+norm(x+u,1); % total position
            pos_val_t=pos_val_t+sum(x+u); % net value of portfolio
            %%%%%%
            cs=cs+(sum(u) + s'*u.^2 + lambda*(x+u)'*sigma*(x+u));
            % propagate the portfolio to next period:
            x=diag(exp(rt_Sigma_t*randn(n,1)+mu))*(x+u);
        end
        costs(i) = cs;
        %%%%%%%
        su(i)=su_t;cash(i)=cash_t;risk(i)=risk_t;tot(i)=tot_t;
        short(i)=short_t;quad(i)=quad_t;abs_c(i)=abs_c_t;short_pos(i)=short_pos_t;
        long_pos(i)=long_pos_t;tot_pos(i)=tot_pos_t;pos_val(i)=pos_val_t;
        %%%%%%%
    end
    out_cs = [out_cs costs];
    bumps=[bumps bump];
    if save_on
        save bump_data;
    end
end
if save_on
    save_on=0
    save bump_data;
end