/* Produced by CVXGEN, 2011-12-13 19:33:04 -0800.  */
/* CVXGEN is Copyright (C) 2006-2011 Jacob Mattingley, jem@cvxgen.com. */
/* The code in this file is Copyright (C) 2006-2011 Jacob Mattingley. */
/* CVXGEN, or solvers produced by CVXGEN, cannot be used for commercial */
/* applications without prior written permission from Jacob Mattingley. */

/* Filename: testsolver.c. */
/* Description: Basic test harness for solver.c. */

#include "solver.h"

Vars vars;
Params params;
Workspace work;
Settings settings;
#define NUMTESTS 0

int main(int argc, char **argv) {
  int num_iters;
#if (NUMTESTS > 0)
  int i;
  double time;
  double time_per;
#endif

  set_defaults();
  setup_indexing();
  load_default_data();

  /* Solve problem instance for the record. */
  settings.verbose = 1;
  num_iters = solve();

#ifndef ZERO_LIBRARY_MODE
#if (NUMTESTS > 0)
  /* Now solve multiple problem instances for timing purposes. */
  settings.verbose = 0;

  tic();
  for (i = 0; i < NUMTESTS; i++) {
    solve();
  }
  time = tocq();

  printf("Timed %d solves over %.3f seconds.\n", NUMTESTS, time);
  time_per = time / NUMTESTS;

  if (time_per > 1) {
    printf("Actual time taken per solve: %.3g s.\n", time_per);
  } else if (time_per > 1e-3) {
    printf("Actual time taken per solve: %.3g ms.\n", 1e3*time_per);
  } else {
    printf("Actual time taken per solve: %.3g us.\n", 1e6*time_per);
  }
#endif
#endif

  return 0;
}

void load_default_data(void) {
  params.S[0] = 1.55079790257458;
  params.S[1] = 1.7081478226181;
  params.S[2] = 1.29090473891294;
  params.S[3] = 1.51082760519766;
  params.S[4] = 1.89294695434765;
  params.S[5] = 1.89629308893344;
  params.S[6] = 1.12558531046384;
  params.S[7] = 1.20724287813819;
  params.S[8] = 1.05146720330083;
  params.S[9] = 1.44080984365064;
  params.S[10] = 1.02987621087857;
  params.S[11] = 1.45683322439471;
  params.S[12] = 1.64914404761476;
  params.S[13] = 1.27848728264798;
  params.S[14] = 1.67625490198013;
  params.S[15] = 1.59086281741635;
  params.S[16] = 1.02398188237717;
  params.S[17] = 1.55885408799088;
  params.S[18] = 1.25925244690747;
  params.S[19] = 1.41510119701007;
  params.S[20] = 1.28352508177132;
  params.S[21] = 1.693137918313;
  params.S[22] = 1.44045371767074;
  params.S[23] = 1.15686773847496;
  params.S[24] = 1.54464901803184;
  params.S[25] = 1.78031476451137;
  params.S[26] = 1.30636353237618;
  params.S[27] = 1.22195788393218;
  params.S[28] = 1.38797125755565;
  params.S[29] = 1.93638364986043;
  params.lambda[0] = 1.95199084494587;
  /* Make this a diagonal PSD matrix, even though it's not diagonal. */
  params.Sigma[0] = 1.67238367591281;
  params.Sigma[30] = 0;
  params.Sigma[60] = 0;
  params.Sigma[90] = 0;
  params.Sigma[120] = 0;
  params.Sigma[150] = 0;
  params.Sigma[180] = 0;
  params.Sigma[210] = 0;
  params.Sigma[240] = 0;
  params.Sigma[270] = 0;
  params.Sigma[300] = 0;
  params.Sigma[330] = 0;
  params.Sigma[360] = 0;
  params.Sigma[390] = 0;
  params.Sigma[420] = 0;
  params.Sigma[450] = 0;
  params.Sigma[480] = 0;
  params.Sigma[510] = 0;
  params.Sigma[540] = 0;
  params.Sigma[570] = 0;
  params.Sigma[600] = 0;
  params.Sigma[630] = 0;
  params.Sigma[660] = 0;
  params.Sigma[690] = 0;
  params.Sigma[720] = 0;
  params.Sigma[750] = 0;
  params.Sigma[780] = 0;
  params.Sigma[810] = 0;
  params.Sigma[840] = 0;
  params.Sigma[870] = 0;
  params.Sigma[1] = 0;
  params.Sigma[31] = 1.9028341085384;
  params.Sigma[61] = 0;
  params.Sigma[91] = 0;
  params.Sigma[121] = 0;
  params.Sigma[151] = 0;
  params.Sigma[181] = 0;
  params.Sigma[211] = 0;
  params.Sigma[241] = 0;
  params.Sigma[271] = 0;
  params.Sigma[301] = 0;
  params.Sigma[331] = 0;
  params.Sigma[361] = 0;
  params.Sigma[391] = 0;
  params.Sigma[421] = 0;
  params.Sigma[451] = 0;
  params.Sigma[481] = 0;
  params.Sigma[511] = 0;
  params.Sigma[541] = 0;
  params.Sigma[571] = 0;
  params.Sigma[601] = 0;
  params.Sigma[631] = 0;
  params.Sigma[661] = 0;
  params.Sigma[691] = 0;
  params.Sigma[721] = 0;
  params.Sigma[751] = 0;
  params.Sigma[781] = 0;
  params.Sigma[811] = 0;
  params.Sigma[841] = 0;
  params.Sigma[871] = 0;
  params.Sigma[2] = 0;
  params.Sigma[32] = 0;
  params.Sigma[62] = 1.84575087129318;
  params.Sigma[92] = 0;
  params.Sigma[122] = 0;
  params.Sigma[152] = 0;
  params.Sigma[182] = 0;
  params.Sigma[212] = 0;
  params.Sigma[242] = 0;
  params.Sigma[272] = 0;
  params.Sigma[302] = 0;
  params.Sigma[332] = 0;
  params.Sigma[362] = 0;
  params.Sigma[392] = 0;
  params.Sigma[422] = 0;
  params.Sigma[452] = 0;
  params.Sigma[482] = 0;
  params.Sigma[512] = 0;
  params.Sigma[542] = 0;
  params.Sigma[572] = 0;
  params.Sigma[602] = 0;
  params.Sigma[632] = 0;
  params.Sigma[662] = 0;
  params.Sigma[692] = 0;
  params.Sigma[722] = 0;
  params.Sigma[752] = 0;
  params.Sigma[782] = 0;
  params.Sigma[812] = 0;
  params.Sigma[842] = 0;
  params.Sigma[872] = 0;
  params.Sigma[3] = 0;
  params.Sigma[33] = 0;
  params.Sigma[63] = 0;
  params.Sigma[93] = 1.37799404132889;
  params.Sigma[123] = 0;
  params.Sigma[153] = 0;
  params.Sigma[183] = 0;
  params.Sigma[213] = 0;
  params.Sigma[243] = 0;
  params.Sigma[273] = 0;
  params.Sigma[303] = 0;
  params.Sigma[333] = 0;
  params.Sigma[363] = 0;
  params.Sigma[393] = 0;
  params.Sigma[423] = 0;
  params.Sigma[453] = 0;
  params.Sigma[483] = 0;
  params.Sigma[513] = 0;
  params.Sigma[543] = 0;
  params.Sigma[573] = 0;
  params.Sigma[603] = 0;
  params.Sigma[633] = 0;
  params.Sigma[663] = 0;
  params.Sigma[693] = 0;
  params.Sigma[723] = 0;
  params.Sigma[753] = 0;
  params.Sigma[783] = 0;
  params.Sigma[813] = 0;
  params.Sigma[843] = 0;
  params.Sigma[873] = 0;
  params.Sigma[4] = 0;
  params.Sigma[34] = 0;
  params.Sigma[64] = 0;
  params.Sigma[94] = 0;
  params.Sigma[124] = 1.09221700887172;
  params.Sigma[154] = 0;
  params.Sigma[184] = 0;
  params.Sigma[214] = 0;
  params.Sigma[244] = 0;
  params.Sigma[274] = 0;
  params.Sigma[304] = 0;
  params.Sigma[334] = 0;
  params.Sigma[364] = 0;
  params.Sigma[394] = 0;
  params.Sigma[424] = 0;
  params.Sigma[454] = 0;
  params.Sigma[484] = 0;
  params.Sigma[514] = 0;
  params.Sigma[544] = 0;
  params.Sigma[574] = 0;
  params.Sigma[604] = 0;
  params.Sigma[634] = 0;
  params.Sigma[664] = 0;
  params.Sigma[694] = 0;
  params.Sigma[724] = 0;
  params.Sigma[754] = 0;
  params.Sigma[784] = 0;
  params.Sigma[814] = 0;
  params.Sigma[844] = 0;
  params.Sigma[874] = 0;
  params.Sigma[5] = 0;
  params.Sigma[35] = 0;
  params.Sigma[65] = 0;
  params.Sigma[95] = 0;
  params.Sigma[125] = 0;
  params.Sigma[155] = 1.65341090252354;
  params.Sigma[185] = 0;
  params.Sigma[215] = 0;
  params.Sigma[245] = 0;
  params.Sigma[275] = 0;
  params.Sigma[305] = 0;
  params.Sigma[335] = 0;
  params.Sigma[365] = 0;
  params.Sigma[395] = 0;
  params.Sigma[425] = 0;
  params.Sigma[455] = 0;
  params.Sigma[485] = 0;
  params.Sigma[515] = 0;
  params.Sigma[545] = 0;
  params.Sigma[575] = 0;
  params.Sigma[605] = 0;
  params.Sigma[635] = 0;
  params.Sigma[665] = 0;
  params.Sigma[695] = 0;
  params.Sigma[725] = 0;
  params.Sigma[755] = 0;
  params.Sigma[785] = 0;
  params.Sigma[815] = 0;
  params.Sigma[845] = 0;
  params.Sigma[875] = 0;
  params.Sigma[6] = 0;
  params.Sigma[36] = 0;
  params.Sigma[66] = 0;
  params.Sigma[96] = 0;
  params.Sigma[126] = 0;
  params.Sigma[156] = 0;
  params.Sigma[186] = 1.55784076238845;
  params.Sigma[216] = 0;
  params.Sigma[246] = 0;
  params.Sigma[276] = 0;
  params.Sigma[306] = 0;
  params.Sigma[336] = 0;
  params.Sigma[366] = 0;
  params.Sigma[396] = 0;
  params.Sigma[426] = 0;
  params.Sigma[456] = 0;
  params.Sigma[486] = 0;
  params.Sigma[516] = 0;
  params.Sigma[546] = 0;
  params.Sigma[576] = 0;
  params.Sigma[606] = 0;
  params.Sigma[636] = 0;
  params.Sigma[666] = 0;
  params.Sigma[696] = 0;
  params.Sigma[726] = 0;
  params.Sigma[756] = 0;
  params.Sigma[786] = 0;
  params.Sigma[816] = 0;
  params.Sigma[846] = 0;
  params.Sigma[876] = 0;
  params.Sigma[7] = 0;
  params.Sigma[37] = 0;
  params.Sigma[67] = 0;
  params.Sigma[97] = 0;
  params.Sigma[127] = 0;
  params.Sigma[157] = 0;
  params.Sigma[187] = 0;
  params.Sigma[217] = 1.36156476306258;
  params.Sigma[247] = 0;
  params.Sigma[277] = 0;
  params.Sigma[307] = 0;
  params.Sigma[337] = 0;
  params.Sigma[367] = 0;
  params.Sigma[397] = 0;
  params.Sigma[427] = 0;
  params.Sigma[457] = 0;
  params.Sigma[487] = 0;
  params.Sigma[517] = 0;
  params.Sigma[547] = 0;
  params.Sigma[577] = 0;
  params.Sigma[607] = 0;
  params.Sigma[637] = 0;
  params.Sigma[667] = 0;
  params.Sigma[697] = 0;
  params.Sigma[727] = 0;
  params.Sigma[757] = 0;
  params.Sigma[787] = 0;
  params.Sigma[817] = 0;
  params.Sigma[847] = 0;
  params.Sigma[877] = 0;
  params.Sigma[8] = 0;
  params.Sigma[38] = 0;
  params.Sigma[68] = 0;
  params.Sigma[98] = 0;
  params.Sigma[128] = 0;
  params.Sigma[158] = 0;
  params.Sigma[188] = 0;
  params.Sigma[218] = 0;
  params.Sigma[248] = 1.22505450483983;
  params.Sigma[278] = 0;
  params.Sigma[308] = 0;
  params.Sigma[338] = 0;
  params.Sigma[368] = 0;
  params.Sigma[398] = 0;
  params.Sigma[428] = 0;
  params.Sigma[458] = 0;
  params.Sigma[488] = 0;
  params.Sigma[518] = 0;
  params.Sigma[548] = 0;
  params.Sigma[578] = 0;
  params.Sigma[608] = 0;
  params.Sigma[638] = 0;
  params.Sigma[668] = 0;
  params.Sigma[698] = 0;
  params.Sigma[728] = 0;
  params.Sigma[758] = 0;
  params.Sigma[788] = 0;
  params.Sigma[818] = 0;
  params.Sigma[848] = 0;
  params.Sigma[878] = 0;
  params.Sigma[9] = 0;
  params.Sigma[39] = 0;
  params.Sigma[69] = 0;
  params.Sigma[99] = 0;
  params.Sigma[129] = 0;
  params.Sigma[159] = 0;
  params.Sigma[189] = 0;
  params.Sigma[219] = 0;
  params.Sigma[249] = 0;
  params.Sigma[279] = 1.40651991637625;
  params.Sigma[309] = 0;
  params.Sigma[339] = 0;
  params.Sigma[369] = 0;
  params.Sigma[399] = 0;
  params.Sigma[429] = 0;
  params.Sigma[459] = 0;
  params.Sigma[489] = 0;
  params.Sigma[519] = 0;
  params.Sigma[549] = 0;
  params.Sigma[579] = 0;
  params.Sigma[609] = 0;
  params.Sigma[639] = 0;
  params.Sigma[669] = 0;
  params.Sigma[699] = 0;
  params.Sigma[729] = 0;
  params.Sigma[759] = 0;
  params.Sigma[789] = 0;
  params.Sigma[819] = 0;
  params.Sigma[849] = 0;
  params.Sigma[879] = 0;
  params.Sigma[10] = 0;
  params.Sigma[40] = 0;
  params.Sigma[70] = 0;
  params.Sigma[100] = 0;
  params.Sigma[130] = 0;
  params.Sigma[160] = 0;
  params.Sigma[190] = 0;
  params.Sigma[220] = 0;
  params.Sigma[250] = 0;
  params.Sigma[280] = 0;
  params.Sigma[310] = 1.46894024869917;
  params.Sigma[340] = 0;
  params.Sigma[370] = 0;
  params.Sigma[400] = 0;
  params.Sigma[430] = 0;
  params.Sigma[460] = 0;
  params.Sigma[490] = 0;
  params.Sigma[520] = 0;
  params.Sigma[550] = 0;
  params.Sigma[580] = 0;
  params.Sigma[610] = 0;
  params.Sigma[640] = 0;
  params.Sigma[670] = 0;
  params.Sigma[700] = 0;
  params.Sigma[730] = 0;
  params.Sigma[760] = 0;
  params.Sigma[790] = 0;
  params.Sigma[820] = 0;
  params.Sigma[850] = 0;
  params.Sigma[880] = 0;
  params.Sigma[11] = 0;
  params.Sigma[41] = 0;
  params.Sigma[71] = 0;
  params.Sigma[101] = 0;
  params.Sigma[131] = 0;
  params.Sigma[161] = 0;
  params.Sigma[191] = 0;
  params.Sigma[221] = 0;
  params.Sigma[251] = 0;
  params.Sigma[281] = 0;
  params.Sigma[311] = 0;
  params.Sigma[341] = 1.26923557825106;
  params.Sigma[371] = 0;
  params.Sigma[401] = 0;
  params.Sigma[431] = 0;
  params.Sigma[461] = 0;
  params.Sigma[491] = 0;
  params.Sigma[521] = 0;
  params.Sigma[551] = 0;
  params.Sigma[581] = 0;
  params.Sigma[611] = 0;
  params.Sigma[641] = 0;
  params.Sigma[671] = 0;
  params.Sigma[701] = 0;
  params.Sigma[731] = 0;
  params.Sigma[761] = 0;
  params.Sigma[791] = 0;
  params.Sigma[821] = 0;
  params.Sigma[851] = 0;
  params.Sigma[881] = 0;
  params.Sigma[12] = 0;
  params.Sigma[42] = 0;
  params.Sigma[72] = 0;
  params.Sigma[102] = 0;
  params.Sigma[132] = 0;
  params.Sigma[162] = 0;
  params.Sigma[192] = 0;
  params.Sigma[222] = 0;
  params.Sigma[252] = 0;
  params.Sigma[282] = 0;
  params.Sigma[312] = 0;
  params.Sigma[342] = 0;
  params.Sigma[372] = 1.29179277422543;
  params.Sigma[402] = 0;
  params.Sigma[432] = 0;
  params.Sigma[462] = 0;
  params.Sigma[492] = 0;
  params.Sigma[522] = 0;
  params.Sigma[552] = 0;
  params.Sigma[582] = 0;
  params.Sigma[612] = 0;
  params.Sigma[642] = 0;
  params.Sigma[672] = 0;
  params.Sigma[702] = 0;
  params.Sigma[732] = 0;
  params.Sigma[762] = 0;
  params.Sigma[792] = 0;
  params.Sigma[822] = 0;
  params.Sigma[852] = 0;
  params.Sigma[882] = 0;
  params.Sigma[13] = 0;
  params.Sigma[43] = 0;
  params.Sigma[73] = 0;
  params.Sigma[103] = 0;
  params.Sigma[133] = 0;
  params.Sigma[163] = 0;
  params.Sigma[193] = 0;
  params.Sigma[223] = 0;
  params.Sigma[253] = 0;
  params.Sigma[283] = 0;
  params.Sigma[313] = 0;
  params.Sigma[343] = 0;
  params.Sigma[373] = 0;
  params.Sigma[403] = 1.45768639932298;
  params.Sigma[433] = 0;
  params.Sigma[463] = 0;
  params.Sigma[493] = 0;
  params.Sigma[523] = 0;
  params.Sigma[553] = 0;
  params.Sigma[583] = 0;
  params.Sigma[613] = 0;
  params.Sigma[643] = 0;
  params.Sigma[673] = 0;
  params.Sigma[703] = 0;
  params.Sigma[733] = 0;
  params.Sigma[763] = 0;
  params.Sigma[793] = 0;
  params.Sigma[823] = 0;
  params.Sigma[853] = 0;
  params.Sigma[883] = 0;
  params.Sigma[14] = 0;
  params.Sigma[44] = 0;
  params.Sigma[74] = 0;
  params.Sigma[104] = 0;
  params.Sigma[134] = 0;
  params.Sigma[164] = 0;
  params.Sigma[194] = 0;
  params.Sigma[224] = 0;
  params.Sigma[254] = 0;
  params.Sigma[284] = 0;
  params.Sigma[314] = 0;
  params.Sigma[344] = 0;
  params.Sigma[374] = 0;
  params.Sigma[404] = 0;
  params.Sigma[434] = 1.86053391294693;
  params.Sigma[464] = 0;
  params.Sigma[494] = 0;
  params.Sigma[524] = 0;
  params.Sigma[554] = 0;
  params.Sigma[584] = 0;
  params.Sigma[614] = 0;
  params.Sigma[644] = 0;
  params.Sigma[674] = 0;
  params.Sigma[704] = 0;
  params.Sigma[734] = 0;
  params.Sigma[764] = 0;
  params.Sigma[794] = 0;
  params.Sigma[824] = 0;
  params.Sigma[854] = 0;
  params.Sigma[884] = 0;
  params.Sigma[15] = 0;
  params.Sigma[45] = 0;
  params.Sigma[75] = 0;
  params.Sigma[105] = 0;
  params.Sigma[135] = 0;
  params.Sigma[165] = 0;
  params.Sigma[195] = 0;
  params.Sigma[225] = 0;
  params.Sigma[255] = 0;
  params.Sigma[285] = 0;
  params.Sigma[315] = 0;
  params.Sigma[345] = 0;
  params.Sigma[375] = 0;
  params.Sigma[405] = 0;
  params.Sigma[435] = 0;
  params.Sigma[465] = 1.58625290446782;
  params.Sigma[495] = 0;
  params.Sigma[525] = 0;
  params.Sigma[555] = 0;
  params.Sigma[585] = 0;
  params.Sigma[615] = 0;
  params.Sigma[645] = 0;
  params.Sigma[675] = 0;
  params.Sigma[705] = 0;
  params.Sigma[735] = 0;
  params.Sigma[765] = 0;
  params.Sigma[795] = 0;
  params.Sigma[825] = 0;
  params.Sigma[855] = 0;
  params.Sigma[885] = 0;
  params.Sigma[16] = 0;
  params.Sigma[46] = 0;
  params.Sigma[76] = 0;
  params.Sigma[106] = 0;
  params.Sigma[136] = 0;
  params.Sigma[166] = 0;
  params.Sigma[196] = 0;
  params.Sigma[226] = 0;
  params.Sigma[256] = 0;
  params.Sigma[286] = 0;
  params.Sigma[316] = 0;
  params.Sigma[346] = 0;
  params.Sigma[376] = 0;
  params.Sigma[406] = 0;
  params.Sigma[436] = 0;
  params.Sigma[466] = 0;
  params.Sigma[496] = 1.28348786243221;
  params.Sigma[526] = 0;
  params.Sigma[556] = 0;
  params.Sigma[586] = 0;
  params.Sigma[616] = 0;
  params.Sigma[646] = 0;
  params.Sigma[676] = 0;
  params.Sigma[706] = 0;
  params.Sigma[736] = 0;
  params.Sigma[766] = 0;
  params.Sigma[796] = 0;
  params.Sigma[826] = 0;
  params.Sigma[856] = 0;
  params.Sigma[886] = 0;
  params.Sigma[17] = 0;
  params.Sigma[47] = 0;
  params.Sigma[77] = 0;
  params.Sigma[107] = 0;
  params.Sigma[137] = 0;
  params.Sigma[167] = 0;
  params.Sigma[197] = 0;
  params.Sigma[227] = 0;
  params.Sigma[257] = 0;
  params.Sigma[287] = 0;
  params.Sigma[317] = 0;
  params.Sigma[347] = 0;
  params.Sigma[377] = 0;
  params.Sigma[407] = 0;
  params.Sigma[437] = 0;
  params.Sigma[467] = 0;
  params.Sigma[497] = 0;
  params.Sigma[527] = 1.2779775066236;
  params.Sigma[557] = 0;
  params.Sigma[587] = 0;
  params.Sigma[617] = 0;
  params.Sigma[647] = 0;
  params.Sigma[677] = 0;
  params.Sigma[707] = 0;
  params.Sigma[737] = 0;
  params.Sigma[767] = 0;
  params.Sigma[797] = 0;
  params.Sigma[827] = 0;
  params.Sigma[857] = 0;
  params.Sigma[887] = 0;
  params.Sigma[18] = 0;
  params.Sigma[48] = 0;
  params.Sigma[78] = 0;
  params.Sigma[108] = 0;
  params.Sigma[138] = 0;
  params.Sigma[168] = 0;
  params.Sigma[198] = 0;
  params.Sigma[228] = 0;
  params.Sigma[258] = 0;
  params.Sigma[288] = 0;
  params.Sigma[318] = 0;
  params.Sigma[348] = 0;
  params.Sigma[378] = 0;
  params.Sigma[408] = 0;
  params.Sigma[438] = 0;
  params.Sigma[468] = 0;
  params.Sigma[498] = 0;
  params.Sigma[528] = 0;
  params.Sigma[558] = 1.45462207552195;
  params.Sigma[588] = 0;
  params.Sigma[618] = 0;
  params.Sigma[648] = 0;
  params.Sigma[678] = 0;
  params.Sigma[708] = 0;
  params.Sigma[738] = 0;
  params.Sigma[768] = 0;
  params.Sigma[798] = 0;
  params.Sigma[828] = 0;
  params.Sigma[858] = 0;
  params.Sigma[888] = 0;
  params.Sigma[19] = 0;
  params.Sigma[49] = 0;
  params.Sigma[79] = 0;
  params.Sigma[109] = 0;
  params.Sigma[139] = 0;
  params.Sigma[169] = 0;
  params.Sigma[199] = 0;
  params.Sigma[229] = 0;
  params.Sigma[259] = 0;
  params.Sigma[289] = 0;
  params.Sigma[319] = 0;
  params.Sigma[349] = 0;
  params.Sigma[379] = 0;
  params.Sigma[409] = 0;
  params.Sigma[439] = 0;
  params.Sigma[469] = 0;
  params.Sigma[499] = 0;
  params.Sigma[529] = 0;
  params.Sigma[559] = 0;
  params.Sigma[589] = 1.20541034460499;
  params.Sigma[619] = 0;
  params.Sigma[649] = 0;
  params.Sigma[679] = 0;
  params.Sigma[709] = 0;
  params.Sigma[739] = 0;
  params.Sigma[769] = 0;
  params.Sigma[799] = 0;
  params.Sigma[829] = 0;
  params.Sigma[859] = 0;
  params.Sigma[889] = 0;
  params.Sigma[20] = 0;
  params.Sigma[50] = 0;
  params.Sigma[80] = 0;
  params.Sigma[110] = 0;
  params.Sigma[140] = 0;
  params.Sigma[170] = 0;
  params.Sigma[200] = 0;
  params.Sigma[230] = 0;
  params.Sigma[260] = 0;
  params.Sigma[290] = 0;
  params.Sigma[320] = 0;
  params.Sigma[350] = 0;
  params.Sigma[380] = 0;
  params.Sigma[410] = 0;
  params.Sigma[440] = 0;
  params.Sigma[470] = 0;
  params.Sigma[500] = 0;
  params.Sigma[530] = 0;
  params.Sigma[560] = 0;
  params.Sigma[590] = 0;
  params.Sigma[620] = 1.20137871104307;
  params.Sigma[650] = 0;
  params.Sigma[680] = 0;
  params.Sigma[710] = 0;
  params.Sigma[740] = 0;
  params.Sigma[770] = 0;
  params.Sigma[800] = 0;
  params.Sigma[830] = 0;
  params.Sigma[860] = 0;
  params.Sigma[890] = 0;
  params.Sigma[21] = 0;
  params.Sigma[51] = 0;
  params.Sigma[81] = 0;
  params.Sigma[111] = 0;
  params.Sigma[141] = 0;
  params.Sigma[171] = 0;
  params.Sigma[201] = 0;
  params.Sigma[231] = 0;
  params.Sigma[261] = 0;
  params.Sigma[291] = 0;
  params.Sigma[321] = 0;
  params.Sigma[351] = 0;
  params.Sigma[381] = 0;
  params.Sigma[411] = 0;
  params.Sigma[441] = 0;
  params.Sigma[471] = 0;
  params.Sigma[501] = 0;
  params.Sigma[531] = 0;
  params.Sigma[561] = 0;
  params.Sigma[591] = 0;
  params.Sigma[621] = 0;
  params.Sigma[651] = 1.51403505981744;
  params.Sigma[681] = 0;
  params.Sigma[711] = 0;
  params.Sigma[741] = 0;
  params.Sigma[771] = 0;
  params.Sigma[801] = 0;
  params.Sigma[831] = 0;
  params.Sigma[861] = 0;
  params.Sigma[891] = 0;
  params.Sigma[22] = 0;
  params.Sigma[52] = 0;
  params.Sigma[82] = 0;
  params.Sigma[112] = 0;
  params.Sigma[142] = 0;
  params.Sigma[172] = 0;
  params.Sigma[202] = 0;
  params.Sigma[232] = 0;
  params.Sigma[262] = 0;
  params.Sigma[292] = 0;
  params.Sigma[322] = 0;
  params.Sigma[352] = 0;
  params.Sigma[382] = 0;
  params.Sigma[412] = 0;
  params.Sigma[442] = 0;
  params.Sigma[472] = 0;
  params.Sigma[502] = 0;
  params.Sigma[532] = 0;
  params.Sigma[562] = 0;
  params.Sigma[592] = 0;
  params.Sigma[622] = 0;
  params.Sigma[652] = 0;
  params.Sigma[682] = 1.0872293687808;
  params.Sigma[712] = 0;
  params.Sigma[742] = 0;
  params.Sigma[772] = 0;
  params.Sigma[802] = 0;
  params.Sigma[832] = 0;
  params.Sigma[862] = 0;
  params.Sigma[892] = 0;
  params.Sigma[23] = 0;
  params.Sigma[53] = 0;
  params.Sigma[83] = 0;
  params.Sigma[113] = 0;
  params.Sigma[143] = 0;
  params.Sigma[173] = 0;
  params.Sigma[203] = 0;
  params.Sigma[233] = 0;
  params.Sigma[263] = 0;
  params.Sigma[293] = 0;
  params.Sigma[323] = 0;
  params.Sigma[353] = 0;
  params.Sigma[383] = 0;
  params.Sigma[413] = 0;
  params.Sigma[443] = 0;
  params.Sigma[473] = 0;
  params.Sigma[503] = 0;
  params.Sigma[533] = 0;
  params.Sigma[563] = 0;
  params.Sigma[593] = 0;
  params.Sigma[623] = 0;
  params.Sigma[653] = 0;
  params.Sigma[683] = 0;
  params.Sigma[713] = 1.48358553235159;
  params.Sigma[743] = 0;
  params.Sigma[773] = 0;
  params.Sigma[803] = 0;
  params.Sigma[833] = 0;
  params.Sigma[863] = 0;
  params.Sigma[893] = 0;
  params.Sigma[24] = 0;
  params.Sigma[54] = 0;
  params.Sigma[84] = 0;
  params.Sigma[114] = 0;
  params.Sigma[144] = 0;
  params.Sigma[174] = 0;
  params.Sigma[204] = 0;
  params.Sigma[234] = 0;
  params.Sigma[264] = 0;
  params.Sigma[294] = 0;
  params.Sigma[324] = 0;
  params.Sigma[354] = 0;
  params.Sigma[384] = 0;
  params.Sigma[414] = 0;
  params.Sigma[444] = 0;
  params.Sigma[474] = 0;
  params.Sigma[504] = 0;
  params.Sigma[534] = 0;
  params.Sigma[564] = 0;
  params.Sigma[594] = 0;
  params.Sigma[624] = 0;
  params.Sigma[654] = 0;
  params.Sigma[684] = 0;
  params.Sigma[714] = 0;
  params.Sigma[744] = 1.36217621238783;
  params.Sigma[774] = 0;
  params.Sigma[804] = 0;
  params.Sigma[834] = 0;
  params.Sigma[864] = 0;
  params.Sigma[894] = 0;
  params.Sigma[25] = 0;
  params.Sigma[55] = 0;
  params.Sigma[85] = 0;
  params.Sigma[115] = 0;
  params.Sigma[145] = 0;
  params.Sigma[175] = 0;
  params.Sigma[205] = 0;
  params.Sigma[235] = 0;
  params.Sigma[265] = 0;
  params.Sigma[295] = 0;
  params.Sigma[325] = 0;
  params.Sigma[355] = 0;
  params.Sigma[385] = 0;
  params.Sigma[415] = 0;
  params.Sigma[445] = 0;
  params.Sigma[475] = 0;
  params.Sigma[505] = 0;
  params.Sigma[535] = 0;
  params.Sigma[565] = 0;
  params.Sigma[595] = 0;
  params.Sigma[625] = 0;
  params.Sigma[655] = 0;
  params.Sigma[685] = 0;
  params.Sigma[715] = 0;
  params.Sigma[745] = 0;
  params.Sigma[775] = 1.70768662181567;
  params.Sigma[805] = 0;
  params.Sigma[835] = 0;
  params.Sigma[865] = 0;
  params.Sigma[895] = 0;
  params.Sigma[26] = 0;
  params.Sigma[56] = 0;
  params.Sigma[86] = 0;
  params.Sigma[116] = 0;
  params.Sigma[146] = 0;
  params.Sigma[176] = 0;
  params.Sigma[206] = 0;
  params.Sigma[236] = 0;
  params.Sigma[266] = 0;
  params.Sigma[296] = 0;
  params.Sigma[326] = 0;
  params.Sigma[356] = 0;
  params.Sigma[386] = 0;
  params.Sigma[416] = 0;
  params.Sigma[446] = 0;
  params.Sigma[476] = 0;
  params.Sigma[506] = 0;
  params.Sigma[536] = 0;
  params.Sigma[566] = 0;
  params.Sigma[596] = 0;
  params.Sigma[626] = 0;
  params.Sigma[656] = 0;
  params.Sigma[686] = 0;
  params.Sigma[716] = 0;
  params.Sigma[746] = 0;
  params.Sigma[776] = 0;
  params.Sigma[806] = 1.746746223102;
  params.Sigma[836] = 0;
  params.Sigma[866] = 0;
  params.Sigma[896] = 0;
  params.Sigma[27] = 0;
  params.Sigma[57] = 0;
  params.Sigma[87] = 0;
  params.Sigma[117] = 0;
  params.Sigma[147] = 0;
  params.Sigma[177] = 0;
  params.Sigma[207] = 0;
  params.Sigma[237] = 0;
  params.Sigma[267] = 0;
  params.Sigma[297] = 0;
  params.Sigma[327] = 0;
  params.Sigma[357] = 0;
  params.Sigma[387] = 0;
  params.Sigma[417] = 0;
  params.Sigma[447] = 0;
  params.Sigma[477] = 0;
  params.Sigma[507] = 0;
  params.Sigma[537] = 0;
  params.Sigma[567] = 0;
  params.Sigma[597] = 0;
  params.Sigma[627] = 0;
  params.Sigma[657] = 0;
  params.Sigma[687] = 0;
  params.Sigma[717] = 0;
  params.Sigma[747] = 0;
  params.Sigma[777] = 0;
  params.Sigma[807] = 0;
  params.Sigma[837] = 1.69109292185576;
  params.Sigma[867] = 0;
  params.Sigma[897] = 0;
  params.Sigma[28] = 0;
  params.Sigma[58] = 0;
  params.Sigma[88] = 0;
  params.Sigma[118] = 0;
  params.Sigma[148] = 0;
  params.Sigma[178] = 0;
  params.Sigma[208] = 0;
  params.Sigma[238] = 0;
  params.Sigma[268] = 0;
  params.Sigma[298] = 0;
  params.Sigma[328] = 0;
  params.Sigma[358] = 0;
  params.Sigma[388] = 0;
  params.Sigma[418] = 0;
  params.Sigma[448] = 0;
  params.Sigma[478] = 0;
  params.Sigma[508] = 0;
  params.Sigma[538] = 0;
  params.Sigma[568] = 0;
  params.Sigma[598] = 0;
  params.Sigma[628] = 0;
  params.Sigma[658] = 0;
  params.Sigma[688] = 0;
  params.Sigma[718] = 0;
  params.Sigma[748] = 0;
  params.Sigma[778] = 0;
  params.Sigma[808] = 0;
  params.Sigma[838] = 0;
  params.Sigma[868] = 1.68918041375491;
  params.Sigma[898] = 0;
  params.Sigma[29] = 0;
  params.Sigma[59] = 0;
  params.Sigma[89] = 0;
  params.Sigma[119] = 0;
  params.Sigma[149] = 0;
  params.Sigma[179] = 0;
  params.Sigma[209] = 0;
  params.Sigma[239] = 0;
  params.Sigma[269] = 0;
  params.Sigma[299] = 0;
  params.Sigma[329] = 0;
  params.Sigma[359] = 0;
  params.Sigma[389] = 0;
  params.Sigma[419] = 0;
  params.Sigma[449] = 0;
  params.Sigma[479] = 0;
  params.Sigma[509] = 0;
  params.Sigma[539] = 0;
  params.Sigma[569] = 0;
  params.Sigma[599] = 0;
  params.Sigma[629] = 0;
  params.Sigma[659] = 0;
  params.Sigma[689] = 0;
  params.Sigma[719] = 0;
  params.Sigma[749] = 0;
  params.Sigma[779] = 0;
  params.Sigma[809] = 0;
  params.Sigma[839] = 0;
  params.Sigma[869] = 0;
  params.Sigma[899] = 1.37360012414893;
  params.rtp1[0] = 1.33626960947054;
  params.ztp1[0] = -0.640605344172728;
  params.ztp1[1] = 0.2911754794755;
  params.ztp1[2] = -0.696771367740502;
  params.ztp1[3] = -0.219419802945872;
  params.ztp1[4] = -1.75388427668024;
  params.ztp1[5] = -1.02929831126265;
  params.ztp1[6] = 1.88641042469427;
  params.ztp1[7] = -1.0776631825797;
  params.ztp1[8] = 0.765910043789321;
  params.ztp1[9] = 0.601907432854958;
  params.ztp1[10] = 0.895756557749928;
  params.ztp1[11] = -0.0996455574622748;
  params.ztp1[12] = 0.386655098407451;
  params.ztp1[13] = -1.73212230426869;
  params.ztp1[14] = -1.70975144871107;
  params.ztp1[15] = -1.20409589481169;
  params.ztp1[16] = -1.39255601196584;
  params.ztp1[17] = -1.59958262167422;
  params.ztp1[18] = -1.48282454156458;
  params.ztp1[19] = 0.213110927230614;
  params.ztp1[20] = -1.24874070030449;
  params.ztp1[21] = 1.80840497212483;
  params.ztp1[22] = 0.726447115229707;
  params.ztp1[23] = 0.164078693439085;
  params.ztp1[24] = 0.828722403231591;
  params.ztp1[25] = -0.944453316189946;
  params.ztp1[26] = 1.70690273701491;
  params.ztp1[27] = 1.35677223119988;
  params.ztp1[28] = 0.905277993712149;
  params.ztp1[29] = -0.0790401756583599;
  params.r_bar[0] = 1.36841274350659;
  params.r_bar[1] = 0.979009293697437;
  params.r_bar[2] = 0.64130362559845;
  params.r_bar[3] = 1.65590106802375;
  params.r_bar[4] = 0.534662255150299;
  params.r_bar[5] = -0.536237660589562;
  params.r_bar[6] = 0.211378292601782;
  params.r_bar[7] = -1.21447769319945;
  params.r_bar[8] = -1.23171081442559;
  params.r_bar[9] = 0.902678495731283;
  params.r_bar[10] = 1.13974681372452;
  params.r_bar[11] = 1.88839345473506;
  params.r_bar[12] = 1.40388566816601;
  params.r_bar[13] = 0.174377306383291;
  params.r_bar[14] = -1.64083652190774;
  params.r_bar[15] = -0.0445070215355488;
  params.r_bar[16] = 1.7117453902485;
  params.r_bar[17] = 1.15047279801391;
  params.r_bar[18] = -0.0596230957836474;
  params.r_bar[19] = -0.178882554076455;
  params.r_bar[20] = -1.12805692636259;
  params.r_bar[21] = -1.29114647679271;
  params.r_bar[22] = -1.70550532312257;
  params.r_bar[23] = 1.56957275034837;
  params.r_bar[24] = 0.560706467596236;
  params.r_bar[25] = -1.42667073011471;
  params.r_bar[26] = -0.343492321135171;
  params.r_bar[27] = -1.80356430240851;
  params.r_bar[28] = -1.16250660191055;
  params.r_bar[29] = 0.922832496516153;
  params.yt[0] = 0.604491081766398;
  params.yt[1] = -0.0840868104920891;
  params.yt[2] = -0.900877978017443;
  params.yt[3] = 0.608892500264739;
  params.yt[4] = 1.82579804526952;
  params.yt[5] = -0.257917775299229;
  params.yt[6] = -1.71946997964932;
  params.yt[7] = -1.76907404870813;
  params.yt[8] = -1.66851592480977;
  params.yt[9] = 1.83882874901288;
  params.yt[10] = 0.163043344745975;
  params.yt[11] = 1.34984973067889;
  params.yt[12] = -1.31986582305146;
  params.yt[13] = -0.958619709084339;
  params.yt[14] = 0.767910047491371;
  params.yt[15] = 1.58228131256793;
  params.yt[16] = -0.637246062159362;
  params.yt[17] = -1.74130720803887;
  params.yt[18] = 1.45647867764258;
  params.yt[19] = -0.836510216682096;
  params.yt[20] = 0.96432962559825;
  params.yt[21] = -1.36786538119402;
  params.yt[22] = 0.779853740563504;
  params.yt[23] = 1.36567847612459;
  params.yt[24] = 0.908608314986837;
  params.yt[25] = -0.563569900546034;
  params.yt[26] = 0.906759005960792;
  params.yt[27] = -1.44213150327016;
  params.yt[28] = -0.744723539067112;
  params.yt[29] = -0.321668973268222;
  params.rtm1[0] = 1.75442407788863;
  params.ztm1[0] = -1.38503916571543;
  params.ztm1[1] = 1.52049916099726;
  params.ztm1[2] = 1.19585727688322;
  params.ztm1[3] = 1.88649718831192;
  params.ztm1[4] = -0.529188066786158;
  params.ztm1[5] = -1.18024092436888;
  params.ztm1[6] = -1.0377187186616;
  params.ztm1[7] = 1.31145120568568;
  params.ztm1[8] = 1.86091259437566;
  params.ztm1[9] = 0.795239993521694;
  params.ztm1[10] = -0.0700118329046804;
  params.ztm1[11] = -0.851800941275469;
  params.ztm1[12] = 1.33475153737264;
  params.ztm1[13] = 1.4887180335977;
  params.ztm1[14] = -1.63147363279763;
  params.ztm1[15] = -1.13620211592089;
  params.ztm1[16] = 1.32704436183147;
  params.ztm1[17] = 1.39321558831798;
  params.ztm1[18] = -0.741388004944011;
  params.ztm1[19] = -0.882821612612575;
  params.ztm1[20] = -0.27673991192616;
  params.ztm1[21] = 0.157786001058667;
  params.ztm1[22] = -1.61773273997355;
  params.ztm1[23] = 1.34764855485446;
  params.ztm1[24] = 0.138939481405284;
  params.ztm1[25] = 1.09987126016369;
  params.ztm1[26] = -1.07665493769469;
  params.ztm1[27] = 1.86117340442546;
  params.ztm1[28] = 1.00410922927352;
  params.ztm1[29] = -0.627624542432154;
  params.vtm1[0] = 1.79411058783982;
  params.vtm1[1] = 0.802047115865091;
  params.vtm1[2] = 1.36224434194495;
  params.vtm1[3] = -1.81801077657652;
  params.vtm1[4] = -1.77743383579325;
  params.vtm1[5] = 0.970949094198515;
  params.vtm1[6] = -0.781254268206432;
  params.vtm1[7] = 0.0671374633729811;
  params.vtm1[8] = -1.37495030531491;
  params.vtm1[9] = 1.91180963862794;
  params.vtm1[10] = 0.0110041906976779;
  params.vtm1[11] = 1.3160043138989;
  params.vtm1[12] = -1.70384881488001;
  params.vtm1[13] = -0.0843381911286474;
  params.vtm1[14] = -1.7508820783769;
  params.vtm1[15] = 1.53696572435095;
  params.vtm1[16] = -0.216759285148165;
  params.vtm1[17] = -1.72580032695265;
  params.vtm1[18] = -1.69401487073617;
  params.vtm1[19] = 0.15517063201268;
  params.vtm1[20] = -1.69773438197908;
  params.vtm1[21] = -1.26491072795023;
  params.vtm1[22] = -0.254571663333944;
  params.vtm1[23] = -0.00886867592617024;
  params.vtm1[24] = 0.33324766096703;
  params.vtm1[25] = 0.482050725619629;
  params.vtm1[26] = -0.508754001429326;
  params.vtm1[27] = 0.474946331922319;
  params.vtm1[28] = -1.37102136645946;
  params.vtm1[29] = -0.897966098265226;
  params.ytm1[0] = 1.19487308238524;
  params.ytm1[1] = -1.38764279709394;
  params.ytm1[2] = -1.10670810845705;
  params.ytm1[3] = -1.02808728122418;
  params.ytm1[4] = -0.0819707807077323;
  params.ytm1[5] = -1.99701791183241;
  params.ytm1[6] = -1.87875455791013;
  params.ytm1[7] = -0.153807393408778;
  params.ytm1[8] = -1.34991726053392;
  params.ytm1[9] = 0.718007215093141;
  params.ytm1[10] = 1.18081834870655;
  params.ytm1[11] = 0.312653434950841;
  params.ytm1[12] = 0.779059908692823;
  params.ytm1[13] = -0.436167937064485;
  params.ytm1[14] = -1.81481518802821;
  params.ytm1[15] = -0.242313869481403;
  params.ytm1[16] = -0.512078751162241;
  params.ytm1[17] = 0.38801296880132;
  params.ytm1[18] = -1.46312732120387;
  params.ytm1[19] = -1.08914841311266;
  params.ytm1[20] = 1.25912966610912;
  params.ytm1[21] = -0.942697893439147;
  params.ytm1[22] = -0.358719180371347;
  params.ytm1[23] = 1.74388870598313;
  params.ytm1[24] = -0.897790147916582;
  params.ytm1[25] = -1.41884016458574;
  params.ytm1[26] = 0.808080517325809;
  params.ytm1[27] = 0.268266201765099;
  params.ytm1[28] = 0.446375342186388;
  params.ytm1[29] = -1.83187659602571;
  params.az[0] = -0.330932420971093;
  params.av[0] = -1.98293426333136;
  params.x_constraint[0] = -1.01385812455644;
  params.x_constraint[1] = 0.824224734336025;
  params.x_constraint[2] = -1.7538371363172;
  params.x_constraint[3] = -0.821226005586881;
  params.x_constraint[4] = 1.95245101124871;
  params.x_constraint[5] = 1.8848889209079;
  params.x_constraint[6] = -0.0726144452811801;
  params.x_constraint[7] = 0.942773546112984;
  params.x_constraint[8] = 0.530623096744556;
  params.x_constraint[9] = -0.137227714225053;
  params.x_constraint[10] = 1.42826573056528;
  params.x_constraint[11] = -1.30992699133528;
  params.x_constraint[12] = 1.31372768897644;
  params.x_constraint[13] = -1.83172190616673;
  params.x_constraint[14] = 1.46781476725119;
  params.x_constraint[15] = 0.703986349872991;
  params.x_constraint[16] = -0.216343560356526;
  params.x_constraint[17] = 0.686280990537108;
  params.x_constraint[18] = -0.158525984443032;
  params.x_constraint[19] = 1.12001288951434;
  params.x_constraint[20] = -1.54622366454353;
  params.x_constraint[21] = 0.0326297153944215;
  params.x_constraint[22] = 1.48595815977549;
  params.x_constraint[23] = 1.71011710324809;
  params.x_constraint[24] = -1.11865467380675;
  params.x_constraint[25] = -0.992278789781524;
  params.x_constraint[26] = 1.61604988643595;
  params.x_constraint[27] = -0.617930645139486;
  params.x_constraint[28] = -1.77250970380514;
  params.x_constraint[29] = 0.859546688448131;
}
