/* Produced by CVXGEN, 2011-10-19 15:59:18 -0700.  */
/* CVXGEN is Copyright (C) 2006-2011 Jacob Mattingley, jem@cvxgen.com. */
/* The code in this file is Copyright (C) 2006-2011 Jacob Mattingley. */
/* CVXGEN, or solvers produced by CVXGEN, cannot be used for commercial */
/* applications without prior written permission from Jacob Mattingley. */

/* Filename: testsolver.c. */
/* Description: Basic test harness for solver.c. */

#include "solver.h"

Vars vars;
Params params;
Workspace work;
Settings settings;
#define NUMTESTS 0

int main(int argc, char **argv) {
  int num_iters;
#if (NUMTESTS > 0)
  int i;
  double time;
  double time_per;
#endif

  set_defaults();
  setup_indexing();
  load_default_data();

  /* Solve problem instance for the record. */
  settings.verbose = 1;
  num_iters = solve();

#ifndef ZERO_LIBRARY_MODE
#if (NUMTESTS > 0)
  /* Now solve multiple problem instances for timing purposes. */
  settings.verbose = 0;

  tic();
  for (i = 0; i < NUMTESTS; i++) {
    solve();
  }
  time = tocq();

  printf("Timed %d solves over %.3f seconds.\n", NUMTESTS, time);
  time_per = time / NUMTESTS;

  if (time_per > 1) {
    printf("Actual time taken per solve: %.3g s.\n", time_per);
  } else if (time_per > 1e-3) {
    printf("Actual time taken per solve: %.3g ms.\n", 1e3*time_per);
  } else {
    printf("Actual time taken per solve: %.3g us.\n", 1e6*time_per);
  }
#endif
#endif

  return 0;
}

void load_default_data(void) {
  params.sh[0] = 1.10159580514915;
  params.sh[1] = 1.41629564523621;
  params.sh[2] = 0.581809477825889;
  params.sh[3] = 1.02165521039533;
  params.sh[4] = 1.78589390869531;
  params.sh[5] = 1.79258617786688;
  params.sh[6] = 0.251170620927673;
  params.sh[7] = 0.414485756276374;
  params.sh[8] = 0.10293440660166;
  params.sh[9] = 0.881619687301273;
  params.sh[10] = 0.0597524217571339;
  params.sh[11] = 0.913666448789422;
  params.sh[12] = 1.29828809522952;
  params.sh[13] = 0.556974565295951;
  params.sh[14] = 1.35250980396026;
  params.sh[15] = 1.1817256348327;
  params.sh[16] = 0.0479637647543307;
  params.sh[17] = 1.11770817598176;
  params.sh[18] = 0.518504893814931;
  params.sh[19] = 0.830202394020139;
  params.sh[20] = 0.567050163542637;
  params.sh[21] = 1.38627583662599;
  params.sh[22] = 0.880907435341479;
  params.sh[23] = 0.313735476949927;
  params.sh[24] = 1.08929803606369;
  params.sh[25] = 1.56062952902273;
  params.sh[26] = 0.612727064752359;
  params.sh[27] = 0.443915767864363;
  params.sh[28] = 0.775942515111298;
  params.sh[29] = 1.87276729972086;
  params.x[0] = 1.90398168989174;
  params.x[1] = 0.689534703651255;
  params.x[2] = 1.61133643415359;
  params.x[3] = 1.38300348517272;
  params.x[4] = -0.488023834684443;
  params.x[5] = -1.6311319645131;
  params.x[6] = 0.613643610094145;
  params.x[7] = 0.231363049553804;
  params.x[8] = -0.553740947749688;
  params.x[9] = -1.09978198064067;
  params.x[10] = -0.373920334495006;
  params.x[11] = -0.124239005203324;
  params.x[12] = -0.923057686995755;
  params.x[13] = -0.83282890309827;
  params.x[14] = -0.169254402708088;
  params.x[15] = 1.44213565178771;
  params.x[16] = 0.345011617871286;
  params.x[17] = -0.866048550271161;
  params.x[18] = -0.888089973505595;
  params.x[19] = -0.181511697912213;
  params.x[20] = -1.17835862158005;
  params.x[21] = -1.19448515582771;
  params.x[22] = 0.0561402392697676;
  params.x[23] = -1.65108252487678;
  params.x[24] = -0.0656578705936539;
  params.x[25] = -0.551295150448667;
  params.x[26] = 0.830746487262684;
  params.x[27] = 0.986984892408018;
  params.x[28] = 0.764371687423057;
  params.x[29] = 0.756721655019656;
  params.kappa[0] = 0.747200248297857;
  params.kappa[1] = 1.33626960947054;
  params.kappa[2] = 0.679697327913636;
  params.kappa[3] = 1.14558773973775;
  params.kappa[4] = 0.651614316129749;
  params.kappa[5] = 0.890290098527064;
  params.kappa[6] = 0.123057861659879;
  params.kappa[7] = 0.485350844368676;
  params.kappa[8] = 1.94320521234714;
  params.kappa[9] = 0.461168408710148;
  params.kappa[10] = 1.38295502189466;
  params.kappa[11] = 1.30095371642748;
  params.kappa[12] = 1.44787827887496;
  params.kappa[13] = 0.950177221268863;
  params.kappa[14] = 1.19332754920373;
  params.kappa[15] = 0.133938847865653;
  params.kappa[16] = 0.145124275644467;
  params.kappa[17] = 0.397952052594157;
  params.kappa[18] = 0.303721994017082;
  params.kappa[19] = 0.200208689162889;
  params.kappa[20] = 0.258587729217708;
  params.kappa[21] = 1.10655546361531;
  params.kappa[22] = 0.375629649847756;
  params.kappa[23] = 1.90420248606242;
  params.kappa[24] = 1.36322355761485;
  params.kappa[25] = 1.08203934671954;
  params.kappa[26] = 1.4143612016158;
  params.kappa[27] = 0.527773341905027;
  params.kappa[28] = 1.85345136850746;
  params.kappa[29] = 1.67838611559994;
  params.S[0] = 1.72631949842804;
  params.S[1] = 1.48023995608541;
  params.S[2] = 1.84210318587665;
  params.S[3] = 1.74475232342436;
  params.S[4] = 1.66032590639961;
  params.S[5] = 1.91397526700594;
  params.S[6] = 1.63366556378757;
  params.S[7] = 1.36594058485261;
  params.S[8] = 1.55284457315045;
  params.S[9] = 1.19638057670014;
  params.S[10] = 1.1920722963936;
  params.S[11] = 1.72566962393282;
  params.S[12] = 1.78493670343113;
  params.S[13] = 1.97209836368377;
  params.S[14] = 1.8509714170415;
  params.S[15] = 1.54359432659582;
  params.S[16] = 1.08979086952306;
  params.S[17] = 1.48887324461611;
  params.S[18] = 1.92793634756213;
  params.S[19] = 1.78761819950348;
  params.S[20] = 1.48509422605409;
  params.S[21] = 1.45527936148089;
  params.S[22] = 1.21798576840935;
  params.S[23] = 1.17721338080182;
  params.S[24] = 1.07362366921936;
  params.S[25] = 1.89239318758709;
  params.S[26] = 1.64017661689906;
  params.S[27] = 1.14333231747132;
  params.S[28] = 1.41412691971621;
  params.S[29] = 1.04910892439787;
  params.lambda[0] = 0.418746699044727;
  /* Make this a diagonal PSD matrix, even though it's not diagonal. */
  params.Sigma[0] = 1.73070812412904;
  params.Sigma[30] = 0;
  params.Sigma[60] = 0;
  params.Sigma[90] = 0;
  params.Sigma[120] = 0;
  params.Sigma[150] = 0;
  params.Sigma[180] = 0;
  params.Sigma[210] = 0;
  params.Sigma[240] = 0;
  params.Sigma[270] = 0;
  params.Sigma[300] = 0;
  params.Sigma[330] = 0;
  params.Sigma[360] = 0;
  params.Sigma[390] = 0;
  params.Sigma[420] = 0;
  params.Sigma[450] = 0;
  params.Sigma[480] = 0;
  params.Sigma[510] = 0;
  params.Sigma[540] = 0;
  params.Sigma[570] = 0;
  params.Sigma[600] = 0;
  params.Sigma[630] = 0;
  params.Sigma[660] = 0;
  params.Sigma[690] = 0;
  params.Sigma[720] = 0;
  params.Sigma[750] = 0;
  params.Sigma[780] = 0;
  params.Sigma[810] = 0;
  params.Sigma[840] = 0;
  params.Sigma[870] = 0;
  params.Sigma[1] = 0;
  params.Sigma[31] = 1.6511227704416;
  params.Sigma[61] = 0;
  params.Sigma[91] = 0;
  params.Sigma[121] = 0;
  params.Sigma[151] = 0;
  params.Sigma[181] = 0;
  params.Sigma[211] = 0;
  params.Sigma[241] = 0;
  params.Sigma[271] = 0;
  params.Sigma[301] = 0;
  params.Sigma[331] = 0;
  params.Sigma[361] = 0;
  params.Sigma[391] = 0;
  params.Sigma[421] = 0;
  params.Sigma[451] = 0;
  params.Sigma[481] = 0;
  params.Sigma[511] = 0;
  params.Sigma[541] = 0;
  params.Sigma[571] = 0;
  params.Sigma[601] = 0;
  params.Sigma[631] = 0;
  params.Sigma[661] = 0;
  params.Sigma[691] = 0;
  params.Sigma[721] = 0;
  params.Sigma[751] = 0;
  params.Sigma[781] = 0;
  params.Sigma[811] = 0;
  params.Sigma[841] = 0;
  params.Sigma[871] = 0;
  params.Sigma[2] = 0;
  params.Sigma[32] = 0;
  params.Sigma[62] = 1.47897829737698;
  params.Sigma[92] = 0;
  params.Sigma[122] = 0;
  params.Sigma[152] = 0;
  params.Sigma[182] = 0;
  params.Sigma[212] = 0;
  params.Sigma[242] = 0;
  params.Sigma[272] = 0;
  params.Sigma[302] = 0;
  params.Sigma[332] = 0;
  params.Sigma[362] = 0;
  params.Sigma[392] = 0;
  params.Sigma[422] = 0;
  params.Sigma[452] = 0;
  params.Sigma[482] = 0;
  params.Sigma[512] = 0;
  params.Sigma[542] = 0;
  params.Sigma[572] = 0;
  params.Sigma[602] = 0;
  params.Sigma[632] = 0;
  params.Sigma[662] = 0;
  params.Sigma[692] = 0;
  params.Sigma[722] = 0;
  params.Sigma[752] = 0;
  params.Sigma[782] = 0;
  params.Sigma[812] = 0;
  params.Sigma[842] = 0;
  params.Sigma[872] = 0;
  params.Sigma[3] = 0;
  params.Sigma[33] = 0;
  params.Sigma[63] = 0;
  params.Sigma[93] = 1.27478050549564;
  params.Sigma[123] = 0;
  params.Sigma[153] = 0;
  params.Sigma[183] = 0;
  params.Sigma[213] = 0;
  params.Sigma[243] = 0;
  params.Sigma[273] = 0;
  params.Sigma[303] = 0;
  params.Sigma[333] = 0;
  params.Sigma[363] = 0;
  params.Sigma[393] = 0;
  params.Sigma[423] = 0;
  params.Sigma[453] = 0;
  params.Sigma[483] = 0;
  params.Sigma[513] = 0;
  params.Sigma[543] = 0;
  params.Sigma[573] = 0;
  params.Sigma[603] = 0;
  params.Sigma[633] = 0;
  params.Sigma[663] = 0;
  params.Sigma[693] = 0;
  params.Sigma[723] = 0;
  params.Sigma[753] = 0;
  params.Sigma[783] = 0;
  params.Sigma[813] = 0;
  params.Sigma[843] = 0;
  params.Sigma[873] = 0;
  params.Sigma[4] = 0;
  params.Sigma[34] = 0;
  params.Sigma[64] = 0;
  params.Sigma[94] = 0;
  params.Sigma[124] = 1.65222312506618;
  params.Sigma[154] = 0;
  params.Sigma[184] = 0;
  params.Sigma[214] = 0;
  params.Sigma[244] = 0;
  params.Sigma[274] = 0;
  params.Sigma[304] = 0;
  params.Sigma[334] = 0;
  params.Sigma[364] = 0;
  params.Sigma[394] = 0;
  params.Sigma[424] = 0;
  params.Sigma[454] = 0;
  params.Sigma[484] = 0;
  params.Sigma[514] = 0;
  params.Sigma[544] = 0;
  params.Sigma[574] = 0;
  params.Sigma[604] = 0;
  params.Sigma[634] = 0;
  params.Sigma[664] = 0;
  params.Sigma[694] = 0;
  params.Sigma[724] = 0;
  params.Sigma[754] = 0;
  params.Sigma[784] = 0;
  params.Sigma[814] = 0;
  params.Sigma[844] = 0;
  params.Sigma[874] = 0;
  params.Sigma[5] = 0;
  params.Sigma[35] = 0;
  params.Sigma[65] = 0;
  params.Sigma[95] = 0;
  params.Sigma[125] = 0;
  params.Sigma[155] = 1.95644951131738;
  params.Sigma[185] = 0;
  params.Sigma[215] = 0;
  params.Sigma[245] = 0;
  params.Sigma[275] = 0;
  params.Sigma[305] = 0;
  params.Sigma[335] = 0;
  params.Sigma[365] = 0;
  params.Sigma[395] = 0;
  params.Sigma[425] = 0;
  params.Sigma[455] = 0;
  params.Sigma[485] = 0;
  params.Sigma[515] = 0;
  params.Sigma[545] = 0;
  params.Sigma[575] = 0;
  params.Sigma[605] = 0;
  params.Sigma[635] = 0;
  params.Sigma[665] = 0;
  params.Sigma[695] = 0;
  params.Sigma[725] = 0;
  params.Sigma[755] = 0;
  params.Sigma[785] = 0;
  params.Sigma[815] = 0;
  params.Sigma[845] = 0;
  params.Sigma[875] = 0;
  params.Sigma[6] = 0;
  params.Sigma[36] = 0;
  params.Sigma[66] = 0;
  params.Sigma[96] = 0;
  params.Sigma[126] = 0;
  params.Sigma[156] = 0;
  params.Sigma[186] = 1.43552055617519;
  params.Sigma[216] = 0;
  params.Sigma[246] = 0;
  params.Sigma[276] = 0;
  params.Sigma[306] = 0;
  params.Sigma[336] = 0;
  params.Sigma[366] = 0;
  params.Sigma[396] = 0;
  params.Sigma[426] = 0;
  params.Sigma[456] = 0;
  params.Sigma[486] = 0;
  params.Sigma[516] = 0;
  params.Sigma[546] = 0;
  params.Sigma[576] = 0;
  params.Sigma[606] = 0;
  params.Sigma[636] = 0;
  params.Sigma[666] = 0;
  params.Sigma[696] = 0;
  params.Sigma[726] = 0;
  params.Sigma[756] = 0;
  params.Sigma[786] = 0;
  params.Sigma[816] = 0;
  params.Sigma[846] = 0;
  params.Sigma[876] = 0;
  params.Sigma[7] = 0;
  params.Sigma[37] = 0;
  params.Sigma[67] = 0;
  params.Sigma[97] = 0;
  params.Sigma[127] = 0;
  params.Sigma[157] = 0;
  params.Sigma[187] = 0;
  params.Sigma[217] = 1.07013250508767;
  params.Sigma[247] = 0;
  params.Sigma[277] = 0;
  params.Sigma[307] = 0;
  params.Sigma[337] = 0;
  params.Sigma[367] = 0;
  params.Sigma[397] = 0;
  params.Sigma[427] = 0;
  params.Sigma[457] = 0;
  params.Sigma[487] = 0;
  params.Sigma[517] = 0;
  params.Sigma[547] = 0;
  params.Sigma[577] = 0;
  params.Sigma[607] = 0;
  params.Sigma[637] = 0;
  params.Sigma[667] = 0;
  params.Sigma[697] = 0;
  params.Sigma[727] = 0;
  params.Sigma[757] = 0;
  params.Sigma[787] = 0;
  params.Sigma[817] = 0;
  params.Sigma[847] = 0;
  params.Sigma[877] = 0;
  params.Sigma[8] = 0;
  params.Sigma[38] = 0;
  params.Sigma[68] = 0;
  params.Sigma[98] = 0;
  params.Sigma[128] = 0;
  params.Sigma[158] = 0;
  params.Sigma[188] = 0;
  params.Sigma[218] = 0;
  params.Sigma[248] = 1.05773148782297;
  params.Sigma[278] = 0;
  params.Sigma[308] = 0;
  params.Sigma[338] = 0;
  params.Sigma[368] = 0;
  params.Sigma[398] = 0;
  params.Sigma[428] = 0;
  params.Sigma[458] = 0;
  params.Sigma[488] = 0;
  params.Sigma[518] = 0;
  params.Sigma[548] = 0;
  params.Sigma[578] = 0;
  params.Sigma[608] = 0;
  params.Sigma[638] = 0;
  params.Sigma[668] = 0;
  params.Sigma[698] = 0;
  params.Sigma[728] = 0;
  params.Sigma[758] = 0;
  params.Sigma[788] = 0;
  params.Sigma[818] = 0;
  params.Sigma[848] = 0;
  params.Sigma[878] = 0;
  params.Sigma[9] = 0;
  params.Sigma[39] = 0;
  params.Sigma[69] = 0;
  params.Sigma[99] = 0;
  params.Sigma[129] = 0;
  params.Sigma[159] = 0;
  params.Sigma[189] = 0;
  params.Sigma[219] = 0;
  params.Sigma[249] = 0;
  params.Sigma[279] = 1.08287101879756;
  params.Sigma[309] = 0;
  params.Sigma[339] = 0;
  params.Sigma[369] = 0;
  params.Sigma[399] = 0;
  params.Sigma[429] = 0;
  params.Sigma[459] = 0;
  params.Sigma[489] = 0;
  params.Sigma[519] = 0;
  params.Sigma[549] = 0;
  params.Sigma[579] = 0;
  params.Sigma[609] = 0;
  params.Sigma[639] = 0;
  params.Sigma[669] = 0;
  params.Sigma[699] = 0;
  params.Sigma[729] = 0;
  params.Sigma[759] = 0;
  params.Sigma[789] = 0;
  params.Sigma[819] = 0;
  params.Sigma[849] = 0;
  params.Sigma[879] = 0;
  params.Sigma[10] = 0;
  params.Sigma[40] = 0;
  params.Sigma[70] = 0;
  params.Sigma[100] = 0;
  params.Sigma[130] = 0;
  params.Sigma[160] = 0;
  params.Sigma[190] = 0;
  params.Sigma[220] = 0;
  params.Sigma[250] = 0;
  params.Sigma[280] = 0;
  params.Sigma[310] = 1.95970718725322;
  params.Sigma[340] = 0;
  params.Sigma[370] = 0;
  params.Sigma[400] = 0;
  params.Sigma[430] = 0;
  params.Sigma[460] = 0;
  params.Sigma[490] = 0;
  params.Sigma[520] = 0;
  params.Sigma[550] = 0;
  params.Sigma[580] = 0;
  params.Sigma[610] = 0;
  params.Sigma[640] = 0;
  params.Sigma[670] = 0;
  params.Sigma[700] = 0;
  params.Sigma[730] = 0;
  params.Sigma[760] = 0;
  params.Sigma[790] = 0;
  params.Sigma[820] = 0;
  params.Sigma[850] = 0;
  params.Sigma[880] = 0;
  params.Sigma[11] = 0;
  params.Sigma[41] = 0;
  params.Sigma[71] = 0;
  params.Sigma[101] = 0;
  params.Sigma[131] = 0;
  params.Sigma[161] = 0;
  params.Sigma[191] = 0;
  params.Sigma[221] = 0;
  params.Sigma[251] = 0;
  params.Sigma[281] = 0;
  params.Sigma[311] = 0;
  params.Sigma[341] = 1.54076083618649;
  params.Sigma[371] = 0;
  params.Sigma[401] = 0;
  params.Sigma[431] = 0;
  params.Sigma[461] = 0;
  params.Sigma[491] = 0;
  params.Sigma[521] = 0;
  params.Sigma[551] = 0;
  params.Sigma[581] = 0;
  params.Sigma[611] = 0;
  params.Sigma[641] = 0;
  params.Sigma[671] = 0;
  params.Sigma[701] = 0;
  params.Sigma[731] = 0;
  params.Sigma[761] = 0;
  params.Sigma[791] = 0;
  params.Sigma[821] = 0;
  params.Sigma[851] = 0;
  params.Sigma[881] = 0;
  params.Sigma[12] = 0;
  params.Sigma[42] = 0;
  params.Sigma[72] = 0;
  params.Sigma[102] = 0;
  params.Sigma[132] = 0;
  params.Sigma[162] = 0;
  params.Sigma[192] = 0;
  params.Sigma[222] = 0;
  params.Sigma[252] = 0;
  params.Sigma[282] = 0;
  params.Sigma[312] = 0;
  params.Sigma[342] = 0;
  params.Sigma[372] = 1.83746243266972;
  params.Sigma[402] = 0;
  params.Sigma[432] = 0;
  params.Sigma[462] = 0;
  params.Sigma[492] = 0;
  params.Sigma[522] = 0;
  params.Sigma[552] = 0;
  params.Sigma[582] = 0;
  params.Sigma[612] = 0;
  params.Sigma[642] = 0;
  params.Sigma[672] = 0;
  params.Sigma[702] = 0;
  params.Sigma[732] = 0;
  params.Sigma[762] = 0;
  params.Sigma[792] = 0;
  params.Sigma[822] = 0;
  params.Sigma[852] = 0;
  params.Sigma[882] = 0;
  params.Sigma[13] = 0;
  params.Sigma[43] = 0;
  params.Sigma[73] = 0;
  params.Sigma[103] = 0;
  params.Sigma[133] = 0;
  params.Sigma[163] = 0;
  params.Sigma[193] = 0;
  params.Sigma[223] = 0;
  params.Sigma[253] = 0;
  params.Sigma[283] = 0;
  params.Sigma[313] = 0;
  params.Sigma[343] = 0;
  params.Sigma[373] = 0;
  params.Sigma[403] = 1.17003354423713;
  params.Sigma[433] = 0;
  params.Sigma[463] = 0;
  params.Sigma[493] = 0;
  params.Sigma[523] = 0;
  params.Sigma[553] = 0;
  params.Sigma[583] = 0;
  params.Sigma[613] = 0;
  params.Sigma[643] = 0;
  params.Sigma[673] = 0;
  params.Sigma[703] = 0;
  params.Sigma[733] = 0;
  params.Sigma[763] = 0;
  params.Sigma[793] = 0;
  params.Sigma[823] = 0;
  params.Sigma[853] = 0;
  params.Sigma[883] = 0;
  params.Sigma[14] = 0;
  params.Sigma[44] = 0;
  params.Sigma[74] = 0;
  params.Sigma[104] = 0;
  params.Sigma[134] = 0;
  params.Sigma[164] = 0;
  params.Sigma[194] = 0;
  params.Sigma[224] = 0;
  params.Sigma[254] = 0;
  params.Sigma[284] = 0;
  params.Sigma[314] = 0;
  params.Sigma[344] = 0;
  params.Sigma[374] = 0;
  params.Sigma[404] = 0;
  params.Sigma[434] = 1.26034507272892;
  params.Sigma[464] = 0;
  params.Sigma[494] = 0;
  params.Sigma[524] = 0;
  params.Sigma[554] = 0;
  params.Sigma[584] = 0;
  params.Sigma[614] = 0;
  params.Sigma[644] = 0;
  params.Sigma[674] = 0;
  params.Sigma[704] = 0;
  params.Sigma[734] = 0;
  params.Sigma[764] = 0;
  params.Sigma[794] = 0;
  params.Sigma[824] = 0;
  params.Sigma[854] = 0;
  params.Sigma[884] = 0;
  params.Sigma[15] = 0;
  params.Sigma[45] = 0;
  params.Sigma[75] = 0;
  params.Sigma[105] = 0;
  params.Sigma[135] = 0;
  params.Sigma[165] = 0;
  params.Sigma[195] = 0;
  params.Sigma[225] = 0;
  params.Sigma[255] = 0;
  params.Sigma[285] = 0;
  params.Sigma[315] = 0;
  params.Sigma[345] = 0;
  params.Sigma[375] = 0;
  params.Sigma[405] = 0;
  params.Sigma[435] = 0;
  params.Sigma[465] = 1.69197751187284;
  params.Sigma[495] = 0;
  params.Sigma[525] = 0;
  params.Sigma[555] = 0;
  params.Sigma[585] = 0;
  params.Sigma[615] = 0;
  params.Sigma[645] = 0;
  params.Sigma[675] = 0;
  params.Sigma[705] = 0;
  params.Sigma[735] = 0;
  params.Sigma[765] = 0;
  params.Sigma[795] = 0;
  params.Sigma[825] = 0;
  params.Sigma[855] = 0;
  params.Sigma[885] = 0;
  params.Sigma[16] = 0;
  params.Sigma[46] = 0;
  params.Sigma[76] = 0;
  params.Sigma[106] = 0;
  params.Sigma[136] = 0;
  params.Sigma[166] = 0;
  params.Sigma[196] = 0;
  params.Sigma[226] = 0;
  params.Sigma[256] = 0;
  params.Sigma[286] = 0;
  params.Sigma[316] = 0;
  params.Sigma[346] = 0;
  params.Sigma[376] = 0;
  params.Sigma[406] = 0;
  params.Sigma[436] = 0;
  params.Sigma[466] = 0;
  params.Sigma[496] = 1.89557032814198;
  params.Sigma[526] = 0;
  params.Sigma[556] = 0;
  params.Sigma[586] = 0;
  params.Sigma[616] = 0;
  params.Sigma[646] = 0;
  params.Sigma[676] = 0;
  params.Sigma[706] = 0;
  params.Sigma[736] = 0;
  params.Sigma[766] = 0;
  params.Sigma[796] = 0;
  params.Sigma[826] = 0;
  params.Sigma[856] = 0;
  params.Sigma[886] = 0;
  params.Sigma[17] = 0;
  params.Sigma[47] = 0;
  params.Sigma[77] = 0;
  params.Sigma[107] = 0;
  params.Sigma[137] = 0;
  params.Sigma[167] = 0;
  params.Sigma[197] = 0;
  params.Sigma[227] = 0;
  params.Sigma[257] = 0;
  params.Sigma[287] = 0;
  params.Sigma[317] = 0;
  params.Sigma[347] = 0;
  params.Sigma[377] = 0;
  params.Sigma[407] = 0;
  params.Sigma[437] = 0;
  params.Sigma[467] = 0;
  params.Sigma[497] = 0;
  params.Sigma[527] = 1.34068848446016;
  params.Sigma[557] = 0;
  params.Sigma[587] = 0;
  params.Sigma[617] = 0;
  params.Sigma[647] = 0;
  params.Sigma[677] = 0;
  params.Sigma[707] = 0;
  params.Sigma[737] = 0;
  params.Sigma[767] = 0;
  params.Sigma[797] = 0;
  params.Sigma[827] = 0;
  params.Sigma[857] = 0;
  params.Sigma[887] = 0;
  params.Sigma[18] = 0;
  params.Sigma[48] = 0;
  params.Sigma[78] = 0;
  params.Sigma[108] = 0;
  params.Sigma[138] = 0;
  params.Sigma[168] = 0;
  params.Sigma[198] = 0;
  params.Sigma[228] = 0;
  params.Sigma[258] = 0;
  params.Sigma[288] = 0;
  params.Sigma[318] = 0;
  params.Sigma[348] = 0;
  params.Sigma[378] = 0;
  params.Sigma[408] = 0;
  params.Sigma[438] = 0;
  params.Sigma[468] = 0;
  params.Sigma[498] = 0;
  params.Sigma[528] = 0;
  params.Sigma[558] = 1.06467319799028;
  params.Sigma[588] = 0;
  params.Sigma[618] = 0;
  params.Sigma[648] = 0;
  params.Sigma[678] = 0;
  params.Sigma[708] = 0;
  params.Sigma[738] = 0;
  params.Sigma[768] = 0;
  params.Sigma[798] = 0;
  params.Sigma[828] = 0;
  params.Sigma[858] = 0;
  params.Sigma[888] = 0;
  params.Sigma[19] = 0;
  params.Sigma[49] = 0;
  params.Sigma[79] = 0;
  params.Sigma[109] = 0;
  params.Sigma[139] = 0;
  params.Sigma[169] = 0;
  params.Sigma[199] = 0;
  params.Sigma[229] = 0;
  params.Sigma[259] = 0;
  params.Sigma[289] = 0;
  params.Sigma[319] = 0;
  params.Sigma[349] = 0;
  params.Sigma[379] = 0;
  params.Sigma[409] = 0;
  params.Sigma[439] = 0;
  params.Sigma[469] = 0;
  params.Sigma[499] = 0;
  params.Sigma[529] = 0;
  params.Sigma[559] = 0;
  params.Sigma[589] = 1.86411966941064;
  params.Sigma[619] = 0;
  params.Sigma[649] = 0;
  params.Sigma[679] = 0;
  params.Sigma[709] = 0;
  params.Sigma[739] = 0;
  params.Sigma[769] = 0;
  params.Sigma[799] = 0;
  params.Sigma[829] = 0;
  params.Sigma[859] = 0;
  params.Sigma[889] = 0;
  params.Sigma[20] = 0;
  params.Sigma[50] = 0;
  params.Sigma[80] = 0;
  params.Sigma[110] = 0;
  params.Sigma[140] = 0;
  params.Sigma[170] = 0;
  params.Sigma[200] = 0;
  params.Sigma[230] = 0;
  params.Sigma[260] = 0;
  params.Sigma[290] = 0;
  params.Sigma[320] = 0;
  params.Sigma[350] = 0;
  params.Sigma[380] = 0;
  params.Sigma[410] = 0;
  params.Sigma[440] = 0;
  params.Sigma[470] = 0;
  params.Sigma[500] = 0;
  params.Sigma[530] = 0;
  params.Sigma[560] = 0;
  params.Sigma[590] = 0;
  params.Sigma[620] = 1.29087244582948;
  params.Sigma[650] = 0;
  params.Sigma[680] = 0;
  params.Sigma[710] = 0;
  params.Sigma[740] = 0;
  params.Sigma[770] = 0;
  params.Sigma[800] = 0;
  params.Sigma[830] = 0;
  params.Sigma[860] = 0;
  params.Sigma[890] = 0;
  params.Sigma[21] = 0;
  params.Sigma[51] = 0;
  params.Sigma[81] = 0;
  params.Sigma[111] = 0;
  params.Sigma[141] = 0;
  params.Sigma[171] = 0;
  params.Sigma[201] = 0;
  params.Sigma[231] = 0;
  params.Sigma[261] = 0;
  params.Sigma[291] = 0;
  params.Sigma[321] = 0;
  params.Sigma[351] = 0;
  params.Sigma[381] = 0;
  params.Sigma[411] = 0;
  params.Sigma[441] = 0;
  params.Sigma[471] = 0;
  params.Sigma[501] = 0;
  params.Sigma[531] = 0;
  params.Sigma[561] = 0;
  params.Sigma[591] = 0;
  params.Sigma[621] = 0;
  params.Sigma[651] = 1.74108240639956;
  params.Sigma[681] = 0;
  params.Sigma[711] = 0;
  params.Sigma[741] = 0;
  params.Sigma[771] = 0;
  params.Sigma[801] = 0;
  params.Sigma[831] = 0;
  params.Sigma[861] = 0;
  params.Sigma[891] = 0;
  params.Sigma[22] = 0;
  params.Sigma[52] = 0;
  params.Sigma[82] = 0;
  params.Sigma[112] = 0;
  params.Sigma[142] = 0;
  params.Sigma[172] = 0;
  params.Sigma[202] = 0;
  params.Sigma[232] = 0;
  params.Sigma[262] = 0;
  params.Sigma[292] = 0;
  params.Sigma[322] = 0;
  params.Sigma[352] = 0;
  params.Sigma[382] = 0;
  params.Sigma[412] = 0;
  params.Sigma[442] = 0;
  params.Sigma[472] = 0;
  params.Sigma[502] = 0;
  params.Sigma[532] = 0;
  params.Sigma[562] = 0;
  params.Sigma[592] = 0;
  params.Sigma[622] = 0;
  params.Sigma[652] = 0;
  params.Sigma[682] = 1.15803365470149;
  params.Sigma[712] = 0;
  params.Sigma[742] = 0;
  params.Sigma[772] = 0;
  params.Sigma[802] = 0;
  params.Sigma[832] = 0;
  params.Sigma[862] = 0;
  params.Sigma[892] = 0;
  params.Sigma[23] = 0;
  params.Sigma[53] = 0;
  params.Sigma[83] = 0;
  params.Sigma[113] = 0;
  params.Sigma[143] = 0;
  params.Sigma[173] = 0;
  params.Sigma[203] = 0;
  params.Sigma[233] = 0;
  params.Sigma[263] = 0;
  params.Sigma[293] = 0;
  params.Sigma[323] = 0;
  params.Sigma[353] = 0;
  params.Sigma[383] = 0;
  params.Sigma[413] = 0;
  params.Sigma[443] = 0;
  params.Sigma[473] = 0;
  params.Sigma[503] = 0;
  params.Sigma[533] = 0;
  params.Sigma[563] = 0;
  params.Sigma[593] = 0;
  params.Sigma[623] = 0;
  params.Sigma[653] = 0;
  params.Sigma[683] = 0;
  params.Sigma[713] = 1.69496343514088;
  params.Sigma[743] = 0;
  params.Sigma[773] = 0;
  params.Sigma[803] = 0;
  params.Sigma[833] = 0;
  params.Sigma[863] = 0;
  params.Sigma[893] = 0;
  params.Sigma[24] = 0;
  params.Sigma[54] = 0;
  params.Sigma[84] = 0;
  params.Sigma[114] = 0;
  params.Sigma[144] = 0;
  params.Sigma[174] = 0;
  params.Sigma[204] = 0;
  params.Sigma[234] = 0;
  params.Sigma[264] = 0;
  params.Sigma[294] = 0;
  params.Sigma[324] = 0;
  params.Sigma[354] = 0;
  params.Sigma[384] = 0;
  params.Sigma[414] = 0;
  params.Sigma[444] = 0;
  params.Sigma[474] = 0;
  params.Sigma[504] = 0;
  params.Sigma[534] = 0;
  params.Sigma[564] = 0;
  params.Sigma[594] = 0;
  params.Sigma[624] = 0;
  params.Sigma[654] = 0;
  params.Sigma[684] = 0;
  params.Sigma[714] = 0;
  params.Sigma[744] = 1.84141961903115;
  params.Sigma[774] = 0;
  params.Sigma[804] = 0;
  params.Sigma[834] = 0;
  params.Sigma[864] = 0;
  params.Sigma[894] = 0;
  params.Sigma[25] = 0;
  params.Sigma[55] = 0;
  params.Sigma[85] = 0;
  params.Sigma[115] = 0;
  params.Sigma[145] = 0;
  params.Sigma[175] = 0;
  params.Sigma[205] = 0;
  params.Sigma[235] = 0;
  params.Sigma[265] = 0;
  params.Sigma[295] = 0;
  params.Sigma[325] = 0;
  params.Sigma[355] = 0;
  params.Sigma[385] = 0;
  params.Sigma[415] = 0;
  params.Sigma[445] = 0;
  params.Sigma[475] = 0;
  params.Sigma[505] = 0;
  params.Sigma[535] = 0;
  params.Sigma[565] = 0;
  params.Sigma[595] = 0;
  params.Sigma[625] = 0;
  params.Sigma[655] = 0;
  params.Sigma[685] = 0;
  params.Sigma[715] = 0;
  params.Sigma[745] = 0;
  params.Sigma[775] = 1.72715207874671;
  params.Sigma[805] = 0;
  params.Sigma[835] = 0;
  params.Sigma[865] = 0;
  params.Sigma[895] = 0;
  params.Sigma[26] = 0;
  params.Sigma[56] = 0;
  params.Sigma[86] = 0;
  params.Sigma[116] = 0;
  params.Sigma[146] = 0;
  params.Sigma[176] = 0;
  params.Sigma[206] = 0;
  params.Sigma[236] = 0;
  params.Sigma[266] = 0;
  params.Sigma[296] = 0;
  params.Sigma[326] = 0;
  params.Sigma[356] = 0;
  params.Sigma[386] = 0;
  params.Sigma[416] = 0;
  params.Sigma[446] = 0;
  params.Sigma[476] = 0;
  params.Sigma[506] = 0;
  params.Sigma[536] = 0;
  params.Sigma[566] = 0;
  params.Sigma[596] = 0;
  params.Sigma[626] = 0;
  params.Sigma[656] = 0;
  params.Sigma[686] = 0;
  params.Sigma[716] = 0;
  params.Sigma[746] = 0;
  params.Sigma[776] = 0;
  params.Sigma[806] = 1.35910752486349;
  params.Sigma[836] = 0;
  params.Sigma[866] = 0;
  params.Sigma[896] = 0;
  params.Sigma[27] = 0;
  params.Sigma[57] = 0;
  params.Sigma[87] = 0;
  params.Sigma[117] = 0;
  params.Sigma[147] = 0;
  params.Sigma[177] = 0;
  params.Sigma[207] = 0;
  params.Sigma[237] = 0;
  params.Sigma[267] = 0;
  params.Sigma[297] = 0;
  params.Sigma[327] = 0;
  params.Sigma[357] = 0;
  params.Sigma[387] = 0;
  params.Sigma[417] = 0;
  params.Sigma[447] = 0;
  params.Sigma[477] = 0;
  params.Sigma[507] = 0;
  params.Sigma[537] = 0;
  params.Sigma[567] = 0;
  params.Sigma[597] = 0;
  params.Sigma[627] = 0;
  params.Sigma[657] = 0;
  params.Sigma[687] = 0;
  params.Sigma[717] = 0;
  params.Sigma[747] = 0;
  params.Sigma[777] = 0;
  params.Sigma[807] = 0;
  params.Sigma[837] = 1.7266897514902;
  params.Sigma[867] = 0;
  params.Sigma[897] = 0;
  params.Sigma[28] = 0;
  params.Sigma[58] = 0;
  params.Sigma[88] = 0;
  params.Sigma[118] = 0;
  params.Sigma[148] = 0;
  params.Sigma[178] = 0;
  params.Sigma[208] = 0;
  params.Sigma[238] = 0;
  params.Sigma[268] = 0;
  params.Sigma[298] = 0;
  params.Sigma[328] = 0;
  params.Sigma[358] = 0;
  params.Sigma[388] = 0;
  params.Sigma[418] = 0;
  params.Sigma[448] = 0;
  params.Sigma[478] = 0;
  params.Sigma[508] = 0;
  params.Sigma[538] = 0;
  params.Sigma[568] = 0;
  params.Sigma[598] = 0;
  params.Sigma[628] = 0;
  params.Sigma[658] = 0;
  params.Sigma[688] = 0;
  params.Sigma[718] = 0;
  params.Sigma[748] = 0;
  params.Sigma[778] = 0;
  params.Sigma[808] = 0;
  params.Sigma[838] = 0;
  params.Sigma[868] = 1.13946712418246;
  params.Sigma[898] = 0;
  params.Sigma[29] = 0;
  params.Sigma[59] = 0;
  params.Sigma[89] = 0;
  params.Sigma[119] = 0;
  params.Sigma[149] = 0;
  params.Sigma[179] = 0;
  params.Sigma[209] = 0;
  params.Sigma[239] = 0;
  params.Sigma[269] = 0;
  params.Sigma[299] = 0;
  params.Sigma[329] = 0;
  params.Sigma[359] = 0;
  params.Sigma[389] = 0;
  params.Sigma[419] = 0;
  params.Sigma[449] = 0;
  params.Sigma[479] = 0;
  params.Sigma[509] = 0;
  params.Sigma[539] = 0;
  params.Sigma[569] = 0;
  params.Sigma[599] = 0;
  params.Sigma[629] = 0;
  params.Sigma[659] = 0;
  params.Sigma[689] = 0;
  params.Sigma[719] = 0;
  params.Sigma[749] = 0;
  params.Sigma[779] = 0;
  params.Sigma[809] = 0;
  params.Sigma[839] = 0;
  params.Sigma[869] = 0;
  params.Sigma[899] = 1.31381911523322;
  /* Make this a diagonal PSD matrix, even though it's not diagonal. */
  params.PM[0] = 1.41958275668294;
  params.PM[30] = 0;
  params.PM[60] = 0;
  params.PM[90] = 0;
  params.PM[120] = 0;
  params.PM[150] = 0;
  params.PM[180] = 0;
  params.PM[210] = 0;
  params.PM[240] = 0;
  params.PM[270] = 0;
  params.PM[300] = 0;
  params.PM[330] = 0;
  params.PM[360] = 0;
  params.PM[390] = 0;
  params.PM[420] = 0;
  params.PM[450] = 0;
  params.PM[480] = 0;
  params.PM[510] = 0;
  params.PM[540] = 0;
  params.PM[570] = 0;
  params.PM[600] = 0;
  params.PM[630] = 0;
  params.PM[660] = 0;
  params.PM[690] = 0;
  params.PM[720] = 0;
  params.PM[750] = 0;
  params.PM[780] = 0;
  params.PM[810] = 0;
  params.PM[840] = 0;
  params.PM[870] = 0;
  params.PM[1] = 0;
  params.PM[31] = 1.87721203894432;
  params.PM[61] = 0;
  params.PM[91] = 0;
  params.PM[121] = 0;
  params.PM[151] = 0;
  params.PM[181] = 0;
  params.PM[211] = 0;
  params.PM[241] = 0;
  params.PM[271] = 0;
  params.PM[301] = 0;
  params.PM[331] = 0;
  params.PM[361] = 0;
  params.PM[391] = 0;
  params.PM[421] = 0;
  params.PM[451] = 0;
  params.PM[481] = 0;
  params.PM[511] = 0;
  params.PM[541] = 0;
  params.PM[571] = 0;
  params.PM[601] = 0;
  params.PM[631] = 0;
  params.PM[661] = 0;
  params.PM[691] = 0;
  params.PM[721] = 0;
  params.PM[751] = 0;
  params.PM[781] = 0;
  params.PM[811] = 0;
  params.PM[841] = 0;
  params.PM[871] = 0;
  params.PM[2] = 0;
  params.PM[32] = 0;
  params.PM[62] = 1.15374020857114;
  params.PM[92] = 0;
  params.PM[122] = 0;
  params.PM[152] = 0;
  params.PM[182] = 0;
  params.PM[212] = 0;
  params.PM[242] = 0;
  params.PM[272] = 0;
  params.PM[302] = 0;
  params.PM[332] = 0;
  params.PM[362] = 0;
  params.PM[392] = 0;
  params.PM[422] = 0;
  params.PM[452] = 0;
  params.PM[482] = 0;
  params.PM[512] = 0;
  params.PM[542] = 0;
  params.PM[572] = 0;
  params.PM[602] = 0;
  params.PM[632] = 0;
  params.PM[662] = 0;
  params.PM[692] = 0;
  params.PM[722] = 0;
  params.PM[752] = 0;
  params.PM[782] = 0;
  params.PM[812] = 0;
  params.PM[842] = 0;
  params.PM[872] = 0;
  params.PM[3] = 0;
  params.PM[33] = 0;
  params.PM[63] = 0;
  params.PM[93] = 1.88012479024932;
  params.PM[123] = 0;
  params.PM[153] = 0;
  params.PM[183] = 0;
  params.PM[213] = 0;
  params.PM[243] = 0;
  params.PM[273] = 0;
  params.PM[303] = 0;
  params.PM[333] = 0;
  params.PM[363] = 0;
  params.PM[393] = 0;
  params.PM[423] = 0;
  params.PM[453] = 0;
  params.PM[483] = 0;
  params.PM[513] = 0;
  params.PM[543] = 0;
  params.PM[573] = 0;
  params.PM[603] = 0;
  params.PM[633] = 0;
  params.PM[663] = 0;
  params.PM[693] = 0;
  params.PM[723] = 0;
  params.PM[753] = 0;
  params.PM[783] = 0;
  params.PM[813] = 0;
  params.PM[843] = 0;
  params.PM[873] = 0;
  params.PM[4] = 0;
  params.PM[34] = 0;
  params.PM[64] = 0;
  params.PM[94] = 0;
  params.PM[124] = 1.7989643192208;
  params.PM[154] = 0;
  params.PM[184] = 0;
  params.PM[214] = 0;
  params.PM[244] = 0;
  params.PM[274] = 0;
  params.PM[304] = 0;
  params.PM[334] = 0;
  params.PM[364] = 0;
  params.PM[394] = 0;
  params.PM[424] = 0;
  params.PM[454] = 0;
  params.PM[484] = 0;
  params.PM[514] = 0;
  params.PM[544] = 0;
  params.PM[574] = 0;
  params.PM[604] = 0;
  params.PM[634] = 0;
  params.PM[664] = 0;
  params.PM[694] = 0;
  params.PM[724] = 0;
  params.PM[754] = 0;
  params.PM[784] = 0;
  params.PM[814] = 0;
  params.PM[844] = 0;
  params.PM[874] = 0;
  params.PM[5] = 0;
  params.PM[35] = 0;
  params.PM[65] = 0;
  params.PM[95] = 0;
  params.PM[125] = 0;
  params.PM[155] = 1.97162429707798;
  params.PM[185] = 0;
  params.PM[215] = 0;
  params.PM[245] = 0;
  params.PM[275] = 0;
  params.PM[305] = 0;
  params.PM[335] = 0;
  params.PM[365] = 0;
  params.PM[395] = 0;
  params.PM[425] = 0;
  params.PM[455] = 0;
  params.PM[485] = 0;
  params.PM[515] = 0;
  params.PM[545] = 0;
  params.PM[575] = 0;
  params.PM[605] = 0;
  params.PM[635] = 0;
  params.PM[665] = 0;
  params.PM[695] = 0;
  params.PM[725] = 0;
  params.PM[755] = 0;
  params.PM[785] = 0;
  params.PM[815] = 0;
  params.PM[845] = 0;
  params.PM[875] = 0;
  params.PM[6] = 0;
  params.PM[36] = 0;
  params.PM[66] = 0;
  params.PM[96] = 0;
  params.PM[126] = 0;
  params.PM[156] = 0;
  params.PM[186] = 1.36770298330346;
  params.PM[216] = 0;
  params.PM[246] = 0;
  params.PM[276] = 0;
  params.PM[306] = 0;
  params.PM[336] = 0;
  params.PM[366] = 0;
  params.PM[396] = 0;
  params.PM[426] = 0;
  params.PM[456] = 0;
  params.PM[486] = 0;
  params.PM[516] = 0;
  params.PM[546] = 0;
  params.PM[576] = 0;
  params.PM[606] = 0;
  params.PM[636] = 0;
  params.PM[666] = 0;
  params.PM[696] = 0;
  params.PM[726] = 0;
  params.PM[756] = 0;
  params.PM[786] = 0;
  params.PM[816] = 0;
  params.PM[846] = 0;
  params.PM[876] = 0;
  params.PM[7] = 0;
  params.PM[37] = 0;
  params.PM[67] = 0;
  params.PM[97] = 0;
  params.PM[127] = 0;
  params.PM[157] = 0;
  params.PM[187] = 0;
  params.PM[217] = 1.20493976890778;
  params.PM[247] = 0;
  params.PM[277] = 0;
  params.PM[307] = 0;
  params.PM[337] = 0;
  params.PM[367] = 0;
  params.PM[397] = 0;
  params.PM[427] = 0;
  params.PM[457] = 0;
  params.PM[487] = 0;
  params.PM[517] = 0;
  params.PM[547] = 0;
  params.PM[577] = 0;
  params.PM[607] = 0;
  params.PM[637] = 0;
  params.PM[667] = 0;
  params.PM[697] = 0;
  params.PM[727] = 0;
  params.PM[757] = 0;
  params.PM[787] = 0;
  params.PM[817] = 0;
  params.PM[847] = 0;
  params.PM[877] = 0;
  params.PM[8] = 0;
  params.PM[38] = 0;
  params.PM[68] = 0;
  params.PM[98] = 0;
  params.PM[128] = 0;
  params.PM[158] = 0;
  params.PM[188] = 0;
  params.PM[218] = 0;
  params.PM[248] = 1.2405703203346;
  params.PM[278] = 0;
  params.PM[308] = 0;
  params.PM[338] = 0;
  params.PM[368] = 0;
  params.PM[398] = 0;
  params.PM[428] = 0;
  params.PM[458] = 0;
  params.PM[488] = 0;
  params.PM[518] = 0;
  params.PM[548] = 0;
  params.PM[578] = 0;
  params.PM[608] = 0;
  params.PM[638] = 0;
  params.PM[668] = 0;
  params.PM[698] = 0;
  params.PM[728] = 0;
  params.PM[758] = 0;
  params.PM[788] = 0;
  params.PM[818] = 0;
  params.PM[848] = 0;
  params.PM[878] = 0;
  params.PM[9] = 0;
  params.PM[39] = 0;
  params.PM[69] = 0;
  params.PM[99] = 0;
  params.PM[129] = 0;
  params.PM[159] = 0;
  params.PM[189] = 0;
  params.PM[219] = 0;
  params.PM[249] = 0;
  params.PM[279] = 1.82786280142142;
  params.PM[309] = 0;
  params.PM[339] = 0;
  params.PM[369] = 0;
  params.PM[399] = 0;
  params.PM[429] = 0;
  params.PM[459] = 0;
  params.PM[489] = 0;
  params.PM[519] = 0;
  params.PM[549] = 0;
  params.PM[579] = 0;
  params.PM[609] = 0;
  params.PM[639] = 0;
  params.PM[669] = 0;
  params.PM[699] = 0;
  params.PM[729] = 0;
  params.PM[759] = 0;
  params.PM[789] = 0;
  params.PM[819] = 0;
  params.PM[849] = 0;
  params.PM[879] = 0;
  params.PM[10] = 0;
  params.PM[40] = 0;
  params.PM[70] = 0;
  params.PM[100] = 0;
  params.PM[130] = 0;
  params.PM[160] = 0;
  params.PM[190] = 0;
  params.PM[220] = 0;
  params.PM[250] = 0;
  params.PM[280] = 0;
  params.PM[310] = 1.96522814859392;
  params.PM[340] = 0;
  params.PM[370] = 0;
  params.PM[400] = 0;
  params.PM[430] = 0;
  params.PM[460] = 0;
  params.PM[490] = 0;
  params.PM[520] = 0;
  params.PM[550] = 0;
  params.PM[580] = 0;
  params.PM[610] = 0;
  params.PM[640] = 0;
  params.PM[670] = 0;
  params.PM[700] = 0;
  params.PM[730] = 0;
  params.PM[760] = 0;
  params.PM[790] = 0;
  params.PM[820] = 0;
  params.PM[850] = 0;
  params.PM[880] = 0;
  params.PM[11] = 0;
  params.PM[41] = 0;
  params.PM[71] = 0;
  params.PM[101] = 0;
  params.PM[131] = 0;
  params.PM[161] = 0;
  params.PM[191] = 0;
  params.PM[221] = 0;
  params.PM[251] = 0;
  params.PM[281] = 0;
  params.PM[311] = 0;
  params.PM[341] = 1.69880999838042;
  params.PM[371] = 0;
  params.PM[401] = 0;
  params.PM[431] = 0;
  params.PM[461] = 0;
  params.PM[491] = 0;
  params.PM[521] = 0;
  params.PM[551] = 0;
  params.PM[581] = 0;
  params.PM[611] = 0;
  params.PM[641] = 0;
  params.PM[671] = 0;
  params.PM[701] = 0;
  params.PM[731] = 0;
  params.PM[761] = 0;
  params.PM[791] = 0;
  params.PM[821] = 0;
  params.PM[851] = 0;
  params.PM[881] = 0;
  params.PM[12] = 0;
  params.PM[42] = 0;
  params.PM[72] = 0;
  params.PM[102] = 0;
  params.PM[132] = 0;
  params.PM[162] = 0;
  params.PM[192] = 0;
  params.PM[222] = 0;
  params.PM[252] = 0;
  params.PM[282] = 0;
  params.PM[312] = 0;
  params.PM[342] = 0;
  params.PM[372] = 1.48249704177383;
  params.PM[402] = 0;
  params.PM[432] = 0;
  params.PM[462] = 0;
  params.PM[492] = 0;
  params.PM[522] = 0;
  params.PM[552] = 0;
  params.PM[582] = 0;
  params.PM[612] = 0;
  params.PM[642] = 0;
  params.PM[672] = 0;
  params.PM[702] = 0;
  params.PM[732] = 0;
  params.PM[762] = 0;
  params.PM[792] = 0;
  params.PM[822] = 0;
  params.PM[852] = 0;
  params.PM[882] = 0;
  params.PM[13] = 0;
  params.PM[43] = 0;
  params.PM[73] = 0;
  params.PM[103] = 0;
  params.PM[133] = 0;
  params.PM[163] = 0;
  params.PM[193] = 0;
  params.PM[223] = 0;
  params.PM[253] = 0;
  params.PM[283] = 0;
  params.PM[313] = 0;
  params.PM[343] = 0;
  params.PM[373] = 0;
  params.PM[403] = 1.28704976468113;
  params.PM[433] = 0;
  params.PM[463] = 0;
  params.PM[493] = 0;
  params.PM[523] = 0;
  params.PM[553] = 0;
  params.PM[583] = 0;
  params.PM[613] = 0;
  params.PM[643] = 0;
  params.PM[673] = 0;
  params.PM[703] = 0;
  params.PM[733] = 0;
  params.PM[763] = 0;
  params.PM[793] = 0;
  params.PM[823] = 0;
  params.PM[853] = 0;
  params.PM[883] = 0;
  params.PM[14] = 0;
  params.PM[44] = 0;
  params.PM[74] = 0;
  params.PM[104] = 0;
  params.PM[134] = 0;
  params.PM[164] = 0;
  params.PM[194] = 0;
  params.PM[224] = 0;
  params.PM[254] = 0;
  params.PM[284] = 0;
  params.PM[314] = 0;
  params.PM[344] = 0;
  params.PM[374] = 0;
  params.PM[404] = 0;
  params.PM[434] = 1.83368788434316;
  params.PM[464] = 0;
  params.PM[494] = 0;
  params.PM[524] = 0;
  params.PM[554] = 0;
  params.PM[584] = 0;
  params.PM[614] = 0;
  params.PM[644] = 0;
  params.PM[674] = 0;
  params.PM[704] = 0;
  params.PM[734] = 0;
  params.PM[764] = 0;
  params.PM[794] = 0;
  params.PM[824] = 0;
  params.PM[854] = 0;
  params.PM[884] = 0;
  params.PM[15] = 0;
  params.PM[45] = 0;
  params.PM[75] = 0;
  params.PM[105] = 0;
  params.PM[135] = 0;
  params.PM[165] = 0;
  params.PM[195] = 0;
  params.PM[225] = 0;
  params.PM[255] = 0;
  params.PM[285] = 0;
  params.PM[315] = 0;
  params.PM[345] = 0;
  params.PM[375] = 0;
  params.PM[405] = 0;
  params.PM[435] = 0;
  params.PM[465] = 1.87217950839943;
  params.PM[495] = 0;
  params.PM[525] = 0;
  params.PM[555] = 0;
  params.PM[585] = 0;
  params.PM[615] = 0;
  params.PM[645] = 0;
  params.PM[675] = 0;
  params.PM[705] = 0;
  params.PM[735] = 0;
  params.PM[765] = 0;
  params.PM[795] = 0;
  params.PM[825] = 0;
  params.PM[855] = 0;
  params.PM[885] = 0;
  params.PM[16] = 0;
  params.PM[46] = 0;
  params.PM[76] = 0;
  params.PM[106] = 0;
  params.PM[136] = 0;
  params.PM[166] = 0;
  params.PM[196] = 0;
  params.PM[226] = 0;
  params.PM[256] = 0;
  params.PM[286] = 0;
  params.PM[316] = 0;
  params.PM[346] = 0;
  params.PM[376] = 0;
  params.PM[406] = 0;
  params.PM[436] = 0;
  params.PM[466] = 0;
  params.PM[496] = 1.09213159180059;
  params.PM[526] = 0;
  params.PM[556] = 0;
  params.PM[586] = 0;
  params.PM[616] = 0;
  params.PM[646] = 0;
  params.PM[676] = 0;
  params.PM[706] = 0;
  params.PM[736] = 0;
  params.PM[766] = 0;
  params.PM[796] = 0;
  params.PM[826] = 0;
  params.PM[856] = 0;
  params.PM[886] = 0;
  params.PM[17] = 0;
  params.PM[47] = 0;
  params.PM[77] = 0;
  params.PM[107] = 0;
  params.PM[137] = 0;
  params.PM[167] = 0;
  params.PM[197] = 0;
  params.PM[227] = 0;
  params.PM[257] = 0;
  params.PM[287] = 0;
  params.PM[317] = 0;
  params.PM[347] = 0;
  params.PM[377] = 0;
  params.PM[407] = 0;
  params.PM[437] = 0;
  params.PM[467] = 0;
  params.PM[497] = 0;
  params.PM[527] = 1.21594947101978;
  params.PM[557] = 0;
  params.PM[587] = 0;
  params.PM[617] = 0;
  params.PM[647] = 0;
  params.PM[677] = 0;
  params.PM[707] = 0;
  params.PM[737] = 0;
  params.PM[767] = 0;
  params.PM[797] = 0;
  params.PM[827] = 0;
  params.PM[857] = 0;
  params.PM[887] = 0;
  params.PM[18] = 0;
  params.PM[48] = 0;
  params.PM[78] = 0;
  params.PM[108] = 0;
  params.PM[138] = 0;
  params.PM[168] = 0;
  params.PM[198] = 0;
  params.PM[228] = 0;
  params.PM[258] = 0;
  params.PM[288] = 0;
  params.PM[318] = 0;
  params.PM[348] = 0;
  params.PM[378] = 0;
  params.PM[408] = 0;
  params.PM[438] = 0;
  params.PM[468] = 0;
  params.PM[498] = 0;
  params.PM[528] = 0;
  params.PM[558] = 1.83176109045787;
  params.PM[588] = 0;
  params.PM[618] = 0;
  params.PM[648] = 0;
  params.PM[678] = 0;
  params.PM[708] = 0;
  params.PM[738] = 0;
  params.PM[768] = 0;
  params.PM[798] = 0;
  params.PM[828] = 0;
  params.PM[858] = 0;
  params.PM[888] = 0;
  params.PM[19] = 0;
  params.PM[49] = 0;
  params.PM[79] = 0;
  params.PM[109] = 0;
  params.PM[139] = 0;
  params.PM[169] = 0;
  params.PM[199] = 0;
  params.PM[229] = 0;
  params.PM[259] = 0;
  params.PM[289] = 0;
  params.PM[319] = 0;
  params.PM[349] = 0;
  params.PM[379] = 0;
  params.PM[409] = 0;
  params.PM[439] = 0;
  params.PM[469] = 0;
  params.PM[499] = 0;
  params.PM[529] = 0;
  params.PM[559] = 0;
  params.PM[589] = 1.8483038970795;
  params.PM[619] = 0;
  params.PM[649] = 0;
  params.PM[679] = 0;
  params.PM[709] = 0;
  params.PM[739] = 0;
  params.PM[769] = 0;
  params.PM[799] = 0;
  params.PM[829] = 0;
  params.PM[859] = 0;
  params.PM[889] = 0;
  params.PM[20] = 0;
  params.PM[50] = 0;
  params.PM[80] = 0;
  params.PM[110] = 0;
  params.PM[140] = 0;
  params.PM[170] = 0;
  params.PM[200] = 0;
  params.PM[230] = 0;
  params.PM[260] = 0;
  params.PM[290] = 0;
  params.PM[320] = 0;
  params.PM[350] = 0;
  params.PM[380] = 0;
  params.PM[410] = 0;
  params.PM[440] = 0;
  params.PM[470] = 0;
  params.PM[500] = 0;
  params.PM[530] = 0;
  params.PM[560] = 0;
  params.PM[590] = 0;
  params.PM[620] = 1.314652998764;
  params.PM[650] = 0;
  params.PM[680] = 0;
  params.PM[710] = 0;
  params.PM[740] = 0;
  params.PM[770] = 0;
  params.PM[800] = 0;
  params.PM[830] = 0;
  params.PM[860] = 0;
  params.PM[890] = 0;
  params.PM[21] = 0;
  params.PM[51] = 0;
  params.PM[81] = 0;
  params.PM[111] = 0;
  params.PM[141] = 0;
  params.PM[171] = 0;
  params.PM[201] = 0;
  params.PM[231] = 0;
  params.PM[261] = 0;
  params.PM[291] = 0;
  params.PM[321] = 0;
  params.PM[351] = 0;
  params.PM[381] = 0;
  params.PM[411] = 0;
  params.PM[441] = 0;
  params.PM[471] = 0;
  params.PM[501] = 0;
  params.PM[531] = 0;
  params.PM[561] = 0;
  params.PM[591] = 0;
  params.PM[621] = 0;
  params.PM[651] = 1.27929459684686;
  params.PM[681] = 0;
  params.PM[711] = 0;
  params.PM[741] = 0;
  params.PM[771] = 0;
  params.PM[801] = 0;
  params.PM[831] = 0;
  params.PM[861] = 0;
  params.PM[891] = 0;
  params.PM[22] = 0;
  params.PM[52] = 0;
  params.PM[82] = 0;
  params.PM[112] = 0;
  params.PM[142] = 0;
  params.PM[172] = 0;
  params.PM[202] = 0;
  params.PM[232] = 0;
  params.PM[262] = 0;
  params.PM[292] = 0;
  params.PM[322] = 0;
  params.PM[352] = 0;
  params.PM[382] = 0;
  params.PM[412] = 0;
  params.PM[442] = 0;
  params.PM[472] = 0;
  params.PM[502] = 0;
  params.PM[532] = 0;
  params.PM[562] = 0;
  params.PM[592] = 0;
  params.PM[622] = 0;
  params.PM[652] = 0;
  params.PM[682] = 1.43081502201846;
  params.PM[712] = 0;
  params.PM[742] = 0;
  params.PM[772] = 0;
  params.PM[802] = 0;
  params.PM[832] = 0;
  params.PM[862] = 0;
  params.PM[892] = 0;
  params.PM[23] = 0;
  params.PM[53] = 0;
  params.PM[83] = 0;
  params.PM[113] = 0;
  params.PM[143] = 0;
  params.PM[173] = 0;
  params.PM[203] = 0;
  params.PM[233] = 0;
  params.PM[263] = 0;
  params.PM[293] = 0;
  params.PM[323] = 0;
  params.PM[353] = 0;
  params.PM[383] = 0;
  params.PM[413] = 0;
  params.PM[443] = 0;
  params.PM[473] = 0;
  params.PM[503] = 0;
  params.PM[533] = 0;
  params.PM[563] = 0;
  params.PM[593] = 0;
  params.PM[623] = 0;
  params.PM[653] = 0;
  params.PM[683] = 0;
  params.PM[713] = 1.53944650026467;
  params.PM[743] = 0;
  params.PM[773] = 0;
  params.PM[803] = 0;
  params.PM[833] = 0;
  params.PM[863] = 0;
  params.PM[893] = 0;
  params.PM[24] = 0;
  params.PM[54] = 0;
  params.PM[84] = 0;
  params.PM[114] = 0;
  params.PM[144] = 0;
  params.PM[174] = 0;
  params.PM[204] = 0;
  params.PM[234] = 0;
  params.PM[264] = 0;
  params.PM[294] = 0;
  params.PM[324] = 0;
  params.PM[354] = 0;
  params.PM[384] = 0;
  params.PM[414] = 0;
  params.PM[444] = 0;
  params.PM[474] = 0;
  params.PM[504] = 0;
  params.PM[534] = 0;
  params.PM[564] = 0;
  params.PM[594] = 0;
  params.PM[624] = 0;
  params.PM[654] = 0;
  params.PM[684] = 0;
  params.PM[714] = 0;
  params.PM[744] = 1.09556681500661;
  params.PM[774] = 0;
  params.PM[804] = 0;
  params.PM[834] = 0;
  params.PM[864] = 0;
  params.PM[894] = 0;
  params.PM[25] = 0;
  params.PM[55] = 0;
  params.PM[85] = 0;
  params.PM[115] = 0;
  params.PM[145] = 0;
  params.PM[175] = 0;
  params.PM[205] = 0;
  params.PM[235] = 0;
  params.PM[265] = 0;
  params.PM[295] = 0;
  params.PM[325] = 0;
  params.PM[355] = 0;
  params.PM[385] = 0;
  params.PM[415] = 0;
  params.PM[445] = 0;
  params.PM[475] = 0;
  params.PM[505] = 0;
  params.PM[535] = 0;
  params.PM[565] = 0;
  params.PM[595] = 0;
  params.PM[625] = 0;
  params.PM[655] = 0;
  params.PM[685] = 0;
  params.PM[715] = 0;
  params.PM[745] = 0;
  params.PM[775] = 1.83691213871362;
  params.PM[805] = 0;
  params.PM[835] = 0;
  params.PM[865] = 0;
  params.PM[895] = 0;
  params.PM[26] = 0;
  params.PM[56] = 0;
  params.PM[86] = 0;
  params.PM[116] = 0;
  params.PM[146] = 0;
  params.PM[176] = 0;
  params.PM[206] = 0;
  params.PM[236] = 0;
  params.PM[266] = 0;
  params.PM[296] = 0;
  params.PM[326] = 0;
  params.PM[356] = 0;
  params.PM[386] = 0;
  params.PM[416] = 0;
  params.PM[446] = 0;
  params.PM[476] = 0;
  params.PM[506] = 0;
  params.PM[536] = 0;
  params.PM[566] = 0;
  params.PM[596] = 0;
  params.PM[626] = 0;
  params.PM[656] = 0;
  params.PM[686] = 0;
  params.PM[716] = 0;
  params.PM[746] = 0;
  params.PM[776] = 0;
  params.PM[806] = 1.53473487035132;
  params.PM[836] = 0;
  params.PM[866] = 0;
  params.PM[896] = 0;
  params.PM[27] = 0;
  params.PM[57] = 0;
  params.PM[87] = 0;
  params.PM[117] = 0;
  params.PM[147] = 0;
  params.PM[177] = 0;
  params.PM[207] = 0;
  params.PM[237] = 0;
  params.PM[267] = 0;
  params.PM[297] = 0;
  params.PM[327] = 0;
  params.PM[357] = 0;
  params.PM[387] = 0;
  params.PM[417] = 0;
  params.PM[447] = 0;
  params.PM[477] = 0;
  params.PM[507] = 0;
  params.PM[537] = 0;
  params.PM[567] = 0;
  params.PM[597] = 0;
  params.PM[627] = 0;
  params.PM[657] = 0;
  params.PM[687] = 0;
  params.PM[717] = 0;
  params.PM[747] = 0;
  params.PM[777] = 0;
  params.PM[807] = 0;
  params.PM[837] = 1.77496781504092;
  params.PM[867] = 0;
  params.PM[897] = 0;
  params.PM[28] = 0;
  params.PM[58] = 0;
  params.PM[88] = 0;
  params.PM[118] = 0;
  params.PM[148] = 0;
  params.PM[178] = 0;
  params.PM[208] = 0;
  params.PM[238] = 0;
  params.PM[268] = 0;
  params.PM[298] = 0;
  params.PM[328] = 0;
  params.PM[358] = 0;
  params.PM[388] = 0;
  params.PM[418] = 0;
  params.PM[448] = 0;
  params.PM[478] = 0;
  params.PM[508] = 0;
  params.PM[538] = 0;
  params.PM[568] = 0;
  params.PM[598] = 0;
  params.PM[628] = 0;
  params.PM[658] = 0;
  params.PM[688] = 0;
  params.PM[718] = 0;
  params.PM[748] = 0;
  params.PM[778] = 0;
  params.PM[808] = 0;
  params.PM[838] = 0;
  params.PM[868] = 1.23083626557633;
  params.PM[898] = 0;
  params.PM[29] = 0;
  params.PM[59] = 0;
  params.PM[89] = 0;
  params.PM[119] = 0;
  params.PM[149] = 0;
  params.PM[179] = 0;
  params.PM[209] = 0;
  params.PM[239] = 0;
  params.PM[269] = 0;
  params.PM[299] = 0;
  params.PM[329] = 0;
  params.PM[359] = 0;
  params.PM[389] = 0;
  params.PM[419] = 0;
  params.PM[449] = 0;
  params.PM[479] = 0;
  params.PM[509] = 0;
  params.PM[539] = 0;
  params.PM[569] = 0;
  params.PM[599] = 0;
  params.PM[629] = 0;
  params.PM[659] = 0;
  params.PM[689] = 0;
  params.PM[719] = 0;
  params.PM[749] = 0;
  params.PM[779] = 0;
  params.PM[809] = 0;
  params.PM[839] = 0;
  params.PM[869] = 0;
  params.PM[899] = 1.96529335110637;
  params.pm[0] = 1.00410922927352;
  params.pm[1] = -0.627624542432154;
  params.pm[2] = 1.79411058783982;
  params.pm[3] = 0.802047115865091;
  params.pm[4] = 1.36224434194495;
  params.pm[5] = -1.81801077657652;
  params.pm[6] = -1.77743383579325;
  params.pm[7] = 0.970949094198515;
  params.pm[8] = -0.781254268206432;
  params.pm[9] = 0.0671374633729811;
  params.pm[10] = -1.37495030531491;
  params.pm[11] = 1.91180963862794;
  params.pm[12] = 0.0110041906976779;
  params.pm[13] = 1.3160043138989;
  params.pm[14] = -1.70384881488001;
  params.pm[15] = -0.0843381911286474;
  params.pm[16] = -1.7508820783769;
  params.pm[17] = 1.53696572435095;
  params.pm[18] = -0.216759285148165;
  params.pm[19] = -1.72580032695265;
  params.pm[20] = -1.69401487073617;
  params.pm[21] = 0.15517063201268;
  params.pm[22] = -1.69773438197908;
  params.pm[23] = -1.26491072795023;
  params.pm[24] = -0.254571663333944;
  params.pm[25] = -0.00886867592617024;
  params.pm[26] = 0.33324766096703;
  params.pm[27] = 0.482050725619629;
  params.pm[28] = -0.508754001429326;
  params.pm[29] = 0.474946331922319;
}
