% Stephen Becker, 2/21/09.  srbecker@caltech.edu

% Had to rewrite some of the fortran code into C, because
% compiling fortran on Windows is a major headache.

% 3/4/09 -- didn't I set this up for SVT code already?

fprintf('\n');
in = input('This will compile mex files.  Continue? [y]/n  ','s');
if ~isempty(in) && (strcmp(in,'n') || strcmp(in,'no') )
    return;
end

fprintf('You may need to run ''mex -setup'' to setup the mex compiler,\n if you''ve never used the mex compiler before\n');

c = computer;
if ispc
    % Windows -- that's unfortunate
    
    if strfind(c,'64')
        disp('If you have 64-bit windows, you might need to modify this script yourself');
        libpath = fullfile(matlabroot,'extern','lib','win64','lcc');
    else
        libpath = fullfile(matlabroot,'extern','lib','win32','lcc');
    end

    % look for necessary files (i.e. make sure we're in right directory)
    if ~exist('dbdqr.c','file') || ~exist('bdsqr_mex.c','file')
        disp('Please run this from the same directory as dbdqr.c and bdsqr_mex.c');
        return;
    end
    
    % look for pre-built executables
%     mexext('all');  c = computer 
    ext = mexext;
    if exist(['bdsqr.',ext],'file')
        disp('Found precompiled executables for your platform');
        in = input('Recompile anyway? (old executable will be copied to the "Old" subdirectory) [n]/y  ','s');
        if ~isempty(in) && ( strcmp(in,'y') || strcmp(in,'yes') )
            disp('Backing up old executables ...');
            if ~exist('Old','file'), mkdir('Old'); end
            if ~exist(['Old',filesep,'bdsqr.',ext],'file')
                copyfile(['bdsqr.',ext],'Old');
            end
            disp('Proceeding to compile...');
        else
            return;
        end
    end
    
    % build a temporary file
%     rspfile = [tempname '.rsp'];  % if this fails, try with  tempname(pwd)
    rspfile = 'temp_file.rsp';
    [Frsp, errmsg] = fopen(rspfile, 'wt');
    if ~isempty(errmsg) 
%         rspfile = [tempname(pwd) '.rsp']; 
%         [Frsp, errmsg] = fopen(rspfile, 'wt');
%         if ~isempty(errmsg) 
            disp('Error: can''t open temp file');  return;
%         end
    end
    fprintf(Frsp,'-L''%s''',libpath);
    fclose(Frsp);
    
    % try to compile
    mex -v -DWINDOWS @temp_file.rsp  -lmwlapack -lmwblas dbdqr.c bdsqr_mex.c -output bdsqr
    
    % and remove rspfile:
    delete(rspfile);
    
    % see if it worked
    disp('Looks like it worked.  Now, testing the installation');
    a = randn(50,1); b = randn(50,1);
    [s,bnd]=bdsqr(a,b);
    disp('No error messages!  Our job here is done');
    
    % This is what we don't want to see: PROPACK:NotUsingMex','Using slow
    % matlab code for bdsqr.'
    
end
