if isempty(strfind(path,'PROPACK_simple'))
    addpath PROPACK_simple   % you might want to modify this
                            % to an absolute path
end

%% Setup a matrix
randn('state',2009);
rand('state',2009);

n1 = 200; n2 = 200; r = 10;
M = randn(n1,r)*randn(r,n2);

df = r*(n1+n2-r);
oversampling = 5; m = min(5*df,.99*n1*n2); 

Omega = randsample(n1*n2,m); 
data = M(Omega) + .1*randn(size(Omega));

%% Set parameters and solve

p  = m/(n1*n2); tau = 5*sqrt(n1*n2); delta = 1.2/p;       
maxiter = 500; tol = 1e-4;
% if the algorithm doesn't work well, try changing tau and delta
%   i.e. if it diverges, try a smaller delta (e.g. delta < 2 is a 
%   safe choice, but the algorithm may be slower than necessary).

%% Approximate minimum nuclear norm solution by SVT algorithm

    tic

    [U,S,V,numiter] = SVT([n1 n2],Omega,data,tau,delta,maxiter,tol);

    toc 
    
   X = U*S*V';
    
%% Show results
fprintf('The recovered rank is %d\n',length(diag(S)) );
fprintf('The relative error on Omega is: %d\n', norm(data-X(Omega))/norm(data))
fprintf('The relative recovery error is: %d\n', norm(M-X,'fro')/norm(M,'fro'))
fprintf('The relative recovery in the spectral norm is: %d\n', norm(M-X)/norm(M))





