function y = XonOmega(U,V,omega)
% y = XonOmega(U,V,omega)
%   This implicitly forms the matrix A = U*V'
%   and then returns A(omega).
%
% y = XonOmega(U,V,I,J)
%   does the same thing, but uses subscript indices I and J
%   ( where [I,J] = ind2sub( size(A), omega )
%
% y = XonOmega(U,V,OMEGA)
%   does the same thing, but now omega is specified by the nonzero
%   entries of the matrix OMEGA.   This will give same results
%   as previous variations IF the vector omega is sorted.
%
%   Stephen Becker, 11/10/08


% This file only runs if there is no compiled mex file in the
% path.  You do NOT want to run this file as-is, because it's
% very wasteful.
disp('Warning in XonOmega.m: using non-mex version');
A = U*V';
y = A(omega);
