%{
    Thanks for downloading SVT.

    SVT, and PROPACK (a software package by R.M.Larsen for sparse
        SVDs) contain some .mex files.  These files have already
        been compiled for most standard computer platforms, so
        you probably do not need to do anything special.  But if
        you need to compile them, go the "private" subdirectory
        and run "install_mex".

    Also in the "private" subdirectory is "test_PROPACK.m", which
        tests the PROPACK installation.  We have included only the
        part of PROPACK relevant to SVT (and made a few small changes).

    This files runs SVT to verify that it works.

    -Stephen Becker, March 2009
%}
if ispc
    % reorth.f isn't compiled for Windows, but this shouldn't be an
    % issue, because the .m file version is pretty fast
    warning('off','PROPACK:NotUsingMex');
end
%% Setup a matrix
randn('state',2009);
rand('state',2009);

n1 = 150; n2 = 300; r = 10;
M = randn(n1,r)*randn(r,n2);

df = r*(n1+n2-r);
oversampling = 5; m = min(5*df,round(.99*n1*n2) ); 

Omega = randsample(n1*n2,m);  % this requires the stats toolbox
% a workaround, if you don't have the stats toolbox, is this:
%   Omega = randperm(n1*n2); Omega = Omega(1:m);

data = M(Omega);
% add in noise, if desired
sigma = 0;
% sigma = .05*std(data);
data = data + sigma*randn(size(data));

%% Set parameters and solve

p  = m/(n1*n2); tau = 5*sqrt(n1*n2); delta = 1.2/p;       
% if n1 and n2 are very different, then
%   tau should probably be bigger than 5*sqrt(n1*n2)
maxiter = 500; tol = 1e-4;
% if the algorithm doesn't work well, try changing tau and delta
%   i.e. if it diverges, try a smaller delta (e.g. delta < 2 is a 
%   safe choice, but the algorithm may be slower than necessary).

%% Approximate minimum nuclear norm solution by SVT algorithm
% Note: SVT is setup for noiseless data (i.e. equality constraints).
%   It is easy to modify it to handle noisy data (i.e. certain types
%   of inequality constraings).  Without this modification, it
%   will do poorly in the presence of noise (since actually isn't a
%   low-rank matrix that fits the equalities).

tic
[U,S,V,numiter] = SVT([n1 n2],Omega,data,tau,delta,maxiter,tol);
toc
    
X = U*S*V';
    
% Show results
fprintf('The recovered rank is %d\n',length(diag(S)) );
fprintf('The relative error on Omega is: %d\n', norm(data-X(Omega))/norm(data))
fprintf('The relative recovery error is: %d\n', norm(M-X,'fro')/norm(M,'fro'))
fprintf('The relative recovery in the spectral norm is: %d\n', norm(M-X)/norm(M))

%% Approximate minimum nuclear norm solution by FPC algorithm
mu_final = .01; tol = 1e-3;

tic
[U,S,V,numiter] = FPC([n1 n2],Omega,data,mu_final,maxiter,tol);
toc
   
X = U*S*V';

% Show results
fprintf('The recovered rank is %d\n',length(diag(S)) );
fprintf('The relative error on Omega is: %d\n', norm(data-X(Omega))/norm(data))
fprintf('The relative recovery error is: %d\n', norm(M-X,'fro')/norm(M,'fro'))
fprintf('The relative recovery in the spectral norm is: %d\n', norm(M-X)/norm(M))
    