/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.JobAttributes;
import java.awt.MediaTracker;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class PrintUtil {
    private static PrintUtil pu = null;
    private static Object objectToBePrinted;
    private static final int LINESPERPAGE = 60;
    private static JobAttributes jobAttr;
    private static PageAttributes pageAttr;
    private static PrintJob printJob;
    private static Properties printProperties;
    private static boolean printHeader;
    private static String userTitle;
    private static String jobName;
    private static String[] theHeader;
    private static String theDate;
    private static String dateFormat;
    private static String frameTitle;
    private static String pageNumberPrefix;
    private static int pageNumberStart;
    private static char pageNumberLocation;
    private static double marginBinding;
    private static double marginLeft;
    private static double marginTop;
    private static final String[] BLANK_ARRAY;
    private static final int BLANK_ARRAY_LENGTH;
    private static final int BLANK_ARRAY_LAST;
    private static final String BLANK_MSG = "This page intentionally left blank.";

    public PrintUtil(Object object) {
        if (pu != null && pu != this) {
            System.err.println("PrintUtil reconstructed.  Send information to CEA team at NASA/GRC.");
        }
        pu = this;
        objectToBePrinted = object;
    }

    public static PrintUtil getInstance() {
        if (pu == null) {
            new PrintUtil(null);
        }
        return pu;
    }

    public static void printComponent(Object object) {
        if (pu == null) {
            new PrintUtil(object).print();
        } else {
            objectToBePrinted = object;
            pu.print();
        }
    }

    public static void printFile(String string) {
        File file = new File(string);
        if (pu == null) {
            new PrintUtil(file).print();
        } else {
            objectToBePrinted = file;
            pu.print();
        }
    }

    public void print() {
        int n = this.getNumberOfLines();
        if (n > 0) {
            int n2 = this.getNumberOfPages(n);
            Object object = new Date();
            Serializable serializable = new SimpleDateFormat("yyMMddHHmmss");
            ((DateFormat)serializable).setTimeZone(TimeZone.getDefault());
            String string = "output.CEA." + ((DateFormat)serializable).format((Date)object);
            jobAttr.setFileName(string);
            jobAttr.setMinPage(1);
            jobAttr.setMaxPage(n2);
            jobName = "";
            object = null;
            if (objectToBePrinted instanceof Component) {
                serializable = (Component)objectToBePrinted;
                while (serializable != null) {
                    if (serializable instanceof JInternalFrame) {
                        jobName = ((JInternalFrame)serializable).getTitle();
                    } else {
                        if (serializable instanceof JFrame) {
                            frameTitle = ((JFrame)serializable).getTitle();
                            if (jobName.length() != 0) break;
                            jobName = frameTitle;
                            frameTitle = "";
                            break;
                        }
                        if (serializable instanceof Frame) {
                            frameTitle = ((Frame)serializable).getTitle();
                            if (jobName.length() != 0) break;
                            jobName = frameTitle;
                            frameTitle = "";
                            break;
                        }
                        if (((Component)serializable).getParent() instanceof JTabbedPane) {
                            int n3 = ((JTabbedPane)((Component)serializable).getParent()).indexOfComponent((Component)serializable);
                            object = ((JTabbedPane)((Component)serializable).getParent()).getTitleAt(n3);
                        }
                    }
                    serializable = ((Component)serializable).getParent();
                }
                if (object != null) {
                    jobName = jobName + ": " + (String)object;
                }
                if (objectToBePrinted instanceof JTextArea) {
                    pageAttr.setPrintQuality(PageAttributes.PrintQualityType.NORMAL);
                } else if (objectToBePrinted instanceof JTable) {
                    pageAttr.setPrintQuality(PageAttributes.PrintQualityType.NORMAL);
                } else if (objectToBePrinted instanceof JTree) {
                    pageAttr.setPrintQuality(PageAttributes.PrintQualityType.NORMAL);
                } else {
                    pageAttr.setPrintQuality(PageAttributes.PrintQualityType.HIGH);
                    if (((Component)objectToBePrinted).getWidth() > ((Component)objectToBePrinted).getHeight()) {
                        pageAttr.setOrientationRequested(PageAttributes.OrientationRequestedType.LANDSCAPE);
                    } else {
                        pageAttr.setOrientationRequested(PageAttributes.OrientationRequestedType.PORTRAIT);
                    }
                }
            } else if (objectToBePrinted instanceof Vector) {
                frameTitle = "CEA";
                jobName = "CEA data";
                pageAttr.setPrintQuality(PageAttributes.PrintQualityType.NORMAL);
            } else if (objectToBePrinted instanceof File) {
                frameTitle = "CEA";
                jobName = "CEA file " + ((File)objectToBePrinted).getName();
                pageAttr.setPrintQuality(PageAttributes.PrintQualityType.NORMAL);
            } else {
                frameTitle = "CEA";
                jobName = "CEA ???";
                pageAttr.setPrintQuality(PageAttributes.PrintQualityType.NORMAL);
            }
            printJob = Toolkit.getDefaultToolkit().getPrintJob(new Frame("Printer Options"), jobName, jobAttr, pageAttr);
            if (printJob != null) {
                this.printMe(n, n2);
                printJob.end();
                printJob.finalize();
            }
        }
    }

    private void printMe(int n, int n2) {
        block350: {
            boolean bl;
            Font font;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            boolean bl2;
            boolean bl3;
            int[][] nArray;
            block354: {
                String string;
                int n12;
                int n13;
                int n14;
                String string2;
                int n15;
                block353: {
                    block352: {
                        block351: {
                            Object object;
                            block349: {
                                if (n2 == 0) {
                                    return;
                                }
                                if (jobAttr.getDefaultSelection() == JobAttributes.DefaultSelectionType.RANGE) {
                                    nArray = jobAttr.getPageRanges();
                                } else {
                                    nArray = new int[1][2];
                                    nArray[0][0] = 1;
                                    nArray[0][1] = n2;
                                }
                                bl3 = false;
                                bl2 = false;
                                JobAttributes.SidesType sidesType = jobAttr.getSides();
                                PageAttributes.OrientationRequestedType orientationRequestedType = pageAttr.getOrientationRequested();
                                if (sidesType == JobAttributes.SidesType.TWO_SIDED_LONG_EDGE) {
                                    if (orientationRequestedType == PageAttributes.OrientationRequestedType.PORTRAIT) {
                                        bl3 = true;
                                    } else {
                                        bl2 = true;
                                    }
                                } else if (sidesType == JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE) {
                                    if (orientationRequestedType == PageAttributes.OrientationRequestedType.PORTRAIT) {
                                        bl2 = true;
                                    } else {
                                        bl3 = true;
                                    }
                                }
                                n11 = 20;
                                int n16 = printJob.getPageResolution();
                                n10 = (int)Math.ceil((double)n16 * marginBinding);
                                n9 = (int)Math.ceil((double)n16 * marginLeft);
                                if (n9 < 20) {
                                    n9 = 20;
                                }
                                if ((n8 = (int)Math.ceil((double)n16 * marginTop)) < 20) {
                                    n8 = 20;
                                }
                                int n17 = (n16 + 3) / 6;
                                Dimension dimension = printJob.getPageDimension();
                                n7 = dimension.height;
                                n6 = dimension.width;
                                n5 = n7 - n8 - n11;
                                n4 = n6 - n9 - n11;
                                if (bl3) {
                                    n4 -= n10;
                                } else if (bl2) {
                                    n5 -= n10;
                                } else {
                                    n4 -= n10;
                                }
                                int n18 = (n5 + 30) / 60;
                                int n19 = n6 > n7 ? 132 : 80;
                                int n20 = (n4 + n19 / 2) * 7 / n19 / 5;
                                n3 = Math.min(n17, Math.min(n18, n20));
                                font = new Font("Monospaced", 0, n3 * 4 / 5);
                                n15 = this.getLinesPerPage();
                                bl = true;
                                if (!(objectToBePrinted instanceof JTextArea)) break block349;
                                JTextArea jTextArea = (JTextArea)objectToBePrinted;
                                int n21 = 0;
                                int n22 = 0;
                                int n23 = 0;
                                while (n23 < nArray.length) {
                                    int n24;
                                    int n25 = nArray[n23][0];
                                    int n26 = nArray[n23][1];
                                    if (printJob.lastPageFirst()) {
                                        n24 = n25;
                                        n25 = n26;
                                        n26 = n24;
                                        n24 = -1;
                                    } else {
                                        n24 = 1;
                                    }
                                    int n27 = n25;
                                    while (true) {
                                        int n28;
                                        int n29;
                                        int n30;
                                        int n31;
                                        int n32;
                                        Graphics graphics = printJob.getGraphics();
                                        graphics.setFont(font);
                                        FontMetrics fontMetrics = graphics.getFontMetrics();
                                        int n33 = fontMetrics.getHeight();
                                        int n34 = fontMetrics.getAscent();
                                        int n35 = n3;
                                        int n36 = fontMetrics.charWidth('W');
                                        int n37 = n9;
                                        int n38 = n8 + n34;
                                        int n39 = pageNumberStart + n27 - 1;
                                        if (bl3) {
                                            if (n39 % 2 != 0) {
                                                n37 += n10;
                                            }
                                        } else if (bl2) {
                                            if (n39 % 2 != 0) {
                                                n38 += n10;
                                            }
                                        } else if (pageNumberLocation == 'a') {
                                            if (n39 % 2 != 0) {
                                                n37 += n10;
                                            }
                                        } else {
                                            n37 += n10;
                                        }
                                        int n40 = n4 / n36;
                                        if (bl) {
                                            PrintUtil.initializeHeaders(n40);
                                            bl = false;
                                            if (bl3 || bl2) {
                                                if (n39 % 2 == 0) {
                                                    if (n24 > 0) {
                                                        n32 = (n6 + n9 - n11 - n36 * BLANK_MSG.length()) / 2;
                                                        if (bl3) {
                                                            n32 += n10 / 2;
                                                        }
                                                        if (n32 < 0) {
                                                            n32 = 0;
                                                        }
                                                        n31 = n7 / 2;
                                                        if (bl2) {
                                                            n31 += n10 / 2;
                                                        }
                                                        graphics.drawString(BLANK_MSG, n32, n31);
                                                        graphics.dispose();
                                                        graphics = printJob.getGraphics();
                                                        graphics.setFont(font);
                                                    }
                                                } else if (n24 < 0) {
                                                    n32 = (n6 + n9 - n11 - n36 * BLANK_MSG.length()) / 2;
                                                    if (bl3) {
                                                        n32 -= n10 / 2;
                                                    }
                                                    if (n32 < 0) {
                                                        n32 = 0;
                                                    }
                                                    n31 = n7 / 2;
                                                    if (bl2) {
                                                        n31 -= n10 / 2;
                                                    }
                                                    if (n31 < 0) {
                                                        n31 = 0;
                                                    }
                                                    graphics.drawString(BLANK_MSG, n32, n31);
                                                    graphics.dispose();
                                                    graphics = printJob.getGraphics();
                                                    graphics.setFont(font);
                                                }
                                            }
                                        }
                                        if (theHeader != null) {
                                            n32 = theHeader.length;
                                            n31 = 0;
                                            while (n31 < n32) {
                                                graphics.drawString(theHeader[n31], n37, n38);
                                                n38 += n35;
                                                ++n31;
                                            }
                                            n38 += n35;
                                        }
                                        n32 = (n27 - 1) * n15;
                                        n31 = Math.min(n32 + n15, n);
                                        int n41 = 0;
                                        int n42 = n32;
                                        while (n42 < n31) {
                                            try {
                                                int n43 = n42 == n32 ? jTextArea.getLineStartOffset(n42) : n41;
                                                n41 = jTextArea.getLineEndOffset(n42);
                                                int n44 = n41 - n43;
                                                String string3 = jTextArea.getText(n43, n44);
                                                int n45 = string3.length();
                                                if (n45 > 0) {
                                                    n30 = string3.charAt(0);
                                                    if (n30 == 10) {
                                                        string3 = string3.substring(1, n45);
                                                    } else if (n30 == 12) {
                                                        string3 = string3.substring(1, n45);
                                                        --n45;
                                                    }
                                                    n29 = --n45;
                                                    while (n29 > 0) {
                                                        n28 = string3.charAt(n29 - 1);
                                                        if (!Character.isWhitespace((char)n28)) break;
                                                        --n29;
                                                    }
                                                    if (n29 < n45) {
                                                        string3 = string3.substring(0, n29);
                                                        n45 = n29;
                                                    }
                                                }
                                                while ((n30 = string3.indexOf(9)) >= 0) {
                                                    n29 = (n30 / 8 + 1) * 8 - n30;
                                                    if (n30 == 0) {
                                                        string3 = BLANK_ARRAY[n29] + string3.substring(n30 + 1);
                                                        continue;
                                                    }
                                                    string3 = string3.substring(0, n30) + BLANK_ARRAY[n29] + string3.substring(n30 + 1);
                                                }
                                                graphics.drawString(string3, n37, n38);
                                                ++n22;
                                                n38 += n35;
                                            }
                                            catch (BadLocationException badLocationException) {
                                                System.err.println("BAD Location at line " + n42 + " on page " + n27);
                                                break;
                                            }
                                            ++n42;
                                        }
                                        String string4 = pageNumberPrefix + n39;
                                        n30 = n37;
                                        n29 = n7 - n11 - n35;
                                        n28 = n6 - n11 - n36 * string4.length();
                                        if (bl3) {
                                            if (n39 % 2 == 0) {
                                                n28 -= n10;
                                            }
                                        } else if (bl2 && n39 % 2 == 0) {
                                            n29 -= n10;
                                        }
                                        if (pageNumberLocation == 'c') {
                                            n30 = (n37 + n28) / 2;
                                        } else if (pageNumberLocation == 'l') {
                                            n30 = n37;
                                        } else if (pageNumberLocation == 'r') {
                                            n30 = n28;
                                        } else if (pageNumberLocation == 'a') {
                                            if (n39 % 2 != 0) {
                                                n30 = n28;
                                            }
                                        } else {
                                            n30 = n6 / 2;
                                        }
                                        n29 = Math.max(n29, n38 + n35 + n35);
                                        graphics.drawString(string4, n30, n29);
                                        graphics.dispose();
                                        ++n21;
                                        if (n27 == n26) break;
                                        n27 += n24;
                                    }
                                    ++n23;
                                }
                                break block350;
                            }
                            if (!(objectToBePrinted instanceof File)) break block351;
                            File file = (File)objectToBePrinted;
                            String string5 = file.getPath();
                            BufferedReader bufferedReader = null;
                            try {
                                object = new FileInputStream(file);
                                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                System.err.println("File not found: " + string5);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            int n46 = 0;
                            int n47 = 0;
                            int n48 = 0;
                            int n49 = 0;
                            while (n49 < nArray.length) {
                                int n50;
                                int n51 = nArray[n49][0];
                                int n52 = nArray[n49][1];
                                if (printJob.lastPageFirst()) {
                                    n50 = n51;
                                    n51 = n52;
                                    n52 = n50;
                                    n50 = -1;
                                } else {
                                    n50 = 1;
                                }
                                int n53 = n51;
                                while (true) {
                                    Object object2;
                                    int n54;
                                    int n55;
                                    Graphics graphics = printJob.getGraphics();
                                    graphics.setFont(font);
                                    FontMetrics fontMetrics = graphics.getFontMetrics();
                                    int n56 = fontMetrics.getHeight();
                                    int n57 = fontMetrics.getAscent();
                                    int n58 = n3;
                                    int n59 = fontMetrics.charWidth('W');
                                    int n60 = n9;
                                    int n61 = n8 + n57;
                                    int n62 = pageNumberStart + n53 - 1;
                                    if (bl3) {
                                        if (n62 % 2 != 0) {
                                            n60 += n10;
                                        }
                                    } else if (bl2) {
                                        if (n62 % 2 != 0) {
                                            n61 += n10;
                                        }
                                    } else if (pageNumberLocation == 'a') {
                                        if (n62 % 2 != 0) {
                                            n60 += n10;
                                        }
                                    } else {
                                        n60 += n10;
                                    }
                                    int n63 = n4 / n59;
                                    if (bl) {
                                        PrintUtil.initializeHeaders(n63);
                                        bl = false;
                                        if (bl3 || bl2) {
                                            if (n62 % 2 == 0) {
                                                if (n50 > 0) {
                                                    n55 = (n6 + n9 - n11 - n59 * BLANK_MSG.length()) / 2;
                                                    if (bl3) {
                                                        n55 += n10 / 2;
                                                    }
                                                    if (n55 < 0) {
                                                        n55 = 0;
                                                    }
                                                    n54 = n7 / 2;
                                                    if (bl2) {
                                                        n54 += n10 / 2;
                                                    }
                                                    graphics.drawString(BLANK_MSG, n55, n54);
                                                    graphics.dispose();
                                                    graphics = printJob.getGraphics();
                                                    graphics.setFont(font);
                                                }
                                            } else if (n50 < 0) {
                                                n55 = (n6 + n9 - n11 - n59 * BLANK_MSG.length()) / 2;
                                                if (bl3) {
                                                    n55 -= n10 / 2;
                                                }
                                                if (n55 < 0) {
                                                    n55 = 0;
                                                }
                                                n54 = n7 / 2;
                                                if (bl2) {
                                                    n54 -= n10 / 2;
                                                }
                                                if (n54 < 0) {
                                                    n54 = 0;
                                                }
                                                graphics.drawString(BLANK_MSG, n55, n54);
                                                graphics.dispose();
                                                graphics = printJob.getGraphics();
                                                graphics.setFont(font);
                                            }
                                        }
                                    }
                                    if (theHeader != null) {
                                        n55 = theHeader.length;
                                        n54 = 0;
                                        while (n54 < n55) {
                                            graphics.drawString(theHeader[n54], n60, n61);
                                            n61 += n58;
                                            ++n54;
                                        }
                                        n61 += n58;
                                    }
                                    n55 = (n53 - 1) * n15;
                                    n54 = Math.min(n55 + n15, n);
                                    if (n48 < n55) {
                                        try {
                                            bufferedReader.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        try {
                                            object2 = new FileInputStream(file);
                                            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object2));
                                        }
                                        catch (FileNotFoundException fileNotFoundException) {
                                            System.err.println("File not found: " + string5);
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    do {
                                        int n64;
                                        try {
                                            object = bufferedReader.readLine();
                                        }
                                        catch (IOException iOException) {
                                            object = null;
                                        }
                                        if (object == null) break;
                                        if (n48 < n55 || n48 >= n54) continue;
                                        while ((n64 = ((String)object).indexOf(9)) >= 0) {
                                            int n65 = (n64 / 8 + 1) * 8 - n64;
                                            if (n64 == 0) {
                                                object = BLANK_ARRAY[n65] + ((String)object).substring(n64 + 1);
                                                continue;
                                            }
                                            object = ((String)object).substring(0, n64) + BLANK_ARRAY[n65] + ((String)object).substring(n64 + 1);
                                        }
                                        graphics.drawString((String)object, n60, n61);
                                        ++n47;
                                        n61 += n58;
                                    } while (++n48 < n54);
                                    object2 = pageNumberPrefix + n62;
                                    int n66 = n60;
                                    int n67 = n7 - n11 - n58;
                                    int n68 = n6 - n11 - n59 * ((String)object2).length();
                                    if (bl3) {
                                        if (n62 % 2 == 0) {
                                            n68 -= n10;
                                        }
                                    } else if (bl2 && n62 % 2 == 0) {
                                        n67 -= n10;
                                    }
                                    if (pageNumberLocation == 'c') {
                                        n66 = (n60 + n68) / 2;
                                    } else if (pageNumberLocation == 'l') {
                                        n66 = n60;
                                    } else if (pageNumberLocation == 'r') {
                                        n66 = n68;
                                    } else if (pageNumberLocation == 'a') {
                                        if (n62 % 2 != 0) {
                                            n66 = n68;
                                        }
                                    } else {
                                        n66 = n6 / 2;
                                    }
                                    n67 = Math.max(n67, n61 + n58 + n58);
                                    graphics.drawString((String)object2, n66, n67);
                                    graphics.dispose();
                                    ++n46;
                                    if (n53 == n52) break;
                                    n53 += n50;
                                }
                                ++n49;
                            }
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {}
                            break block350;
                        }
                        if (!(objectToBePrinted instanceof Vector)) break block352;
                        Vector vector = (Vector)objectToBePrinted;
                        int n69 = 0;
                        int n70 = 0;
                        int n71 = 0;
                        while (n71 < nArray.length) {
                            int n72;
                            int n73 = nArray[n71][0];
                            int n74 = nArray[n71][1];
                            if (printJob.lastPageFirst()) {
                                n72 = n73;
                                n73 = n74;
                                n74 = n72;
                                n72 = -1;
                            } else {
                                n72 = 1;
                            }
                            int n75 = n73;
                            while (true) {
                                int n76;
                                int n77;
                                Graphics graphics = printJob.getGraphics();
                                graphics.setFont(font);
                                FontMetrics fontMetrics = graphics.getFontMetrics();
                                int n78 = fontMetrics.getHeight();
                                int n79 = fontMetrics.getAscent();
                                int n80 = n3;
                                int n81 = fontMetrics.charWidth('W');
                                int n82 = n9;
                                int n83 = n8 + n79;
                                int n84 = pageNumberStart + n75 - 1;
                                if (bl3) {
                                    if (n84 % 2 != 0) {
                                        n82 += n10;
                                    }
                                } else if (bl2) {
                                    if (n84 % 2 != 0) {
                                        n83 += n10;
                                    }
                                } else if (pageNumberLocation == 'a') {
                                    if (n84 % 2 != 0) {
                                        n82 += n10;
                                    }
                                } else {
                                    n82 += n10;
                                }
                                int n85 = n4 / n81;
                                if (bl) {
                                    PrintUtil.initializeHeaders(n85);
                                    bl = false;
                                    if (bl3 || bl2) {
                                        if (n84 % 2 == 0) {
                                            if (n72 > 0) {
                                                n77 = (n6 + n9 - n11 - n81 * BLANK_MSG.length()) / 2;
                                                if (bl3) {
                                                    n77 += n10 / 2;
                                                }
                                                if (n77 < 0) {
                                                    n77 = 0;
                                                }
                                                n76 = n7 / 2;
                                                if (bl2) {
                                                    n76 += n10 / 2;
                                                }
                                                graphics.drawString(BLANK_MSG, n77, n76);
                                                graphics.dispose();
                                                graphics = printJob.getGraphics();
                                                graphics.setFont(font);
                                            }
                                        } else if (n72 < 0) {
                                            n77 = (n6 + n9 - n11 - n81 * BLANK_MSG.length()) / 2;
                                            if (bl3) {
                                                n77 -= n10 / 2;
                                            }
                                            if (n77 < 0) {
                                                n77 = 0;
                                            }
                                            n76 = n7 / 2;
                                            if (bl2) {
                                                n76 -= n10 / 2;
                                            }
                                            if (n76 < 0) {
                                                n76 = 0;
                                            }
                                            graphics.drawString(BLANK_MSG, n77, n76);
                                            graphics.dispose();
                                            graphics = printJob.getGraphics();
                                            graphics.setFont(font);
                                        }
                                    }
                                }
                                if (theHeader != null) {
                                    n77 = theHeader.length;
                                    n76 = 0;
                                    while (n76 < n77) {
                                        graphics.drawString(theHeader[n76], n82, n83);
                                        n83 += n80;
                                        ++n76;
                                    }
                                    n83 += n80;
                                }
                                n77 = (n75 - 1) * n15;
                                n76 = Math.min(n77 + n15, n);
                                int n86 = n77;
                                while (n86 < n76) {
                                    String string6 = vector.elementAt(n86).toString();
                                    graphics.drawString(string6, n82, n83);
                                    ++n70;
                                    n83 += n80;
                                    ++n86;
                                }
                                String string7 = pageNumberPrefix + n84;
                                int n87 = n82;
                                int n88 = n7 - n11 - n80;
                                int n89 = n6 - n11 - n81 * string7.length();
                                if (bl3) {
                                    if (n84 % 2 == 0) {
                                        n89 -= n10;
                                    }
                                } else if (bl2 && n84 % 2 == 0) {
                                    n88 -= n10;
                                }
                                if (pageNumberLocation == 'c') {
                                    n87 = (n82 + n89) / 2;
                                } else if (pageNumberLocation == 'l') {
                                    n87 = n82;
                                } else if (pageNumberLocation == 'r') {
                                    n87 = n89;
                                } else if (pageNumberLocation == 'a') {
                                    if (n84 % 2 != 0) {
                                        n87 = n89;
                                    }
                                } else {
                                    n87 = n6 / 2;
                                }
                                n88 = Math.max(n88, n83 + n80 + n80);
                                graphics.drawString(string7, n87, n88);
                                graphics.dispose();
                                ++n69;
                                if (n75 == n74) break;
                                n75 += n72;
                            }
                            ++n71;
                        }
                        break block350;
                    }
                    if (!(objectToBePrinted instanceof JTree)) break block353;
                    JTree jTree = (JTree)objectToBePrinted;
                    TreeModel treeModel = jTree.getModel();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
                    int n90 = 32;
                    int[] nArray2 = new int[n90];
                    int[] nArray3 = new int[n90];
                    DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n90];
                    int n91 = 0;
                    nArray2[n91] = 0;
                    nArray3[n91] = 1;
                    defaultMutableTreeNodeArray[n91] = defaultMutableTreeNode;
                    int n92 = 0;
                    int n93 = 0;
                    int n94 = 0;
                    int n95 = 0;
                    while (n95 < nArray.length) {
                        int n96;
                        int n97 = nArray[n95][0];
                        int n98 = nArray[n95][1];
                        if (printJob.lastPageFirst()) {
                            n96 = n97;
                            n97 = n98;
                            n98 = n96;
                            n96 = -1;
                        } else {
                            n96 = 1;
                        }
                        int n99 = n97;
                        while (true) {
                            int n100;
                            int n101;
                            Graphics graphics = printJob.getGraphics();
                            graphics.setFont(font);
                            FontMetrics fontMetrics = graphics.getFontMetrics();
                            int n102 = fontMetrics.getHeight();
                            int n103 = fontMetrics.getAscent();
                            int n104 = n3;
                            int n105 = fontMetrics.charWidth('W');
                            int n106 = n9;
                            int n107 = n8 + n103;
                            int n108 = pageNumberStart + n99 - 1;
                            if (bl3) {
                                if (n108 % 2 != 0) {
                                    n106 += n10;
                                }
                            } else if (bl2) {
                                if (n108 % 2 != 0) {
                                    n107 += n10;
                                }
                            } else if (pageNumberLocation == 'a') {
                                if (n108 % 2 != 0) {
                                    n106 += n10;
                                }
                            } else {
                                n106 += n10;
                            }
                            int n109 = n4 / n105;
                            if (bl) {
                                PrintUtil.initializeHeaders(n109);
                                bl = false;
                                if (bl3 || bl2) {
                                    if (n108 % 2 == 0) {
                                        if (n96 > 0) {
                                            n101 = (n6 + n9 - n11 - n105 * BLANK_MSG.length()) / 2;
                                            if (bl3) {
                                                n101 += n10 / 2;
                                            }
                                            if (n101 < 0) {
                                                n101 = 0;
                                            }
                                            n100 = n7 / 2;
                                            if (bl2) {
                                                n100 += n10 / 2;
                                            }
                                            graphics.drawString(BLANK_MSG, n101, n100);
                                            graphics.dispose();
                                            graphics = printJob.getGraphics();
                                            graphics.setFont(font);
                                        }
                                    } else if (n96 < 0) {
                                        n101 = (n6 + n9 - n11 - n105 * BLANK_MSG.length()) / 2;
                                        if (bl3) {
                                            n101 -= n10 / 2;
                                        }
                                        if (n101 < 0) {
                                            n101 = 0;
                                        }
                                        n100 = n7 / 2;
                                        if (bl2) {
                                            n100 -= n10 / 2;
                                        }
                                        if (n100 < 0) {
                                            n100 = 0;
                                        }
                                        graphics.drawString(BLANK_MSG, n101, n100);
                                        graphics.dispose();
                                        graphics = printJob.getGraphics();
                                        graphics.setFont(font);
                                    }
                                }
                            }
                            if (theHeader != null) {
                                n101 = theHeader.length;
                                n100 = 0;
                                while (n100 < n101) {
                                    graphics.drawString(theHeader[n100], n106, n107);
                                    n107 += n104;
                                    ++n100;
                                }
                                n107 += n104;
                            }
                            n101 = (n99 - 1) * n15;
                            n100 = Math.min(n101 + n15, n);
                            if (n94 < n101) {
                                n91 = 0;
                                nArray2[n91] = 0;
                                nArray3[n91] = 1;
                                defaultMutableTreeNodeArray[n91] = defaultMutableTreeNode;
                                n94 = 0;
                            }
                            while (true) {
                                String string8;
                                if (treeModel.isLeaf(defaultMutableTreeNodeArray[n91])) {
                                    if (n94 >= n101 && n94 < n100) {
                                        string8 = defaultMutableTreeNodeArray[n91].toString();
                                        graphics.drawString(string8, n106 + n91 * 4 * n105, n107);
                                        n107 += n104;
                                        ++n93;
                                    }
                                    ++n94;
                                } else {
                                    if (n94 >= n101 && n94 < n100) {
                                        string8 = defaultMutableTreeNodeArray[n91].toString();
                                        graphics.drawString(string8, n106 + n91 * 4 * n105, n107);
                                        n107 += n104;
                                        ++n93;
                                    }
                                    ++n94;
                                    int n110 = treeModel.getChildCount(defaultMutableTreeNodeArray[n91]);
                                    if (n110 != 0) {
                                        nArray2[++n91] = 0;
                                        nArray3[n91] = n110;
                                        defaultMutableTreeNodeArray[n91] = (DefaultMutableTreeNode)treeModel.getChild(defaultMutableTreeNodeArray[n91 - 1], nArray2[n91]);
                                        if (n94 < n100) continue;
                                        break;
                                    }
                                }
                                do {
                                    int n111 = n91;
                                    nArray2[n111] = nArray2[n111] + 1;
                                    if (nArray2[n91] >= nArray3[n91]) continue;
                                    defaultMutableTreeNodeArray[n91] = (DefaultMutableTreeNode)treeModel.getChild(defaultMutableTreeNodeArray[n91 - 1], nArray2[n91]);
                                    break;
                                } while (--n91 >= 0);
                                if (n91 < 0 || n94 >= n100) break;
                            }
                            String string9 = pageNumberPrefix + n108;
                            int n112 = n106;
                            int n113 = n7 - n11 - n104;
                            int n114 = n6 - n11 - n105 * string9.length();
                            if (bl3) {
                                if (n108 % 2 == 0) {
                                    n114 -= n10;
                                }
                            } else if (bl2 && n108 % 2 == 0) {
                                n113 -= n10;
                            }
                            if (pageNumberLocation == 'c') {
                                n112 = (n106 + n114) / 2;
                            } else if (pageNumberLocation == 'l') {
                                n112 = n106;
                            } else if (pageNumberLocation == 'r') {
                                n112 = n114;
                            } else if (pageNumberLocation == 'a') {
                                if (n108 % 2 != 0) {
                                    n112 = n114;
                                }
                            } else {
                                n112 = n6 / 2;
                            }
                            n113 = Math.max(n113, n107 + n104 + n104);
                            graphics.drawString(string9, n112, n113);
                            graphics.dispose();
                            ++n92;
                            if (n99 == n98) break;
                            n99 += n96;
                        }
                        ++n95;
                    }
                    break block350;
                }
                if (!(objectToBePrinted instanceof JTable)) break block354;
                JTable jTable = (JTable)objectToBePrinted;
                TableModel tableModel = jTable.getModel();
                int n115 = tableModel.getColumnCount();
                int[] nArray4 = new int[n115];
                int[] nArray5 = new int[n115];
                int n116 = 0;
                int n117 = -1;
                String[] stringArray = new String[n115];
                int n118 = 0;
                while (n118 < n115) {
                    int n119 = jTable.convertColumnIndexToView(n118);
                    if (n119 >= 0) {
                        int n120;
                        string2 = tableModel.getColumnName(n118);
                        n14 = string2.length();
                        if (string2.toUpperCase().startsWith("<HTML>")) {
                            StringBuffer stringBuffer = new StringBuffer();
                            n120 = 0;
                            while ((n13 = string2.indexOf(62, n120)) >= 0 && ++n13 < n14) {
                                n120 = string2.indexOf(60, n13);
                                if (n120 < 0) {
                                    n120 = n14;
                                }
                                if (n13 < n120) {
                                    stringBuffer.append(string2.substring(n13, n120));
                                    stringBuffer.append(' ');
                                }
                                if (n120 < n14) continue;
                            }
                            string2 = stringBuffer.toString().trim();
                            n14 = string2.length();
                        }
                        stringArray[n118] = string2;
                        ++n116;
                        n117 = n118;
                        nArray4[n118] = n14;
                        n12 = 0;
                        n13 = 0;
                        while (n13 < n) {
                            string = tableModel.getValueAt(n13, n118).toString();
                            n120 = string.length();
                            if (n120 > n12) {
                                n12 = n120;
                            }
                            ++n13;
                        }
                        nArray5[n118] = n12;
                    }
                    ++n118;
                }
                n14 = 0;
                n12 = 0;
                n13 = 0;
                string2 = null;
                int n121 = 0;
                while (n121 < nArray.length) {
                    int n122;
                    int n123 = nArray[n121][0];
                    int n124 = nArray[n121][1];
                    if (printJob.lastPageFirst()) {
                        n122 = n123;
                        n123 = n124;
                        n124 = n122;
                        n122 = -1;
                    } else {
                        n122 = 1;
                    }
                    int n125 = n123;
                    while (true) {
                        StringBuffer stringBuffer;
                        int n126;
                        int n127;
                        int n128;
                        int n129;
                        int n130;
                        int n131;
                        int n132;
                        int n133;
                        int n134;
                        int n135;
                        Graphics graphics;
                        block355: {
                            int n136;
                            int n137;
                            int n138;
                            int n139;
                            graphics = printJob.getGraphics();
                            graphics.setFont(font);
                            FontMetrics fontMetrics = graphics.getFontMetrics();
                            int n140 = fontMetrics.getHeight();
                            int n141 = fontMetrics.getAscent();
                            n135 = n3;
                            n134 = fontMetrics.charWidth('W');
                            n133 = n9;
                            n132 = n8 + n141;
                            n131 = pageNumberStart + n125 - 1;
                            if (bl3) {
                                if (n131 % 2 != 0) {
                                    n133 += n10;
                                }
                            } else if (bl2) {
                                if (n131 % 2 != 0) {
                                    n132 += n10;
                                }
                            } else if (pageNumberLocation == 'a') {
                                if (n131 % 2 != 0) {
                                    n133 += n10;
                                }
                            } else {
                                n133 += n10;
                            }
                            int n142 = n4 / n134;
                            if (bl) {
                                PrintUtil.initializeHeaders(n142);
                                bl = false;
                                if (bl3 || bl2) {
                                    if (n131 % 2 == 0) {
                                        if (n122 > 0) {
                                            n130 = (n6 + n9 - n11 - n134 * BLANK_MSG.length()) / 2;
                                            if (bl3) {
                                                n130 += n10 / 2;
                                            }
                                            if (n130 < 0) {
                                                n130 = 0;
                                            }
                                            n129 = n7 / 2;
                                            if (bl2) {
                                                n129 += n10 / 2;
                                            }
                                            graphics.drawString(BLANK_MSG, n130, n129);
                                            graphics.dispose();
                                            graphics = printJob.getGraphics();
                                            graphics.setFont(font);
                                        }
                                    } else if (n122 < 0) {
                                        n130 = (n6 + n9 - n11 - n134 * BLANK_MSG.length()) / 2;
                                        if (bl3) {
                                            n130 -= n10 / 2;
                                        }
                                        if (n130 < 0) {
                                            n130 = 0;
                                        }
                                        n129 = n7 / 2;
                                        if (bl2) {
                                            n129 -= n10 / 2;
                                        }
                                        if (n129 < 0) {
                                            n129 = 0;
                                        }
                                        graphics.drawString(BLANK_MSG, n130, n129);
                                        graphics.dispose();
                                        graphics = printJob.getGraphics();
                                        graphics.setFont(font);
                                    }
                                }
                            }
                            if (theHeader != null) {
                                n130 = theHeader.length;
                                n129 = 0;
                                while (n129 < n130) {
                                    graphics.drawString(theHeader[n129], n133, n132);
                                    n132 += n135;
                                    ++n129;
                                }
                                n132 += n135;
                            }
                            n130 = (n125 - 1) * n15;
                            n129 = Math.min(n130 + n15, n);
                            if (string2 != null) break block355;
                            n128 = n142 / n116;
                            n127 = n116;
                            n126 = 0;
                            int[] nArray6 = new int[n115];
                            boolean[] blArray = new boolean[n115];
                            int n143 = 0;
                            while (n143 < n115) {
                                n139 = jTable.convertColumnIndexToView(n143);
                                if (n139 < 0) {
                                    nArray6[n143] = 0;
                                    blArray[n143] = true;
                                } else if (nArray4[n143] == 0 && nArray5[n143] == 0) {
                                    nArray6[n143] = 0;
                                    blArray[n143] = true;
                                } else {
                                    n138 = Math.max(nArray5[n143], nArray4[n143]);
                                    if (n143 == n117) {
                                        if (n138 <= n128) {
                                            nArray6[n143] = n138;
                                            n126 += n138;
                                            blArray[n143] = true;
                                            --n127;
                                        } else {
                                            blArray[n143] = false;
                                        }
                                    } else if (n138 + 4 <= n128) {
                                        nArray6[n143] = n138 += 4;
                                        n126 += n138;
                                        blArray[n143] = true;
                                        --n127;
                                    } else {
                                        blArray[n143] = false;
                                    }
                                }
                                ++n143;
                            }
                            n139 = -999;
                            while (n127 > 0) {
                                n128 = (n142 - n126) / n127;
                                n138 = 0;
                                while (n138 < n115) {
                                    block356: {
                                        block358: {
                                            block360: {
                                                block359: {
                                                    block357: {
                                                        if (blArray[n138] || (n137 = jTable.convertColumnIndexToView(n138)) < 0 || nArray4[n138] == 0 && nArray5[n138] == 0) break block356;
                                                        n136 = Math.max(nArray5[n138], nArray4[n138]);
                                                        if (n138 != n115 - 1) break block357;
                                                        if (n136 <= n128) break block358;
                                                        if (n139 != n127) break block356;
                                                        n136 = n128;
                                                        break block358;
                                                    }
                                                    if (n136 + 2 > n128) break block359;
                                                    n136 += 2;
                                                    break block358;
                                                }
                                                if (nArray4[n138] + 2 > n128) break block360;
                                                n136 = n128;
                                                break block358;
                                            }
                                            if (n139 != n127) break block356;
                                            n136 = n128;
                                        }
                                        nArray6[n138] = n136;
                                        n126 += n136;
                                        blArray[n138] = true;
                                        --n127;
                                    }
                                    ++n138;
                                }
                                n139 = n127;
                            }
                            if (n126 > n142) {
                                System.err.println("Header: lenColUse = " + n126 + ", maxColumns = " + n142);
                                n138 = 0;
                                while (n138 < n115) {
                                    n137 = jTable.convertColumnIndexToView(n138);
                                    if (n137 >= 0 && (nArray4[n138] != 0 || nArray5[n138] != 0)) {
                                        System.err.println("column " + n138 + "(" + n137 + "), header (" + nArray4[n138] + "): " + stringArray[n138] + ", cell (" + nArray5[n138] + "), use " + nArray6[n138]);
                                        n136 = nArray6[n138] - nArray4[n138];
                                    }
                                    ++n138;
                                }
                            }
                            stringBuffer = new StringBuffer();
                            n138 = 0;
                            while (n138 < n115) {
                                n137 = jTable.convertColumnIndexToView(n138);
                                if (n137 >= 0 && (nArray4[n138] != 0 || nArray5[n138] != 0)) {
                                    stringBuffer.append(stringArray[n138]);
                                    n136 = nArray6[n138] - nArray4[n138];
                                    while (n136 >= BLANK_ARRAY_LAST) {
                                        stringBuffer.append(BLANK_ARRAY[BLANK_ARRAY_LAST]);
                                        n136 -= BLANK_ARRAY_LAST;
                                    }
                                    if (n136 > 0) {
                                        stringBuffer.append(BLANK_ARRAY[n136]);
                                    }
                                    nArray5[n138] = nArray6[n138];
                                }
                                ++n138;
                            }
                            string2 = stringBuffer.toString();
                        }
                        graphics.drawString(string2, n133, n132);
                        n132 += n135;
                        n132 += n135;
                        n128 = n130;
                        while (n128 < n129) {
                            stringBuffer = new StringBuffer();
                            n127 = 0;
                            while (n127 < n115) {
                                n126 = jTable.convertColumnIndexToView(n127);
                                if (n126 >= 0 && (nArray4[n127] != 0 || nArray5[n127] != 0)) {
                                    string = tableModel.getValueAt(n128, n127).toString();
                                    n13 = string.length();
                                    if (n13 <= nArray5[n127]) {
                                        stringBuffer.append(string);
                                        int n144 = nArray5[n127] - n13;
                                        while (n144 >= BLANK_ARRAY_LAST) {
                                            stringBuffer.append(BLANK_ARRAY[BLANK_ARRAY_LAST]);
                                            n144 -= BLANK_ARRAY_LAST;
                                        }
                                        if (n144 > 0) {
                                            stringBuffer.append(BLANK_ARRAY[n144]);
                                        }
                                    } else {
                                        stringBuffer.append(string.substring(0, nArray5[n127] - 3));
                                        stringBuffer.append("...");
                                    }
                                }
                                ++n127;
                            }
                            String string10 = stringBuffer.toString();
                            graphics.drawString(string10, n133, n132);
                            ++n12;
                            n132 += n135;
                            ++n128;
                        }
                        String string11 = pageNumberPrefix + n131;
                        n126 = n133;
                        int n145 = n7 - n11 - n135;
                        int n146 = n6 - n11 - n134 * string11.length();
                        if (bl3) {
                            if (n131 % 2 == 0) {
                                n146 -= n10;
                            }
                        } else if (bl2 && n131 % 2 == 0) {
                            n145 -= n10;
                        }
                        if (pageNumberLocation == 'c') {
                            n126 = (n133 + n146) / 2;
                        } else if (pageNumberLocation == 'l') {
                            n126 = n133;
                        } else if (pageNumberLocation == 'r') {
                            n126 = n146;
                        } else if (pageNumberLocation == 'a') {
                            if (n131 % 2 != 0) {
                                n126 = n146;
                            }
                        } else {
                            n126 = n6 / 2;
                        }
                        n145 = Math.max(n145, n132 + n135 + n135);
                        graphics.drawString(string11, n126, n145);
                        graphics.dispose();
                        ++n14;
                        if (n125 == n124) break;
                        n125 += n122;
                    }
                    ++n121;
                }
                break block350;
            }
            if (objectToBePrinted instanceof Component) {
                int n147 = ((Component)objectToBePrinted).getWidth();
                int n148 = ((Component)objectToBePrinted).getHeight();
                boolean bl4 = false;
                int n149 = 0;
                int n150 = nArray[nArray.length - 1][1];
                PrintUtil.disableDoubleBuffering((Component)objectToBePrinted);
                int n151 = 0;
                while (n151 < nArray.length) {
                    int n152;
                    int n153 = nArray[n151][0];
                    int n154 = nArray[n151][1];
                    if (printJob.lastPageFirst()) {
                        n152 = n153;
                        n153 = n154;
                        n154 = n152;
                        n152 = -1;
                    } else {
                        n152 = 1;
                    }
                    int n155 = n153;
                    while (true) {
                        int n156;
                        int n157;
                        int n158;
                        int n159;
                        int n160;
                        int n161;
                        int n162;
                        Graphics graphics = printJob.getGraphics();
                        graphics.setFont(font);
                        FontMetrics fontMetrics = graphics.getFontMetrics();
                        int n163 = fontMetrics.getHeight();
                        int n164 = fontMetrics.getAscent();
                        int n165 = n3;
                        int n166 = fontMetrics.charWidth('W');
                        int n167 = n9;
                        int n168 = n8 + n164;
                        int n169 = pageNumberStart + n155 - 1;
                        if (bl3) {
                            if (n169 % 2 != 0) {
                                n167 += n10;
                            }
                        } else if (bl2) {
                            if (n169 % 2 != 0) {
                                n168 += n10;
                            }
                        } else if (pageNumberLocation == 'a') {
                            if (n169 % 2 != 0) {
                                n167 += n10;
                            }
                        } else {
                            n167 += n10;
                        }
                        int n170 = n4 / n166;
                        if (bl) {
                            PrintUtil.initializeHeaders(n170);
                            bl = false;
                            if (bl3 || bl2) {
                                if (n169 % 2 == 0) {
                                    if (n152 > 0) {
                                        n162 = (n6 + n9 - n11 - n166 * BLANK_MSG.length()) / 2;
                                        if (bl3) {
                                            n162 += n10 / 2;
                                        }
                                        if (n162 < 0) {
                                            n162 = 0;
                                        }
                                        n161 = n7 / 2;
                                        if (bl2) {
                                            n161 += n10 / 2;
                                        }
                                        graphics.drawString(BLANK_MSG, n162, n161);
                                        graphics.dispose();
                                        graphics = printJob.getGraphics();
                                        graphics.setFont(font);
                                    }
                                } else if (n152 < 0) {
                                    n162 = (n6 + n9 - n11 - n166 * BLANK_MSG.length()) / 2;
                                    if (bl3) {
                                        n162 -= n10 / 2;
                                    }
                                    if (n162 < 0) {
                                        n162 = 0;
                                    }
                                    n161 = n7 / 2;
                                    if (bl2) {
                                        n161 -= n10 / 2;
                                    }
                                    if (n161 < 0) {
                                        n161 = 0;
                                    }
                                    graphics.drawString(BLANK_MSG, n162, n161);
                                    graphics.dispose();
                                    graphics = printJob.getGraphics();
                                    graphics.setFont(font);
                                }
                            }
                        }
                        n162 = 0;
                        if (theHeader != null) {
                            n162 = theHeader.length;
                            n161 = 0;
                            while (n161 < n162) {
                                graphics.drawString(theHeader[n161], n167, n168);
                                n168 += n165;
                                ++n161;
                            }
                            n168 += n165;
                        }
                        int n171 = n5 - (n162 + 1) * n165;
                        double d = (double)n4 / (double)n147;
                        double d2 = (double)n171 / (double)n148;
                        double d3 = Math.min(d, d2);
                        if (n150 > 1) {
                            n160 = (n147 + n4 - 1) / n4;
                            n159 = (n148 + n171 - 1) / n171;
                            n158 = (n155 - 1) / n160;
                            n157 = n155 - 1 - n158 * n160;
                            int n172 = n157 * n4;
                            int n173 = n158 * n171;
                            int n174 = Math.max(0, n167 + (n4 - n147) / 2);
                            n156 = Math.max(0, n168 + (n171 - n148) / 2);
                            graphics.setClip(n172, n173, n4, n171);
                            graphics.translate(n174, n156);
                            ((Component)objectToBePrinted).paint(graphics);
                            n161 = n156 + n148;
                        } else if (d3 < 1.0) {
                            bl4 = true;
                            n160 = (int)((double)n147 * d3);
                            n159 = (int)((double)n148 * d3);
                            n158 = Math.max(0, n167 + (n4 - n160) / 2);
                            n157 = Math.max(0, n168 + (n171 - n159) / 2);
                            System.err.println("component " + n147 + " X " + n148 + " scaled: " + n160 + " X " + n159 + " in " + n4 + " X " + n171 + ", offset: " + n158 + " X " + n157);
                            BufferedImage bufferedImage = new BufferedImage(n160, n159, 1);
                            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                            graphics2D.scale(d3, d3);
                            ((Component)objectToBePrinted).paint(graphics2D);
                            MediaTracker mediaTracker = new MediaTracker((Component)objectToBePrinted);
                            mediaTracker.addImage(bufferedImage, 0);
                            try {
                                mediaTracker.waitForID(0);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            n156 = graphics.drawImage(bufferedImage, n158, n157, null) ? 1 : 0;
                            n161 = n157 + n159;
                        } else {
                            n160 = Math.max(0, n167 + (n4 - n147) / 2);
                            n159 = Math.max(0, n168 + (n171 - n148) / 2);
                            graphics.translate(n160, n159);
                            ((Component)objectToBePrinted).paint(graphics);
                            n161 = n159 + n148;
                        }
                        String string = pageNumberPrefix + n169;
                        n159 = n167;
                        n158 = n7 - n11 - n165;
                        n157 = n6 - n11 - n166 * string.length();
                        if (bl3) {
                            if (n169 % 2 == 0) {
                                n157 -= n10;
                            }
                        } else if (bl2 && n169 % 2 == 0) {
                            n158 -= n10;
                        }
                        if (pageNumberLocation == 'c') {
                            n159 = (n167 + n157) / 2;
                        } else if (pageNumberLocation == 'l') {
                            n159 = n167;
                        } else if (pageNumberLocation == 'r') {
                            n159 = n157;
                        } else if (pageNumberLocation == 'a') {
                            if (n169 % 2 != 0) {
                                n159 = n157;
                            }
                        } else {
                            n159 = n6 / 2;
                        }
                        n158 = Math.max(n158, n161 + n165 + n165);
                        graphics.drawString(string, n159, n158);
                        graphics.dispose();
                        ++n149;
                        if (n155 == n154) break;
                        n155 += n152;
                    }
                    ++n151;
                }
                PrintUtil.enableDoubleBuffering((Component)objectToBePrinted);
                if (bl4) {
                    System.err.println("Printer may take a long time to rescale " + n149 + " page" + (n149 == 1 ? "" : "s") + ".");
                    String string = jobAttr.getPrinter();
                    String string12 = System.getProperty("os.name").toLowerCase();
                    if (string12.indexOf("windows") > -1) {
                        System.err.println("Suggest using: Start/Settings/Printers to see if printer " + string + " is done.");
                    } else if (!string12.startsWith("mac")) {
                        System.err.println("Suggest using: 'lpstat -p " + string + "' or 'lpq -P " + string + "' to see if done.");
                    }
                }
            }
        }
    }

    private static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    private static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }

    private static void initializeHeaders(int n) {
        theHeader = null;
        int n2 = 0;
        if (printHeader) {
            if (userTitle.trim().length() > 0) {
                ++n2;
            }
            ++n2;
            ++n2;
        }
        if (n2 > 0) {
            Serializable serializable;
            theHeader = new String[n2];
            int n3 = 0;
            if (userTitle.trim().length() > 0) {
                int n4 = (n - userTitle.length()) / 2;
                if (n4 <= 0) {
                    PrintUtil.theHeader[n3] = userTitle;
                    ++n3;
                } else {
                    serializable = new StringBuffer();
                    while (n4 >= BLANK_ARRAY_LAST) {
                        ((StringBuffer)serializable).append(BLANK_ARRAY[BLANK_ARRAY_LAST]);
                        n4 -= BLANK_ARRAY_LAST;
                    }
                    if (n4 > 0) {
                        ((StringBuffer)serializable).append(BLANK_ARRAY[n4]);
                    }
                    ((StringBuffer)serializable).append(userTitle);
                    PrintUtil.theHeader[n3] = ((StringBuffer)serializable).toString();
                    ++n3;
                }
            }
            Date date = new Date();
            serializable = new SimpleDateFormat(dateFormat);
            ((DateFormat)serializable).setTimeZone(TimeZone.getDefault());
            theDate = ((DateFormat)serializable).format(date);
            StringBuffer stringBuffer = new StringBuffer(frameTitle);
            int n5 = n - frameTitle.length() - theDate.length();
            if (n5 <= 0) {
                n5 = 1;
            }
            while (n5 >= BLANK_ARRAY_LAST) {
                stringBuffer.append(BLANK_ARRAY[BLANK_ARRAY_LAST]);
                n5 -= BLANK_ARRAY_LAST;
            }
            if (n5 > 0) {
                stringBuffer.append(BLANK_ARRAY[n5]);
            }
            stringBuffer.append(theDate);
            PrintUtil.theHeader[n3] = stringBuffer.toString();
            PrintUtil.theHeader[++n3] = jobName.trim();
            ++n3;
        }
    }

    private int getNumberOfLines() {
        int n = 0;
        if (objectToBePrinted instanceof JTextArea) {
            n = ((JTextArea)objectToBePrinted).getLineCount();
        } else if (objectToBePrinted instanceof File) {
            File file = (File)objectToBePrinted;
            String string = file.getPath();
            BufferedReader bufferedReader = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File not found: " + string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while (true) {
                String string2;
                try {
                    string2 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
                if (string2 == null) break;
                ++n;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        } else if (objectToBePrinted instanceof Vector) {
            n = ((Vector)objectToBePrinted).size();
        } else if (objectToBePrinted instanceof JTree) {
            JTree jTree = (JTree)objectToBePrinted;
            TreeModel treeModel = jTree.getModel();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
            int n2 = 32;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n2];
            int n3 = 0;
            nArray[n3] = 0;
            nArray2[n3] = 1;
            defaultMutableTreeNodeArray[n3] = defaultMutableTreeNode;
            while (true) {
                if (treeModel.isLeaf(defaultMutableTreeNodeArray[n3])) {
                    ++n;
                } else {
                    ++n;
                    int n4 = treeModel.getChildCount(defaultMutableTreeNodeArray[n3]);
                    if (n4 != 0) {
                        nArray[++n3] = 0;
                        nArray2[n3] = n4;
                        defaultMutableTreeNodeArray[n3] = (DefaultMutableTreeNode)treeModel.getChild(defaultMutableTreeNodeArray[n3 - 1], nArray[n3]);
                        continue;
                    }
                }
                do {
                    int n5 = n3;
                    nArray[n5] = nArray[n5] + 1;
                    if (nArray[n3] >= nArray2[n3]) continue;
                    defaultMutableTreeNodeArray[n3] = (DefaultMutableTreeNode)treeModel.getChild(defaultMutableTreeNodeArray[n3 - 1], nArray[n3]);
                    break;
                } while (--n3 >= 0);
                if (n3 < 0) break;
            }
        } else if (objectToBePrinted instanceof JTable) {
            n = ((JTable)objectToBePrinted).getRowCount();
        } else if (objectToBePrinted instanceof Component) {
            n = 1;
        }
        return n;
    }

    private int getLinesPerPage() {
        int n = 0;
        if (printHeader) {
            n = 3;
            if (userTitle.trim().length() > 0) {
                ++n;
            }
        }
        int n2 = 0;
        if (objectToBePrinted instanceof JTextArea) {
            n2 = 60 - n;
        } else if (objectToBePrinted instanceof File) {
            n2 = 60 - n;
        } else if (objectToBePrinted instanceof Vector) {
            n2 = 60 - n;
        } else if (objectToBePrinted instanceof JTree) {
            n2 = 60 - n;
        } else if (objectToBePrinted instanceof JTable) {
            n2 = 60 - n - 2;
        } else if (objectToBePrinted instanceof Component) {
            n2 = 1;
        }
        return n2;
    }

    private int getNumberOfPages(int n) {
        int n2 = 0;
        int n3 = this.getLinesPerPage();
        n2 = (n + n3 - 1) / n3;
        return n2;
    }

    private int getNumberOfPages() {
        int n = this.getNumberOfLines();
        int n2 = this.getNumberOfPages(n);
        return n2;
    }

    public static void main(String[] stringArray) {
        String string;
        int n = 40;
        int n2 = 150;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while (n3 < n) {
            string = "VText|gWXO - " + (n3 + 1);
            vector.addElement(string);
            ++n3;
        }
        System.err.println("PrintUtil: Vector 1-" + n);
        PrintUtil.printComponent(vector);
        JTextArea jTextArea = new JTextArea();
        int n4 = 0;
        while (n4 < n) {
            string = "JTextArea # " + (n4 + 1);
            jTextArea.append(string);
            jTextArea.append("\n");
            ++n4;
        }
        System.err.println("PrintUtil: JTextArea 1-" + n);
        PrintUtil.printComponent(jTextArea);
        int n5 = n;
        while (n5 < n2) {
            string = "VText|gWXO - " + (n5 + 1);
            if (n5 == n) {
                string = string + "  RESTART";
            }
            vector.addElement(string);
            ++n5;
        }
        System.err.println("PrintUtil: Vector 1-" + n2);
        PrintUtil.printComponent(vector);
        int n6 = n;
        while (n6 < n2) {
            string = "JTextArea # " + (n6 + 1);
            jTextArea.append(string);
            if (n6 == n) {
                jTextArea.append("  RESTART");
            }
            jTextArea.append("\n");
            ++n6;
        }
        System.err.println("PrintUtil: JTextArea 1-" + n2);
        PrintUtil.printComponent(jTextArea);
        System.exit(0);
    }

    static {
        jobAttr = new JobAttributes();
        pageAttr = new PageAttributes();
        printHeader = true;
        userTitle = "";
        jobName = null;
        theHeader = null;
        theDate = null;
        dateFormat = "MMM d, yyyy  hh:mm a";
        frameTitle = null;
        pageNumberPrefix = "";
        pageNumberStart = 1;
        pageNumberLocation = (char)99;
        marginBinding = 0.0;
        marginLeft = 0.0;
        marginTop = 0.0;
        BLANK_ARRAY = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    ", "                     ", "                      ", "                       ", "                        ", "                         ", "                          ", "                           ", "                            ", "                             ", "                              ", "                               ", "                                ", "                                 ", "                                  ", "                                   ", "                                    ", "                                     ", "                                      ", "                                       ", "                                        "};
        BLANK_ARRAY_LENGTH = BLANK_ARRAY.length;
        BLANK_ARRAY_LAST = BLANK_ARRAY_LENGTH - 1;
    }
}

