/*
 * Decompiled with CFR 0.152.
 */
package com.symantec.itools.javax.swing.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Icon;

public class ImageIcon
implements Icon,
Serializable {
    protected transient Image image;
    protected transient int loadStatus;
    protected ImageObserver imageObserver;
    protected URL imageLocation;
    protected static final Component component = new 1();
    protected static final MediaTracker tracker = new MediaTracker(component);
    protected int width = -1;
    protected int height = -1;

    public ImageIcon() {
    }

    public ImageIcon(URL uRL) {
        this.imageLocation = uRL;
        this.image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.loadImage(this.image);
    }

    public ImageIcon(Image image) {
        this.image = image;
        this.loadImage(this.image);
    }

    public ImageIcon(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        byteArrayOutputStream.flush();
        this.image = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
        this.loadImage(this.image);
        ((OutputStream)byteArrayOutputStream).close();
    }

    public URL getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(URL uRL) {
        this.imageLocation = uRL;
        this.image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.loadImage(this.image);
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.imageObserver = imageObserver;
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.image != null) {
            if (this.imageObserver == null) {
                graphics.drawImage(this.image, n, n2, component);
                return;
            }
            graphics.drawImage(this.image, n, n2, this.imageObserver);
        }
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    protected void loadImage(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 5000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            this.loadStatus = tracker.statusID(0, false);
            tracker.removeImage(image, 0);
            this.width = image.getWidth(this.imageObserver);
            this.height = image.getHeight(this.imageObserver);
            return;
        }
    }

    public int getImageLoadStatus() {
        return this.loadStatus;
    }

    public Image getImage() {
        return this.image;
    }

    private final class 1
    extends Component {
        /* synthetic */ 1() {
        }
    }
}

