/*
 * Decompiled with CFR 0.152.
 */
package javax.awt.swing.event;

import java.util.EventObject;
import javax.awt.swing.tree.TreePath;

public class TreeModelEvent
extends EventObject {
    protected TreePath path;
    protected int[] childIndices;
    protected Object[] children;

    public TreeModelEvent(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        this(object, new TreePath(objectArray), nArray, objectArray2);
    }

    public TreeModelEvent(Object object, TreePath treePath, int[] nArray, Object[] objectArray) {
        super(object);
        this.path = treePath;
        this.childIndices = nArray;
        this.children = objectArray;
    }

    public TreeModelEvent(Object object, Object[] objectArray) {
        this(object, new TreePath(objectArray));
    }

    public TreeModelEvent(Object object, TreePath treePath) {
        super(object);
        this.path = treePath;
        this.childIndices = new int[0];
    }

    public TreePath getTreePath() {
        return this.path;
    }

    public Object[] getPath() {
        if (this.path != null) {
            return this.path.getPath();
        }
        return null;
    }

    public Object[] getChildren() {
        if (this.children != null) {
            int n = this.children.length;
            Object[] objectArray = new Object[n];
            System.arraycopy(this.children, 0, objectArray, 0, n);
            return objectArray;
        }
        return null;
    }

    public int[] getChildIndices() {
        if (this.childIndices != null) {
            int n = this.childIndices.length;
            int[] nArray = new int[n];
            System.arraycopy(this.childIndices, 0, nArray, 0, n);
            return nArray;
        }
        return null;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getClass().getName()) + " " + Integer.toString(this.hashCode()));
        if (this.path != null) {
            stringBuffer.append(" path " + this.path);
        }
        if (this.childIndices != null) {
            stringBuffer.append(" indicices [ ");
            n = 0;
            while (n < this.childIndices.length) {
                stringBuffer.append(String.valueOf(Integer.toString(this.childIndices[n])) + " ");
                ++n;
            }
            stringBuffer.append("]");
        }
        if (this.children != null) {
            stringBuffer.append(" children [ ");
            n = 0;
            while (n < this.children.length) {
                stringBuffer.append(String.valueOf(this.children[n]) + " ");
                ++n;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

