/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import symantec.itools.awt.util.Util;

public class KeyPressManagerPanel
extends Panel
implements Serializable {
    protected Button defaultButton;
    protected Button cancelButton;
    protected A action = new A();
    protected K key = new K();

    public KeyPressManagerPanel() {
        super.setLayout(null);
        this.resetKeyManager();
    }

    public void resetKeyManager() {
        this.removeDefaultButton();
        this.removeCancelButton();
    }

    public void setDefaultButton(Button button) {
        this.removeDefaultButton();
        this.defaultButton = button;
    }

    public void removeDefaultButton() {
        this.defaultButton = null;
    }

    public void setDefaultButton(Button button, Event event, Container container, boolean bl) {
        this.setDefaultButton(button);
    }

    public void setCancelButton(Button button) {
        this.removeCancelButton();
        this.cancelButton = button;
    }

    public void removeCancelButton() {
        this.cancelButton = null;
    }

    public void setCancelButton(Button button, Event event, Container container, boolean bl) {
        this.setCancelButton(this.cancelButton);
    }

    protected void addImpl(Component component, Object object, int n) {
        this.componentAdded(component);
        super.addImpl(component, object, n);
    }

    public void remove(int n) {
        this.componentRemoved(this.getComponent(n));
        super.remove(n);
    }

    public void removeAll() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.componentRemoved(componentArray[n]);
            ++n;
        }
        super.removeAll();
    }

    protected boolean sendAction(Button button) {
        if (button != null && button.isEnabled()) {
            button.requestFocus();
            button.dispatchEvent(new ActionEvent(button, 1001, new String(button.getLabel())));
            return true;
        }
        return false;
    }

    protected boolean consumeKeyTyped(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                return this.sendAction(this.defaultButton);
            }
            case 27: {
                return this.sendAction(this.cancelButton);
            }
            case 9: {
                return this.handleTabEvent(keyEvent);
            }
        }
        return false;
    }

    protected boolean handleTabEvent(KeyEvent keyEvent) {
        Component[] componentArray = this.getComponents();
        Component component = null;
        int n = componentArray.length - 1;
        do {
            if (componentArray[n].isFocusTraversable()) {
                component = componentArray[n];
                continue;
            }
            --n;
        } while (!componentArray[n].isFocusTraversable() && n >= 0);
        if (component == null) {
            return false;
        }
        if ((keyEvent.getModifiers() & 2) == 2) {
            component.transferFocus();
            return true;
        }
        if (keyEvent.getComponent() == component) {
            n = 0;
            while (n < componentArray.length) {
                if (componentArray[n].isFocusTraversable()) {
                    componentArray[n].requestFocus();
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected void componentAdded(Component component) {
        if (Util.findComponent(this, component) != -1) {
            return;
        }
        if (component instanceof TextField) {
            TextField textField = (TextField)component;
            textField.addActionListener(this.action);
        }
        if (!component.getClass().getName().equals("symantec.itools.db.awt.Grid")) {
            component.addKeyListener(this.key);
        }
    }

    protected void componentRemoved(Component component) {
        if (Util.findComponent(this, component) == -1) {
            return;
        }
        if (component instanceof TextField) {
            TextField textField = (TextField)component;
            textField.removeActionListener(this.action);
        }
        if (!component.getClass().getName().equals("symantec.itools.db.awt.Grid")) {
            component.removeKeyListener(this.key);
        }
    }

    class A
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            KeyPressManagerPanel.this.sendAction(KeyPressManagerPanel.this.defaultButton);
        }

        A() {
            KeyPressManagerPanel.this = KeyPressManagerPanel.this;
        }
    }

    class K
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent keyEvent) {
            if (KeyPressManagerPanel.this.consumeKeyTyped(keyEvent)) {
                keyEvent.consume();
            }
        }

        K() {
            KeyPressManagerPanel.this = KeyPressManagerPanel.this;
        }
    }
}

