/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.sql.SQLException;
import symantec.itools.db.awt.ProjectionBean;
import symantec.itools.db.beans.binding.Mediator;
import symantec.itools.db.beans.binding.Name;
import symantec.itools.db.pro.ProjBinder;
import symantec.itools.db.pro.ProjLink;
import symantec.itools.db.pro.RelationView;

public class ProjectionBeanHelper
extends KeyAdapter
implements ProjLink,
ActionListener,
FocusListener,
ItemListener,
TextListener {
    private ProjBinder m_ProjBinder;
    private int m_ColumnType;
    private boolean m_IsBound = false;
    private boolean m_DynamicUpdate = true;
    private boolean m_BinderDetermines = true;
    private Object m_BinderData;
    private Object m_ScreenData;
    private RelationView m_RelationView;
    private String m_ProjectionName = "";
    private ProjectionBean m_ProjectionBean;
    private String[] m_GetMethods = new String[]{"getData()"};
    private String[] m_SetMethods = new String[]{"setData(Value)"};
    public static final int Action_Event = 0;
    public static final int Focus_Event = 1;
    public static final int Key_Event = 2;
    public static final int Item_Event = 5;
    public static final int Text_Event = 4;
    public static final String BLANK = "Blank";
    public static final String NULL = "Null";
    public static final String DEFAULT = "Default";
    public Mediator m_Mediator;

    ProjectionBeanHelper(ProjectionBean projectionBean) {
        this.m_ScreenData = new String();
        this.m_BinderData = new String();
        this.m_ProjectionBean = projectionBean;
        this.m_Mediator = new Mediator();
        this.m_Mediator.setOutput(this.m_ProjectionBean);
        this.m_Mediator.setSetMethods(this.m_SetMethods);
        this.m_Mediator.setGetMethods(this.m_GetMethods);
    }

    public void init(ProjBinder projBinder) {
        ProjectionBeanHelper projectionBeanHelper = this;
        synchronized (projectionBeanHelper) {
            this.m_IsBound = true;
            this.m_ProjBinder = projBinder;
            this.setReadOnly(projBinder);
            return;
        }
    }

    public boolean notifySetData(ProjBinder projBinder) throws SQLException {
        return false;
    }

    public void notifyDataChange(ProjBinder projBinder) {
    }

    public void notifyDataChange() {
        this.setDataBinding(this.getDataBinding());
    }

    void raiseException(Exception exception) {
        System.out.println("Exception class [" + exception.getClass().getName() + "]");
        System.out.println("Exception message [" + exception.getMessage() + "]");
        Thread.dumpStack();
    }

    void setReadOnly(ProjBinder projBinder) {
        boolean bl = false;
        try {
            if (projBinder != null) {
                bl = projBinder.isWritable();
            }
        }
        catch (Exception exception) {
            this.raiseException(exception);
        }
        this.m_ProjectionBean.setReadOnly(!bl);
    }

    boolean notifyInputChanged(Object object) {
        this.m_Mediator.commit();
        return true;
    }

    synchronized void setBinding(RelationView relationView, String string) {
        this.m_RelationView = relationView;
        this.m_ProjectionName = string;
        if (this.m_RelationView == null || this.m_ProjectionName == null) {
            return;
        }
        if (this.m_ProjectionName.equals("")) {
            return;
        }
        try {
            Name name = new Name(this.m_RelationView.getName(), this.m_ProjectionName);
            this.m_Mediator.setDataBinding(name.getFullName());
            return;
        }
        catch (SQLException sQLException) {
            this.raiseException(sQLException);
            return;
        }
    }

    synchronized void setDataBinding(Name name) {
        this.m_Mediator.setDataBinding(name.getFullName());
    }

    synchronized Name getDataBinding() {
        return new Name(this.m_Mediator.getDataBinding());
    }

    synchronized void setFormatNumbers(boolean bl) {
        if (this.m_Mediator != null) {
            this.m_Mediator.setFormatNumbers(bl);
        }
    }

    synchronized boolean getFormatNumbers() {
        if (this.m_Mediator != null) {
            return this.m_Mediator.getFormatNumbers();
        }
        return false;
    }

    public void setLocalizationUsed(boolean bl) {
        if (this.m_Mediator != null) {
            this.m_Mediator.setLocalizationUsed(bl);
        }
    }

    public boolean isLocalizationUsed() {
        if (this.m_Mediator != null) {
            return this.m_Mediator.isLocalizationUsed();
        }
        return false;
    }

    synchronized void setBinderDeterminesReadOnly(boolean bl) {
        this.m_BinderDetermines = bl;
    }

    synchronized void setTreatBlankAs(int n) {
        this.m_Mediator.setEmptyMeansNull(n == 1);
    }

    synchronized void setTreatBlankAsString(String string) {
        if (string.equals(BLANK)) {
            this.setTreatBlankAs(2);
            return;
        }
        if (string.equals(NULL)) {
            this.setTreatBlankAs(1);
            return;
        }
        this.setTreatBlankAs(0);
    }

    synchronized void setDynamicUpdate(boolean bl) {
        this.m_DynamicUpdate = bl;
    }

    synchronized boolean getDynamicUpdate() {
        return this.m_DynamicUpdate;
    }

    synchronized void setProjection(String string) {
        this.setBinding(this.m_RelationView, string);
    }

    synchronized String getProjection() {
        return this.m_ProjectionName;
    }

    synchronized void setRelationView(RelationView relationView) {
        this.setBinding(relationView, this.m_ProjectionName);
    }

    synchronized RelationView getRelationView() {
        return this.m_RelationView;
    }

    synchronized String getRelationViewName() {
        if (this.m_RelationView != null) {
            try {
                return this.m_RelationView.getName();
            }
            catch (Exception exception) {
                this.raiseException(exception);
            }
        }
        return "null";
    }

    synchronized ProjBinder getBinder() {
        return this.m_ProjBinder;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.m_Mediator.commit();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.m_Mediator.commit();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.m_Mediator.commit();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.m_Mediator.commit();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.m_Mediator.commit();
    }

    public Mediator getMediator() {
        return this.m_Mediator;
    }

    public void setEmptyMeansNull(boolean bl) {
        this.m_Mediator.setEmptyMeansNull(bl);
    }

    public boolean getEmptyMeansNull() {
        return this.m_Mediator.getEmptyMeansNull();
    }
}

