/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.binding;

import java.awt.Dimension;
import java.beans.Beans;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import symantec.itools.db.beans.binding.BasicDataSource;
import symantec.itools.db.beans.binding.DataInput;
import symantec.itools.db.beans.binding.DataItemAddition;
import symantec.itools.db.beans.binding.MediatorDS;
import symantec.itools.db.beans.binding.MutableCollectionItem;
import symantec.itools.db.beans.binding.Name;
import symantec.itools.db.beans.binding.NewValue;
import symantec.itools.db.beans.binding.OutputComponent;
import symantec.itools.db.beans.binding.OutputComponentForDS;
import symantec.itools.db.beans.binding.OutputComponentForProj;
import symantec.itools.db.beans.binding.TriggerUIEvent;
import symantec.itools.db.beans.binding.databus.CollectionAccess;
import symantec.itools.db.beans.binding.databus.DataBus;
import symantec.itools.db.beans.binding.databus.DataBusEvent;
import symantec.itools.db.beans.binding.databus.DataBusEventListener;
import symantec.itools.db.beans.binding.databus.DataBusMember;
import symantec.itools.db.beans.binding.databus.DataCursor;
import symantec.itools.db.beans.binding.databus.DataItem;
import symantec.itools.db.beans.binding.databus.DataItemChangedEvent;
import symantec.itools.db.beans.binding.databus.DataItemChangedListener;
import symantec.itools.db.beans.binding.databus.ImmediateAccess;
import symantec.itools.db.beans.binding.databus.MutableCollectionAccess;
import symantec.itools.db.beans.binding.databus.MutableImmediateAccess;
import symantec.itools.db.beans.util.LocalizedValueGenerator;

public class Mediator
implements DataItemChangedListener,
DataBusEventListener,
DataBusMember {
    public static final int Default = 0;
    public static final int Null = 1;
    public static final int Blank = 2;
    protected DataItem Input;
    protected String dataBinding;
    protected Object output = this;
    protected String[] setMethods;
    protected String[] getMethods;
    protected boolean emptyMeansNull = true;
    protected OutputComponent Component;
    protected DataBus DBus;
    protected boolean hasFoundSetMethod = false;
    protected boolean hasFoundGetMethod = false;
    protected boolean formatNumbers = false;
    protected boolean localizationUsed = false;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    static boolean notifyOnStatic;
    protected boolean notifyOn = true;
    static boolean notifySizeOnStatic;
    protected int currentCursorNumber;
    protected int offset;
    protected int recursionLevel;

    static {
        notifySizeOnStatic = true;
    }

    public Mediator() {
        this.killActualInput();
        this.dataBinding = new String();
    }

    public Mediator(Object object, String string) {
        this.setOutput(object);
        this.setDataBinding(string);
    }

    public void setDataBus(DataBus dataBus) throws PropertyVetoException {
        this.vetos.fireVetoableChange("DataBus", this.DBus, dataBus);
        this.DBus = dataBus;
        this.DBus.addDataBusEventListener(this);
    }

    public DataBus getDataBus() {
        return this.DBus;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void handleDataBusEvent(DataBusEvent dataBusEvent) {
        String string;
        if (dataBusEvent.getEventType() == 0 && dataBusEvent.getSource() != this && this.Input == null && Name.getTableName(string = dataBusEvent.getDataItemName()).equals(Name.getTableName(this.dataBinding))) {
            this.findDI();
        }
        if (dataBusEvent.getEventType() == 1 && dataBusEvent.getSource() != this && this.dataBinding.substring(0, this.dataBinding.indexOf(64)).equals(dataBusEvent.getDataItemName())) {
            this.suicide();
        }
    }

    public void requestDataItem(DataBusEvent dataBusEvent) {
    }

    protected void findDI() {
        if (Beans.isDesignTime()) {
            return;
        }
        this.killActualInput();
        DataItem dataItem = this.DBus.findDataItem(this.dataBinding, this);
        if (dataItem != null && dataItem instanceof DataItem) {
            this.Input = dataItem;
            this.setOutputSize(this.getCollectionSize(dataItem));
            this.Input.addDataItemChangedListener(this);
            this.update(this.Input);
        }
    }

    protected void killActualInput() {
        if (this.Input != null) {
            this.Input.removeDataItemChangedListener(this);
            this.Input = null;
        }
    }

    public void notifyDataItemChanged(DataItemChangedEvent dataItemChangedEvent) {
        if ((this.notifyOn || notifyOnStatic) && this.hasFoundSetMethod && (DataItem)dataItemChangedEvent.getSource() == this.Input) {
            if (dataItemChangedEvent.getChangeType() == 1) {
                this.update(this.Input);
            }
            if (dataItemChangedEvent.getChangeType() == 2) {
                this.setOutputSize(this.getCollectionSize(this.Input));
                this.update(this.Input);
            }
            if (dataItemChangedEvent.getChangeType() == 0) {
                this.setOutputSize(this.getCollectionSize(this.Input));
                if (notifySizeOnStatic) {
                    this.update(this.Input);
                }
            }
        }
    }

    public void commit() {
        if (this.hasFoundGetMethod && this.hasFoundSetMethod && this.Input != null) {
            Object object = this.Component.getPrintOut();
            this.createDataItemFromArray(this.Input, (Object[][])object);
        }
    }

    public void commitUI(TriggerUIEvent triggerUIEvent) {
        this.commit();
    }

    public boolean hasFoundDI() {
        return this.Input != null;
    }

    public void setOutput(Object object) {
        this.output = object;
        this.Component = object.getClass().getName().equals("symantec.itools.db.awt.ProjectionBean") ? new OutputComponentForProj(object) : (object instanceof BasicDataSource ? new OutputComponentForDS(object) : new OutputComponent(object));
        this.Component.setEmptyMeansNull(this.emptyMeansNull);
        if (!this.dataBinding.equals("")) {
            this.setDataBinding(this.dataBinding);
        }
        if (this.setMethods != null) {
            this.setSetMethods(this.setMethods);
        }
        if (this.getMethods != null) {
            this.setGetMethods(this.getMethods);
        }
    }

    public Object getOutput() {
        return this.output;
    }

    public void setSetMethods(String[] stringArray) {
        this.setMethods = stringArray;
        if (this.Component != null) {
            this.hasFoundSetMethod = this.Component.setSetMethods(this.setMethods);
            if (this.hasFoundSetMethod && this.hasFoundDI()) {
                this.update(this.Input);
            }
        }
    }

    public void setGetMethods(String[] stringArray) {
        this.getMethods = stringArray;
        if (this.Component != null) {
            this.hasFoundGetMethod = this.Component.setGetMethods(this.getMethods);
        }
    }

    public String[] getSetMethods() {
        return this.setMethods;
    }

    public String[] getGetMethods() {
        return this.getMethods;
    }

    protected void setOutputSize(Dimension dimension) {
        this.Component.setOutputSize(dimension);
    }

    public Dimension getOutputSize() {
        return this.Component.getOutputSize();
    }

    public int getNumberOfRows() {
        return this.getOutputSize().height;
    }

    protected void update(DataItem dataItem) {
        this.update(dataItem, 0, 0);
    }

    protected void update(DataItem dataItem, int n, int n2) {
        this.currentCursorNumber = 0;
        this.update(dataItem, null, 0, 0);
    }

    protected void update(DataItem dataItem, int[] nArray, int n, int n2) {
        if (dataItem instanceof ImmediateAccess) {
            Object object = ((ImmediateAccess)dataItem).getValueAsObject();
            if (!this.output.getClass().getName().equals("symantec.itools.db.awt.DBTstamp") && this.isLocalizationUsed()) {
                object = LocalizedValueGenerator.formatValue(object, this.formatNumbers);
            }
            if (object == null && this.emptyMeansNull) {
                object = "";
            }
            int n3 = n;
            if (nArray != null) {
                n3 = nArray[n];
            }
            this.Component.setPrintOut(object, n2 - this.offset, n3);
            return;
        }
        if (dataItem instanceof CollectionAccess) {
            DataCursor dataCursor = ((CollectionAccess)dataItem).getCursor();
            ++this.currentCursorNumber;
            DataItem dataItem2 = dataCursor.getCurrentItem();
            while (dataItem2 != null) {
                if (dataItem2 instanceof DataItemAddition) {
                    int n4 = ((DataItemAddition)((Object)dataItem2)).getStatusFlag();
                    if (n4 != 0) {
                        this.update(dataItem2, nArray, n, n2);
                    }
                } else {
                    this.update(dataItem2, nArray, n, n2);
                }
                if (this.currentCursorNumber == 1) {
                    ++n2;
                }
                if (this.currentCursorNumber == 2) {
                    ++n;
                }
                dataItem2 = dataCursor.getNextItem();
            }
            --this.currentCursorNumber;
        }
    }

    public void setDataBinding(String string) {
        this.dataBinding = string;
        if (this.Component != null) {
            if (this.DBus == null) {
                DataBus.joinDataBus(this);
            }
            this.findDI();
        }
    }

    public String getDataBinding() {
        return this.dataBinding;
    }

    protected void notifyEnabled(boolean bl) {
        this.notifyOn = bl;
    }

    public void setEmptyMeansNull(boolean bl) {
        this.emptyMeansNull = bl;
        if (this.Component != null) {
            this.Component.setEmptyMeansNull(this.emptyMeansNull);
        }
    }

    public boolean getEmptyMeansNull() {
        return this.emptyMeansNull;
    }

    public void setFormatNumbers(boolean bl) {
        if (bl) {
            this.setLocalizationUsed(true);
        }
        this.formatNumbers = bl;
    }

    public boolean getFormatNumbers() {
        return this.formatNumbers;
    }

    public void setLocalizationUsed(boolean bl) {
        this.localizationUsed = bl;
        if (!bl) {
            this.setFormatNumbers(false);
        }
    }

    public boolean isLocalizationUsed() {
        return this.localizationUsed;
    }

    protected Dimension getCollectionSize(DataItem dataItem) {
        DataCursor dataCursor;
        DataItem dataItem2;
        if (dataItem instanceof ImmediateAccess) {
            return new Dimension(1, 1);
        }
        Dimension dimension = new Dimension(0, 0);
        if (dataItem instanceof CollectionAccess && (dataItem2 = (dataCursor = ((CollectionAccess)dataItem).getCursor()).getCurrentItem()) != null) {
            ++dimension.height;
            while (dataCursor.getNextItem() != null) {
                ++dimension.height;
            }
            if (dataItem2 instanceof CollectionAccess) {
                DataCursor dataCursor2 = ((CollectionAccess)dataItem2).getCursor();
                ++dimension.width;
                while (dataCursor2.getNextItem() != null) {
                    ++dimension.width;
                }
            }
        }
        return dimension;
    }

    protected DataItem createDataItemFromArray(DataItem dataItem, Object[][] objectArray) {
        int n;
        if (this instanceof MediatorDS) {
            ((MediatorDS)this).notifyEnabled(false);
            notifyOnStatic = false;
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = objectArray[0].length;
            n2 = objectArray.length;
        }
        catch (Exception exception) {
            objectArray = new Object[1][1];
            n3 = 1;
            n2 = 1;
        }
        int n4 = 0;
        if (n3 == 1 && n2 == 1 && (dataItem == null || dataItem instanceof MutableImmediateAccess)) {
            if (dataItem == null) {
                bl = true;
                dataItem = new DataInput();
            }
            Object object = objectArray[0][0];
            this.notifyEnabled(false);
            ((MutableImmediateAccess)dataItem).setValue(new NewValue(object));
            this.notifyEnabled(true);
            if (bl) {
                bl = false;
                if (dataItem instanceof DataItemAddition) {
                    ((DataItemAddition)((Object)dataItem)).setStatusFlag(2);
                }
            }
            return dataItem;
        }
        ++this.recursionLevel;
        if (dataItem == null) {
            dataItem = new MutableCollectionItem();
            ((DataItemAddition)((Object)dataItem)).setStatusFlag(2);
        }
        DataCursor dataCursor = ((CollectionAccess)dataItem).getCursor();
        DataItem dataItem2 = dataCursor.getCurrentItem();
        int n5 = n2;
        if (n2 == 1 && this.recursionLevel > 1) {
            n5 = n3;
        }
        if (this.recursionLevel == 1) {
            n = this.getCollectionSize((DataItem)dataItem).height;
            n4 = n - n2;
            int n6 = 0;
            while (n6 < n4) {
                dataItem2 = dataCursor.getNextItem();
                if (dataItem2 instanceof DataItemAddition) {
                    ((DataItemAddition)((Object)dataItem2)).setStatusFlag(1);
                }
                ++n6;
            }
        }
        n = 0;
        while (n < n5) {
            Object[][] objectArray2 = n2 == 1 && this.recursionLevel > 1 ? this.getSlice(0, objectArray, n) : this.getSlice(1, objectArray, n);
            if (dataItem2 != null) {
                DataItem dataItem3 = dataItem2;
                if ((dataItem2 = this.createDataItemFromArray(dataItem2, objectArray2)) instanceof DataItemAddition && n4 != 0) {
                    ((DataItemAddition)((Object)dataItem2)).setStatusFlag(1);
                }
                if (dataItem2 != dataItem3) {
                    ((MutableCollectionAccess)dataItem).insertBeforeCursor(dataCursor, dataItem2);
                    ((MutableCollectionAccess)dataItem).removeAtCursor(dataCursor);
                    if (dataItem2 instanceof DataItemAddition) {
                        ((DataItemAddition)((Object)dataItem)).setStatusFlag(((DataItemAddition)((Object)dataItem2)).getStatusFlag());
                    }
                }
                dataItem2 = dataCursor.getNextItem();
            } else {
                dataItem2 = this.createDataItemFromArray(null, objectArray2);
                dataItem2.addDataItemChangedListener((DataItemChangedListener)((Object)dataItem));
                ((MutableCollectionAccess)dataItem).addDataItem(dataItem2);
                dataItem2 = null;
            }
            ++n;
        }
        while (dataItem2 != null) {
            ((MutableCollectionAccess)dataItem).removeAtCursor(dataCursor);
            dataItem2.removeDataItemChangedListener((DataItemChangedListener)((Object)dataItem));
            dataItem2 = dataCursor.getNextItem();
        }
        if (this.recursionLevel == 1) {
            dataCursor.reset();
            int n7 = 0;
            while (n7 < n4) {
                notifySizeOnStatic = n7 == n4 - 1;
                ((MutableCollectionAccess)dataItem).removeAtCursor(dataCursor);
                notifySizeOnStatic = true;
                ++n7;
            }
        }
        --this.recursionLevel;
        dataCursor.reset();
        return dataItem;
    }

    protected Object[][] getSlice(int n, Object[][] objectArray, int n2) {
        if (n == 0) {
            Object[][] objectArray2 = new Object[][]{{objectArray[0][n2]}};
            return objectArray2;
        }
        Object[][] objectArray3 = new Object[][]{objectArray[n2]};
        return objectArray3;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void suicide() {
        this.DBus.removeDataBusEventListener(this);
        DataBus.leaveDataBus(this);
        try {
            this.finalize();
            return;
        }
        catch (Throwable throwable) {
            System.out.println("could'nt do it");
            return;
        }
    }
}

