/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.binding;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.db.beans.binding.BindingResourceLoader;
import symantec.itools.db.beans.binding.Connection;
import symantec.itools.db.beans.binding.IllegalRelationshipException;
import symantec.itools.db.beans.binding.ParentInvalidRecordException;
import symantec.itools.db.beans.binding.PersistentObject;
import symantec.itools.db.beans.binding.QueryNavigatorLink;
import symantec.itools.db.beans.binding.RelationshipPendingException;
import symantec.itools.db.beans.binding.SaveChangesDialog;
import symantec.itools.db.beans.binding.SaveChangesWindow;
import symantec.itools.db.beans.binding.Synchronizable;
import symantec.itools.db.beans.binding.SynchronizerLink;
import symantec.itools.db.beans.binding.SynchronizerNode;
import symantec.itools.db.beans.binding.SynchronizerTree;

public class QuerySynchronizer {
    private static BindingResourceLoader resourceLoader = BindingResourceLoader.getInstance();
    private static ResourceBundle MyResource = resourceLoader.getBundle();
    public static final String EASY_WAY_OUT = "Easy way out";
    private static QuerySynchronizer[] m_AllSynchronizers = new QuerySynchronizer[255];
    private static Hashtable m_AllLinks = new Hashtable();
    private static final int SAVE_DELETED_CHILDREN = 1;
    private static final int SAVE_CURRENT = 2;
    private static final int SAVE_DELETED = 3;
    private static final int SAVE_NEW_OR_MODIFIED_CHILDREN = 4;
    private static final int COMMIT_STATE = 5;
    private static final int QUERY_CHILDREN = 6;
    private static final int CLEAR_CHILDREN = 7;
    private static final int SAVE_NEW_OR_MODIFIED = 8;
    private static final int UNDO_DATA = 10;
    private static final int CLOSE = 9;
    private SynchronizerTree m_Tree;
    private SynchronizerLink m_RootLink;
    private Hashtable m_AllConnections;
    private SaveChangesDialog m_SaveChangesWindow;

    private QuerySynchronizer() {
        QuerySynchronizer.addSynchronizer(this);
    }

    static void testTrees() {
        System.out.println("Testing trees!");
        int n = 0;
        while (n < m_AllSynchronizers.length) {
            if (m_AllSynchronizers[n] != null) {
                System.out.println(m_AllSynchronizers[n].toString());
            }
            ++n;
        }
    }

    static synchronized void addSynchronizable(Synchronizable synchronizable) throws IllegalRelationshipException {
        String string = synchronizable.getAliasName();
        String string2 = synchronizable.getMasterAliasName();
        if (string2 == null) {
            string2 = "";
        }
        if (string == string2) {
            throw new IllegalRelationshipException(MyResource.getString("QuerySynch_IllegalRelation1"));
        }
        SynchronizerLink synchronizerLink = QuerySynchronizer.findLink(string);
        SynchronizerLink synchronizerLink2 = string2 != "" ? QuerySynchronizer.findLink(string2) : null;
        if (synchronizerLink != null) {
            if (!synchronizerLink.isOpen() && synchronizerLink.getMasterAlias() != string2) {
                throw new IllegalRelationshipException(MyResource.getString("QuerySynch_IllegalRelation2"));
            }
            if (synchronizerLink2 != null && synchronizerLink.getParentLink() != synchronizerLink2) {
                QuerySynchronizer.merge(synchronizerLink2, synchronizerLink);
            }
        } else {
            QuerySynchronizer querySynchronizer;
            if (synchronizerLink2 == null) {
                querySynchronizer = new QuerySynchronizer();
                SynchronizerNode synchronizerNode = new SynchronizerNode();
                SynchronizerTree synchronizerTree = new SynchronizerTree(synchronizerNode);
                QueryNavigatorLink queryNavigatorLink = new QueryNavigatorLink();
                querySynchronizer.m_Tree = synchronizerTree;
                querySynchronizer.m_RootLink = queryNavigatorLink;
                synchronizerNode.setUserObject(queryNavigatorLink);
                queryNavigatorLink.setNode(synchronizerNode);
                queryNavigatorLink.setSynchronizer(querySynchronizer);
            } else {
                querySynchronizer = null;
            }
            if (string2 == "") {
                synchronizerLink = querySynchronizer.m_RootLink;
            } else {
                SynchronizerNode synchronizerNode = new SynchronizerNode();
                synchronizerLink = new QueryNavigatorLink();
                synchronizerNode.setUserObject(synchronizerLink);
                synchronizerLink.setNode(synchronizerNode);
                if (synchronizerLink2 == null) {
                    synchronizerLink2 = querySynchronizer.m_RootLink;
                    synchronizerLink2.setAlias(string2);
                    SynchronizerNode synchronizerNode2 = (SynchronizerNode)synchronizerLink2.getNode();
                    synchronizerNode = (SynchronizerNode)synchronizerLink.getNode();
                    synchronizerNode2.add(synchronizerNode);
                    synchronizerLink.setSynchronizer(querySynchronizer);
                } else {
                    QuerySynchronizer.merge(synchronizerLink2, synchronizerLink);
                }
            }
        }
        synchronizerLink.setSynchronizable(synchronizable);
        synchronizable.setLink(synchronizerLink);
    }

    private static SynchronizerLink findLink(Object object) {
        SynchronizerLink synchronizerLink = m_AllLinks.containsKey(object) ? (SynchronizerLink)m_AllLinks.get(object) : null;
        return synchronizerLink;
    }

    private static synchronized void addSynchronizer(QuerySynchronizer querySynchronizer) {
        int n = 0;
        while (n < m_AllSynchronizers.length) {
            if (m_AllSynchronizers[n] == null) {
                QuerySynchronizer.m_AllSynchronizers[n] = querySynchronizer;
                return;
            }
            ++n;
        }
        QuerySynchronizer[] querySynchronizerArray = new QuerySynchronizer[m_AllSynchronizers.length + 255];
        System.arraycopy(m_AllSynchronizers, 0, querySynchronizerArray, 255, m_AllSynchronizers.length);
        m_AllSynchronizers = querySynchronizerArray;
    }

    private static synchronized void removeSynchronizer(QuerySynchronizer querySynchronizer) {
        int n = 0;
        while (n < m_AllSynchronizers.length) {
            if (m_AllSynchronizers[n] == querySynchronizer) {
                m_AllSynchronizers[n].removeAllLinks();
                QuerySynchronizer.m_AllSynchronizers[n] = null;
                return;
            }
            ++n;
        }
    }

    static synchronized void addLink(SynchronizerLink synchronizerLink) {
        String string = synchronizerLink.getAlias();
        if (!m_AllLinks.contains(string)) {
            m_AllLinks.put(string, synchronizerLink);
        }
    }

    static synchronized void removeLink(SynchronizerLink synchronizerLink) {
        SynchronizerNode synchronizerNode = (SynchronizerNode)synchronizerLink.getNode();
        SynchronizerNode synchronizerNode2 = (SynchronizerNode)synchronizerNode.getParent();
        QuerySynchronizer querySynchronizer = synchronizerLink.getSynchronizer();
        m_AllLinks.remove(synchronizerLink.getAlias());
        if (synchronizerNode2 != null) {
            try {
                querySynchronizer.orderAndProcessNodes(synchronizerNode, 9);
            }
            catch (SQLException sQLException) {}
            synchronizerNode2.remove(synchronizerNode);
        }
    }

    private static synchronized void merge(SynchronizerLink synchronizerLink, SynchronizerLink synchronizerLink2) {
        QuerySynchronizer querySynchronizer = synchronizerLink2.getSynchronizer();
        if (querySynchronizer != null) {
            QuerySynchronizer.removeSynchronizer(querySynchronizer);
        }
        SynchronizerNode synchronizerNode = (SynchronizerNode)synchronizerLink.getNode();
        SynchronizerNode synchronizerNode2 = (SynchronizerNode)synchronizerLink2.getNode();
        synchronizerNode.add(synchronizerNode2);
        synchronizerLink2.setSynchronizer(synchronizerLink.getSynchronizer());
        Enumeration enumeration = synchronizerNode2.children();
        while (enumeration.hasMoreElements()) {
            SynchronizerNode synchronizerNode3 = (SynchronizerNode)enumeration.nextElement();
            SynchronizerLink synchronizerLink3 = (SynchronizerLink)synchronizerNode3.getUserObject();
            synchronizerLink3.setSynchronizer(synchronizerLink.getSynchronizer());
        }
    }

    public static Enumeration pathFromRootEnumeration(Synchronizable synchronizable) {
        Vector<Synchronizable> vector = new Vector<Synchronizable>();
        SynchronizerNode synchronizerNode = (SynchronizerNode)synchronizable.getLink().getNode();
        Enumeration enumeration = synchronizerNode.pathFromRootEnumeration();
        while (enumeration.hasMoreElements()) {
            synchronizerNode = (SynchronizerNode)enumeration.nextElement();
            SynchronizerLink synchronizerLink = (SynchronizerLink)synchronizerNode.getUserObject();
            Synchronizable synchronizable2 = synchronizerLink.getSynchronizable();
            vector.addElement(synchronizable2);
        }
        return vector.elements();
    }

    boolean saveAll(SynchronizerLink synchronizerLink) throws RelationshipPendingException, ParentInvalidRecordException {
        boolean bl = this.saveTree((SynchronizerNode)synchronizerLink.getNode(), true);
        if (bl) {
            this.navigate(synchronizerLink, 4, null);
        }
        return bl;
    }

    boolean saveAllLevels(SynchronizerLink synchronizerLink) throws RelationshipPendingException, ParentInvalidRecordException {
        return this.saveAll((SynchronizerLink)((SynchronizerNode)this.m_Tree.getRoot()).getUserObject());
    }

    boolean save(SynchronizerLink synchronizerLink) throws RelationshipPendingException, ParentInvalidRecordException {
        boolean bl;
        block2: {
            bl = this.saveTree((SynchronizerNode)synchronizerLink.getNode(), false);
            if (!bl) break block2;
            try {
                this.orderAndProcessNodes((SynchronizerNode)synchronizerLink.getNode(), 6);
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    void clear(SynchronizerLink synchronizerLink) throws RelationshipPendingException, ParentInvalidRecordException {
        try {
            this.orderAndProcessNodes((SynchronizerNode)synchronizerLink.getNode(), 10);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private boolean saveTree(SynchronizerNode synchronizerNode, boolean bl) throws RelationshipPendingException, ParentInvalidRecordException {
        boolean bl2;
        if (this.isOpen()) {
            throw new RelationshipPendingException(MyResource.getString("QuerySynch_RelationPend1"));
        }
        if (this.isParentOnNewRecord((SynchronizerLink)synchronizerNode.getUserObject())) {
            throw new ParentInvalidRecordException(MyResource.getString("QuerySynch_ParentInvalid1"));
        }
        this.beginAllTransactions();
        try {
            this.orderAndProcessNodes(synchronizerNode, 1);
            if (bl) {
                this.orderAndProcessNodes(synchronizerNode, 3);
                this.orderAndProcessNodes(synchronizerNode, 8);
            } else {
                this.orderAndProcessNodes(synchronizerNode, 2);
            }
            this.orderAndProcessNodes(synchronizerNode, 4);
            bl2 = true;
            this.orderAndProcessNodes(synchronizerNode, 5);
        }
        catch (SQLException sQLException) {
            System.out.println(MyResource.getString("QuerySynch_TransactionFail"));
            bl2 = false;
        }
        catch (Exception exception) {
            bl2 = true;
        }
        this.endAllTransactions(bl2);
        return bl2;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void navigate(SynchronizerLink var1_1, int var2_2, Integer var3_3) throws RelationshipPendingException, ParentInvalidRecordException {
        if (this.isOpen()) {
            throw new RelationshipPendingException(QuerySynchronizer.MyResource.getString("QuerySynch_RelationPend2"));
        }
        if (this.isParentOnNewRecord(var1_1)) {
            throw new ParentInvalidRecordException(QuerySynchronizer.MyResource.getString("QuerySynch_ParentInvalid1"));
        }
        var7_4 = (SynchronizerNode)var1_1.getNode();
        var12_5 = this.isDirty(var1_1, var2_2);
        var13_6 = var12_5.isDirty;
        if (var13_6) {
            var14_7 = var12_5.target.getSaveChangesWindowClass();
            try {
                this.m_SaveChangesWindow = (SaveChangesDialog)Class.forName(var14_7).newInstance();
            }
            catch (Exception v0) {
                this.m_SaveChangesWindow = new SaveChangesWindow();
            }
        }
        if (!var13_6 || this.m_SaveChangesWindow == null) ** GOTO lbl29
        this.m_SaveChangesWindow.setMessage(var12_5.target.getDirtySaveMessage());
        var4_8 = this.m_SaveChangesWindow.run();
        switch (var4_8) {
            case 1: {
                var5_10 = this.saveAll(var1_1);
                if (var5_10) break;
                return;
            }
            case 2: {
                if (var2_2 != 6) break;
                this.clear(var1_1);
                break;
            }
            case 3: {
                throw new RelationshipPendingException("Easy way out");
            }
lbl29:
            // 1 sources

            var4_9 = 2;
            break;
        }
        try {
            var6_11 = (SynchronizerLink)var7_4.getUserObject();
            var8_12 = var6_11.getSynchronizable();
            if (var2_2 == 4) {
                var10_13 = (SynchronizerNode)var7_4.getParent();
                if (var10_13 != null) {
                    var9_14 = (SynchronizerLink)var10_13.getUserObject();
                    var11_15 = var9_14.getSynchronizable();
                } else {
                    var11_15 = null;
                }
                var8_12.executeQuery(var11_15);
            } else {
                var8_12.navigate(var2_2, var3_3);
            }
            this.orderAndProcessNodes(var7_4, 6);
            return;
        }
        catch (SQLException v1) {
            return;
        }
    }

    public String toString() {
        SynchronizerNode synchronizerNode = (SynchronizerNode)this.m_Tree.getRoot();
        Enumeration enumeration = synchronizerNode.enumerateNodes(0);
        String string = super.toString();
        string = String.valueOf(string) + "\nQuerySynchronizer nodes: ";
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + "\n\t" + enumeration.nextElement().toString();
        }
        return string;
    }

    private boolean isOpen() {
        SynchronizerNode synchronizerNode = (SynchronizerNode)this.m_Tree.getRoot();
        SynchronizerLink synchronizerLink = (SynchronizerLink)synchronizerNode.getUserObject();
        return synchronizerLink.isOpen();
    }

    private DirtyNode isDirty(SynchronizerLink synchronizerLink, int n) {
        DirtyNode dirtyNode = new DirtyNode();
        SynchronizerNode synchronizerNode = (SynchronizerNode)synchronizerLink.getNode();
        Enumeration enumeration = n == 6 || n == 4 ? synchronizerNode.enumerateNodes(0) : synchronizerNode.enumerateNodes(1);
        while (enumeration.hasMoreElements()) {
            synchronizerNode = (SynchronizerNode)enumeration.nextElement();
            SynchronizerLink synchronizerLink2 = (SynchronizerLink)synchronizerNode.getUserObject();
            Synchronizable synchronizable = synchronizerLink2.getSynchronizable();
            if (!synchronizable.isDirty()) continue;
            dirtyNode.target = synchronizable;
            dirtyNode.isDirty = true;
            if (synchronizerNode.getLevel() == 0) {
                dirtyNode.isRoot = true;
            }
            return dirtyNode;
        }
        dirtyNode.isDirty = false;
        return dirtyNode;
    }

    private void beginAllTransactions() {
        Enumeration enumeration = this.enumerateConnections();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            connection.beginTransaction();
        }
    }

    private void endAllTransactions(boolean bl) {
        Enumeration enumeration = this.enumerateConnections();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            connection.endTransaction(bl);
        }
    }

    private synchronized void addConnection(Connection connection) {
        Integer n;
        if (this.m_AllConnections.containsKey(connection)) {
            n = (Integer)this.m_AllConnections.get(connection);
            this.m_AllConnections.remove(connection);
            n = new Integer(n + 1);
        } else {
            n = new Integer(1);
        }
        this.m_AllConnections.put(connection, n);
    }

    private synchronized void removeConnection(Connection connection) {
        Integer n = (Integer)this.m_AllConnections.get(connection);
        this.m_AllConnections.remove(connection);
        n = new Integer(n - 1);
        if (n > 0) {
            this.m_AllConnections.put(connection, n);
        }
    }

    private Enumeration enumerateConnections() {
        if (this.m_AllConnections == null) {
            this.m_AllConnections = new Hashtable();
            SynchronizerNode synchronizerNode = (SynchronizerNode)this.m_Tree.getRoot();
            Enumeration enumeration = synchronizerNode.enumerateNodes(0);
            while (enumeration.hasMoreElements()) {
                synchronizerNode = (SynchronizerNode)enumeration.nextElement();
                SynchronizerLink synchronizerLink = (SynchronizerLink)synchronizerNode.getUserObject();
                Synchronizable synchronizable = synchronizerLink.getSynchronizable();
                Connection connection = synchronizable.getConnection();
                this.addConnection(connection);
            }
        }
        return this.m_AllConnections.keys();
    }

    void removeAllLinks() {
        SynchronizerNode synchronizerNode = (SynchronizerNode)this.m_Tree.getRoot();
        Enumeration enumeration = synchronizerNode.enumerateNodes(0);
        while (enumeration.hasMoreElements()) {
            synchronizerNode = (SynchronizerNode)enumeration.nextElement();
            SynchronizerLink synchronizerLink = (SynchronizerLink)synchronizerNode.getUserObject();
            QuerySynchronizer.removeLink(synchronizerLink);
        }
    }

    boolean isParentOnNewRecord(SynchronizerLink synchronizerLink) {
        SynchronizerLink synchronizerLink2;
        Synchronizable synchronizable;
        PersistentObject persistentObject;
        SynchronizerNode synchronizerNode = (SynchronizerNode)synchronizerLink.getNode();
        SynchronizerNode synchronizerNode2 = (SynchronizerNode)synchronizerNode.getParent();
        boolean bl = synchronizerNode2 != null ? ((persistentObject = (PersistentObject)(synchronizable = (synchronizerLink2 = (SynchronizerLink)synchronizerNode2.getUserObject()).getSynchronizable()).getCurrentObject()) == null ? false : persistentObject.getMarkedAsNew()) : false;
        return bl;
    }

    private void orderAndProcessNodes(SynchronizerNode synchronizerNode, int n) throws SQLException {
        Synchronizable synchronizable;
        SynchronizerLink synchronizerLink;
        int n2;
        int n3;
        switch (n) {
            case 1: {
                n3 = 2;
                n2 = 1;
                break;
            }
            case 10: {
                n3 = 0;
                n2 = 4;
                break;
            }
            case 2: {
                n3 = 3;
                n2 = 5;
                break;
            }
            case 3: {
                n3 = 3;
                n2 = 1;
                break;
            }
            case 8: {
                n3 = 3;
                n2 = 2;
                break;
            }
            case 4: {
                n3 = 1;
                n2 = 2;
                break;
            }
            case 5: {
                n3 = 0;
                n2 = 5;
                break;
            }
            default: {
                n3 = 1;
                synchronizerLink = (SynchronizerLink)synchronizerNode.getUserObject();
                synchronizable = synchronizerLink.getSynchronizable();
                PersistentObject persistentObject = (PersistentObject)synchronizable.getCurrentObject();
                if (persistentObject == null || persistentObject.getMarkedAsNew()) {
                    n = 7;
                    n2 = 4;
                    break;
                }
                n2 = 6;
                break;
            }
            case 9: {
                n3 = 1;
                n2 = 9;
            }
        }
        Enumeration enumeration = synchronizerNode.enumerateNodes(n3);
        while (enumeration.hasMoreElements()) {
            SynchronizerNode synchronizerNode2 = (SynchronizerNode)enumeration.nextElement();
            synchronizerLink = (SynchronizerLink)synchronizerNode2.getUserObject();
            synchronizable = synchronizerLink.getSynchronizable();
            if (n == 5) {
                synchronizable.commitState();
                continue;
            }
            if (n == 9) {
                synchronizerLink.close();
                continue;
            }
            if (n == 10) {
                synchronizable.saveAll(4);
                continue;
            }
            if (n == 6) {
                SynchronizerNode synchronizerNode3 = (SynchronizerNode)synchronizerNode2.getParent();
                if (synchronizerNode3 == null) continue;
                SynchronizerLink synchronizerLink2 = (SynchronizerLink)synchronizerNode3.getUserObject();
                Synchronizable synchronizable2 = synchronizerLink2.getSynchronizable();
                synchronizable.executeQuery(synchronizable2);
                continue;
            }
            synchronizable.saveAll(n2);
        }
    }

    class DirtyNode {
        public boolean isRoot;
        public boolean isDirty;
        public Synchronizable target;

        public DirtyNode() {
            QuerySynchronizer.this = QuerySynchronizer.this;
        }
    }
}

