/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.binding.databus;

import java.beans.PropertyVetoException;
import java.util.Vector;
import symantec.itools.db.beans.binding.databus.DataBusEvent;
import symantec.itools.db.beans.binding.databus.DataBusEventListener;
import symantec.itools.db.beans.binding.databus.DataBusMember;
import symantec.itools.db.beans.binding.databus.DataItem;
import symantec.itools.db.beans.binding.databus.InvalidType;

public class DataBus {
    private boolean debug = false;
    private static Vector listeners = new Vector();
    private static Vector members = null;
    private static DataBus ib = null;

    private DataBus() {
        if (members == null) {
            members = new Vector();
        }
        ib = this;
    }

    public static void initialize() {
        ib = null;
        members = null;
        listeners = new Vector();
    }

    private static DataBus getDataBus(DataBus dataBus) {
        if (dataBus == null && ib == null) {
            ib = new DataBus();
            return ib;
        }
        if (ib != null) {
            return ib;
        }
        return dataBus;
    }

    public static synchronized void joinDataBus(DataBusMember dataBusMember) {
        DataBus dataBus = dataBusMember.getDataBus();
        try {
            dataBusMember.setDataBus(DataBus.getDataBus(dataBus));
        }
        catch (PropertyVetoException propertyVetoException) {}
        members.addElement(dataBusMember);
    }

    public static synchronized void leaveDataBus(DataBusMember dataBusMember) {
        members.removeElement(dataBusMember);
    }

    public synchronized void addDataBusEventListener(DataBusEventListener dataBusEventListener) {
        listeners.addElement(dataBusEventListener);
    }

    public synchronized void removeDataBusEventListener(DataBusEventListener dataBusEventListener) {
        listeners.removeElement(dataBusEventListener);
    }

    public void announceDataItem(DataBusEvent dataBusEvent) {
        Vector vector;
        if (this.debug) {
            System.err.println("Event type pressed: " + dataBusEvent.getEventType() + " , for the data item: " + dataBusEvent.getDataItemName() + " from: " + dataBusEvent.toString());
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)listeners.clone();
        }
        try {
            object = new DataBusEvent(dataBusEvent.getEventType(), dataBusEvent.getDataItemName(), dataBusEvent.getSource());
            int n = 0;
            while (n < vector.size()) {
                DataBusEventListener dataBusEventListener = (DataBusEventListener)vector.elementAt(n);
                dataBusEventListener.handleDataBusEvent((DataBusEvent)object);
                ++n;
            }
            return;
        }
        catch (InvalidType invalidType) {
            System.err.println("Exception: " + invalidType.getMessage());
            return;
        }
    }

    public DataItem findDataItem(String string, DataBusMember dataBusMember) {
        DataItem dataItem = null;
        try {
            try {
                DataBusEvent dataBusEvent = new DataBusEvent(2, string, dataBusMember, dataItem);
                int n = 0;
                while (n < members.size()) {
                    DataBusEventListener dataBusEventListener = (DataBusEventListener)members.elementAt(n);
                    dataBusEventListener.requestDataItem(dataBusEvent);
                    dataItem = dataBusEvent.getDataItem();
                    if (dataItem == null) {
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (InvalidType invalidType) {
                System.err.println("Exception: " + invalidType.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return dataItem;
    }

    public synchronized DataItem[] findAllDataItems(String string, DataBusMember dataBusMember) {
        Vector<DataItem> vector = new Vector<DataItem>();
        Object[] objectArray = null;
        DataItem dataItem = null;
        try {
            try {
                DataBusEvent dataBusEvent = new DataBusEvent(2, string, dataBusMember, dataItem);
                int n = 0;
                while (n < members.size()) {
                    DataBusEventListener dataBusEventListener = (DataBusEventListener)members.elementAt(n);
                    dataBusEventListener.requestDataItem(dataBusEvent);
                    dataItem = dataBusEvent.getDataItem();
                    if (dataItem != null) {
                        vector.addElement(dataItem);
                        ++n;
                        dataItem = null;
                    }
                    ++n;
                }
                objectArray = new DataItem[vector.size()];
                vector.copyInto(objectArray);
            }
            catch (InvalidType invalidType) {
                System.err.println("Exception: " + invalidType.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return objectArray;
    }

    public synchronized void findDataItem(DataBusEvent dataBusEvent) {
        DataItem dataItem = null;
        int n = 0;
        while (n < members.capacity()) {
            DataBusEventListener dataBusEventListener = (DataBusEventListener)members.elementAt(n);
            dataBusEventListener.requestDataItem(dataBusEvent);
            dataItem = dataBusEvent.getDataItem();
            if (dataItem != null) {
                return;
            }
            ++n;
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }
}

