/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.beans.Beans;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import symantec.itools.db.beans.jdbc.JdbcConnection;

public class ConnectionManager {
    public static boolean isDesignTimeOverride;
    public static boolean debug;
    public static final String CLASS_NAME = "ConnectionManager.";
    private static Hashtable m_ConnectionManagersTable;
    private Hashtable m_ConnectionsTable = new Hashtable();
    private Hashtable m_ConnectionsCounter = new Hashtable();

    static {
        m_ConnectionManagersTable = new Hashtable();
    }

    public ConnectionManager() {
        String string = "ConnectionManager()";
        if (debug) {
            System.out.println(CLASS_NAME + string);
        }
    }

    public synchronized void finalize() throws Throwable {
        Object object;
        String string = "ConnectionManager.finalize()";
        if (debug) {
            System.out.println("<ENTER:>" + string);
        }
        if (debug) {
            object = this.getJdbcConnectionsIndentifiers();
            int n = 0;
            while (n < ((String[])object).length) {
                System.out.println((String)object[n]);
                ++n;
            }
        }
        if (Beans.isDesignTime()) {
            super.finalize();
            return;
        }
        object = this.m_ConnectionsTable.elements();
        while (object.hasMoreElements()) {
            JdbcConnection jdbcConnection = (JdbcConnection)object.nextElement();
            if (jdbcConnection.getSQLConnection().isClosed()) continue;
            if (debug) {
                System.out.println("con.getSQLConnection().close() <---");
            }
            jdbcConnection.getSQLConnection().close();
        }
        if (this.m_ConnectionsTable != null) {
            if (debug) {
                System.out.println("set m_ConnectionsTable to null");
            }
            this.m_ConnectionsTable = null;
        }
        if (this.m_ConnectionsCounter != null) {
            if (debug) {
                System.out.println("set m_ConnectionCounter to null");
            }
            this.m_ConnectionsCounter = null;
        }
        super.finalize();
        if (debug) {
            System.out.println("<END:>" + string);
        }
    }

    public static synchronized ConnectionManager getManager(String string) {
        String string2 = "ConnectionManager.getManager(" + string + ")";
        if (debug) {
            System.out.println("<ENTER>: " + string2);
        }
        ConnectionManager connectionManager = null;
        if (m_ConnectionManagersTable.containsKey(string)) {
            connectionManager = (ConnectionManager)m_ConnectionManagersTable.get(string);
        } else {
            try {
                connectionManager = (ConnectionManager)Class.forName(string).newInstance();
                m_ConnectionManagersTable.put(string, connectionManager);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (debug) {
            System.out.println("<END>: " + string2);
        }
        return connectionManager;
    }

    public static ConnectionManager getManager() throws SQLException {
        String string = "getManager()";
        if (debug) {
            System.out.println(CLASS_NAME + string);
        }
        return ConnectionManager.getManager("ConnectionManager");
    }

    public void add(JdbcConnection jdbcConnection) {
        String string = "add(JdbcConnection)";
        if (debug) {
            System.out.println(CLASS_NAME + string);
        }
        Hashtable hashtable = this.m_ConnectionsTable;
        synchronized (hashtable) {
            this.m_ConnectionsTable.put(jdbcConnection.getIdentifier(), jdbcConnection);
            if (debug) {
                System.out.println("m_ConnectionsTable.put(" + jdbcConnection.getIdentifier() + ",connection)");
            }
        }
        hashtable = this.m_ConnectionsCounter;
        synchronized (hashtable) {
            this.m_ConnectionsCounter.put(jdbcConnection.getIdentifier(), new Integer(0));
            if (debug) {
                System.out.println("m_ConnectionsCounter.put(" + jdbcConnection.getIdentifier() + ",0)");
            }
            return;
        }
    }

    public synchronized JdbcConnection getConnectionBean(String string) throws SQLException {
        String string2 = "getConnectionBean(" + string + ")";
        if (debug) {
            System.out.println(CLASS_NAME + string2);
        }
        JdbcConnection jdbcConnection = null;
        if (Beans.isDesignTime() && !isDesignTimeOverride) {
            return jdbcConnection;
        }
        if (this.m_ConnectionsTable.containsKey(string)) {
            jdbcConnection = (JdbcConnection)this.m_ConnectionsTable.get(string);
            int n = (Integer)this.m_ConnectionsCounter.get(string);
            this.m_ConnectionsCounter.remove(string);
            this.m_ConnectionsCounter.put(string, new Integer(++n));
            if (debug) {
                System.out.println("put: " + string + " cont: " + n);
            }
        }
        if (debug) {
            System.out.println("URL:" + jdbcConnection.getURL());
        }
        return jdbcConnection;
    }

    public synchronized void releaseConnection(String string) {
        String string2 = "releaseConnection(" + string + ")";
        if (debug) {
            System.out.println(CLASS_NAME + string2);
        }
        JdbcConnection jdbcConnection = null;
        if (this.m_ConnectionsTable.containsKey(string)) {
            int n = (Integer)this.m_ConnectionsCounter.get(string);
            jdbcConnection = (JdbcConnection)this.m_ConnectionsTable.get(string);
            this.m_ConnectionsCounter.remove(string);
            this.m_ConnectionsCounter.put(string, new Integer(--n));
            if (debug) {
                System.out.println("put: " + string + " cont: " + n);
            }
            if (n <= 0) {
                try {
                    if (!jdbcConnection.getSQLConnection().isClosed()) {
                        jdbcConnection.setConnectionClosed(true);
                        if (debug) {
                            System.out.println("m_ConnectionsTable.remove(" + string + ")");
                            System.out.println("m_ConnectionsCounter.remove(" + string + ")");
                        }
                        this.m_ConnectionsTable.remove(string);
                        this.m_ConnectionsCounter.remove(string);
                        return;
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    return;
                }
            }
        }
    }

    public synchronized String[] getJdbcConnectionsIndentifiers() {
        Object[] objectArray = new String[]{};
        Vector<String> vector = new Vector<String>(this.m_ConnectionsTable.size());
        Enumeration enumeration = this.m_ConnectionsTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n && string.compareTo((String)vector.elementAt(n2)) > 0) {
                ++n2;
            }
            vector.insertElementAt(string, n2);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized JdbcConnection getDesignTimeConnection(String string) throws SQLException {
        String string2 = "getDesignTimeConnection(" + string + ")";
        if (debug) {
            System.out.println(CLASS_NAME + string2);
        }
        JdbcConnection jdbcConnection = null;
        isDesignTimeOverride = true;
        jdbcConnection = this.getConnectionBean(string);
        isDesignTimeOverride = false;
        if (jdbcConnection != null) {
            jdbcConnection.connect();
        }
        return jdbcConnection;
    }

    public synchronized ConnectionManager getDesignTimeInstance() {
        if (!Beans.isDesignTime()) {
            throw new RuntimeException("ConnectionManager.getDesignTimeInstance() called at run-time");
        }
        return this;
    }
}

