/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.Visibility;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JDBCBean
implements Serializable,
VetoableChangeListener,
PropertyChangeListener,
ObjectInputValidation,
Visibility {
    protected static String PROP_NAME = "name";
    protected static String PROP_DESCRIPTION = "description";
    protected static String PROP_DEBUG = "debug";
    protected static String PROP_AUTOSTART = "autoStart";
    private static String CURRENTVERSION = "0.01";
    private String version = CURRENTVERSION;
    private String name = "";
    private String description = "";
    private boolean debug = false;
    private boolean autoStart = false;
    private PropertyChangeSupport boundChanges = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetoChanges = new VetoableChangeSupport(this);
    protected transient boolean guiAvailable = false;
    protected transient ResourceBundle stringResources;

    public JDBCBean() {
        this.name = "";
        this.description = "";
        this.debug = false;
        this.autoStart = false;
    }

    public JDBCBean(String string, String string2, boolean bl, boolean bl2) {
        this.setName(string);
        this.setDescription(string2);
        this.setDebug(bl);
        this.setAutoStart(bl2);
    }

    public void setName(String string) {
        this.processPropertyChange(PROP_NAME, this.name, string);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.processPropertyChange(PROP_DESCRIPTION, this.description, string);
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDebug(boolean bl) {
        this.processPropertyChange(PROP_DEBUG, new Boolean(this.debug), new Boolean(bl));
        this.debug = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setAutoStart(boolean bl) {
        this.processPropertyChange(PROP_AUTOSTART, new Boolean(this.autoStart), new Boolean(bl));
        this.autoStart = bl;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean needsGui() {
        return false;
    }

    public void dontUseGui() {
        this.guiAvailable = false;
    }

    public void okToUseGui() {
        this.guiAvailable = true;
    }

    public boolean avoidingGui() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundChanges.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundChanges.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoChanges.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoChanges.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void validateObject() throws InvalidObjectException {
        if (!this.version.equals(CURRENTVERSION)) {
            throw new InvalidObjectException("Serialized version " + this.version + "is not compatible with JDBCBean version " + CURRENTVERSION);
        }
        try {
            if (this.isAutoStart()) {
                this.doAutoStart();
                return;
            }
        }
        catch (Exception exception) {
            this.printMessage("Exception thrown during de-serialization: " + exception.toString());
        }
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        if (this.isDebug()) {
            this.printMessage("Exception thrown: " + sQLException.toString());
            this.printMessage("Stack Trace: ");
            sQLException.printStackTrace();
        }
        throw sQLException;
    }

    protected void printMessage(String string) {
        if (this.isDebug()) {
            System.out.println(string);
        }
    }

    protected void doAutoStart() {
    }

    protected String getResString(String string) {
        String string2 = "String Resource Error";
        try {
            string2 = this.getResourceBundle().getString(string);
        }
        catch (Exception exception) {
            this.printMessage("Exception caught: " + exception.toString());
        }
        return string2;
    }

    protected ResourceBundle getResourceBundle() throws MissingResourceException {
        if (this.stringResources == null) {
            this.stringResources = ResourceBundle.getBundle("symantec.itools.db.beans.res.StringResources");
        }
        return this.stringResources;
    }

    protected void processPropertyChange(String string, Object object, Object object2) {
        this.printMessage("BOUND PROPERTY " + string + " CHANGED FROM " + object + " TO " + object2);
        this.boundChanges.firePropertyChange(string, object, object2);
    }

    protected void processVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.printMessage("ATTEMPTING TO CHANGE CONSTRAINED PROPERTY " + string + " FROM " + object + " TO " + object2);
        try {
            this.vetoChanges.fireVetoableChange(string, object, object2);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.printMessage("ATTEMPT TO CHANGE CONSTRAINED PROPERTY " + string + " FAILED");
            throw propertyVetoException;
        }
        this.printMessage("ATTEMPT TO CHANGE CONSTRAINED PROPERTY " + string + " SUCCEEDED");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.registerValidation(this, 0);
        objectInputStream.defaultReadObject();
    }
}

