/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import symantec.itools.db.beans.jdbc.ConnectFailedEvent;
import symantec.itools.db.beans.jdbc.ConnectFailedListener;
import symantec.itools.db.beans.jdbc.JDBCBean;
import symantec.itools.db.beans.util.LogWindowHelper;
import symantec.itools.lang.OS;

public class JdbcConnection
extends JDBCBean
implements symantec.itools.db.beans.binding.Connection {
    public static final String BEGIN_TRANSACTION = "Begin Transaction";
    public static final String COMMIT_TRANSACTION = "Commit Transaction";
    public static final String ROLLBACK_TRANSACTION = "Rollback Transaction";
    public static final String USER_ID = "userid";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static boolean debug;
    public static final String CLASS_NAME = "JdbcConnection.";
    public static final String PROP_DRIVERNAME = "driverName";
    public static final String PROP_URL = "url";
    public static final String PROP_USERNAME = "userName";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_CATALOG = "catalog";
    public static final String PROP_AUTOCOMMIT = "autoCommit";
    public static final String PROP_READONLY = "readOnly";
    public static final String PROP_CONNCLOSED = "connectionClosed";
    public static final String PROP_TRANS_ISOLATION = "transactionIsolationLevel";
    public static final String POINTBASE_DRIVER = "com.pointbase.jdbc.jdbcDriver";
    protected static LogWindowHelper logWindow;
    private static final String T_LOGIN_FAILED_CONNECTION = " ";
    private static String CURRENTVERSION;
    private String version = CURRENTVERSION;
    private String driverName = "symantec.itools.db.jdbc.Driver";
    private String url = "";
    private String userName = "";
    private String password = "";
    private boolean autoCommit = true;
    private int transactionIsolation = 16;
    private int defaultTransactionIsolation = 16;
    private boolean readOnly = false;
    private String catalog = "";
    private String identifier = "jdbcConnection1";
    private transient Vector m_ConnectFailedListeners = new Vector();
    private String loginFailedPattern = "userid user password";
    private transient Stack m_AutoCommitMode = new Stack();
    private transient Stack m_TransactionState = new Stack();
    private transient Vector connectionsPool = new Vector();
    private transient DatabaseMetaData metaData;
    private boolean closed = true;
    private boolean supportsOpenStatementsAcrossCommit = true;
    private boolean supportsOpenStatementsAcrossRollback = true;
    private boolean supportsTransactions = true;
    private transient Hashtable statements = new Hashtable();
    private int maxStatements = Integer.MAX_VALUE;
    private int minConnections = 1;
    private int maxConnections = Integer.MAX_VALUE;
    private String m_ConnectFailedListener = "symantec.itools.db.beans.jdbc.DefaultConnectFailedListener";
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    public static final int TRANSACTION_DEFAULT = 16;

    static {
        logWindow = LogWindowHelper.getInstance();
        CURRENTVERSION = "0.02";
    }

    public JdbcConnection() {
        String string = "JdbcConnection()";
        if (debug) {
            System.out.println(CLASS_NAME + string);
        }
    }

    public JdbcConnection(String string, String string2, String string3, String string4) {
        this();
        String string5 = "JdbcConnection(" + string + "," + string2 + "," + string3 + "," + string4 + ")";
        if (debug) {
            System.out.println(CLASS_NAME + string5);
        }
        this.setDriverName(string);
        this.setURL(string2);
        this.setUserName(string3);
        this.setPassword(string4);
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private boolean isLoginFailed(SQLException sQLException) {
        String string = this.getLoginFailedPattern();
        if (string == null || string.equals("")) {
            return true;
        }
        boolean bl = false;
        String string2 = sQLException.getMessage().toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, T_LOGIN_FAILED_CONNECTION);
        String string3 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            bl = string2.indexOf(string3.toLowerCase()) > -1;
            if (bl) break;
            string3 = stringTokenizer.nextToken();
        }
        return bl;
    }

    void announceSQLMessages(String string) {
        if (!Beans.isDesignTime()) {
            logWindow.displayMsgToLog("SQL", string);
        }
    }

    public synchronized void connect() throws SQLException {
        String string = "connect()";
        if (debug) {
            System.out.println(CLASS_NAME + string);
        }
        if (!this.isConnectionClosed()) {
            if (debug) {
                System.out.println("Connection is still opened.  Simply return.");
            }
            return;
        }
        if (debug) {
            System.out.println("Connect to database --->");
        }
        this.registerDriver();
        Connection connection = this.createSQLConnection();
        if (connection != null) {
            this.obtainMetaData(connection);
            SQLConnection sQLConnection = new SQLConnection(connection);
            this.connectionsPool.addElement(sQLConnection);
            this.setConnectionProperties(connection);
            int n = this.getMinConnections();
            int n2 = 1;
            while (n2 < n) {
                Connection connection2 = this.createSQLConnection();
                sQLConnection = new SQLConnection(connection2);
                this.connectionsPool.addElement(sQLConnection);
                this.setConnectionProperties(connection2);
                ++n2;
            }
            this.closed = false;
            try {
                this.announceSQLMessages("Connected to: " + this.getURL());
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        throw new SQLException();
    }

    protected synchronized void registerDriver() throws SQLException {
        if (this.getDriverName() != null && this.getDriverName().length() != 0) {
            try {
                Driver driver = (Driver)Class.forName(this.getDriverName()).newInstance();
                DriverManager.registerDriver(driver);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string = "Could not register JDBC driver.  Driver class name: " + classNotFoundException.getMessage();
                System.out.println(string);
                throw new SQLException(string);
            }
            catch (Exception exception) {
                String string = "Could not register JDBC driver.  Driver class name: " + exception.getMessage();
                System.out.println(string);
                throw new SQLException(string);
            }
        }
    }

    protected synchronized Connection createSQLConnection() throws SQLException {
        Connection connection = null;
        String string = System.getProperty("java.vendor");
        boolean bl = string.startsWith("Microsoft");
        System.getProperty("java.version");
        try {
            if (OS.isWindows() && bl) {
                Class<?> clazz = Class.forName("symantec.itools.db.beans.jdbc.MSSecurityAccess");
                Class[] classArray = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                Method method = clazz.getMethod("getConnection", classArray);
                Object[] objectArray = new String[]{this.getURL(), this.getUserName(), this.getPassword()};
                try {
                    connection = (Connection)method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    throw new SQLException(USER_ID);
                }
            } else {
                connection = DriverManager.getConnection(this.getURL(), this.getConnectionProps());
            }
            if (this.driverName.equals(POINTBASE_DRIVER)) {
                this.setAutoCommit(false);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
            if (!Beans.isDesignTime()) {
                if (this.isLoginFailed(sQLException)) {
                    this.connectFailed(new ConnectFailedEvent(this, 3, sQLException.getMessage()));
                    if (connection == null) {
                        throw new SQLException(sQLException.getMessage());
                    }
                    return connection;
                }
                throw new SQLException(sQLException.getMessage());
            }
            throw new SQLException(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw new SQLException(exception.getMessage());
        }
    }

    protected synchronized void obtainMetaData(Connection connection) throws SQLException {
        if (connection != null) {
            try {
                this.metaData = connection.getMetaData();
                this.supportsTransactions = this.metaData.supportsTransactions();
                this.defaultTransactionIsolation = this.metaData.getDefaultTransactionIsolation();
                this.supportsOpenStatementsAcrossCommit = this.metaData.supportsOpenStatementsAcrossCommit();
                this.supportsOpenStatementsAcrossRollback = this.metaData.supportsOpenStatementsAcrossRollback();
                int n = this.metaData.getMaxStatements();
                if (n > 0 && n < this.getMaxStatements()) {
                    this.setMaxStatements(n);
                    return;
                }
            }
            catch (SQLException sQLException) {
                String string = "Warning: " + sQLException.getMessage();
                System.out.println(string);
                System.out.println("Defaulting to TRANSACTION_NONE");
                this.defaultTransactionIsolation = 0;
                try {
                    this.announceSQLMessages(string);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    protected synchronized void setConnectionProperties(Connection connection) throws SQLException {
        if (connection != null) {
            String string;
            try {
                connection.setAutoCommit(this.autoCommit);
            }
            catch (SQLException sQLException) {
                string = "Warning: could not apply autoCommit property to live connection: " + sQLException.getMessage();
                System.out.println(string);
                try {
                    this.announceSQLMessages(string);
                }
                catch (Exception exception) {}
            }
            try {
                connection.setReadOnly(this.readOnly);
            }
            catch (SQLException sQLException) {
                string = "Warning: could not apply readOnly property to live connection: " + sQLException.getMessage();
                System.out.println(string);
                try {
                    this.announceSQLMessages(string);
                }
                catch (Exception exception) {}
            }
            try {
                if (this.transactionIsolation != 16) {
                    connection.setTransactionIsolation(this.transactionIsolation);
                }
            }
            catch (SQLException sQLException) {
                string = "Warning: could not apply transactionIsolation property to live connection: " + sQLException.getMessage();
                System.out.println(string);
                try {
                    this.announceSQLMessages(string);
                }
                catch (Exception exception) {}
            }
            try {
                if (this.catalog != null && this.catalog.length() != 0) {
                    connection.setCatalog(this.catalog);
                    return;
                }
            }
            catch (SQLException sQLException) {
                string = "Warning: could not apply catalog property to live connection: " + sQLException.getMessage();
                System.out.println(string);
                try {
                    this.announceSQLMessages(string);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    public synchronized void beginTransaction() {
        try {
            if (!this.supportsTransactions) {
                return;
            }
            boolean bl = this.isAutoCommit();
            this.m_AutoCommitMode.push(new Boolean(bl));
            this.m_TransactionState.push(new Boolean(true));
            if (!(this.supportsOpenStatementsAcrossCommit && this.supportsOpenStatementsAcrossRollback || this.statements == null)) {
                Hashtable hashtable = null;
                Object object = this.statements;
                synchronized (object) {
                    hashtable = (Hashtable)this.statements.clone();
                }
                if (hashtable != null) {
                    object = hashtable.keys();
                    while (object.hasMoreElements()) {
                        Statement statement = (Statement)object.nextElement();
                        this.closeStatement(statement);
                    }
                }
            }
            this.setAutoCommit(false);
            this.announceSQLMessages(BEGIN_TRANSACTION);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void endTransaction(boolean bl) {
        try {
            if (!this.supportsTransactions) {
                return;
            }
            Boolean bl2 = (Boolean)this.m_TransactionState.pop();
            if (bl && bl2.booleanValue()) {
                this.commit();
            } else {
                this.rollback();
            }
            Boolean bl3 = (Boolean)this.m_AutoCommitMode.pop();
            if (bl3.booleanValue()) {
                this.setAutoCommit(true);
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected synchronized SQLConnection getAvailableConnection() throws SQLException {
        SQLConnection sQLConnection = null;
        int n = this.connectionsPool.size();
        int n2 = 0;
        while (n2 < n) {
            sQLConnection = (SQLConnection)this.connectionsPool.elementAt(n2);
            if (sQLConnection != null && sQLConnection.getOpenedStatements() < this.getMaxStatements()) {
                return sQLConnection;
            }
            ++n2;
        }
        if (n == this.getMaxConnections()) {
            throw new SQLException();
        }
        Connection connection = this.createSQLConnection();
        this.setConnectionProperties(connection);
        sQLConnection = new SQLConnection(connection);
        this.connectionsPool.addElement(sQLConnection);
        return sQLConnection;
    }

    public synchronized Statement createStatement() throws SQLException {
        Statement statement = null;
        SQLConnection sQLConnection = this.getAvailableConnection();
        if (sQLConnection != null && (statement = sQLConnection.createStatement()) != null) {
            this.statements.put(statement, sQLConnection);
        }
        return statement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        SQLConnection sQLConnection = this.getAvailableConnection();
        if (sQLConnection != null && (preparedStatement = sQLConnection.prepareStatement(string)) != null) {
            this.statements.put(preparedStatement, sQLConnection);
        }
        return preparedStatement;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        CallableStatement callableStatement = null;
        SQLConnection sQLConnection = this.getAvailableConnection();
        if (sQLConnection != null && (callableStatement = sQLConnection.prepareCall(string)) != null) {
            this.statements.put(callableStatement, sQLConnection);
        }
        return callableStatement;
    }

    public synchronized void closeStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        SQLConnection sQLConnection = (SQLConnection)this.statements.get(statement);
        if (sQLConnection != null) {
            this.statements.remove(statement);
            sQLConnection.closeStatement(statement);
            return;
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public int executeStatement(Statement statement, String string, String string2) throws SQLException {
        int n = 0;
        try {
            this.announceSQLMessages(string2);
        }
        catch (Exception exception) {}
        try {
            if (statement instanceof PreparedStatement) {
                n = ((PreparedStatement)statement).executeUpdate();
            } else if (statement instanceof Statement) {
                n = statement.executeUpdate(string);
            }
            return n;
        }
        catch (SQLException sQLException) {
            if (!this.m_TransactionState.empty()) {
                Boolean bl = (Boolean)this.m_TransactionState.peek();
                bl.booleanValue();
            }
            throw sQLException;
        }
    }

    public ResultSet executeQuery(Statement statement, String string, String string2) throws SQLException {
        ResultSet resultSet = null;
        try {
            this.announceSQLMessages(string2);
        }
        catch (Exception exception) {}
        try {
            if (statement instanceof PreparedStatement) {
                resultSet = ((PreparedStatement)statement).executeQuery();
            } else if (statement instanceof Statement) {
                resultSet = statement.executeQuery(string);
            }
            return resultSet;
        }
        catch (SQLException sQLException) {
            Boolean bl;
            if (!this.m_TransactionState.empty() && (bl = (Boolean)this.m_TransactionState.peek()).booleanValue()) {
                this.m_TransactionState.pop();
                this.m_TransactionState.push(new Boolean(false));
            }
            throw sQLException;
        }
    }

    public void connectFailed(ConnectFailedEvent connectFailedEvent) {
        EventListener eventListener;
        Serializable serializable;
        try {
            serializable = Class.forName(this.m_ConnectFailedListener);
            eventListener = (ConnectFailedListener)((Class)serializable).newInstance();
            eventListener.connectFailed(connectFailedEvent);
        }
        catch (Exception exception) {}
        try {
            eventListener = this;
            synchronized (eventListener) {
                serializable = (Vector)this.m_ConnectFailedListeners.clone();
            }
            int n = 0;
            while (n < ((Vector)serializable).size()) {
                ((ConnectFailedListener)((Vector)serializable).elementAt(n)).connectFailed(connectFailedEvent);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setConnectFailedListener(String string) {
        this.m_ConnectFailedListener = string;
    }

    public String getConnectFailedListener() {
        return this.m_ConnectFailedListener;
    }

    public synchronized void commit() throws SQLException {
        try {
            if (this.connectionsPool != null && this.connectionsPool.size() > 0) {
                int n = this.connectionsPool.size();
                int n2 = 0;
                while (n2 < n) {
                    Connection connection;
                    SQLConnection sQLConnection = (SQLConnection)this.connectionsPool.elementAt(n2);
                    if (sQLConnection != null) {
                        connection = sQLConnection.getConnection();
                        if (connection == null) {
                            throw new SQLException("Connection is closed");
                        }
                    } else {
                        throw new SQLException("Connection is closed");
                    }
                    connection.commit();
                    ++n2;
                }
            }
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
        try {
            this.announceSQLMessages(COMMIT_TRANSACTION);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            if (this.connectionsPool != null && this.connectionsPool.size() > 0) {
                int n = this.connectionsPool.size();
                int n2 = 0;
                while (n2 < n) {
                    Connection connection;
                    SQLConnection sQLConnection = (SQLConnection)this.connectionsPool.elementAt(n2);
                    if (sQLConnection != null) {
                        connection = sQLConnection.getConnection();
                        if (connection == null) {
                            throw new SQLException("Connection is closed");
                        }
                    } else {
                        throw new SQLException("Connection is closed");
                    }
                    connection.rollback();
                    ++n2;
                }
            }
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
        try {
            this.announceSQLMessages(ROLLBACK_TRANSACTION);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.connect();
        return this.metaData;
    }

    public void setDriverName(String string) {
        if (Beans.isDesignTime()) {
            this.processPropertyChange(PROP_DRIVERNAME, this.driverName, string);
        }
        this.driverName = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setURL(String string) {
        if (debug) {
            System.out.println("JdbcConnection.setURL(" + string + ")");
        }
        if (Beans.isDesignTime()) {
            this.processPropertyChange(PROP_URL, this.url, string);
        }
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    public void setUserName(String string) {
        if (debug) {
            System.out.println("JdbcConnection..setUserName(" + string + ")");
        }
        if (Beans.isDesignTime()) {
            this.processPropertyChange(PROP_USERNAME, this.userName, string);
        }
        this.userName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String string) {
        if (debug) {
            System.out.println("JdbcConnection..setPassword(" + string + ")");
        }
        if (Beans.isDesignTime()) {
            this.processPropertyChange("password", this.password, string);
        }
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void setCatalog(String string) throws SQLException {
        if (Beans.isDesignTime()) {
            this.processPropertyChange(PROP_CATALOG, this.catalog, string);
        }
        this.catalog = string;
        try {
            if (this.connectionsPool != null && this.connectionsPool.size() > 0) {
                int n = this.connectionsPool.size();
                int n2 = 0;
                while (n2 < n) {
                    Connection connection;
                    SQLConnection sQLConnection = (SQLConnection)this.connectionsPool.elementAt(n2);
                    if (sQLConnection != null) {
                        connection = sQLConnection.getConnection();
                        if (connection == null) {
                            throw new SQLException("Connection is closed");
                        }
                    } else {
                        throw new SQLException("Connection is closed");
                    }
                    connection.setCatalog(string);
                    ++n2;
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public synchronized String getCatalog() throws SQLException {
        try {
            if (this.getSQLConnection() != null) {
                this.catalog = this.getSQLConnection().getCatalog();
            }
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
        return this.catalog;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (Beans.isDesignTime()) {
            this.processPropertyChange(PROP_AUTOCOMMIT, new Boolean(this.autoCommit), new Boolean(bl));
        }
        this.autoCommit = bl;
        try {
            if (this.connectionsPool != null && this.connectionsPool.size() > 0) {
                int n = this.connectionsPool.size();
                int n2 = 0;
                while (n2 < n) {
                    Connection connection;
                    SQLConnection sQLConnection = (SQLConnection)this.connectionsPool.elementAt(n2);
                    if (sQLConnection != null) {
                        connection = sQLConnection.getConnection();
                        if (connection == null) {
                            throw new SQLException("Connection is closed");
                        }
                    } else {
                        throw new SQLException("Connection is closed");
                    }
                    connection.setAutoCommit(bl);
                    ++n2;
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public synchronized boolean isAutoCommit() {
        try {
            if (this.getSQLConnection() != null) {
                this.autoCommit = this.getSQLConnection().getAutoCommit();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Warning: isAutoCommit was returning a corrupted value: " + sQLException.getMessage());
        }
        return this.autoCommit;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        if (Beans.isDesignTime()) {
            this.processPropertyChange(PROP_READONLY, new Boolean(this.readOnly), new Boolean(bl));
        }
        this.readOnly = bl;
        try {
            if (this.connectionsPool != null && this.connectionsPool.size() > 0) {
                int n = this.connectionsPool.size();
                int n2 = 0;
                while (n2 < n) {
                    Connection connection;
                    SQLConnection sQLConnection = (SQLConnection)this.connectionsPool.elementAt(n2);
                    if (sQLConnection != null) {
                        connection = sQLConnection.getConnection();
                        if (connection == null) {
                            throw new SQLException("Connection is closed");
                        }
                    } else {
                        throw new SQLException("Connection is closed");
                    }
                    connection.setReadOnly(bl);
                    ++n2;
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public String getLoginFailedPattern() {
        return this.loginFailedPattern;
    }

    public synchronized void setLoginFailedPattern(String string) {
        this.loginFailedPattern = string;
    }

    public synchronized boolean isReadOnly() throws SQLException {
        try {
            if (this.getSQLConnection() != null) {
                this.readOnly = this.getSQLConnection().isReadOnly();
            }
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
        return this.readOnly;
    }

    public synchronized boolean getReadOnly() throws SQLException {
        return this.isReadOnly();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (Beans.isDesignTime()) {
            this.processPropertyChange(PROP_TRANS_ISOLATION, new Integer(this.transactionIsolation), new Integer(n));
        }
        this.transactionIsolation = n;
        try {
            if (this.connectionsPool == null || this.connectionsPool.size() <= 0) return;
            int n2 = this.connectionsPool.size();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                SQLConnection sQLConnection = (SQLConnection)this.connectionsPool.elementAt(n3);
                if (sQLConnection == null) throw new SQLException("Connection is closed");
                Connection connection = sQLConnection.getConnection();
                if (connection == null) throw new SQLException("Connection is closed");
                if (this.transactionIsolation == 16) {
                    this.transactionIsolation = this.defaultTransactionIsolation;
                }
                if (this.transactionIsolation != (n4 = connection.getTransactionIsolation())) {
                    connection.setTransactionIsolation(this.transactionIsolation);
                }
                ++n3;
            }
            return;
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        try {
            if (this.getSQLConnection() != null) {
                this.transactionIsolation = this.getSQLConnection().getTransactionIsolation();
            }
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
        return this.transactionIsolation;
    }

    public synchronized void setConnectionClosed(boolean bl) throws PropertyVetoException, SQLException {
        String string = "setConnectionClose(" + bl + ")";
        if (debug) {
            System.out.println(CLASS_NAME + string);
        }
        if (!bl || this.isConnectionClosed()) {
            return;
        }
        if (this.connectionsPool != null && this.connectionsPool.size() > 0) {
            this.processVetoableChange(PROP_CONNCLOSED, new Boolean(false), new Boolean(true));
            int n = this.connectionsPool.size();
            int n2 = 0;
            while (n2 < n) {
                Connection connection;
                SQLConnection sQLConnection = (SQLConnection)this.connectionsPool.elementAt(n2);
                if (sQLConnection != null && (connection = sQLConnection.getConnection()) != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        this.handleException(sQLException);
                    }
                }
                ++n2;
            }
            this.connectionsPool.setSize(0);
            this.closed = true;
            this.processPropertyChange(PROP_CONNCLOSED, new Boolean(false), new Boolean(true));
        }
    }

    public synchronized boolean isConnectionClosed() {
        return this.closed;
    }

    public void setMaxStatements(int n) {
        if (n < 1) {
            n = Integer.MAX_VALUE;
        }
        this.maxStatements = n;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMinConnections(int n) {
        if (n < 1 || n > this.getMaxConnections()) {
            throw new IllegalArgumentException();
        }
        this.minConnections = n;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMaxConnections(int n) {
        if (n < this.getMinConnections()) {
            throw new IllegalArgumentException();
        }
        this.maxConnections = n;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() == this) {
            return;
        }
    }

    public synchronized void addConnectFailedListener(ConnectFailedListener connectFailedListener) {
        this.m_ConnectFailedListeners.addElement(connectFailedListener);
    }

    public synchronized void removeConnectFailedListener(ConnectFailedListener connectFailedListener) {
        this.m_ConnectFailedListeners.removeElement(connectFailedListener);
    }

    public void validateObject() throws InvalidObjectException {
        if (!this.version.equals(CURRENTVERSION)) {
            throw new InvalidObjectException("Serialized version " + this.version + "is not compatible with Connection version " + CURRENTVERSION);
        }
        super.validateObject();
    }

    protected Properties getConnectionProps() {
        Properties properties = new Properties();
        if (this.getUserName() != null) {
            ((Hashtable)properties).put(USER, this.getUserName());
        }
        if (this.getPassword() != null) {
            ((Hashtable)properties).put("password", this.getPassword());
        }
        return properties;
    }

    protected void doAutoStart() {
        new 1().start();
    }

    public boolean equals(Object object) {
        boolean bl;
        block3: {
            bl = false;
            if (object == null || !(object instanceof JdbcConnection)) break block3;
            JdbcConnection jdbcConnection = (JdbcConnection)object;
            try {
                if (this.getURL().equals(jdbcConnection.getURL()) && this.getDriverName().equals(jdbcConnection.getDriverName()) && this.getUserName().equals(jdbcConnection.getUserName()) && this.getPassword().equals(jdbcConnection.getPassword()) && this.getReadOnly() == jdbcConnection.getReadOnly()) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                bl = false;
                System.err.println(sQLException);
                sQLException.printStackTrace();
            }
        }
        return bl;
    }

    public synchronized Connection getSQLConnection() {
        SQLConnection sQLConnection;
        Connection connection = null;
        if (this.connectionsPool != null && this.connectionsPool.size() > 0 && (sQLConnection = (SQLConnection)this.connectionsPool.elementAt(0)) != null) {
            connection = sQLConnection.getConnection();
        }
        return connection;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    private final class 1
    extends Thread {
        public void run() {
            try {
                JdbcConnection.this.connect();
                return;
            }
            catch (SQLException sQLException) {
                JdbcConnection.this.printMessage("Attempt to connect to database " + JdbcConnection.this.getURL() + " via Driver " + JdbcConnection.this.getDriverName() + " failed: " + sQLException.toString());
                JdbcConnection.this.connectionsPool.setSize(0);
                return;
            }
        }

        /* synthetic */ 1() {
        }
    }

    class SQLConnection {
        private Connection sqlConnection;
        private int openedStatements;

        public SQLConnection(Connection connection) {
            JdbcConnection.this = JdbcConnection.this;
            try {
                if (connection == null || connection.isClosed()) {
                    throw new IllegalArgumentException();
                }
            }
            catch (SQLException sQLException) {}
            this.sqlConnection = connection;
            this.openedStatements = 0;
        }

        public Connection getConnection() {
            return this.sqlConnection;
        }

        public int getOpenedStatements() {
            return this.openedStatements;
        }

        public Statement createStatement() throws SQLException {
            ++this.openedStatements;
            return this.sqlConnection.createStatement();
        }

        public PreparedStatement prepareStatement(String string) throws SQLException {
            ++this.openedStatements;
            return this.sqlConnection.prepareStatement(string);
        }

        public CallableStatement prepareCall(String string) throws SQLException {
            ++this.openedStatements;
            return this.sqlConnection.prepareCall(string);
        }

        public void closeStatement(Statement statement) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                --this.openedStatements;
            }
        }
    }
}

