/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.ResourceBundle;
import symantec.itools.db.beans.binding.DefaultPersistentObjectMemberModel;
import symantec.itools.db.beans.jdbc.JdbcResourceLoader;
import symantec.itools.db.beans.jdbc.SQLAdapterException;

public class ParameterMetaData
extends DefaultPersistentObjectMemberModel
implements Serializable {
    public static final String PROP_SCALE = "scale";
    public static final String PROP_DEFAULT_VALUE = "defaultValue";
    private static JdbcResourceLoader resourceLoader = JdbcResourceLoader.getInstance();
    private static ResourceBundle MyResource = resourceLoader.getBundle();
    protected int scale;
    protected Object defaultValue;

    public ParameterMetaData() {
    }

    public ParameterMetaData(ParameterMetaData parameterMetaData) {
        super(parameterMetaData);
        this.setScale(parameterMetaData.getScale());
        this.setDefaultValue(parameterMetaData.getDefaultValueCopy());
    }

    public ParameterMetaData(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, 0, null);
    }

    public ParameterMetaData(String string, int n, int n2, int n3, Object object) {
        this(string, n, n2, n3, 0, object);
    }

    public ParameterMetaData(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, null);
    }

    public ParameterMetaData(String string, int n, int n2, int n3, int n4, Object object) {
        this();
        this.setName(string);
        this.setIndex(n);
        this.setType(n2);
        this.setDataType(n3);
        this.setScale(n4);
        this.setDefaultValue(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\nName: " + this.name);
        stringBuffer.append("\tIndex: " + this.index);
        stringBuffer.append("\tType: " + this.type);
        stringBuffer.append("\tDataType: " + this.dataType);
        stringBuffer.append("\tScale: " + this.scale);
        stringBuffer.append("\tDefaultValue: " + this.defaultValue);
        return stringBuffer.toString();
    }

    public void checkType() throws SQLAdapterException {
        switch (this.getType()) {
            default: {
                throw new SQLAdapterException(MyResource.getString("Unknown parameter type."), 3);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
        }
    }

    public boolean lessThan(ParameterMetaData parameterMetaData) throws SQLAdapterException {
        boolean bl;
        block0 : switch (this.getType()) {
            case 5: {
                if (parameterMetaData.getType() == 5) {
                    throw new SQLAdapterException(MyResource.getString("More than one return values."), 1);
                }
                if (this.getIndex() != 1) {
                    throw new SQLAdapterException(MyResource.getString("Invalid parameter index."), 10);
                }
                bl = true;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                switch (parameterMetaData.getType()) {
                    case 5: {
                        bl = false;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        if (this.getIndex() == parameterMetaData.getIndex()) {
                            throw new SQLAdapterException(MyResource.getString("Duplicated parameter's indeces"), 2);
                        }
                        bl = this.getIndex() < parameterMetaData.getIndex();
                        break block0;
                    }
                    case 3: {
                        bl = true;
                        break block0;
                    }
                }
                throw new SQLAdapterException(MyResource.getString("Unknown parameter type."), 3);
            }
            case 3: {
                switch (parameterMetaData.getType()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        if (this.getIndex() == parameterMetaData.getIndex()) {
                            throw new SQLAdapterException(MyResource.getString("More than 1 parameters with the same index."), 2);
                        }
                        bl = this.getIndex() < parameterMetaData.getIndex();
                        break block0;
                    }
                }
                throw new SQLAdapterException(MyResource.getString("Unknown parameter type."), 3);
            }
            default: {
                throw new SQLAdapterException(MyResource.getString("Unknown parameter type."), 3);
            }
        }
        return bl;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        Integer n2 = new Integer(this.scale);
        Integer n3 = new Integer(n);
        this.scale = n;
        this.firePropertyChange(PROP_SCALE, n2, n3);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        Object object2 = this.defaultValue;
        this.defaultValue = object;
        this.firePropertyChange(PROP_DEFAULT_VALUE, object2, object);
    }

    protected synchronized Object getDefaultValueCopy() {
        if (this.defaultValue == null) {
            return null;
        }
        Object object = null;
        if (this.defaultValue instanceof String) {
            object = new String((String)this.defaultValue);
        } else if (this.defaultValue instanceof Boolean) {
            object = new Boolean((Boolean)this.defaultValue);
        } else if (this.defaultValue instanceof Number) {
            object = this.defaultValue instanceof Byte ? new Byte((Byte)this.defaultValue) : (this.defaultValue instanceof Short ? new Short((Short)this.defaultValue) : (this.defaultValue instanceof Integer ? new Integer((Integer)this.defaultValue) : (this.defaultValue instanceof Long ? new Long((Long)this.defaultValue) : (this.defaultValue instanceof Float ? new Float(((Float)this.defaultValue).floatValue()) : (this.defaultValue instanceof Double ? new Double((Double)this.defaultValue) : (this.defaultValue instanceof BigDecimal ? new BigDecimal(((BigDecimal)this.defaultValue).toString()) : (this.defaultValue instanceof BigInteger ? new BigInteger(((BigInteger)this.defaultValue).toString()) : this.defaultValue)))))));
        } else if (this.defaultValue instanceof Date) {
            object = this.defaultValue instanceof java.sql.Date ? java.sql.Date.valueOf(((java.sql.Date)this.defaultValue).toString()) : (this.defaultValue instanceof Time ? Time.valueOf(((Time)this.defaultValue).toString()) : (this.defaultValue instanceof Timestamp ? Timestamp.valueOf(((Timestamp)this.defaultValue).toString()) : this.defaultValue));
        } else if (this.defaultValue instanceof byte[]) {
            byte[] byArray = (byte[])this.defaultValue;
            object = new byte[byArray.length];
            System.arraycopy(byArray, 0, object, 0, byArray.length);
        } else {
            object = this.defaultValue;
        }
        return object;
    }
}

