/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import symantec.itools.db.beans.util.LocalizedValueGenerator;

public class PreparedStatementHelper
implements Serializable {
    protected PreparedStatementHelper() {
    }

    public static void setInParameter(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        PreparedStatementHelper.setInParameter(preparedStatement, n, n2, object, 0);
    }

    public static void setInParameter(PreparedStatement preparedStatement, int n, int n2, Object object, int n3) throws SQLException {
        if (object == null) {
            preparedStatement.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -7: {
                PreparedStatementHelper.setBoolean(preparedStatement, n, n2, object);
                return;
            }
            case -6: {
                PreparedStatementHelper.setByte(preparedStatement, n, n2, object);
                return;
            }
            case 5: {
                PreparedStatementHelper.setShort(preparedStatement, n, n2, object);
                return;
            }
            case 4: {
                PreparedStatementHelper.setInt(preparedStatement, n, n2, object);
                return;
            }
            case -5: {
                PreparedStatementHelper.setLong(preparedStatement, n, n2, object);
                return;
            }
            case 6: 
            case 7: {
                PreparedStatementHelper.setFloat(preparedStatement, n, n2, object);
                return;
            }
            case 8: {
                PreparedStatementHelper.setDouble(preparedStatement, n, n2, object);
                return;
            }
            case 2: 
            case 3: {
                PreparedStatementHelper.setBigDecimal(preparedStatement, n, n2, object, n3);
                return;
            }
            case 1: 
            case 12: {
                if (object instanceof String) {
                    preparedStatement.setString(n, (String)object);
                    return;
                }
                preparedStatement.setObject(n, object, n2);
                return;
            }
            case -1: {
                PreparedStatementHelper.setAsciiStream(preparedStatement, n, n2, object);
                return;
            }
            case 91: {
                PreparedStatementHelper.setDate(preparedStatement, n, n2, object);
                return;
            }
            case 92: {
                PreparedStatementHelper.setTime(preparedStatement, n, n2, object);
                return;
            }
            case 93: {
                PreparedStatementHelper.setTimestamp(preparedStatement, n, n2, object);
                return;
            }
            case -3: 
            case -2: {
                PreparedStatementHelper.setBytes(preparedStatement, n, n2, object);
                return;
            }
            case -4: {
                PreparedStatementHelper.setBinaryStream(preparedStatement, n, n2, object);
                return;
            }
            case 0: {
                preparedStatement.setNull(n, n2);
                return;
            }
        }
        preparedStatement.setObject(n, object);
    }

    protected static void setBoolean(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != -7 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            preparedStatement.setBoolean(n, bl);
            return;
        }
        if (object instanceof String) {
            boolean bl = Boolean.valueOf((String)object);
            preparedStatement.setBoolean(n, bl);
            return;
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setByte(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != -6 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof String) {
            try {
                object = LocalizedValueGenerator.parseNumberValue((String)object, n2);
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.toString());
            }
        }
        if (object instanceof Number) {
            byte by = object instanceof Byte ? (Byte)object : (object instanceof Short ? ((Short)object).byteValue() : (object instanceof Integer ? ((Integer)object).byteValue() : (object instanceof Long ? ((Long)object).byteValue() : (object instanceof Float ? ((Float)object).byteValue() : (object instanceof Double ? ((Double)object).byteValue() : ((Number)object).byteValue())))));
            try {
                preparedStatement.setByte(n, by);
                return;
            }
            catch (SQLException sQLException) {
                String string = ((Number)object).toString();
                preparedStatement.setString(n, string);
                return;
            }
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setShort(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != 5 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof String) {
            try {
                object = LocalizedValueGenerator.parseNumberValue((String)object, n2);
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.getMessage());
            }
        }
        if (object instanceof Number) {
            short s = object instanceof Byte ? (short)((Byte)object).byteValue() : (object instanceof Short ? (Short)object : (object instanceof Integer ? ((Integer)object).shortValue() : (object instanceof Long ? ((Long)object).shortValue() : (object instanceof Float ? ((Float)object).shortValue() : (object instanceof Double ? ((Double)object).shortValue() : ((Number)object).shortValue())))));
            try {
                preparedStatement.setShort(n, s);
                return;
            }
            catch (SQLException sQLException) {
                String string = ((Number)object).toString();
                preparedStatement.setString(n, string);
                return;
            }
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setInt(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != 4 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof String) {
            try {
                object = LocalizedValueGenerator.parseNumberValue((String)object, n2);
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.getMessage());
            }
        }
        if (object instanceof Number) {
            int n3 = object instanceof Byte ? (Byte)object : (object instanceof Short ? (Short)object : (object instanceof Integer ? (Integer)object : (object instanceof Long ? ((Long)object).intValue() : (object instanceof Float ? ((Float)object).intValue() : (object instanceof Double ? ((Double)object).intValue() : ((Number)object).intValue())))));
            try {
                preparedStatement.setInt(n, n3);
                return;
            }
            catch (SQLException sQLException) {
                String string = ((Number)object).toString();
                preparedStatement.setString(n, string);
                return;
            }
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setLong(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != -5 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof String) {
            try {
                object = LocalizedValueGenerator.parseNumberValue((String)object, n2);
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.getMessage());
            }
        }
        if (object instanceof Number) {
            long l = object instanceof Byte ? (long)((Byte)object).byteValue() : (object instanceof Short ? (long)((Short)object).shortValue() : (object instanceof Integer ? (long)((Integer)object).intValue() : (object instanceof Long ? (Long)object : (object instanceof Float ? ((Float)object).longValue() : (object instanceof Double ? ((Double)object).longValue() : ((Number)object).longValue())))));
            try {
                preparedStatement.setLong(n, l);
                return;
            }
            catch (SQLException sQLException) {
                String string = ((Number)object).toString();
                preparedStatement.setString(n, string);
                return;
            }
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setFloat(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != 6 && n2 != 7 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof String) {
            try {
                object = LocalizedValueGenerator.parseNumberValue((String)object, n2);
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.getMessage());
            }
        }
        if (object instanceof Number) {
            float f = object instanceof Byte ? (float)((Byte)object).byteValue() : (object instanceof Short ? (float)((Short)object).shortValue() : (object instanceof Integer ? (float)((Integer)object).intValue() : (object instanceof Long ? (float)((Long)object).longValue() : (object instanceof Float ? ((Float)object).floatValue() : (object instanceof Double ? ((Double)object).floatValue() : ((Number)object).floatValue())))));
            try {
                preparedStatement.setFloat(n, f);
                return;
            }
            catch (SQLException sQLException) {
                String string = ((Number)object).toString();
                preparedStatement.setString(n, string);
                return;
            }
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setDouble(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != 8 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof String) {
            try {
                object = LocalizedValueGenerator.parseNumberValue((String)object, n2);
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.getMessage());
            }
        }
        if (object instanceof Number) {
            double d = object instanceof Byte ? (double)((Byte)object).byteValue() : (object instanceof Short ? (double)((Short)object).shortValue() : (object instanceof Integer ? (double)((Integer)object).intValue() : (object instanceof Long ? (double)((Long)object).longValue() : (object instanceof Float ? (double)((Float)object).floatValue() : (object instanceof Double ? ((Double)object).doubleValue() : ((Number)object).doubleValue())))));
            try {
                preparedStatement.setDouble(n, d);
                return;
            }
            catch (SQLException sQLException) {
                String string = ((Number)object).toString();
                preparedStatement.setString(n, string);
                return;
            }
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setBigDecimal(PreparedStatement preparedStatement, int n, int n2, Object object, int n3) throws SQLException {
        if (n2 != 2 && n2 != 3 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof BigDecimal) {
            try {
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
                return;
            }
            catch (SQLException sQLException) {
                String string = ((BigDecimal)object).toString();
                preparedStatement.setString(n, string);
                return;
            }
        }
        if (object instanceof Number) {
            String string = ((Number)object).toString();
            BigDecimal bigDecimal = new BigDecimal(string);
            try {
                preparedStatement.setBigDecimal(n, bigDecimal);
                return;
            }
            catch (SQLException sQLException) {
                preparedStatement.setString(n, string);
                return;
            }
        }
        if (object instanceof String) {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(LocalizedValueGenerator.parseNumberValue((String)object, n2).toString());
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.getMessage());
            }
            try {
                preparedStatement.setBigDecimal(n, bigDecimal);
                return;
            }
            catch (SQLException sQLException) {
                String string = bigDecimal.toString();
                preparedStatement.setString(n, string);
                return;
            }
        }
        preparedStatement.setObject(n, object, n2, n3);
    }

    protected static void setAsciiStream(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != -1 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            int n3 = 0;
            try {
                n3 = inputStream.available();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            preparedStatement.setAsciiStream(n, inputStream, n3);
            return;
        }
        if (object instanceof String) {
            byte[] byArray = ((String)object).getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
            int n4 = 0;
            try {
                n4 = ((InputStream)byteArrayInputStream).available();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            try {
                preparedStatement.setAsciiStream(n, (InputStream)byteArrayInputStream, n4);
                return;
            }
            catch (SQLException sQLException) {
                preparedStatement.setString(n, (String)object);
                return;
            }
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setDate(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != 91 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof Date) {
            preparedStatement.setDate(n, (Date)object);
            return;
        }
        if (object instanceof java.util.Date) {
            Date date = new Date(((java.util.Date)object).getTime());
            preparedStatement.setDate(n, date);
            return;
        }
        if (object instanceof String) {
            Date date;
            try {
                date = new Date(LocalizedValueGenerator.parseDateValue((String)object, n2).getTime());
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.toString());
            }
            preparedStatement.setDate(n, date);
            return;
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setTime(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != 92 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof Time) {
            preparedStatement.setTime(n, (Time)object);
            return;
        }
        if (object instanceof java.util.Date) {
            Time time = new Time(((java.util.Date)object).getTime());
            preparedStatement.setTime(n, time);
            return;
        }
        if (object instanceof String) {
            Time time;
            try {
                time = new Time(LocalizedValueGenerator.parseDateValue((String)object, n2).getTime());
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.toString());
            }
            preparedStatement.setTime(n, time);
            return;
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setTimestamp(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != 93 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof Timestamp) {
            preparedStatement.setTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof java.util.Date) {
            Timestamp timestamp = new Timestamp(((java.util.Date)object).getTime());
            preparedStatement.setTimestamp(n, timestamp);
            return;
        }
        if (object instanceof String) {
            Timestamp timestamp;
            try {
                timestamp = new Timestamp(LocalizedValueGenerator.parseDateValue((String)object, n2).getTime());
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.toString());
            }
            preparedStatement.setTimestamp(n, timestamp);
            return;
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setBytes(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != -2 && n2 != -3 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof byte[]) {
            preparedStatement.setBytes(n, (byte[])object);
            return;
        }
        if (object instanceof String) {
            byte[] byArray = ((String)object).getBytes();
            preparedStatement.setBytes(n, byArray);
            return;
        }
        preparedStatement.setObject(n, object, n2);
    }

    protected static void setBinaryStream(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (n2 != -4 || object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            int n3 = 0;
            try {
                n3 = inputStream.available();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            preparedStatement.setBinaryStream(n, inputStream, n3);
            return;
        }
        if (object instanceof String || object instanceof byte[]) {
            byte[] byArray = object instanceof byte[] ? (byte[])object : ((String)object).getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
            int n4 = 0;
            try {
                n4 = ((InputStream)byteArrayInputStream).available();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, n4);
            return;
        }
        preparedStatement.setObject(n, object, n2);
    }
}

