/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.beans.Beans;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import symantec.itools.db.beans.binding.Connection;
import symantec.itools.db.beans.binding.PersistentObjectModel;
import symantec.itools.db.beans.binding.Synchronizable;
import symantec.itools.db.beans.jdbc.BaseRecordDefinition;
import symantec.itools.db.beans.jdbc.ColumnMetaData;
import symantec.itools.db.beans.jdbc.ConnectionManager;
import symantec.itools.db.beans.jdbc.DataModel;
import symantec.itools.db.beans.jdbc.JdbcConnection;
import symantec.itools.db.beans.jdbc.PreparedStatementHelper;
import symantec.itools.db.beans.jdbc.ResultSetEnumeration;
import symantec.itools.db.beans.jdbc.ResultSetHelper;
import symantec.itools.db.beans.qbe.QBExlator;
import symantec.itools.db.beans.util.LocalizedValueGenerator;
import symantec.itools.db.beans.util.LogWindowHelper;

public class RecordDefinition
extends BaseRecordDefinition {
    public static final String PROP_CONN_MGR_CLASS_NAME = "connectionManagerClassName";
    public static final String PROP_CONN_NAME = "connectionName";
    protected static final int INSERT_SQL = 100;
    protected static final int UPDATE_SQL = 101;
    protected static final int DELETE_SQL = 102;
    protected static final String CLASS_NAME = "RecordDefinition";
    protected static final String UNEXPECTED_ERROR_MESSAGE = "Unexpected error in RecordDefinition : ";
    protected static final String DESIGN_TIME_MESSAGE = "The following method should only be called at design time: ";
    protected static final String NOT_APPLY_ERROR = "The following method is not applicable when SQL Adapter is not used: ";
    protected static final String IS_NULL = " IS NULL ";
    protected static final String NULL_STRING = " ";
    protected static String BINARY_DATA = "<Binary Data>";
    protected static Hashtable m_Statement = new Hashtable();
    private boolean m_QBERow = false;
    private static Hashtable m_SQL = new Hashtable();
    private RecordState recordState = new RecordState();
    public static final String TableSeparator = "@";
    protected static final int COLUMN_VALUE = 0;
    protected static final int JOIN_VALUE = 1;
    protected static final int OPERATOR_VALUE = 2;
    private int colModif;
    private static boolean debug;
    protected static boolean log;
    protected static LogWindowHelper logWindow;
    protected static Hashtable m_DesignTimePropertiesTable;
    protected static Hashtable m_RunTimePropertiesTable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    static {
        logWindow = LogWindowHelper.getInstance();
        m_DesignTimePropertiesTable = new Hashtable();
        m_RunTimePropertiesTable = new Hashtable();
    }

    public void getQBEObjectValues(Vector vector) {
        if (this.m_ModifiedValues == null) {
            return;
        }
        int n = this.m_ModifiedValues.size();
        int n2 = 0;
        while (n2 < n) {
            ColumnMetaData columnMetaData = (ColumnMetaData)this.getDataModel().getMemberModel(n2);
            if (this.m_ModifiedValues.elementAt(n2) != null) {
                vector.addElement(columnMetaData.getColumnName() + ":" + columnMetaData.getColumnDataType() + ":" + this.m_ModifiedValues.elementAt(n2));
            }
            ++n2;
        }
    }

    public void setValueAsQBE(int n, Object object, boolean bl) {
        if (this.m_ModifiedValues == null) {
            this.m_ModifiedValues = new Vector(this.getDataModel().getMemberCount());
        }
        try {
            if (bl) {
                QBExlator.xlatField(object.toString(), "");
            }
            this.m_ModifiedValues.setElementAt(object, n);
            if (!this.equalsVector(this.m_OriginalValues, this.m_ModifiedValues)) {
                this.setMarkedAsModified(true);
                return;
            }
            if (this.getMarkedAsModified()) {
                this.recordState.setStateUndo(2);
                return;
            }
        }
        catch (QBExlator.QBExlatException qBExlatException) {
            throw new NumberFormatException(qBExlatException.getMessage());
        }
        catch (Exception exception) {
            this.m_ModifiedValues.setElementAt(null, n);
        }
    }

    public void checkQBEValues() throws QBExlator.QBExlatException {
        if (this.m_ModifiedValues == null) {
            return;
        }
        Enumeration enumeration = this.m_ModifiedValues.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            QBExlator.xlatField(e.toString(), "");
        }
    }

    void announceMetaDataMessages(String string) {
        if (!Beans.isDesignTime()) {
            logWindow.displayMsgToLog("MetaData: ", string);
        }
    }

    protected synchronized Statement getInsertStatement() throws SQLException {
        throw new RuntimeException("The following method must be over-ridden: getInsertStatement()");
    }

    protected synchronized Statement getUpdateStatement() throws SQLException {
        throw new RuntimeException("The following method must be over-ridden: getUpdateStatement()");
    }

    protected synchronized Statement getDeleteStatement() throws SQLException {
        throw new RuntimeException("The following method must be over-ridden: getDeleteStatement()");
    }

    public RecordDefinition() {
        if (debug) {
            System.out.println("RecordDefinition.RecordDefinition()");
        }
    }

    public int getValueIndex(String string) {
        return 0;
    }

    public synchronized PersistentObjectModel getDataModel() {
        throw new RuntimeException("The following method must be over-ridden: getDataModel()");
    }

    public synchronized void setDataModel(PersistentObjectModel persistentObjectModel) {
    }

    public synchronized Enumeration querySimilarObjects() {
        try {
            return this.querySimilarObjects(null, null);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
    }

    protected synchronized int getColModif() {
        return this.colModif;
    }

    private synchronized void setColModif(int n) {
        this.colModif = n;
    }

    protected void errorTreaten(Exception exception, String string) {
        String string2 = "ERROR in RecordDefinition in the method " + string + ": ";
        if (debug) {
            System.out.println(String.valueOf(string2) + "error message: " + exception.getMessage() + " ; instance of : " + exception.getClass());
        }
    }

    Enumeration resultSetToEnum(ResultSet resultSet) throws SQLException {
        String string = "resultSetToEnum";
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            resultSetMetaData.getColumnCount();
            ResultSetEnumeration resultSetEnumeration = new ResultSetEnumeration(resultSet, resultSetMetaData, this.getClass(), this.getDataModel().getModelName());
            return resultSetEnumeration;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    public String getStatement() {
        return (String)m_SQL.get(this.getClass());
    }

    private void setStatement(String string) {
        m_SQL.put(this.getClass(), string);
    }

    protected PreparedStatement getSelectStatement() {
        return (PreparedStatement)m_Statement.get(this.getClass());
    }

    private void setSelectStatement(PreparedStatement preparedStatement) {
        m_Statement.put(this.getClass(), preparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int save() {
        int n;
        JdbcConnection jdbcConnection;
        Statement statement;
        block19: {
            int n2;
            block18: {
                int n3;
                String string = "save";
                String string2 = "INSERT";
                String string3 = "UPDATE";
                String string4 = "DELETE";
                int n4 = 0;
                String string5 = "";
                statement = null;
                jdbcConnection = (JdbcConnection)this.getConnection();
                if (jdbcConnection == null) {
                    RecordDefinition recordDefinition = this;
                    recordDefinition.getClass();
                    throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException("The connection is closed" + string);
                }
                try {
                    n3 = this.recordState.getOperation();
                }
                catch (RecordState.StateException stateException) {
                    RecordDefinition recordDefinition = this;
                    recordDefinition.getClass();
                    throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException("The row was found in an invalid state");
                }
                try {
                    try {
                        if (jdbcConnection.isConnectionClosed()) {
                            jdbcConnection.connect();
                        }
                        switch (n3) {
                            case 14: {
                                statement = this.getInsertStatement();
                                string5 = string2;
                                break;
                            }
                            case 16: {
                                statement = this.getDeleteStatement();
                                string5 = string4;
                                break;
                            }
                            case 15: {
                                statement = this.getUpdateStatement();
                                string5 = string3;
                                break;
                            }
                            case 13: {
                                int n5 = n4;
                                Object var12_13 = null;
                                if (statement == null) return n5;
                                jdbcConnection.closeStatement(statement);
                                return n5;
                            }
                            default: {
                                throw new IllegalArgumentException(UNEXPECTED_ERROR_MESSAGE + string);
                            }
                        }
                        if (this.getStatement() == null) {
                            n2 = n4;
                            break block18;
                        }
                        n4 = jdbcConnection.executeStatement(statement, string5, this.getStatement());
                        if (n4 == 0) {
                            throw new SQLException("Record could not be found in DB");
                        }
                        if (jdbcConnection.isAutoCommit()) {
                            this.recordState.reset();
                            Enumeration enumeration = this.m_ModifiedValues.elements();
                            this.m_OriginalValues = new Vector();
                            while (enumeration.hasMoreElements()) {
                                Object e = enumeration.nextElement();
                                this.m_OriginalValues.addElement(e);
                            }
                        }
                        n = n4;
                        break block19;
                    }
                    catch (Exception exception) {
                        this.errorTreaten(exception, string);
                        RecordDefinition recordDefinition = this;
                        recordDefinition.getClass();
                        throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(exception.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (statement == null) throw throwable;
                    jdbcConnection.closeStatement(statement);
                    throw throwable;
                }
            }
            Object var12_14 = null;
            if (statement == null) return n2;
            jdbcConnection.closeStatement(statement);
            return n2;
        }
        Object var12_15 = null;
        if (statement == null) return n;
        jdbcConnection.closeStatement(statement);
        return n;
    }

    public void resetState() {
        this.recordState.reset();
        Enumeration enumeration = this.m_ModifiedValues.elements();
        this.m_OriginalValues = new Vector();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.m_OriginalValues.addElement(e);
        }
    }

    protected PreparedStatement getStatement(PreparedStatement preparedStatement, int n) throws SQLException {
        String string = "getStatement";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (preparedStatement == null) {
                switch (n) {
                    case 100: {
                        this.makeInsertSQLString(stringBuffer);
                        break;
                    }
                    case 101: {
                        this.makeUpdateSQLString(stringBuffer);
                        break;
                    }
                    case 102: {
                        this.makeDeleteSQLString(stringBuffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(UNEXPECTED_ERROR_MESSAGE + string);
                    }
                }
            }
            if (stringBuffer.length() == 0) {
                return null;
            }
            this.setStatement(stringBuffer.toString());
            preparedStatement = this.prepareStatement(stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
        return preparedStatement;
    }

    private boolean columnModifiedCondition(int n) {
        String string = "columnModifiedCondition";
        try {
            Object e = this.m_OriginalValues.elementAt(n);
            Object e2 = this.m_ModifiedValues.elementAt(n);
            if (e == null && e2 == null) {
                return false;
            }
            if (e == null && e2 != null) {
                return !e2.equals(e);
            }
            if (e != null && e2 == null) {
                return !e.equals(e2);
            }
            if (e != null && e2 != null) {
                return !e2.equals(e);
            }
            return false;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    private boolean isColumnNull(int n) {
        return this.m_OriginalValues.elementAt(n) == null;
    }

    protected synchronized void setParameterValues(PreparedStatement preparedStatement) throws SQLException {
        String string = "setParameterValues";
        String string2 = this.getStatement();
        if (preparedStatement == null) {
            return;
        }
        int n = this.getDataModel().getMemberCount();
        try {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4 = string2.indexOf("?", 0);
                if (this.columnModifiedCondition(n3)) {
                    if (this.getValueAsObject(n3, 1) == null) {
                        preparedStatement.setNull(n2 + 1, this.getDataModel().getMemberModel(n3).getDataType());
                        string2 = String.valueOf(string2.substring(0, n4)) + "null" + string2.substring(n4 + 1);
                    } else {
                        this.setObjectInStatement(preparedStatement, this.getValueAsObject(n3, 1), n3, 0, n2);
                        string2 = String.valueOf(string2.substring(0, n4)) + this.getValueAsObject(n3, 1) + string2.substring(n4 + 1);
                    }
                    ++n2;
                }
                ++n3;
            }
            this.setStatement(string2);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    protected void setObjectInStatement(PreparedStatement preparedStatement, Object object, int n, int n2, int n3) throws SQLException {
        int n4 = 1111;
        if (n >= 0) {
            n4 = this.getDataModel().getMemberModel(n).getDataType();
        }
        int n5 = n3 + 1 + n2;
        PreparedStatementHelper.setInParameter(preparedStatement, n5, n4, object);
    }

    String modifyStatement(int n, String string, int n2, String string2, String string3) {
        if (this.columnModifiedCondition(n)) {
            if (n2 > 0) {
                string = String.valueOf(string) + string2;
            }
            string = String.valueOf(string) + string3;
        }
        return string;
    }

    boolean modifyStatement(StringBuffer stringBuffer, int n, int n2, String string, String string2) {
        boolean bl = false;
        if (this.columnModifiedCondition(n)) {
            bl = true;
            if (n2 > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
        }
        return bl;
    }

    void makeInsertSQLString(StringBuffer stringBuffer) {
        String string = "makeInsertSQLString( StringBuffer )";
        try {
            int n = 0;
            int n2 = this.getDataModel().getMemberCount();
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(this.getDataModel().getModelName());
            stringBuffer.append("( ");
            int n3 = 0;
            while (n3 < n2) {
                if (this.modifyStatement(stringBuffer, n3, n, ",", this.getDataModel().getMemberModel(n3).getName())) {
                    ++n;
                }
                ++n3;
            }
            n = 0;
            stringBuffer.append(" ) VALUES( ");
            int n4 = 0;
            while (n4 < n2) {
                if (this.modifyStatement(stringBuffer, n4, n, ",", "?")) {
                    ++n;
                }
                ++n4;
            }
            stringBuffer.append(" )");
            stringBuffer.append("\n");
            return;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    String makeInsertSQLString() {
        String string = "makeInsertSQLString";
        try {
            String string2 = new String();
            int n = 0;
            int n2 = this.getDataModel().getMemberCount();
            string2 = String.valueOf(string2) + "INSERT INTO ";
            string2 = String.valueOf(string2) + this.getDataModel().getModelName();
            String string3 = string2 = String.valueOf(string2) + "( ";
            int n3 = 0;
            while (n3 < n2) {
                if (!(string3 = this.modifyStatement(n3, string3, n, ",", this.getDataModel().getMemberModel(n3).getName())).equals(string2)) {
                    ++n;
                }
                ++n3;
                string2 = string3;
            }
            n = 0;
            string3 = string2 = String.valueOf(string2) + " ) VALUES( ";
            int n4 = 0;
            while (n4 < n2) {
                string3 = this.modifyStatement(n4, string2, n, ",", "?");
                if (!string3.equals(string2)) {
                    ++n;
                }
                ++n4;
                string2 = string3;
            }
            string2 = String.valueOf(string2) + " )";
            if (n == 0) {
                string2 = null;
            }
            return string2;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    void makeUpdateSQLString(StringBuffer stringBuffer) {
        String string = "makeUpdateSQLString( StringBuffer )";
        try {
            int n = this.getDataModel().getMemberCount();
            int n2 = 0;
            stringBuffer.append("UPDATE ");
            stringBuffer.append(this.getDataModel().getModelName());
            stringBuffer.append(" SET ");
            int n3 = 0;
            while (n3 < n) {
                if (this.columnModifiedCondition(n3)) {
                    if (n2 > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.getDataModel().getMemberModel(n3).getName());
                    stringBuffer.append(" = ?");
                    ++n2;
                }
                ++n3;
            }
            this.setColModif(n2);
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this.getQueryPredicate("="));
            if (n2 == 0) {
                stringBuffer.setLength(0);
            }
            stringBuffer.append("\n");
            return;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    String makeUpdateSQLString() {
        String string = "makeUpdateSQLString";
        try {
            String string2 = new String();
            string2 = String.valueOf(string2) + "UPDATE ";
            string2 = String.valueOf(string2) + this.getDataModel().getModelName();
            string2 = String.valueOf(string2) + " SET ";
            int n = this.getDataModel().getMemberCount();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (this.columnModifiedCondition(n3)) {
                    if (n2 > 0) {
                        string2 = String.valueOf(string2) + ",";
                    }
                    string2 = String.valueOf(string2) + this.getDataModel().getMemberModel(n3).getName();
                    string2 = String.valueOf(string2) + " = ?";
                    ++n2;
                }
                ++n3;
            }
            this.setColModif(n2);
            string2 = String.valueOf(string2) + " WHERE ";
            string2 = String.valueOf(string2) + this.getQueryPredicate("=");
            if (n2 == 0) {
                string2 = null;
            }
            return string2;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    void makeDeleteSQLString(StringBuffer stringBuffer) {
        String string = "makeDeleteSQLString( StringBuffer )";
        try {
            stringBuffer.append("DELETE FROM ");
            stringBuffer.append(this.getDataModel().getModelName());
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this.getQueryPredicate("="));
            stringBuffer.append("\n");
            return;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    String makeDeleteSQLString() {
        String string = "makeDeleteSQLString";
        try {
            String string2 = new String();
            string2 = String.valueOf(string2) + "DELETE FROM ";
            string2 = String.valueOf(string2) + this.getDataModel().getModelName();
            string2 = String.valueOf(string2) + " WHERE ";
            string2 = String.valueOf(string2) + this.getQueryPredicate("=");
            return string2;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    public Enumeration querySimilarObjects(String string, String[] stringArray) throws SQLException {
        return this.querySimilarObjects(string, null, stringArray);
    }

    public Enumeration querySimilarObjects(String string, Synchronizable.JoinRecordList joinRecordList, String[] stringArray) throws SQLException {
        String string2 = "querySimilarObjects";
        JdbcConnection jdbcConnection = (JdbcConnection)this.getConnection();
        ResultSet resultSet = null;
        Enumeration enumeration = null;
        try {
            PreparedStatement preparedStatement;
            if (jdbcConnection.isConnectionClosed()) {
                jdbcConnection.connect();
            }
            if ((preparedStatement = this.getSelectStatement()) != null) {
                jdbcConnection.closeStatement(preparedStatement);
                preparedStatement = null;
                m_Statement.remove(this.getClass());
            }
            String string3 = this.createFinalSelectSQL(string, joinRecordList, stringArray);
            preparedStatement = this.prepareStatement(string3);
            this.setSelectStatement(preparedStatement);
            this.setStatement(string3.toString());
            if (joinRecordList != null) {
                this.setQueryParameters(preparedStatement, joinRecordList);
            }
            resultSet = ((JdbcConnection)this.getConnection()).executeQuery(preparedStatement, null, this.getStatement());
            enumeration = this.resultSetToEnum(resultSet);
            return enumeration;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string2);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string2);
        }
    }

    public String createFinalSelectSQL(String string, Synchronizable.JoinRecordList joinRecordList, String[] stringArray) {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer(this.getSelectSQL());
        boolean bl = true;
        if (string != null && string.length() > 0) {
            enumeration = new StringTokenizer(string, NULL_STRING);
            if (((StringTokenizer)enumeration).countTokens() >= 2) {
                String string2 = ((StringTokenizer)enumeration).nextToken();
                bl = false;
                if (!string2.equalsIgnoreCase("WHERE")) {
                    stringBuffer.append(" WHERE ");
                }
            } else {
                stringBuffer.append(" WHERE ");
            }
            stringBuffer.append("( " + string + " ) ");
        }
        enumeration = null;
        if (joinRecordList != null) {
            enumeration = joinRecordList.getJoinRecords();
        }
        if (joinRecordList != null && enumeration.hasMoreElements()) {
            if (bl) {
                stringBuffer.append(" WHERE ( ");
            } else {
                stringBuffer.append(" AND ( ");
            }
            int n = 0;
            while (enumeration.hasMoreElements()) {
                Synchronizable.JoinRecord joinRecord = (Synchronizable.JoinRecord)enumeration.nextElement();
                Object object = joinRecord.getMasterCurrentValue();
                if (n > 0) {
                    stringBuffer.append(" AND ");
                }
                if (object != null) {
                    stringBuffer.append(String.valueOf(joinRecord.getDetailColumnName()) + NULL_STRING + joinRecord.getOperator() + NULL_STRING + " ? ");
                } else {
                    stringBuffer.append(String.valueOf(joinRecord.getDetailColumnName()) + IS_NULL);
                }
                ++n;
            }
            if (n > 0) {
                stringBuffer.append(" ) ");
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append(" ORDER BY ");
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void setQueryParameters(PreparedStatement preparedStatement) throws SQLException {
        this.setQueryParameters(preparedStatement, null);
    }

    public void setQueryParameters(PreparedStatement preparedStatement, Synchronizable.JoinRecordList joinRecordList) throws SQLException {
        Enumeration enumeration = joinRecordList.getJoinRecords();
        int n = 0;
        int n2 = 0;
        String string = this.getStatement();
        while (enumeration.hasMoreElements()) {
            n = string.indexOf("?", 0);
            Synchronizable.JoinRecord joinRecord = (Synchronizable.JoinRecord)enumeration.nextElement();
            Object object = joinRecord.getMasterCurrentValue();
            if (object == null) continue;
            this.setObjectInStatement(preparedStatement, object, joinRecord.getDetailColumnNumber(), n2, 0);
            string = String.valueOf(string.substring(0, n)) + object + string.substring(n + 1);
            ++n2;
        }
        this.setStatement(string);
    }

    String getQueryString(String string) {
        String string2 = "getQueryString";
        String string3 = "WHERE";
        int n = string3.length();
        String string4 = "ORDER BY";
        string4.length();
        String string5 = new String();
        String string6 = this.getSelectSQL();
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        try {
            String string12 = this.getQueryPredicate(string);
            string12.length();
            int n2 = string6.indexOf(string3);
            int n3 = string6.indexOf(string4);
            if (n3 != -1) {
                string11 = string6.substring(n3);
                string8 = string6.substring(0, n3);
            }
            if (n2 != -1) {
                string9 = string6.substring(0, n2);
                string10 = string6.substring(n2 + n);
            }
            if (n2 != -1 && n3 != -1) {
                string5 = String.valueOf(string5) + string8;
                if (string12.length() > 0) {
                    string5 = String.valueOf(string5) + " AND " + string12;
                }
                string5 = String.valueOf(string5) + NULL_STRING + string11;
            } else if (n2 != -1 && n3 == -1) {
                string5 = String.valueOf(string5) + string6;
                if (string12.length() > 0) {
                    string5 = String.valueOf(string5) + " AND " + string12;
                }
            } else if (n2 == -1 && n3 != -1) {
                string5 = String.valueOf(string5) + string8;
                if (string12.length() > 0) {
                    string5 = String.valueOf(string5) + NULL_STRING + string3 + NULL_STRING + string12;
                }
                string5 = String.valueOf(string5) + NULL_STRING + string11;
            } else if (n3 == -1) {
                string5 = String.valueOf(string5) + string6;
                if (string12.length() > 0) {
                    string7 = String.valueOf(string7) + NULL_STRING + string3 + NULL_STRING + string12;
                    string5 = String.valueOf(string5) + string7;
                }
            }
            return string5;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string2);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string2);
        }
    }

    protected boolean shouldColumnBeInWhereClause(ColumnMetaData columnMetaData, int n) {
        return this.isColumnNeeded(columnMetaData, n) && this.canColumnBeUsed(columnMetaData);
    }

    protected boolean isColumnNeeded(ColumnMetaData columnMetaData, int n) {
        boolean bl;
        DataModel dataModel = (DataModel)this.getDataModel();
        boolean bl2 = bl = !dataModel.isUnique();
        return bl || this.columnModifiedCondition(n) || columnMetaData.isPrimaryKey();
    }

    protected boolean canColumnBeUsed(ColumnMetaData columnMetaData) {
        return columnMetaData.canBeIncludedInWhereClause();
    }

    String getQueryPredicate(String string) {
        String string2 = "getQueryPredicate";
        String string3 = new String();
        try {
            int n = 0;
            ColumnMetaData columnMetaData = this.getMemberModel(n);
            while (columnMetaData != null) {
                if (this.shouldColumnBeInWhereClause(columnMetaData, n)) {
                    if (string3.length() > 0) {
                        string3 = String.valueOf(string3) + " AND ";
                    }
                    string3 = String.valueOf(string3) + columnMetaData.getColumnName();
                    if (this.isColumnNull(n)) {
                        string3 = String.valueOf(string3) + IS_NULL;
                    } else {
                        string3 = String.valueOf(string3) + NULL_STRING;
                        string3 = String.valueOf(string3) + string;
                        string3 = String.valueOf(string3) + " ?";
                    }
                }
                columnMetaData = this.getMemberModel(++n);
            }
            return string3;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string2);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string2);
        }
    }

    protected void setParameters(PreparedStatement preparedStatement, int n, int n2, boolean bl) throws SQLException {
        String string = "setParameters";
        if (preparedStatement == null) {
            return;
        }
        String string2 = this.getStatement();
        Object object = null;
        try {
            int n3 = 0;
            int n4 = 0;
            ColumnMetaData columnMetaData = this.getMemberModel(n4);
            while (columnMetaData != null) {
                int n5 = string2.indexOf("?", 0);
                if (this.shouldColumnBeInWhereClause(columnMetaData, n4)) {
                    object = this.getValueAsObject(n4, n);
                    if (object == null) {
                        --n3;
                    } else {
                        this.setObjectInStatement(preparedStatement, object, n4, n2, n3);
                        string2 = String.valueOf(string2.substring(0, n5)) + object + string2.substring(n5 + 1);
                    }
                } else {
                    --n3;
                }
                ++n3;
                columnMetaData = this.getMemberModel(++n4);
            }
            this.setStatement(string2);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    protected synchronized Object getObjectFromResultSet(int n, ResultSet resultSet) throws SQLException {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n) + " < 1");
        }
        int n2 = this.getMemberModel(n - 1).getDataType();
        Object object = ResultSetHelper.getObject(resultSet, n, n2);
        return object;
    }

    public synchronized void undoChanges() {
        Enumeration enumeration = this.m_OriginalValues.elements();
        this.m_ModifiedValues = new Vector();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.m_ModifiedValues.addElement(e);
        }
        this.setMarkedAsModified(false);
        this.setMarkedAsDeleted(false);
        this.setMarkedAsDisplaced(false);
    }

    public void undoColumnChanges(int n) {
        this.setValueAsObject(n, this.getValueAsObject(n, 0));
    }

    public synchronized void setMarkedAsNew(boolean bl) {
        try {
            if (bl) {
                this.recordState.setState(1);
                return;
            }
            this.recordState.setStateUndo(1);
            return;
        }
        catch (RecordState.StateException stateException) {
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException("The row was found in a invalid state");
        }
    }

    public synchronized boolean getMarkedAsNew() {
        return this.recordState.getExternalState() == 110;
    }

    public synchronized void setMarkedAsDeleted(boolean bl) {
        try {
            if (bl) {
                this.recordState.setState(4);
                return;
            }
            this.recordState.setStateUndo(4);
            return;
        }
        catch (RecordState.StateException stateException) {
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException("The row was found in a invalid state");
        }
    }

    public boolean getMarkedAsDeleted() {
        return this.recordState.getExternalState() == 112;
    }

    public boolean getMarkedAsMisplaced() {
        return this.recordState.isMisplaced();
    }

    public boolean getMarkedAsQBE() {
        return this.m_QBERow;
    }

    public synchronized void setMarkedAsDisplaced(boolean bl) {
        try {
            if (bl) {
                this.recordState.setState(8);
                return;
            }
            this.recordState.setStateUndo(8);
            return;
        }
        catch (RecordState.StateException stateException) {
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException("The row was found in a invalid state");
        }
    }

    public synchronized void setMarkedAsQBE(boolean bl) {
        this.m_QBERow = true;
    }

    public synchronized void setMarkedAsModified(boolean bl) {
        try {
            if (bl) {
                this.recordState.setState(2);
                return;
            }
            this.recordState.setStateUndo(2);
            return;
        }
        catch (RecordState.StateException stateException) {
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException("The row was found in a invalid state");
        }
    }

    public synchronized boolean getMarkedAsModified() {
        return this.recordState.getExternalState() == 111;
    }

    void bringUpToDate() {
        Enumeration enumeration = this.m_ModifiedValues.elements();
        this.m_OriginalValues = new Vector();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.m_OriginalValues.addElement(e);
        }
        this.setMarkedAsModified(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataModel generateDataModel() throws SQLException {
        Statement statement;
        DataModel dataModel;
        block58: {
            String string = "generateDataModel";
            if (debug) {
                System.out.println(CLASS_NAME + string);
            }
            if (log) {
                this.announceMetaDataMessages(CLASS_NAME + string);
            }
            if (Beans.isDesignTime()) {
                return this.getDesignTimeDataModel();
            }
            Vector<String> vector = new Vector<String>(0);
            Vector<String> vector2 = new Vector<String>(0);
            dataModel = new DataModel();
            String string2 = this.getTableName();
            this.getColumns();
            statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    ResultSetMetaData resultSetMetaData;
                    block56: {
                        String string3;
                        ResultSet resultSet2;
                        DatabaseMetaData databaseMetaData;
                        block55: {
                            dataModel.setTableName(string2);
                            databaseMetaData = this.getDatabaseMetaData();
                            try {
                                dataModel.setProductName(databaseMetaData.getDatabaseProductName());
                                if (log) {
                                    this.announceMetaDataMessages("getDatabaseProductName: " + databaseMetaData.getDatabaseProductName());
                                }
                            }
                            catch (SQLException sQLException) {}
                            ResultSet resultSet3 = null;
                            resultSet2 = null;
                            try {
                                try {
                                    resultSet3 = databaseMetaData.getPrimaryKeys(null, null, string2.substring(string2.indexOf(".") + 1));
                                    while (resultSet3.next()) {
                                        string3 = resultSet3.getString(4);
                                        vector.addElement(this.removeBrackets(string3));
                                        if (!log) continue;
                                        this.announceMetaDataMessages("primaryKeyName :" + string3);
                                    }
                                }
                                catch (SQLException sQLException) {
                                }
                                resultSetMetaData = null;
                                if (resultSet3 == null) break block55;
                            }
                            catch (Throwable throwable) {
                                Object var15_14 = null;
                                if (resultSet3 != null) {
                                    resultSet3.close();
                                }
                                throw throwable;
                            }
                            resultSet3.close();
                        }
                        try {
                            try {
                                if (vector.isEmpty()) {
                                    if (log) {
                                        this.announceMetaDataMessages("NO PRIMARY KEYS HAVE BEEN FOUND");
                                    }
                                    resultSet2 = databaseMetaData.getIndexInfo(null, null, string2.substring(string2.indexOf(".") + 1), true, false);
                                    while (resultSet2.next()) {
                                        string3 = resultSet2.getString(9);
                                        vector2.addElement(this.removeBrackets(string3));
                                        if (!log) continue;
                                        this.announceMetaDataMessages("indexUniqueName :" + string3);
                                    }
                                }
                                if (vector2.isEmpty() && log) {
                                    this.announceMetaDataMessages("NO INDEXES HAVE BEEN FOUND");
                                }
                            }
                            catch (SQLException sQLException) {
                            }
                            resultSetMetaData = null;
                            if (resultSet2 == null) break block56;
                        }
                        catch (Throwable throwable) {
                            resultSetMetaData = null;
                            if (resultSet2 != null) {
                                resultSet2.close();
                            }
                            throw throwable;
                        }
                        resultSet2.close();
                    }
                    statement = this.createStatement();
                    String string4 = this.makeEmptyResultSetSQLString().toString();
                    resultSet = ((JdbcConnection)this.getConnection()).executeQuery(statement, string4, string4);
                    resultSetMetaData = resultSet.getMetaData();
                    int n = resultSetMetaData.getColumnCount();
                    int n2 = 1;
                    while (true) {
                        if (n2 > n) {
                            this.setDataModel(dataModel);
                            break;
                        }
                        ColumnMetaData columnMetaData = new ColumnMetaData();
                        String string5 = "";
                        try {
                            string5 = resultSetMetaData.getColumnName(n2);
                            if (log) {
                                this.announceMetaDataMessages("columnName(" + n2 + ") :" + string5);
                            }
                        }
                        catch (SQLException sQLException) {}
                        columnMetaData.setColumnName(string5);
                        if (!vector.isEmpty() && vector.contains(string5)) {
                            columnMetaData.setPrimaryKey(true);
                            dataModel.setUnique(true);
                            if (log) {
                                this.announceMetaDataMessages("columnName(" + n2 + ") :" + string5 + "is Primary Key");
                            }
                        } else if (!vector2.isEmpty() && vector2.contains(string5)) {
                            columnMetaData.setPrimaryKey(true);
                            dataModel.setUnique(true);
                            if (log) {
                                this.announceMetaDataMessages("columnName(" + n2 + ") :" + string5 + "is Index");
                            }
                        }
                        try {
                            int n3 = resultSetMetaData.getColumnType(n2);
                            columnMetaData.setColumnDataType(n3);
                            int n4 = Integer.MAX_VALUE;
                            if (n3 == 12 || n3 == 1) {
                                n4 = resultSetMetaData.getColumnDisplaySize(n2);
                                columnMetaData.setColumnDisplaySize(n4);
                            }
                            if (log) {
                                this.announceMetaDataMessages("columnName(" + n2 + ") :" + string5 + " DATA TYPE IS: " + n3 + "; DISPLAY SIZE IS : " + n4);
                            }
                        }
                        catch (SQLException sQLException) {}
                        try {
                            columnMetaData.setIsComparable(resultSetMetaData.isSearchable(n2));
                            if (log) {
                                this.announceMetaDataMessages("columnName(" + n2 + ") :" + string5 + " IS SEARCHABLE: " + resultSetMetaData.isSearchable(n2));
                            }
                        }
                        catch (SQLException sQLException) {}
                        try {
                            columnMetaData.setIsAutoIncrement(resultSetMetaData.isAutoIncrement(n2));
                            if (log) {
                                this.announceMetaDataMessages("columnName(" + n2 + ") :" + string5 + " IS AUTO INCREMENT: " + resultSetMetaData.isAutoIncrement(n2));
                            }
                        }
                        catch (SQLException sQLException) {}
                        try {
                            columnMetaData.setIsReadOnly(resultSetMetaData.isReadOnly(n2));
                            if (log) {
                                this.announceMetaDataMessages("columnName(" + n2 + ") :" + string5 + " IS READ ONLY: " + resultSetMetaData.isReadOnly(n2));
                            }
                        }
                        catch (SQLException sQLException) {}
                        try {
                            columnMetaData.setIsSigned(resultSetMetaData.isSigned(n2));
                            if (log) {
                                this.announceMetaDataMessages("columnName(" + n2 + ") :" + string5 + " IS SIGNED: " + resultSetMetaData.isSigned(n2));
                            }
                        }
                        catch (SQLException sQLException) {}
                        dataModel.addColumnMetaData(columnMetaData);
                        ++n2;
                    }
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (Exception exception) {
                    this.errorTreaten(exception, string);
                    RecordDefinition recordDefinition = this;
                    recordDefinition.getClass();
                    throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
                }
                Object var9_25 = null;
                if (resultSet == null) break block58;
            }
            catch (Throwable throwable) {
                Object var9_26 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    ((JdbcConnection)this.getConnection()).closeStatement(statement);
                    statement = null;
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (statement != null) {
            ((JdbcConnection)this.getConnection()).closeStatement(statement);
            return dataModel;
        }
        return dataModel;
    }

    String removeBrackets(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private boolean equalsColumn(Vector vector, int n, Vector vector2) {
        Object e = vector.elementAt(n);
        Object e2 = vector2.elementAt(n);
        try {
            if (e == null && e2 == null) {
                return true;
            }
            if (e == null && e2 != null) {
                return e2.equals(e);
            }
            if (e != null && e2 == null) {
                return e.equals(e2);
            }
            if (e != null && e2 != null) {
                return e2.toString().equals(e.toString());
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDirty() {
        return !this.equalsVector(this.m_OriginalValues, this.m_ModifiedValues) || this.recordState.getExternalState() != 109;
    }

    private synchronized boolean equalsVector(Vector vector, Vector vector2) {
        int n;
        boolean bl = true;
        if (vector == null && vector2 == null) {
            return true;
        }
        if (vector == null && vector2 != null || vector != null && vector2 == null) {
            return false;
        }
        int n2 = vector.size();
        if (n2 != (n = vector2.size())) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            boolean bl2 = bl = bl && this.equalsColumn(vector, n3, vector2);
            if (!bl) break;
            ++n3;
        }
        return bl;
    }

    public Hashtable toHashtable() {
        int n = this.m_OriginalValues.size();
        Hashtable hashtable = new Hashtable(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = this.m_OriginalValues.elementAt(n2);
            if (object == null) {
                object = new String();
            }
            hashtable.put(this.getDataModel().getMemberModel(n2).getName(), object);
            ++n2;
        }
        return hashtable;
    }

    public boolean equals(RecordDefinition recordDefinition) {
        String string = "equals";
        boolean bl = false;
        int n = recordDefinition.m_OriginalValues.size();
        try {
            int n2;
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = bl2 = recordDefinition.m_OriginalValues.size() == this.m_OriginalValues.size();
            if (bl2) {
                n2 = 0;
                while (n2 < n) {
                    boolean bl5 = bl2 = bl2 && this.equalsColumn(recordDefinition.m_OriginalValues, n2, this.m_OriginalValues);
                    if (!bl2) break;
                    ++n2;
                }
            }
            if (bl2) {
                boolean bl6 = bl3 = recordDefinition.m_ModifiedValues.size() == this.m_ModifiedValues.size();
                if (bl3) {
                    n2 = 0;
                    while (n2 < n) {
                        boolean bl7 = bl3 = bl3 && this.equalsColumn(recordDefinition.m_ModifiedValues, n2, this.m_ModifiedValues);
                        if (!bl3) break;
                        ++n2;
                    }
                }
            }
            bl = bl2 && bl3;
            return bl;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            RecordDefinition recordDefinition2 = this;
            recordDefinition2.getClass();
            throw recordDefinition2.new BaseRecordDefinition.RecordDefinitionException(UNEXPECTED_ERROR_MESSAGE + string);
        }
    }

    public String getSelectSQL() {
        String string = null;
        if (string == null) {
            string = "SELECT ";
            String string2 = this.getTableName();
            String[] stringArray = this.getColumns();
            if (stringArray == null || stringArray.length == 0) {
                string = String.valueOf(string) + " * FROM ";
            } else {
                int n = 0;
                while (n < stringArray.length - 1) {
                    string = String.valueOf(string) + stringArray[n] + ",";
                    ++n;
                }
                string = String.valueOf(string) + stringArray[stringArray.length - 1] + " FROM ";
            }
            string = String.valueOf(string) + string2;
        }
        return string;
    }

    public Object getKey() {
        return this.getClass().getName();
    }

    protected DesignTimeProperties getDesignTimeProperties() {
        DesignTimeProperties designTimeProperties = null;
        if (m_DesignTimePropertiesTable.containsKey(this.getKey())) {
            designTimeProperties = (DesignTimeProperties)m_DesignTimePropertiesTable.get(this.getKey());
        } else {
            designTimeProperties = new DesignTimeProperties();
            m_DesignTimePropertiesTable.put(this.getKey(), designTimeProperties);
            if (debug) {
                System.out.println("RecordDefinition: m_DesignTimePropertiesTable.put(" + this.getKey() + ", properties)");
            }
        }
        return designTimeProperties;
    }

    protected void replaceDesignTimeProperties(DesignTimeProperties designTimeProperties) {
        DesignTimeProperties designTimeProperties2 = this.getDesignTimeProperties();
        designTimeProperties2.connectionName = designTimeProperties.connectionName;
        designTimeProperties2.managerClassName = designTimeProperties.managerClassName;
        designTimeProperties2.tableName = designTimeProperties.tableName;
        designTimeProperties2.columns = designTimeProperties.columns;
        designTimeProperties2.lastSelectSQL = designTimeProperties.lastSelectSQL;
        designTimeProperties2.poModel = designTimeProperties.poModel;
        designTimeProperties2.dtJdbcConnection = designTimeProperties.dtJdbcConnection;
        designTimeProperties2.dataModelChanged = designTimeProperties.dataModelChanged;
        designTimeProperties2.designTimeData = designTimeProperties.designTimeData;
        designTimeProperties2.designTimeDataChanged = designTimeProperties.designTimeDataChanged;
    }

    public synchronized void setConnectionName(String string) {
        if (debug) {
            System.out.println("RecordDefinition.setConnectionName(" + string + ")");
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        String string2 = designTimeProperties.connectionName;
        designTimeProperties.connectionName = string;
        if (string2 == null || string == null || !string2.equals(string)) {
            designTimeProperties.dataModelChanged = true;
            designTimeProperties.designTimeDataChanged = true;
        }
        this.replaceDesignTimeProperties(designTimeProperties);
    }

    public synchronized String getConnectionName() {
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        return designTimeProperties.connectionName;
    }

    public synchronized void setConnectionManagerClassName(String string) {
        if (debug) {
            System.out.println("RecordDefinition.setConnectionManagerClassName(" + string + ")");
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        String string2 = designTimeProperties.managerClassName;
        designTimeProperties.managerClassName = string;
        if (string2 == null || string == null || !string2.equals(string)) {
            designTimeProperties.dataModelChanged = true;
            designTimeProperties.designTimeDataChanged = true;
        }
        this.replaceDesignTimeProperties(designTimeProperties);
    }

    public synchronized String getConnectionManagerClassName() {
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        return designTimeProperties.managerClassName;
    }

    public synchronized void setTableName(String string) {
        if (debug) {
            System.out.println("RecordDefinition.setTableName(" + string + ")");
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        String string2 = designTimeProperties.tableName;
        designTimeProperties.tableName = string;
        designTimeProperties.columns = new String[0];
        if (string2 == null || string == null || !string2.equals(string)) {
            designTimeProperties.dataModelChanged = true;
            designTimeProperties.designTimeDataChanged = true;
        }
        this.replaceDesignTimeProperties(designTimeProperties);
    }

    public synchronized String getTableName() {
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        return designTimeProperties.tableName;
    }

    public synchronized void addColumn(String string) {
        if (debug) {
            System.out.println("RecordDefinition.addColumn(" + string + ")");
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        if (designTimeProperties.columns == null) {
            designTimeProperties.columns = new String[1];
            designTimeProperties.columns[0] = string;
        } else {
            int n = designTimeProperties.columns.length;
            String[] stringArray = new String[n + 1];
            System.arraycopy(designTimeProperties.columns, 0, stringArray, 0, n);
            stringArray[n] = string;
            designTimeProperties.columns = stringArray;
        }
        designTimeProperties.dataModelChanged = true;
        designTimeProperties.designTimeDataChanged = true;
        this.replaceDesignTimeProperties(designTimeProperties);
    }

    public synchronized void setColumns(String[] stringArray) {
        if (debug) {
            System.out.println("RecordDefinition.setColumns(" + stringArray + ")");
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        designTimeProperties.columns = stringArray;
        this.replaceDesignTimeProperties(designTimeProperties);
    }

    public String[] getColumns() {
        if (debug) {
            System.out.println("RecordDefinition.getColumns()");
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        return designTimeProperties.columns;
    }

    protected RunTimeProperties getRunTimeProperties() {
        RunTimeProperties runTimeProperties = null;
        if (m_RunTimePropertiesTable.containsKey(this.getKey())) {
            runTimeProperties = (RunTimeProperties)m_RunTimePropertiesTable.get(this.getKey());
        } else {
            runTimeProperties = new RunTimeProperties();
            m_RunTimePropertiesTable.put(this.getKey(), runTimeProperties);
            if (debug) {
                System.out.println("RecordDefinition: m_RunTimePropertiesTable.put(" + this.getKey() + ", properties)");
            }
        }
        return runTimeProperties;
    }

    protected void replaceRunTimeProperties(RunTimeProperties runTimeProperties) {
        RunTimeProperties runTimeProperties2 = this.getRunTimeProperties();
        runTimeProperties2.connectionManager = runTimeProperties.connectionManager;
        runTimeProperties2.jdbcConnection = runTimeProperties.jdbcConnection;
    }

    public ConnectionManager getConnectionManager() {
        if (debug) {
            System.out.println("RecordDefinition.getConnectionManager()");
        }
        RunTimeProperties runTimeProperties = this.getRunTimeProperties();
        if (runTimeProperties.connectionManager == null) {
            if (debug) {
                System.out.println("runTimeProperties.connectionManager == null");
            }
            String string = this.getConnectionManagerClassName();
            runTimeProperties.connectionManager = ConnectionManager.getManager(string);
            this.replaceRunTimeProperties(runTimeProperties);
        }
        return runTimeProperties.connectionManager;
    }

    public Connection getConnection() {
        if (debug) {
            System.out.println("RecordDefinition.getConnection()");
        }
        RunTimeProperties runTimeProperties = this.getRunTimeProperties();
        if (runTimeProperties.jdbcConnection == null) {
            try {
                ConnectionManager connectionManager = this.getConnectionManager();
                String string = this.getConnectionName();
                runTimeProperties.jdbcConnection = connectionManager.getConnectionBean(string);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.getMessage());
            }
            this.replaceRunTimeProperties(runTimeProperties);
        }
        if (debug) {
            System.out.println("RD.getConnection() returns URL:" + runTimeProperties.jdbcConnection.getURL());
        }
        return runTimeProperties.jdbcConnection;
    }

    public void releaseConnection() {
        String string = "RecordDefinition.releaseConnection()";
        if (debug) {
            System.out.println("<ENTER: >" + string);
        }
        if (!Beans.isDesignTime()) {
            this.getConnectionManager().releaseConnection(this.getConnectionName());
        }
        if (debug) {
            System.out.println("<END: >" + string);
        }
    }

    protected PreparedStatement prepareStatement(String string) throws SQLException {
        JdbcConnection jdbcConnection = (JdbcConnection)this.getConnection();
        this.noConnectionAvailable(jdbcConnection);
        return jdbcConnection.prepareStatement(string);
    }

    protected Statement createStatement() throws SQLException {
        JdbcConnection jdbcConnection = (JdbcConnection)this.getConnection();
        this.noConnectionAvailable(jdbcConnection);
        return jdbcConnection.createStatement();
    }

    protected DatabaseMetaData getDatabaseMetaData() throws SQLException {
        JdbcConnection jdbcConnection = (JdbcConnection)this.getConnection();
        this.noConnectionAvailable(jdbcConnection);
        return jdbcConnection.getMetaData();
    }

    public boolean isOperationNothing() {
        return this.recordState.getOperation() == 13;
    }

    private void noConnectionAvailable(JdbcConnection jdbcConnection) throws SQLException {
        String string = "RecordDefinition.noConnectionAvailable";
        if (debug) {
            System.out.println(string);
        }
        if (jdbcConnection == null) {
            throw new SQLException("The connection is closed");
        }
    }

    public int getOperation() {
        return this.recordState.getOperation();
    }

    public void setSQLAdapter(Object object) {
        String string = "setSQLAdapter";
        throw new RuntimeException(NOT_APPLY_ERROR + string);
    }

    public void close() {
        try {
            this.finalize();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    protected void finalize() throws Throwable {
        String string = "RecordDefinition.finalize()";
        if (debug) {
            System.out.println("<ENTER:>" + string);
        }
        super.finalize();
        if (debug) {
            System.out.println("<END:>" + string);
        }
    }

    public DataModel getDesignTimeDataModel() {
        String string = "RecordDefinition.getDesignTimeDataModel()";
        if (debug) {
            System.out.println("<ENTER:>" + string);
        }
        if (!Beans.isDesignTime()) {
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(DESIGN_TIME_MESSAGE + string);
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        JdbcConnection jdbcConnection = designTimeProperties.dtJdbcConnection;
        JdbcConnection jdbcConnection2 = null;
        ConnectionManager connectionManager = this.getDesignTimeConnectionManager();
        if (connectionManager != null) {
            ConnectionManager.isDesignTimeOverride = true;
            try {
                jdbcConnection2 = connectionManager.getConnectionBean(this.getConnectionName());
            }
            catch (SQLException sQLException) {
                jdbcConnection2 = null;
            }
            ConnectionManager.isDesignTimeOverride = false;
        }
        boolean bl = true;
        if (jdbcConnection != null && jdbcConnection2 != null && jdbcConnection2.equals(jdbcConnection)) {
            bl = false;
        }
        designTimeProperties.dtJdbcConnection = jdbcConnection2;
        this.replaceDesignTimeProperties(designTimeProperties);
        if (jdbcConnection2 != null && jdbcConnection2.getDriverName().equals("com.pointbase.jdbc.jdbcDriver")) {
            this.createDummyDesignTimeDataModel();
        } else if (bl || designTimeProperties.dataModelChanged) {
            String string2 = this.makeEmptyResultSetSQLString().toString();
            this.fetchDesignTimeData(connectionManager, jdbcConnection2, string2, true, 0);
        }
        if (debug) {
            System.out.println("<END:>" + string);
        }
        return designTimeProperties.poModel;
    }

    public Hashtable getDesignTimeData(String string, String[] stringArray, int n) {
        String string2 = "getDesignTimeData";
        if (debug) {
            System.out.println("<ENTER:>RecordDefinition." + string2 + "( " + n + " )");
        }
        if (!Beans.isDesignTime()) {
            RecordDefinition recordDefinition = this;
            recordDefinition.getClass();
            throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException(DESIGN_TIME_MESSAGE + string2);
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        JdbcConnection jdbcConnection = designTimeProperties.dtJdbcConnection;
        JdbcConnection jdbcConnection2 = null;
        ConnectionManager connectionManager = this.getDesignTimeConnectionManager();
        if (connectionManager != null) {
            ConnectionManager.isDesignTimeOverride = true;
            try {
                jdbcConnection2 = connectionManager.getConnectionBean(this.getConnectionName());
            }
            catch (SQLException sQLException) {
                jdbcConnection2 = null;
            }
            ConnectionManager.isDesignTimeOverride = false;
        }
        boolean bl = true;
        if (jdbcConnection != null && jdbcConnection2 != null && jdbcConnection2.equals(jdbcConnection)) {
            bl = false;
        }
        String string3 = designTimeProperties.lastSelectSQL;
        String string4 = this.createFinalSelectSQL(string, null, stringArray);
        boolean bl2 = true;
        if (string3 != null && string4 != null && string3.equals(string4)) {
            bl2 = false;
        }
        designTimeProperties.dtJdbcConnection = jdbcConnection2;
        designTimeProperties.lastSelectSQL = string4;
        this.replaceDesignTimeProperties(designTimeProperties);
        if (jdbcConnection2 != null && jdbcConnection2.getDriverName().equals("com.pointbase.jdbc.jdbcDriver")) {
            this.createDummyDesignTimeDataModel();
            this.createDummyDesignTimeResultSet();
        } else if (bl || bl2 || designTimeProperties.designTimeDataChanged) {
            this.fetchDesignTimeData(connectionManager, jdbcConnection2, string4, false, n);
        }
        if (debug) {
            System.out.println("<END:>" + string2);
        }
        return designTimeProperties.designTimeData;
    }

    protected void fetchDesignTimeData(ConnectionManager connectionManager, JdbcConnection jdbcConnection, String string, boolean bl, int n) {
        Statement statement;
        DataModel dataModel;
        DesignTimeProperties designTimeProperties;
        String string2;
        block27: {
            string2 = "fetchDesignTimeData";
            if (debug) {
                System.out.println("<ENTER:>RecordDefinition." + string2);
            }
            if (!Beans.isDesignTime()) {
                RecordDefinition recordDefinition = this;
                recordDefinition.getClass();
                throw recordDefinition.new BaseRecordDefinition.RecordDefinitionException("The following method should only be called at design time: RecordDefinition." + string2);
            }
            this.createDummyDesignTimeDataModel();
            this.createDummyDesignTimeResultSet();
            designTimeProperties = this.getDesignTimeProperties();
            dataModel = designTimeProperties.poModel;
            if (dataModel == null) {
                dataModel = new DataModel();
                dataModel.setTableName(this.getTableName());
            }
            statement = null;
            ResultSet resultSet = null;
            try {
                block26: {
                    try {
                        int n2;
                        ResultSetMetaData resultSetMetaData;
                        int n3;
                        boolean bl2;
                        if (jdbcConnection == null) break block26;
                        if (jdbcConnection.isConnectionClosed()) {
                            jdbcConnection.connect();
                        }
                        boolean bl3 = bl2 = (n3 = (resultSetMetaData = (resultSet = jdbcConnection.executeQuery(statement = jdbcConnection.createStatement(), string, string)).getMetaData()).getColumnCount()) != (n2 = dataModel.getColumnCount());
                        if (bl2) {
                            dataModel = new DataModel();
                            dataModel.setTableName(this.getTableName());
                        }
                        String[] stringArray = new String[n3];
                        int n4 = 1;
                        while (n4 <= n3) {
                            ColumnMetaData columnMetaData = null;
                            if (bl2) {
                                columnMetaData = new ColumnMetaData();
                                dataModel.addColumnMetaData(columnMetaData);
                            } else {
                                columnMetaData = dataModel.getColumnMetaData(n4 - 1);
                            }
                            String string3 = "";
                            try {
                                string3 = resultSetMetaData.getColumnName(n4);
                            }
                            catch (SQLException sQLException) {}
                            stringArray[n4 - 1] = string3;
                            columnMetaData.setColumnName(string3);
                            try {
                                int n5 = resultSetMetaData.getColumnType(n4);
                                columnMetaData.setColumnDataType(n5);
                            }
                            catch (SQLException sQLException) {}
                            ++n4;
                        }
                        if (!bl) {
                            this.cacheDesignTimeResultSet(resultSet, stringArray, n);
                        }
                    }
                    catch (SQLException sQLException) {
                        this.errorTreaten(sQLException, string2);
                        if (!debug) break block26;
                        System.err.println(UNEXPECTED_ERROR_MESSAGE + string2);
                        sQLException.printStackTrace();
                    }
                }
                Object var12_21 = null;
                if (resultSet == null) break block27;
            }
            catch (Throwable throwable) {
                Object var12_22 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement != null) {
                    jdbcConnection.closeStatement(statement);
                    statement = null;
                }
                if (connectionManager != null && jdbcConnection != null) {
                    connectionManager.releaseConnection(jdbcConnection.getIdentifier());
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        if (statement != null) {
            jdbcConnection.closeStatement(statement);
            statement = null;
        }
        if (connectionManager != null && jdbcConnection != null) {
            connectionManager.releaseConnection(jdbcConnection.getIdentifier());
        }
        this.setDataModel(dataModel);
        designTimeProperties = this.getDesignTimeProperties();
        designTimeProperties.poModel = dataModel;
        designTimeProperties.dataModelChanged = false;
        this.replaceDesignTimeProperties(designTimeProperties);
        if (debug) {
            System.out.println("<END:>RecordDefinition." + string2);
        }
    }

    protected void createDummyDesignTimeDataModel() {
        Object object;
        DataModel dataModel = new DataModel();
        String string = this.getTableName();
        dataModel.setTableName(string);
        String[] stringArray = this.getColumns();
        int n = 0;
        while (n < stringArray.length) {
            object = new ColumnMetaData();
            ((ColumnMetaData)object).setColumnName(stringArray[n]);
            ((ColumnMetaData)object).setColumnDataType(12);
            dataModel.addColumnMetaData((ColumnMetaData)object);
            ++n;
        }
        this.setDataModel(dataModel);
        object = this.getDesignTimeProperties();
        ((DesignTimeProperties)object).poModel = dataModel;
        ((DesignTimeProperties)object).dataModelChanged = false;
        this.replaceDesignTimeProperties((DesignTimeProperties)object);
    }

    protected void createDummyDesignTimeResultSet() {
        Hashtable hashtable = new Hashtable();
        String[] stringArray = this.getColumns();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                Vector<String> vector = (Vector<String>)hashtable.get(stringArray[n]);
                if (vector == null || vector.size() < 1) {
                    vector = new Vector<String>(1);
                    vector.addElement("<" + stringArray[n] + ">");
                    hashtable.put(stringArray[n], vector);
                }
                ++n;
            }
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        designTimeProperties.designTimeData = hashtable;
        designTimeProperties.designTimeDataChanged = false;
        this.replaceDesignTimeProperties(designTimeProperties);
    }

    private void cacheDesignTimeResultSet(ResultSet resultSet, String[] stringArray, int n) {
        Hashtable hashtable;
        String string;
        block15: {
            string = "RecordDefinition.cacheDesignTimeResultSet( ResultSet, " + n + " )";
            if (debug) {
                System.out.println("<ENTER:>" + string);
            }
            hashtable = new Hashtable();
            if (resultSet != null && n > -1 && stringArray != null && stringArray.length > 0) {
                try {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        hashtable.put(stringArray[n2], new Vector(n));
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < n && resultSet.next()) {
                        int n4 = 1;
                        while (n4 <= stringArray.length) {
                            String string2 = stringArray[n4 - 1];
                            Object object = null;
                            try {
                                object = resultSet.getObject(n4);
                                if (resultSet.wasNull() || object == null) {
                                    object = NULL_STRING;
                                } else if (object instanceof byte[]) {
                                    object = BINARY_DATA;
                                }
                                object = LocalizedValueGenerator.formatValue(object, false);
                            }
                            catch (Exception exception) {
                                object = "<" + string2 + ">";
                            }
                            Vector<String> vector = (Vector<String>)hashtable.get(string2);
                            if (vector == null) {
                                vector = new Vector<String>();
                            }
                            vector.addElement(object.toString());
                            hashtable.put(string2, vector);
                            ++n4;
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block15;
                    exception.printStackTrace();
                }
            }
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        DesignTimeProperties designTimeProperties = this.getDesignTimeProperties();
        designTimeProperties.designTimeData = hashtable;
        designTimeProperties.designTimeDataChanged = false;
        this.replaceDesignTimeProperties(designTimeProperties);
        if (debug) {
            System.out.println("<END:>" + string);
        }
    }

    protected ConnectionManager getDesignTimeConnectionManager() {
        String string = "getDesignTimeConnectionManager";
        if (debug) {
            System.out.println("<ENTER:>RecordDefinition." + string);
        }
        ConnectionManager connectionManager = null;
        try {
            String string2 = this.getConnectionManagerClassName();
            Class<?> clazz = Class.forName("symantec.itools.db.beans.util.ObjectFinder");
            Object obj = clazz.newInstance();
            Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RecordDefinition.class$("java.lang.String")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = RecordDefinition.class$("java.lang.Boolean"))};
            Method method = clazz.getMethod("getConectionManager", classArray);
            Object[] objectArray = new Object[]{string2, Boolean.FALSE};
            connectionManager = (ConnectionManager)method.invoke(obj, objectArray);
        }
        catch (Exception exception) {
            connectionManager = null;
            System.err.println(exception);
            exception.printStackTrace();
        }
        if (debug) {
            System.out.println("<END:>RecordDefinition." + string);
        }
        return connectionManager;
    }

    protected StringBuffer makeEmptyResultSetSQLString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getSelectSQL());
        stringBuffer.append(" WHERE 1 > 2");
        stringBuffer.append("\n");
        return stringBuffer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class RecordState {
        public static final int ORIGINAL = 0;
        public static final int INSERTED = 1;
        public static final int MODIFIED = 2;
        public static final int DELETED = 4;
        public static final int MISPLACED = 8;
        public static final int INSERTED_MODIFIED = 3;
        public static final int INSERTED_DELETED = 5;
        public static final int MODIFIED_DELETED = 6;
        public static final int INSERTED_MODIFIED_DELETED = 7;
        public static final int NUMBER_OF_STATES = 4;
        public static final int FIRST_VALUE = 0;
        public static final int LAST_VALUE = 15;
        public static final int EXISTING_STATE = 109;
        public static final int INSERTED_STATE = 110;
        public static final int MODIFIED_STATE = 111;
        public static final int DELETED_STATE = 112;
        public static final int INSERTED_MISPLACED = 113;
        public static final int MODIFIED_MISPLACED = 114;
        int state = 0;

        RecordState() {
        }

        synchronized void reset() {
            this.state = 0;
        }

        public boolean equals(RecordState recordState) {
            return recordState.state == this.state;
        }

        int getOperation() throws StateException {
            int n = 13;
            int n2 = this.state >= 8 ? this.state - 8 : this.state;
            switch (n2) {
                case 0: {
                    n = 13;
                    break;
                }
                case 1: {
                    n = 14;
                    break;
                }
                case 2: {
                    n = 15;
                    break;
                }
                case 3: {
                    n = 14;
                    break;
                }
                case 4: {
                    n = 16;
                    break;
                }
                case 5: {
                    n = 13;
                    break;
                }
                case 6: {
                    n = 16;
                    break;
                }
                case 7: {
                    n = 13;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid call to getOperation()");
                }
            }
            return n;
        }

        synchronized void setState(int n) throws StateException {
            int n2 = 0;
            if ((this.state & n) > 0) {
                return;
            }
            if (this.state == 4 && n == 2) {
                return;
            }
            if ((this.state & 2) == 0 && n == 8) {
                throw new StateException("Invalid try to set the State of the Record to MISPLACED.");
            }
            n2 = this.state + n;
            if (n2 > 15 || n2 < 0) {
                throw new StateException("Invalid try to set the State");
            }
            this.state += n;
        }

        synchronized void setStateUndo(int n) throws StateException {
            int n2 = 0;
            if ((this.state & n) <= 0) {
                return;
            }
            n2 = this.state - n;
            if (n2 > 15 || n2 < 0) {
                throw new StateException("Invalid try to set the State");
            }
            this.state = n2;
        }

        boolean isMisplaced() {
            return (this.state & 8) > 0;
        }

        int getExternalState() {
            int n;
            int n2 = this.state >= 8 ? this.state - 8 : this.state;
            switch (n2) {
                case 0: {
                    n = 109;
                    break;
                }
                case 1: {
                    n = 110;
                    break;
                }
                case 2: {
                    n = 111;
                    break;
                }
                case 3: {
                    n = 110;
                    break;
                }
                case 4: {
                    n = 112;
                    break;
                }
                case 5: {
                    n = 112;
                    break;
                }
                case 6: {
                    n = 112;
                    break;
                }
                case 7: {
                    n = 112;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid try to call getState");
                }
            }
            return n;
        }

        class StateException
        extends RuntimeException {
            StateException(String string) {
                super(string);
                RecordState.this = RecordState.this;
            }
        }
    }

    protected class DesignTimeProperties {
        String connectionName = "";
        String managerClassName = "";
        String tableName = "";
        String[] columns;
        String lastSelectSQL = "";
        DataModel poModel;
        JdbcConnection dtJdbcConnection;
        boolean dataModelChanged = true;
        Hashtable designTimeData = new Hashtable();
        boolean designTimeDataChanged = true;

        protected DesignTimeProperties() {
            RecordDefinition.this = RecordDefinition.this;
        }
    }

    protected class RunTimeProperties {
        ConnectionManager connectionManager;
        JdbcConnection jdbcConnection;

        protected RunTimeProperties() {
            RecordDefinition.this = RecordDefinition.this;
        }
    }
}

