/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.db.beans.binding.DataSynchronizer;
import symantec.itools.db.beans.binding.MediatorDS;
import symantec.itools.db.beans.binding.Name;
import symantec.itools.db.beans.binding.SingleRowBDSSupport;
import symantec.itools.db.beans.jdbc.ConnectionManager;
import symantec.itools.db.beans.jdbc.JdbcConnection;
import symantec.itools.db.beans.jdbc.JdbcResourceLoader;
import symantec.itools.db.beans.jdbc.ParameterMetaData;
import symantec.itools.db.beans.jdbc.PreparedStatementHelper;
import symantec.itools.db.beans.jdbc.SQLAdapterException;
import symantec.itools.db.beans.jdbc.event.SQLAdapterEvent;
import symantec.itools.db.beans.jdbc.event.SQLAdapterEventListener;
import symantec.itools.db.beans.util.LogWindowHelper;

public class SQLAdapter
extends SingleRowBDSSupport
implements Serializable {
    public static final String PROP_CONN_MGR_CLASS_NAME = "connectionManagerClassName";
    public static final String PROP_CONN_NAME = "connectionName";
    public static final String PROP_SQL_TEXT = "sqlText";
    public static final String PROP_META_DATA = "metaData";
    public static final String PROP_COLUMNS = "columns";
    public static final String PROP_ALIAS_NAME = "aliasName";
    public static final String PROP_AUTO_START = "autoStart";
    public static final String PROP_DATA_ITEM_SYNC = "dataItemSync";
    protected static JdbcResourceLoader resourceLoader = JdbcResourceLoader.getInstance();
    protected static ResourceBundle MyResource = resourceLoader.getBundle();
    protected static LogWindowHelper logWindow = LogWindowHelper.getInstance();
    protected String connectionManagerClassName = "";
    protected String connectionName = "";
    protected String sqlText = "";
    protected transient ParameterMetaData[] metaData = new ParameterMetaData[0];
    protected transient DataSynchronizer[] dataItemSync = new DataSynchronizer[0];
    protected transient String[] columns = new String[0];
    protected String aliasName = "";
    protected boolean autoStart = false;
    protected transient ConnectionManager connectionManager;
    protected transient JdbcConnection jdbcConnection;
    protected transient boolean metaDataChecked = false;
    protected transient boolean outParametersRegistered = false;
    protected transient Name bindName;
    protected transient Statement statement;
    protected transient ResultSet currentResultSet;
    protected transient boolean resultSetCached;
    protected Vector listenersSQLAdapterEvent;
    protected PropertyChangeSupport changeSupport;
    protected VetoableChangeSupport vetoableChangeSupport;
    public static final int PARAM_NAMES_SUPPORTED = -1;
    public static final int COLUMN_NAMES_SUPPORTED = -1;

    public synchronized String getConnectionManagerClassName() {
        return this.connectionManagerClassName;
    }

    public synchronized void setConnectionManagerClassName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("setConnectionManagerClassName( null )");
        }
        this.closeStatement();
        if (this.connectionManager != null && this.jdbcConnection != null) {
            this.connectionManager.releaseConnection(this.jdbcConnection.getIdentifier());
        }
        this.jdbcConnection = null;
        this.connectionManager = null;
        this.connectionManagerClassName = string;
    }

    public synchronized String getConnectionName() {
        return this.connectionName;
    }

    public synchronized void setConnectionName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("setConnectionName( null )");
        }
        this.closeStatement();
        if (this.connectionManager != null && this.jdbcConnection != null) {
            this.connectionManager.releaseConnection(this.jdbcConnection.getIdentifier());
        }
        this.jdbcConnection = null;
        this.connectionName = string;
    }

    public synchronized String getSQLText() {
        return this.sqlText;
    }

    public synchronized void setSQLText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("setSQLText( null )");
        }
        this.closeStatement();
        this.sqlText = string;
        this.metaDataChecked = false;
    }

    public synchronized ParameterMetaData[] getMetaData() {
        return this.metaData;
    }

    public synchronized ParameterMetaData[] getMetaDataCopy() {
        ParameterMetaData[] parameterMetaDataArray = null;
        if (this.metaData != null) {
            parameterMetaDataArray = new ParameterMetaData[this.metaData.length];
            int n = 0;
            while (n < this.metaData.length) {
                parameterMetaDataArray[n] = new ParameterMetaData(this.metaData[n]);
                ++n;
            }
        }
        return parameterMetaDataArray;
    }

    public synchronized void setMetaData(ParameterMetaData[] parameterMetaDataArray) {
        if (parameterMetaDataArray == null) {
            throw new IllegalArgumentException("setMetaData( null )");
        }
        this.closeStatement();
        this.metaData = parameterMetaDataArray;
        this.metaDataChecked = false;
        Object[] objectArray = null;
        if (this.metaData != null) {
            objectArray = new Object[this.metaData.length];
            int n = 0;
            while (n < this.metaData.length) {
                objectArray[n] = this.metaData[n].getDefaultValue();
                ++n;
            }
        }
        this.setValues(objectArray);
        this.triggerUI();
    }

    public synchronized ParameterMetaData getMetaData(int n) {
        return this.metaData[n];
    }

    public synchronized void setMetaData(int n, ParameterMetaData parameterMetaData) {
        if (parameterMetaData == null) {
            throw new IllegalArgumentException("setMetaData( " + n + ", null )");
        }
        this.closeStatement();
        this.metaData[n] = parameterMetaData;
        this.metaDataChecked = false;
        Object object = null;
        if (this.metaData[n] != null) {
            object = this.metaData[n].getDefaultValue();
        }
        this.setValues(n, object);
        this.triggerUI();
    }

    public synchronized DataSynchronizer[] getDataItemSync() {
        return this.dataItemSync;
    }

    public synchronized DataSynchronizer[] getDataItemSyncCopy() {
        DataSynchronizer[] dataSynchronizerArray = null;
        if (this.dataItemSync != null) {
            dataSynchronizerArray = new DataSynchronizer[this.dataItemSync.length];
            int n = 0;
            while (n < this.dataItemSync.length) {
                String string = new String(this.dataItemSync[n].getSourceDataItem());
                String string2 = new String(this.dataItemSync[n].getTargetDataItem());
                dataSynchronizerArray[n] = new DataSynchronizer(string, string2);
                ++n;
            }
        }
        return dataSynchronizerArray;
    }

    public synchronized void setDataItemSync(DataSynchronizer[] dataSynchronizerArray) {
        if (dataSynchronizerArray == null) {
            throw new IllegalArgumentException("setDataItemSync( null )");
        }
        this.dataItemSync = dataSynchronizerArray;
    }

    public synchronized DataSynchronizer getDataItemSync(int n) {
        return this.dataItemSync[n];
    }

    public synchronized void setDataItemSync(int n, DataSynchronizer dataSynchronizer) {
        if (dataSynchronizer == null) {
            throw new IllegalArgumentException("setDataItemSync( " + n + ", null )");
        }
        this.dataItemSync[n] = dataSynchronizer;
    }

    public synchronized String[] getColumns() {
        return this.columns;
    }

    public synchronized String[] getColumnsCopy() {
        String[] stringArray = null;
        if (this.columns != null) {
            stringArray = new String[this.columns.length];
            int n = 0;
            while (n < this.columns.length) {
                stringArray[n] = new String(this.columns[n]);
                ++n;
            }
        }
        return stringArray;
    }

    public synchronized void setColumns(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("setColumns( null )");
        }
        this.columns = stringArray;
    }

    public synchronized String getColumns(int n) {
        return this.columns[n];
    }

    public synchronized void setColumns(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("setColumns( " + n + ", null )");
        }
        this.columns[n] = string;
    }

    public synchronized String getAliasName() {
        return this.aliasName;
    }

    public synchronized void setAliasName(String string) throws SQLAdapterException, SQLException {
        if (string == null) {
            throw new IllegalArgumentException("setAliasName( null )");
        }
        this.aliasName = string;
        if (!Beans.isDesignTime()) {
            this.prepareAndExecute();
        }
    }

    public synchronized void setAliasNameOnly(String string) {
        if (string == null) {
            throw new IllegalArgumentException("setAliasNameOnly( null )");
        }
        this.aliasName = string;
    }

    public synchronized void setAutoStart(boolean bl) {
        this.autoStart = bl;
    }

    public synchronized boolean getAutoStart() {
        return this.autoStart;
    }

    public synchronized ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected synchronized void setConnectionManager(ConnectionManager connectionManager) {
        this.closeStatement();
        if (this.connectionManager != null && this.jdbcConnection != null) {
            this.connectionManager.releaseConnection(this.jdbcConnection.getIdentifier());
        }
        this.jdbcConnection = null;
        this.connectionManager = connectionManager;
    }

    public synchronized JdbcConnection getJdbcConnection() {
        return this.jdbcConnection;
    }

    protected synchronized void setJdbcConnection(JdbcConnection jdbcConnection) {
        this.closeStatement();
        if (this.connectionManager != null && this.jdbcConnection != null) {
            this.connectionManager.releaseConnection(this.jdbcConnection.getIdentifier());
        }
        this.jdbcConnection = null;
        this.jdbcConnection = jdbcConnection;
    }

    public SQLAdapter() {
    }

    public SQLAdapter(String string, String string2) {
        this();
        this.setConnectionManagerClassName(string);
        this.setConnectionName(string2);
    }

    public SQLAdapter(String string, String string2, String string3) {
        this(string, string2);
        this.setSQLText(string3);
    }

    public SQLAdapter(String string, String string2, String string3, ParameterMetaData[] parameterMetaDataArray) {
        this(string, string2, string3);
        this.setMetaData(parameterMetaDataArray);
    }

    public SQLAdapter(String string, String string2, String string3, ParameterMetaData[] parameterMetaDataArray, String[] stringArray) {
        this(string, string2, string3, parameterMetaDataArray);
        this.setColumns(stringArray);
    }

    public synchronized void execute() throws SQLException {
        boolean bl = false;
        this.fireBeforeExecute(new SQLAdapterEvent(this, 0, bl));
        try {
            Object object;
            this.closeCurrentResultSet();
            if (this.jdbcConnection == null) {
                object = this.createJdbcConnection();
                this.setJdbcConnection((JdbcConnection)object);
            }
            if (this.jdbcConnection.isConnectionClosed()) {
                this.jdbcConnection.connect();
            }
            this.checkMetaData();
            this.createStatement();
            this.registerOutParameters();
            this.setInParameters();
            logWindow.displayMsgToLog("SQL", this.createDisplaySQL());
            if (this.statement instanceof PreparedStatement) {
                object = (PreparedStatement)this.statement;
                bl = object.execute();
            } else {
                bl = this.statement.execute(this.sqlText);
            }
            if (bl) {
                this.currentResultSet = this.statement.getResultSet();
                this.resultSetCached = true;
            }
            if (this.metaData != null && this.metaData.length > 0) {
                int n = this.metaData.length;
                int n2 = 0;
                while (n2 < n) {
                    ParameterMetaData parameterMetaData = this.metaData[n2];
                    int n3 = parameterMetaData.getType();
                    if (n3 == 2 || n3 == 4 || n3 == 5) {
                        Object object2 = this.getOutParameter(parameterMetaData.getIndex(), parameterMetaData.getDataType(), parameterMetaData.getScale());
                        this.setValues(n2, object2);
                    }
                    ++n2;
                }
                this.triggerUI();
            }
        }
        catch (SQLException sQLException) {
            logWindow.displayMsgToLog(sQLException.getClass().getName(), sQLException.getMessage());
            throw sQLException;
        }
        this.fireAfterExecute(new SQLAdapterEvent(this, 1, bl));
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        try {
            if (!this.resultSetCached) {
                this.currentResultSet = this.statement.getResultSet();
            }
            return this.currentResultSet;
        }
        catch (SQLException sQLException) {
            logWindow.displayMsgToLog(sQLException.getClass().getName(), sQLException.getMessage());
            throw sQLException;
        }
    }

    public synchronized int getUpdateCount() throws SQLException {
        try {
            return this.statement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            logWindow.displayMsgToLog(sQLException.getClass().getName(), sQLException.getMessage());
            throw sQLException;
        }
    }

    public synchronized boolean getMoreResults() throws SQLException {
        try {
            this.resultSetCached = false;
            return this.statement.getMoreResults();
        }
        catch (SQLException sQLException) {
            logWindow.displayMsgToLog(sQLException.getClass().getName(), sQLException.getMessage());
            throw sQLException;
        }
    }

    public synchronized void close() {
        this.closeStatement();
        if (this.connectionManager != null && this.jdbcConnection != null) {
            this.connectionManager.releaseConnection(this.jdbcConnection.getIdentifier());
        }
        this.jdbcConnection = null;
        this.connectionManager = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized int getQuestionmarksCount() {
        int n = 0;
        if (this.sqlText != null && this.sqlText.length() > 0) {
            int n2 = this.sqlText.length();
            int n3 = 0;
            while (n3 < n2) {
                if (this.sqlText.charAt(n3) == '?') {
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    protected synchronized String createDisplaySQL() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.sqlText != null && this.sqlText.length() > 0) {
                int n = this.sqlText.length();
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    char c = this.sqlText.charAt(n3);
                    if (c == '?') {
                        ++n2;
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < this.metaData.length) {
                            if (n2 == this.metaData[n5].getIndex()) {
                                n4 = n5;
                            }
                            ++n5;
                        }
                        int n6 = this.metaData[n4].getType();
                        if (n6 == 1 || n6 == 2) {
                            Object object = this.getValues(n4);
                            if (object == null) {
                                stringBuffer.append("<null>");
                            } else {
                                stringBuffer.append(object.toString());
                            }
                        } else {
                            stringBuffer.append(c);
                        }
                    } else {
                        stringBuffer.append(c);
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public synchronized void closeStatement() {
        this.closeCurrentResultSet();
        if (this.statement != null) {
            if (this.jdbcConnection != null) {
                this.jdbcConnection.closeStatement(this.statement);
            } else {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {
                    System.err.println(sQLException);
                }
            }
        }
        this.statement = null;
        this.outParametersRegistered = false;
    }

    public synchronized void closeCurrentResultSet() {
        if (this.currentResultSet != null) {
            try {
                this.currentResultSet.close();
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
            }
        }
        this.currentResultSet = null;
        this.resultSetCached = false;
    }

    protected synchronized void registerOutParameters() throws SQLException {
        if (this.outParametersRegistered) {
            return;
        }
        if (this.metaData == null || this.metaData.length == 0) {
            this.outParametersRegistered = true;
            return;
        }
        int n = 0;
        while (n < this.metaData.length) {
            ParameterMetaData parameterMetaData = this.metaData[n];
            int n2 = parameterMetaData.getType();
            if (n2 == 2 || n2 == 4 || n2 == 5) {
                CallableStatement callableStatement = (CallableStatement)this.statement;
                int n3 = parameterMetaData.getDataType();
                switch (n3) {
                    case 2: 
                    case 3: {
                        callableStatement.registerOutParameter(parameterMetaData.getIndex(), n3, parameterMetaData.getScale());
                        break;
                    }
                    default: {
                        callableStatement.registerOutParameter(parameterMetaData.getIndex(), n3);
                        break;
                    }
                }
            }
            ++n;
        }
        this.outParametersRegistered = true;
    }

    protected synchronized void setInParameters() throws SQLException {
        if (this.metaData != null) {
            int n = this.metaData.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterMetaData parameterMetaData = this.metaData[n2];
                int n3 = parameterMetaData.getType();
                if (n3 == 1 || n3 == 2) {
                    int n4 = parameterMetaData.getIndex();
                    Object object = this.getValue(0, n4 - 1);
                    this.setInParameter(n4, parameterMetaData.getDataType(), object, parameterMetaData.getScale());
                }
                ++n2;
            }
        }
    }

    protected synchronized void setInParameter(int n, int n2, Object object, int n3) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.statement;
        PreparedStatementHelper.setInParameter(preparedStatement, n, n2, object, n3);
    }

    protected synchronized Object getOutParameter(int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement = (CallableStatement)this.statement;
        return SQLAdapter.getOutParameter(callableStatement, n, n2, n3);
    }

    protected void registerOnDataBus() {
        this.bindName = this.createBindName();
        if (this.bindName != null) {
            MediatorDS mediatorDS = new MediatorDS();
            this.setMediatorDS(mediatorDS);
            this.setDataBinding(this.bindName);
            this.triggerUI();
        }
    }

    public Name createBindName() {
        Name name = null;
        String string = this.getParamNamesList();
        if (string != null && string.length() > 0) {
            name = new Name(this.aliasName, string);
        }
        return name;
    }

    protected String getParamNamesList() {
        if (this.metaData != null && this.metaData.length > 0) {
            ParameterMetaData parameterMetaData;
            int n = this.metaData.length;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n - 1) {
                parameterMetaData = this.metaData[n2];
                stringBuffer.append(parameterMetaData.getName());
                stringBuffer.append(",");
                ++n2;
            }
            parameterMetaData = this.metaData[n - 1];
            stringBuffer.append(parameterMetaData.getName());
            return stringBuffer.toString();
        }
        return null;
    }

    protected synchronized void createStatement() throws SQLAdapterException, SQLException {
        if (this.statement != null) {
            return;
        }
        if (this.jdbcConnection == null) {
            throw new SQLAdapterException(MyResource.getString("There is no JdbcConnection"), 4);
        }
        if (this.sqlText == null || this.sqlText.length() == 0) {
            throw new SQLAdapterException(MyResource.getString("There is no SQL text"), 7);
        }
        if (this.jdbcConnection.isConnectionClosed()) {
            this.jdbcConnection.connect();
        }
        this.statement = this.jdbcConnection.prepareCall(this.sqlText);
        this.outParametersRegistered = false;
    }

    protected synchronized void checkMetaData() throws SQLAdapterException {
        if (Beans.isDesignTime()) {
            return;
        }
        if (this.metaDataChecked) {
            return;
        }
        try {
            int n = this.getQuestionmarksCount();
            if (n == 0) {
                if (this.metaData != null && this.metaData.length != 0) {
                    throw new SQLAdapterException(MyResource.getString("The number of '?' in the SQL text does not match the number of parameters in the meta data"), 5);
                }
                int n2 = SQLAdapter.areColumnNamesSupported(this.columns);
                if (n2 != -1) {
                    throw new SQLAdapterException(String.valueOf(MyResource.getString("The name of a ResultSet column is not supported (not a Java identifier). The column index is: ")) + n2, 12);
                }
                if (!SQLAdapter.areColumnNamesUnique(this.columns)) {
                    throw new SQLAdapterException(MyResource.getString("The ResultSet column names must be unique."), 14);
                }
            } else {
                int n3;
                if (n != this.metaData.length) {
                    throw new SQLAdapterException(MyResource.getString("The number of '?' in the SQL text does not match the number of parameters in the meta data"), 5);
                }
                boolean[] blArray = new boolean[this.metaData.length];
                int n4 = 0;
                while (n4 < this.metaData.length) {
                    if (this.metaData[n4].getIndex() > this.metaData.length) {
                        throw new SQLAdapterException(MyResource.getString("There is a parameter with an index greater than the total number of parameters"), 10);
                    }
                    blArray[this.metaData[n4].getIndex() - 1] = true;
                    this.metaData[n4].checkType();
                    ++n4;
                }
                int n5 = 0;
                while (n5 < this.metaData.length) {
                    if (!blArray[n5]) {
                        throw new SQLAdapterException(String.valueOf(MyResource.getString("There is no metadata for the parameter with index: ")) + Integer.toString(n5), 6);
                    }
                    ++n5;
                }
                if (this.metaData.length > 1) {
                    n3 = 0;
                    while (n3 < this.metaData.length - 1) {
                        ParameterMetaData parameterMetaData = this.metaData[n3];
                        int n6 = n3 + 1;
                        while (n6 < this.metaData.length) {
                            ParameterMetaData parameterMetaData2 = this.metaData[n6];
                            if (parameterMetaData.getIndex() == parameterMetaData2.getIndex()) {
                                throw new SQLAdapterException(MyResource.getString("Duplicated parameter's indeces"), 9);
                            }
                            ++n6;
                        }
                        ++n3;
                    }
                }
                if ((n3 = SQLAdapter.areParamNamesSupported(this.metaData)) != -1) {
                    throw new SQLAdapterException(String.valueOf(MyResource.getString("The name of a parameter is not supported (not a Java identifier). The parameter index is: ")) + this.metaData[n3].getIndex(), 11);
                }
                if (!SQLAdapter.areParamNamesUnique(this.metaData)) {
                    throw new SQLAdapterException(MyResource.getString("The parameter names must be unique."), 13);
                }
                int n7 = SQLAdapter.areColumnNamesSupported(this.columns);
                if (n7 != -1) {
                    throw new SQLAdapterException(String.valueOf(MyResource.getString("The name of a ResultSet column is not supported (not a Java identifier). The column index is: ")) + n7, 12);
                }
                if (!SQLAdapter.areColumnNamesUnique(this.columns)) {
                    throw new SQLAdapterException(MyResource.getString("The ResultSet column names must be unique."), 14);
                }
            }
        }
        catch (SQLAdapterException sQLAdapterException) {
            logWindow.displayMsgToLog(sQLAdapterException.getClass().getName(), sQLAdapterException.getMessage());
            throw sQLAdapterException;
        }
        this.metaDataChecked = true;
    }

    protected JdbcConnection createJdbcConnection() throws SQLException {
        if (this.connectionManager == null) {
            ConnectionManager connectionManager = ConnectionManager.getManager(this.connectionManagerClassName);
            this.setConnectionManager(connectionManager);
        }
        return this.connectionManager.getConnectionBean(this.connectionName);
    }

    protected void prepareAndExecute() throws SQLAdapterException, SQLException {
        this.checkMetaData();
        this.registerOnDataBus();
        this.triggerUI();
        if (this.autoStart) {
            this.execute();
        }
    }

    public synchronized void addSQLAdapterEventListener(SQLAdapterEventListener sQLAdapterEventListener) {
        if (this.listenersSQLAdapterEvent == null) {
            this.listenersSQLAdapterEvent = new Vector();
        }
        this.listenersSQLAdapterEvent.addElement(sQLAdapterEventListener);
    }

    public synchronized void removeSQLAdapterEventListener(SQLAdapterEventListener sQLAdapterEventListener) {
        if (this.listenersSQLAdapterEvent == null) {
            return;
        }
        this.listenersSQLAdapterEvent.removeElement(sQLAdapterEventListener);
    }

    public void fireAfterExecute(SQLAdapterEvent sQLAdapterEvent) {
        Vector vector;
        SQLAdapter sQLAdapter = this;
        synchronized (sQLAdapter) {
            if (this.listenersSQLAdapterEvent == null) {
                Object var4_4 = null;
                return;
            }
            vector = (Vector)this.listenersSQLAdapterEvent.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            SQLAdapterEventListener sQLAdapterEventListener = (SQLAdapterEventListener)vector.elementAt(n);
            sQLAdapterEventListener.afterExecute(sQLAdapterEvent);
            ++n;
        }
    }

    public void fireBeforeExecute(SQLAdapterEvent sQLAdapterEvent) {
        Vector vector;
        SQLAdapter sQLAdapter = this;
        synchronized (sQLAdapter) {
            if (this.listenersSQLAdapterEvent == null) {
                Object var4_4 = null;
                return;
            }
            vector = (Vector)this.listenersSQLAdapterEvent.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            SQLAdapterEventListener sQLAdapterEventListener = (SQLAdapterEventListener)vector.elementAt(n);
            sQLAdapterEventListener.beforeExecute(sQLAdapterEvent);
            ++n;
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public static ParameterMetaData[] getParamsMetaData(ParameterMetaData[] parameterMetaDataArray) {
        Object[] objectArray = new ParameterMetaData[]{};
        if (parameterMetaDataArray != null && parameterMetaDataArray.length > 0) {
            Vector<ParameterMetaData> vector = new Vector<ParameterMetaData>();
            int n = 0;
            while (n < parameterMetaDataArray.length) {
                if (parameterMetaDataArray[n].getType() != 3) {
                    vector.addElement(parameterMetaDataArray[n]);
                }
                ++n;
            }
            objectArray = new ParameterMetaData[vector.size()];
            if (objectArray.length > 0) {
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    public static ParameterMetaData[] getInParamsMetaData(ParameterMetaData[] parameterMetaDataArray) {
        Object[] objectArray = new ParameterMetaData[]{};
        if (parameterMetaDataArray != null && parameterMetaDataArray.length > 0) {
            Vector<ParameterMetaData> vector = new Vector<ParameterMetaData>();
            int n = 0;
            while (n < parameterMetaDataArray.length) {
                int n2 = parameterMetaDataArray[n].getType();
                if (n2 == 1 || n2 == 2) {
                    vector.addElement(parameterMetaDataArray[n]);
                }
                ++n;
            }
            objectArray = new ParameterMetaData[vector.size()];
            if (objectArray.length > 0) {
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    public static ParameterMetaData[] getRSColumnsMetaData(ParameterMetaData[] parameterMetaDataArray) {
        Object[] objectArray = new ParameterMetaData[]{};
        if (parameterMetaDataArray != null && parameterMetaDataArray.length > 0) {
            Vector<ParameterMetaData> vector = new Vector<ParameterMetaData>();
            int n = 0;
            while (n < parameterMetaDataArray.length) {
                if (parameterMetaDataArray[n].getType() == 3) {
                    vector.addElement(parameterMetaDataArray[n]);
                }
                ++n;
            }
            objectArray = new ParameterMetaData[vector.size()];
            if (objectArray.length > 0) {
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    public static ParameterMetaData[] createRSColumnsMetaData(String[] stringArray) {
        if (stringArray == null) {
            return new ParameterMetaData[0];
        }
        ParameterMetaData[] parameterMetaDataArray = new ParameterMetaData[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            parameterMetaDataArray[n] = new ParameterMetaData(stringArray[n], n + 1, 3, 1111, 0, null);
            ++n;
        }
        return parameterMetaDataArray;
    }

    public static Object getOutParameter(CallableStatement callableStatement, int n, int n2, int n3) throws SQLException {
        Object object = null;
        CallableStatement callableStatement2 = callableStatement;
        synchronized (callableStatement2) {
            switch (n2) {
                case -7: {
                    boolean bl = callableStatement.getBoolean(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = new Boolean(bl);
                    break;
                }
                case -6: {
                    byte by = callableStatement.getByte(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = new Byte(by);
                    break;
                }
                case 5: {
                    short s = callableStatement.getShort(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = new Short(s);
                    break;
                }
                case 4: {
                    int n4 = callableStatement.getInt(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = new Integer(n4);
                    break;
                }
                case -5: {
                    long l = callableStatement.getLong(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = new Long(l);
                    break;
                }
                case 6: 
                case 7: {
                    float f = callableStatement.getFloat(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = new Float(f);
                    break;
                }
                case 8: {
                    double d = callableStatement.getDouble(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = new Double(d);
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = callableStatement.getBigDecimal(n, n3);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = bigDecimal;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String string = callableStatement.getString(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = string;
                    break;
                }
                case 91: {
                    Date date = callableStatement.getDate(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = date;
                    break;
                }
                case 92: {
                    Time time = callableStatement.getTime(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = time;
                    break;
                }
                case 93: {
                    Timestamp timestamp = callableStatement.getTimestamp(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = timestamp;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray = callableStatement.getBytes(n);
                    if (callableStatement.wasNull()) {
                        object = null;
                        break;
                    }
                    object = byArray;
                    break;
                }
                case 0: {
                    object = null;
                    break;
                }
                default: {
                    object = callableStatement.getObject(n);
                    if (!callableStatement.wasNull()) break;
                    object = null;
                    break;
                }
            }
        }
        return object;
    }

    public static boolean areParamNamesUnique(ParameterMetaData[] parameterMetaDataArray) {
        boolean bl = true;
        if (parameterMetaDataArray == null || parameterMetaDataArray.length == 0) {
            bl = true;
            return true;
        }
        int n = 0;
        while (n < parameterMetaDataArray.length) {
            if (parameterMetaDataArray[n].getName() == null || parameterMetaDataArray[n].getName().length() == 0) {
                bl = false;
                return false;
            }
            ++n;
        }
        int n2 = 0;
        block1: while (n2 < parameterMetaDataArray.length - 1) {
            int n3 = n2 + 1;
            while (n3 < parameterMetaDataArray.length) {
                if (parameterMetaDataArray[n2].getName().equals(parameterMetaDataArray[n3].getName())) {
                    bl = false;
                    break block1;
                }
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    public static int areParamNamesSupported(ParameterMetaData[] parameterMetaDataArray) {
        if (parameterMetaDataArray == null || parameterMetaDataArray.length == 0) {
            return -1;
        }
        int n = 0;
        while (n < parameterMetaDataArray.length) {
            if (!SQLAdapter.isJavaIdentifier(parameterMetaDataArray[n].getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void setSupportedParamNames(ParameterMetaData[] parameterMetaDataArray) {
        if (parameterMetaDataArray != null) {
            int n = 0;
            while (n < parameterMetaDataArray.length) {
                String string = SQLAdapter.createJavaIdentifier(parameterMetaDataArray[n].getName());
                parameterMetaDataArray[n].setName(string);
                ++n;
            }
        }
    }

    public static boolean areColumnNamesUnique(String[] stringArray) {
        boolean bl = true;
        if (stringArray == null || stringArray.length == 0) {
            return bl;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                bl = false;
                return bl;
            }
            ++n;
        }
        int n2 = 0;
        block1: while (n2 < stringArray.length - 1) {
            int n3 = n2 + 1;
            while (n3 < stringArray.length) {
                if (stringArray[n2].equals(stringArray[n3])) {
                    bl = false;
                    break block1;
                }
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    public static int areColumnNamesSupported(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return -1;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!SQLAdapter.isJavaIdentifier(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void setSupportedColumnNames(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = SQLAdapter.createJavaIdentifier(stringArray[n]);
                ++n;
            }
        }
    }

    public static String getColumnName(int n) {
        String string = "";
        while (n >= 0) {
            string = String.valueOf((char)((char)(n % 26) + 65)) + string;
            n = n / 26 - 1;
        }
        return string;
    }

    public static void setUniqueParamNames(ParameterMetaData[] parameterMetaDataArray) {
        if (parameterMetaDataArray != null) {
            int n = 0;
            while (n < parameterMetaDataArray.length) {
                parameterMetaDataArray[n].setName(SQLAdapter.getColumnName(n));
                ++n;
            }
        }
    }

    public static void setUniqueColumnNames(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = SQLAdapter.getColumnName(n);
                ++n;
            }
        }
    }

    public static boolean isJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = string.length();
        int n2 = 1;
        while (n2 < n) {
            if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String createJavaIdentifier(String string) {
        if (SQLAdapter.isJavaIdentifier(string)) {
            return string;
        }
        StringBuffer stringBuffer = null;
        if (string == null || string.length() == 0) {
            stringBuffer = new StringBuffer(95);
        } else {
            stringBuffer = new StringBuffer();
            if (Character.isJavaIdentifierStart(string.charAt(0))) {
                stringBuffer.append(string.charAt(0));
            } else {
                stringBuffer.append('_');
            }
            int n = string.length();
            int n2 = 1;
            while (n2 < n) {
                if (Character.isJavaIdentifierPart(string.charAt(n2))) {
                    stringBuffer.append(string.charAt(n2));
                } else if (string.charAt(n2 - 1) != '_') {
                    stringBuffer.append('_');
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }
}

