/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.beans.Beans;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.db.beans.binding.Connection;
import symantec.itools.db.beans.binding.PersistentObjectModel;
import symantec.itools.db.beans.binding.Synchronizable;
import symantec.itools.db.beans.jdbc.BaseRecordDefinition;
import symantec.itools.db.beans.jdbc.ColumnMetaData;
import symantec.itools.db.beans.jdbc.DataModel;
import symantec.itools.db.beans.jdbc.JdbcResourceLoader;
import symantec.itools.db.beans.jdbc.ResultSetEnumeration;
import symantec.itools.db.beans.jdbc.ResultSetHelper;
import symantec.itools.db.beans.jdbc.SQLAdapter;

public class SQLRecordDefinition
extends BaseRecordDefinition {
    private static JdbcResourceLoader resourceLoader = JdbcResourceLoader.getInstance();
    private static ResourceBundle MyResource = resourceLoader.getBundle();
    protected SQLAdapter m_SQLAdapter;
    protected boolean debug = false;
    protected static final String CLASS_NAME = "SQLRecordDefinition.";
    protected static final String UNEXPECTED_ERROR = String.valueOf(MyResource.getString("BaseRecordDefinition_Unexpected")) + "SQLRecordDefinition.";
    protected static final String OVERRIDDEN_ERROR = String.valueOf(MyResource.getString("BaseRecordDefinition_Overridden")) + "SQLRecordDefinition.";
    protected static final String NOT_APPLY_ERROR = String.valueOf(MyResource.getString("SQLRecordDefinition_NotApply")) + "SQLRecordDefinition.";
    protected static final String NO_SQL_ERROR = MyResource.getString("SQLRecordDefinition_NoSQL");
    protected static final String NO_RESULT_ERROR = MyResource.getString("SQLRecordDefinition_NoResult");
    protected static final String HELP1 = MyResource.getString("SQLRecordDefinition_Help1");
    protected static final String HELP2 = MyResource.getString("SQLRecordDefinition_Help2");
    protected static final String HELP3 = MyResource.getString("SQLRecordDefinition_Help3");
    protected static final String HELP4 = MyResource.getString("SQLRecordDefinition_Help4");
    protected String m_SQL;

    public synchronized SQLAdapter getSQLAdapter() {
        return this.m_SQLAdapter;
    }

    public synchronized void setSQLAdapter(Object object) {
        this.m_SQLAdapter = (SQLAdapter)object;
    }

    public String getStatement() {
        return this.m_SQL;
    }

    private void setStatement(String string) {
        this.m_SQL = string;
    }

    public synchronized PersistentObjectModel getDataModel() {
        String string = "getDataModel";
        throw new RuntimeException(String.valueOf(OVERRIDDEN_ERROR) + string);
    }

    public synchronized void setDataModel(PersistentObjectModel persistentObjectModel) {
        String string = "setDataModel";
        throw new RuntimeException(String.valueOf(OVERRIDDEN_ERROR) + string);
    }

    public DataModel generateDataModel() throws SQLException {
        String string = "generateDataModel";
        DataModel dataModel = new DataModel();
        try {
            ColumnMetaData columnMetaData;
            int n;
            dataModel.setTableName("SQLAdapter");
            SQLAdapter sQLAdapter = this.getSQLAdapter();
            if (sQLAdapter == null) {
                if (Beans.isDesignTime()) {
                    return dataModel;
                }
                throw new SQLException(NO_SQL_ERROR);
            }
            String[] stringArray = sQLAdapter.getColumns();
            if (stringArray == null || stringArray.length == 0) {
                if (this.debug) {
                    System.out.println("No result columns are selected. Continue processing.");
                }
            } else {
                n = 0;
                while (n < stringArray.length) {
                    columnMetaData = new ColumnMetaData();
                    String string2 = stringArray[n];
                    columnMetaData.setColumnName(string2);
                    dataModel.addColumnMetaData(columnMetaData);
                    ++n;
                }
            }
            if (this.debug) {
                System.out.println(CLASS_NAME + string + ": ");
                n = 0;
                while (n < dataModel.getMemberCount()) {
                    columnMetaData = (ColumnMetaData)dataModel.getMemberModel(n);
                    System.out.print(String.valueOf(columnMetaData.getColumnName()) + " ");
                    System.out.println(columnMetaData.getColumnDataType());
                    ++n;
                }
            }
            this.setDataModel(dataModel);
            return dataModel;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            SQLRecordDefinition sQLRecordDefinition = this;
            sQLRecordDefinition.getClass();
            throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
    }

    public DataModel updateDataModel(ResultSetMetaData resultSetMetaData) throws SQLException {
        String string = "UpdateDataModel";
        DataModel dataModel = (DataModel)this.getDataModel();
        try {
            ColumnMetaData columnMetaData;
            int n;
            int n2 = 0;
            while (n2 < dataModel.getMemberCount()) {
                n = resultSetMetaData.getColumnType(n2 + 1);
                columnMetaData = (ColumnMetaData)dataModel.getMemberModel(n2);
                columnMetaData.setColumnDataType(n);
                ++n2;
            }
            if (this.debug) {
                System.out.println(CLASS_NAME + string + ": ");
                n = 0;
                while (n < dataModel.getMemberCount()) {
                    columnMetaData = (ColumnMetaData)dataModel.getMemberModel(n);
                    System.out.print(String.valueOf(columnMetaData.getColumnName()) + " ");
                    System.out.println(columnMetaData.getColumnDataType());
                    ++n;
                }
            }
            this.setDataModel(dataModel);
            return dataModel;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            SQLRecordDefinition sQLRecordDefinition = this;
            sQLRecordDefinition.getClass();
            throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
    }

    public void executeSQLAdapter() throws SQLException {
        String string = "executeSQLAdapter";
        try {
            SQLAdapter sQLAdapter = this.getSQLAdapter();
            if (sQLAdapter == null) {
                throw new SQLException(NO_SQL_ERROR);
            }
            this.setStatement(sQLAdapter.getSQLText());
            if (this.debug) {
                System.out.println("call SQLAdapter.execute");
            }
            sQLAdapter.execute();
            if (this.debug) {
                System.out.println("return from SQLAdapter.execute");
                return;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            SQLRecordDefinition sQLRecordDefinition = this;
            sQLRecordDefinition.getClass();
            throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
    }

    public Enumeration getSQLAdapterResultSet() throws SQLException {
        String string = "getSQLAdapterResultSet";
        ResultSet resultSet = null;
        Enumeration enumeration = null;
        try {
            SQLAdapter sQLAdapter = this.getSQLAdapter();
            if (sQLAdapter == null) {
                throw new SQLException(NO_SQL_ERROR);
            }
            this.setStatement(sQLAdapter.getSQLText());
            resultSet = sQLAdapter.getResultSet();
            enumeration = this.resultSetToEnum(resultSet);
            return enumeration;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            SQLRecordDefinition sQLRecordDefinition = this;
            sQLRecordDefinition.getClass();
            throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
    }

    Enumeration resultSetToEnum(ResultSet resultSet) throws SQLException {
        String string = "resultSetToEnum";
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.updateDataModel(resultSetMetaData);
            ResultSetEnumeration resultSetEnumeration = new ResultSetEnumeration(resultSet, resultSetMetaData, this.getClass(), this.getDataModel().getModelName());
            return resultSetEnumeration;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            SQLRecordDefinition sQLRecordDefinition = this;
            sQLRecordDefinition.getClass();
            throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
    }

    public Connection getConnection() {
        SQLAdapter sQLAdapter = null;
        try {
            sQLAdapter = this.getSQLAdapter();
            if (sQLAdapter == null) {
                throw new SQLException(NO_SQL_ERROR);
            }
            return sQLAdapter.getJdbcConnection();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
    }

    protected void errorTreaten(Exception exception, String string) {
        String string2 = "Error in SQLRecordDefinition." + string + ": ";
        System.out.println(string2);
    }

    public void checkQBEValues() {
        String string = "checkQBEValues";
        throw new RuntimeException(String.valueOf(NOT_APPLY_ERROR) + string);
    }

    protected synchronized Object getObjectFromResultSet(int n, ResultSet resultSet) throws SQLException {
        Object object = ResultSetHelper.getObject(resultSet, n);
        return object;
    }

    public void getQBEObjectValues(Vector vector) {
        String string = "getQBEObjectValues";
        throw new RuntimeException(String.valueOf(NOT_APPLY_ERROR) + string);
    }

    public Enumeration querySimilarObjects() {
        String string = "querySimilarObjects";
        throw new RuntimeException(String.valueOf(NOT_APPLY_ERROR) + string);
    }

    public Enumeration querySimilarObjects(String string, String[] stringArray) {
        String string2 = "querySimilarObjects";
        throw new RuntimeException(String.valueOf(NOT_APPLY_ERROR) + string2);
    }

    public Enumeration querySimilarObjects(String string, Synchronizable.JoinRecordList joinRecordList, String[] stringArray) {
        String string2 = "querySimilarObjects";
        throw new RuntimeException(String.valueOf(NOT_APPLY_ERROR) + string2);
    }

    public void setValueAsQBE(int n, Object object, boolean bl) {
        String string = "setValueAsQBE";
        throw new RuntimeException(String.valueOf(NOT_APPLY_ERROR) + string);
    }

    public synchronized int save() {
        int n;
        String string = "save";
        int n2 = 0;
        try {
            n = this.recordState.getOperation();
        }
        catch (BaseRecordDefinition.RecordState.StateException stateException) {
            SQLRecordDefinition sQLRecordDefinition = this;
            sQLRecordDefinition.getClass();
            throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException("The row was found in an invalid state");
        }
        try {
            switch (n) {
                case 14: {
                    n2 = this.insert();
                    break;
                }
                case 16: {
                    n2 = this.delete();
                    break;
                }
                case 15: {
                    n2 = this.update();
                    break;
                }
                case 13: {
                    return n2;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(UNEXPECTED_ERROR) + string);
                }
            }
            this.recordState.reset();
            Enumeration enumeration = this.m_ModifiedValues.elements();
            this.m_OriginalValues = new Vector();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.m_OriginalValues.addElement(e);
            }
            return n2;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            SQLRecordDefinition sQLRecordDefinition = this;
            sQLRecordDefinition.getClass();
            throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(exception.getMessage());
        }
    }

    public int update() {
        String string = "update";
        String string2 = this.getHelp(string);
        this.setStatement("user defined update statement");
        SQLRecordDefinition sQLRecordDefinition = this;
        sQLRecordDefinition.getClass();
        throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(string2);
    }

    public int insert() {
        String string = "insert";
        String string2 = this.getHelp(string);
        this.setStatement("user defined insert statement");
        SQLRecordDefinition sQLRecordDefinition = this;
        sQLRecordDefinition.getClass();
        throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(string2);
    }

    public int delete() {
        String string = "delete";
        String string2 = this.getHelp(string);
        this.setStatement("user defined delete statement");
        SQLRecordDefinition sQLRecordDefinition = this;
        sQLRecordDefinition.getClass();
        throw sQLRecordDefinition.new BaseRecordDefinition.RecordDefinitionException(string2);
    }

    private String getHelp(String string) {
        String string2 = "public int " + string + "()";
        String string3 = String.valueOf(HELP1) + string + HELP2 + string + HELP3 + string2 + HELP4;
        return string3;
    }
}

