/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.qbe;

import java.io.StringReader;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.db.beans.qbe.ParseException;
import symantec.itools.db.beans.qbe.QBEResourceLoader;
import symantec.itools.db.beans.qbe.QBEtoSQLtranslator;
import symantec.itools.db.beans.qbe.QBEtoSQLtranslatorFactory;
import symantec.itools.db.beans.qbe.TokenMgrError;

public class QBExlator {
    private static QBEResourceLoader resourceLoader = QBEResourceLoader.getInstance();
    private static ResourceBundle MyResource = resourceLoader.getBundle();
    public static final int texttype = 0;
    public static final int numbtype = 1;
    public static final int datetype = 2;
    public static final int binarytype = 3;
    public static final int eEngNull = 0;
    public static final int eEngSQLAnywhere = 1;
    public static final int eEngMSAccess = 2;
    public static final int eEngMSSQLServer = 3;
    public static final int eEngSybase = 4;
    public static final int eEngOracle = 5;
    public static final int eEngInformix = 6;
    public static final int eEngPointbase = 7;
    static QBEtoSQLtranslator _parser = null;
    static int _engine;
    private static boolean debug;

    public QBExlator() {
        this.init();
    }

    public static String xlatField(String string, String string2) throws QBExlatException {
        String string3 = string;
        if (string3.length() != 0) {
            string3 = String.valueOf(string3) + "\n";
            StringReader stringReader = new StringReader(string3);
            try {
                string3 = _parser.main(stringReader, string2);
            }
            catch (ParseException parseException) {
                QBExlatException qBExlatException = new QBExlatException(String.valueOf(MyResource.getString("QBExlator_SYNTAXERROR")) + parseException.getMessage());
                throw qBExlatException;
            }
            catch (TokenMgrError tokenMgrError) {
                QBExlatException qBExlatException = new QBExlatException(tokenMgrError.getMessage());
                throw qBExlatException;
            }
        }
        return string3;
    }

    public String xlatForm(Vector vector, boolean bl) {
        int n;
        int n2;
        int n3;
        String string = "";
        if (bl) {
            string = String.valueOf(string) + "WHERE ";
        }
        int n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            String string2 = (String)vector.elementAt(n5);
            n3 = string2.indexOf(58);
            n2 = string2.indexOf(58, n3 + 1);
            String string3 = string2.substring(0, n3);
            n = Integer.parseInt(string2.substring(n3 + 1, n2));
            String string4 = String.valueOf(string2.substring(n2 + 1)) + "\n";
            StringReader stringReader = new StringReader(string4);
            try {
                string2 = _parser.main(stringReader, string3);
            }
            catch (ParseException parseException) {
                System.out.println("QBE Parse Error translating form. Entry " + string4 + " " + parseException.getMessage());
                return string;
            }
            if (n5 == 0) {
                string = String.valueOf(string) + "(";
            } else if (n5 > 0) {
                string = String.valueOf(string) + " AND ";
            }
            if (n4 > 1) {
                string = String.valueOf(string) + "(";
            }
            if (QBExlator.getEngine() == 7) {
                string2 = this.fixSQLStringForPointbase(string2, n);
            }
            string = String.valueOf(string) + string2;
            if (n4 > 1) {
                string = String.valueOf(string) + ")";
            }
            ++n5;
        }
        if (n5 > 0) {
            string = String.valueOf(string) + ")";
        }
        int n6 = 0;
        n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == '(') {
                ++n6;
            }
            ++n3;
        }
        n2 = 0;
        int n7 = 0;
        while (n7 < string.length()) {
            if (string.charAt(n7) == ')') {
                ++n2;
            }
            ++n7;
        }
        if (n6 > n2) {
            System.out.println("Fixup performed while parsing form, " + (n6 - n2) + " few right Paranthesis");
            n = 0;
            while (n < n6 - n2) {
                string = String.valueOf(string) + ")";
                ++n;
            }
        }
        if (n2 > n6) {
            System.out.println("Ended up with too many right parens while parsing form.");
        }
        return string;
    }

    public void setEngine(int n) {
        _engine = n;
    }

    public static int getEngine() {
        return _engine;
    }

    public static String getDateDelim() {
        switch (_engine) {
            case 0: {
                return "";
            }
            case 1: {
                return "'";
            }
            case 2: {
                return "#";
            }
            case 3: {
                return "'";
            }
            case 4: {
                return "'";
            }
            case 5: {
                return "'";
            }
            case 6: {
                return "'";
            }
            case 7: {
                return "'";
            }
        }
        return "'";
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        Locale locale = Locale.getDefault();
        return new DecimalFormatSymbols(locale);
    }

    public static char getDecimalSeparator() {
        return QBExlator.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public static char getGroupingSeparator() {
        return QBExlator.getDecimalFormatSymbols().getGroupingSeparator();
    }

    public static char getMinusSign() {
        return QBExlator.getDecimalFormatSymbols().getMinusSign();
    }

    void init() {
        if (_parser == null) {
            QBEtoSQLtranslatorFactory qBEtoSQLtranslatorFactory = new QBEtoSQLtranslatorFactory();
            _parser = qBEtoSQLtranslatorFactory.getQBEtoSQLtranslator();
        }
    }

    private String fixSQLStringForPointbase(String string, int n) {
        String string2 = new String(string);
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = string2.replace('\'', ' ');
                break;
            }
            case 91: {
                string2 = this.insertConstantBeforeString(string, " date ");
                break;
            }
            case 92: {
                string2 = this.insertConstantBeforeString(string, " time ");
                break;
            }
            case 93: {
                string2 = this.insertConstantBeforeString(string, " timestamp ");
                break;
            }
        }
        return string2;
    }

    private String insertConstantBeforeString(String string, String string2) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        int n2 = 0;
        int n3 = string.indexOf("'");
        int n4 = string.indexOf("'", n3 + 1);
        while (n3 > -1 && n4 > -1 && n4 < n) {
            stringBuffer.append(string.substring(n2, n3));
            stringBuffer.append(string2);
            stringBuffer.append(string.substring(n3, n4 + 1));
            n2 = n4 + 1;
            n3 = string.indexOf("'", n2);
            if (n3 <= -1) continue;
            n4 = string.indexOf("'", n3 + 1);
        }
        stringBuffer.append(string.substring(n2, n));
        return stringBuffer.toString();
    }

    public static class QBExlatException
    extends Error {
        public QBExlatException(String string) {
            super(string);
        }
    }
}

