/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.util;

import symantec.itools.db.beans.util.LocalizedValueGenerator;

public class NumberConverter {
    public static final int MAX_PRECISION = 8;
    private int width;
    private int precision = 8;
    private char fmt = (char)102;
    private boolean leading_zeroes;
    private boolean show_plus;
    private boolean alternate = true;
    private boolean show_space;
    private boolean left_align;
    private String pre = "";
    private String post = "";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double atof(String string) {
        int n = 0;
        int n2 = 1;
        double d = 0.0;
        double d2 = 1.0;
        boolean bl = false;
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n < string.length() && string.charAt(n) == '-') {
            n2 = -1;
            ++n;
        } else if (n < string.length() && string.charAt(n) == '+') {
            ++n;
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                if (!bl) {
                    d = d * 10.0 + (double)c - 48.0;
                } else if (bl) {
                    d += (d2 /= 10.0) * (double)(c - 48);
                }
            } else if (c == '.') {
                if (bl) return (double)n2 * d;
                bl = true;
            } else {
                if (c != 'e' && c != 'E') return (double)n2 * d;
                long l = (int)this.parseLong(string.substring(n + 1), 10);
                return (double)n2 * d * Math.pow(10.0, l);
            }
            ++n;
        }
        return (double)n2 * d;
    }

    private long parseLong(String string, int n) {
        int n2 = 0;
        int n3 = 1;
        long l = 0L;
        while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        if (n2 < string.length() && string.charAt(n2) == '-') {
            n3 = -1;
            ++n2;
        } else if (n2 < string.length() && string.charAt(n2) == '+') {
            ++n2;
        }
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c >= '0' && c < 48 + n) {
                l = l * (long)n + (long)c - 48L;
            } else if (c >= 'A' && c < 65 + n - 10) {
                l = l * (long)n + (long)c - 65L + 10L;
            } else if (c >= 'a' && c < 97 + n - 10) {
                l = l * (long)n + (long)c - 97L + 10L;
            } else {
                return l * (long)n3;
            }
            ++n2;
        }
        return l * (long)n3;
    }

    public String form(double d) {
        String string;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int n = 1;
        if (d < 0.0) {
            d = -d;
            n = -1;
        }
        if (this.fmt == 'f') {
            string = this.fixed_format(d);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            string = this.exp_format(d);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    private String fixed_format(double d) {
        String string = "";
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        long l = (long)(this.precision == 0 ? d + 0.5 : d);
        string = String.valueOf(string) + l;
        double d2 = d - (double)l;
        if (d2 >= 1.0 || d2 < 0.0) {
            return this.exp_format(d);
        }
        return String.valueOf(string) + this.frac_part(d2);
    }

    private String exp_format(double d) {
        String string = "";
        int n = 0;
        double d2 = d;
        double d3 = 1.0;
        while (d2 > 10.0) {
            ++n;
            d3 /= 10.0;
            d2 /= 10.0;
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && n >= -4 && n < this.precision) {
            return this.fixed_format(d);
        }
        string = String.valueOf(string) + this.fixed_format(d *= d3);
        string = this.fmt == 'e' || this.fmt == 'g' ? String.valueOf(string) + "e" : String.valueOf(string) + "E";
        String string2 = "000";
        if (n >= 0) {
            string = String.valueOf(string) + "+";
            string2 = String.valueOf(string2) + n;
        } else {
            string = String.valueOf(string) + "-";
            string2 = String.valueOf(string2) + -n;
        }
        return String.valueOf(string) + string2.substring(string2.length() - 3, string2.length());
    }

    private String frac_part(double d) {
        String string = "";
        if (this.precision > 0) {
            double d2 = 1.0;
            String string2 = "";
            int n = 1;
            while (n <= this.precision && d2 <= 9.223372036854776E18) {
                d2 *= 10.0;
                string2 = String.valueOf(string2) + "0";
                ++n;
            }
            long l = (long)(d2 * d + 0.5);
            string = String.valueOf(string2) + l;
            string = string.substring(string.length() - this.precision, string.length());
        }
        if (this.precision > 0 || this.alternate) {
            string = "." + string;
        }
        if (!(this.fmt != 'G' && this.fmt != 'g' || this.alternate)) {
            int n = string.length() - 1;
            string = string.substring(0, n + 1);
        }
        return string;
    }

    private String sign(int n, String string) {
        String string2 = "";
        if (n < 0) {
            string2 = "-";
        } else if (n > 0) {
            if (this.show_plus) {
                string2 = "+";
            } else if (this.show_space) {
                string2 = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && string.length() > 0 && string.charAt(0) != '0') {
            string2 = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            string2 = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            string2 = "0X";
        }
        int n2 = 0;
        if (this.leading_zeroes) {
            n2 = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            n2 = this.precision;
        }
        return String.valueOf(string2) + NumberConverter.repeat('0', n2 - string2.length() - string.length()) + string;
    }

    private String pad(String string) {
        String string2 = NumberConverter.repeat(' ', this.width - string.length());
        string2 = this.left_align ? String.valueOf(this.pre) + string + string2 + this.post : String.valueOf(this.pre) + string2 + string + this.post;
        string2 = LocalizedValueGenerator.formatNumber(string2);
        return string2;
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        NumberConverter numberConverter = new NumberConverter();
        double d = 1.234567899E7;
        String string = numberConverter.form(d);
        System.out.println("Value for: " + d + " is " + string);
        d = 123.4;
        string = numberConverter.form(d);
        System.out.println("Value for: " + d + " is " + string);
        d = 1.234567890123456E15;
        string = numberConverter.form(d);
        System.out.println("Value for: " + d + " is " + string);
        d = 9.000000000000001E-9;
        string = numberConverter.form(d);
        System.out.println("Value for: " + d + " is " + string);
    }
}

