/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.compress;

import symantec.itools.db.compress.CByteBuffer;
import symantec.itools.db.compress.IBitBuffer;
import symantec.itools.db.compress.IByteBuffer;

public class CBitBuffer
implements IBitBuffer {
    private static final int BIT_BUFFER_SIZE = 64;
    private static final int MAX_BITS = 56;
    private static final int BIT_BUFFER_BYTES = 8;
    private static final long BYTE_MASK = 255L;
    private static final long[] BIT_MASKS = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    private IByteBuffer m_bytebuffer;
    private long m_bits;
    private int m_nBitPtr;
    private boolean m_fWrite;

    public CBitBuffer(int n) {
        this.Create(n);
    }

    public CBitBuffer(byte[] byArray) {
        this.Load(byArray);
    }

    public CBitBuffer(CByteBuffer cByteBuffer) {
        this.m_bytebuffer = cByteBuffer;
        this.m_nBitPtr = 0;
        this.m_fWrite = false;
    }

    public void Load(byte[] byArray) {
        this.m_bytebuffer = new CByteBuffer(byArray);
        this.m_nBitPtr = 0;
        this.m_fWrite = false;
    }

    public void Create(int n) {
        this.m_bytebuffer = new CByteBuffer(n);
        this.m_nBitPtr = 0;
        this.m_fWrite = true;
    }

    public void Skip(int n) {
        if (n == 0) {
            return;
        }
        if (this.m_nBitPtr <= n) {
            n -= this.m_nBitPtr;
            this.m_nBitPtr = 0;
            this.LoadBytes();
        }
        if (n != 0) {
            this.m_bits >>>= n;
            this.m_nBitPtr -= n;
        }
    }

    public long Peek(int n) {
        if (n == 0) {
            return 0L;
        }
        if (this.m_nBitPtr < n) {
            this.LoadBytes();
        }
        return this.m_bits & BIT_MASKS[n - 1];
    }

    public long Get(int n) {
        long l = this.Peek(n);
        if (n != 0) {
            this.m_bits >>>= n;
            this.m_nBitPtr -= n;
        }
        return l;
    }

    public void Put(long l, int n) {
        if (n > 64 - this.m_nBitPtr) {
            this.StoreBits(false);
        }
        this.UpdateBits(l, n);
    }

    public void Flush() {
        if (this.m_fWrite && this.m_nBitPtr != 0) {
            this.StoreBits(true);
        }
    }

    public int GetBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.m_nBitPtr != 0) {
            n3 = this.BufferBits(byArray, true);
        }
        n2 = n2 > n3 ? this.m_bytebuffer.Get(byArray, n3, n2 - n3) : 0;
        return n2 + n3;
    }

    public void PutBytes(byte[] byArray, int n, int n2) {
        this.Flush();
        this.m_bytebuffer.Put(byArray, n, n2);
    }

    public int UsedBytes() {
        this.Flush();
        return this.m_bytebuffer.Used();
    }

    public int AvailableBytes() {
        this.Flush();
        return this.m_bytebuffer.Available();
    }

    private void LoadBytes() {
        if (this.m_nBitPtr > 56) {
            return;
        }
        byte[] byArray = this.m_bytebuffer.Get((64 - this.m_nBitPtr) / 8);
        long l = 0L;
        int n = 0;
        while (n < byArray.length) {
            l |= ((long)byArray[n] & 0xFFL) << n * 8;
            ++n;
        }
        this.UpdateBits(l, byArray.length * 8);
    }

    private int BufferBits(byte[] byArray, boolean bl) {
        int n;
        if (bl && (this.m_nBitPtr & 7) != 0) {
            this.m_nBitPtr += 8 - (this.m_nBitPtr & 7);
        }
        if ((n = this.m_nBitPtr / 8) > byArray.length) {
            n = byArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(this.m_bits & 0xFFL);
            this.m_bits >>>= 8;
            this.m_nBitPtr -= 8;
            ++n2;
        }
        return n;
    }

    private void StoreBits(boolean bl) {
        byte[] byArray = new byte[8];
        int n = this.BufferBits(byArray, bl);
        this.m_bytebuffer.Put(byArray, 0, n);
    }

    private void UpdateBits(long l, int n) {
        if (this.m_nBitPtr != 0) {
            this.m_bits &= BIT_MASKS[this.m_nBitPtr - 1];
            this.m_bits |= l << this.m_nBitPtr;
        } else {
            this.m_bits = 0L;
            this.m_bits |= l;
        }
        this.m_nBitPtr += n;
    }
}

