/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.compress;

import symantec.itools.db.compress.CCodeDescriptor;
import symantec.itools.db.compress.CZip;

class CCodeTree {
    private int[] m_anValues = new int[256];
    private byte[] m_abyLengths = new byte[256];
    private int[] m_anTree;
    private int[] m_anNextCode;
    private int[] m_anTempCodes;

    public CCodeTree(int n) {
        if (n > 0) {
            this.m_anTree = new int[n];
        }
        this.m_anNextCode = new int[16];
        this.m_anTempCodes = new int[288];
    }

    public int Value(int n) {
        return this.m_anValues[n];
    }

    public byte Length(int n) {
        return this.m_abyLengths[n];
    }

    public void Build(CCodeDescriptor cCodeDescriptor, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (n == 0) {
            return;
        }
        --n;
        int n7 = 0;
        this.m_anNextCode[0] = 0;
        n7 = 0;
        while (n7 < 15) {
            this.m_anNextCode[n7 + 1] = (this.m_anNextCode[n7] + cCodeDescriptor.Counts(n7)) * 2 & 0xFFFF;
            ++n7;
        }
        if (this.m_anNextCode[n7] != 0) {
            n6 = 0;
            n5 = 0;
            while (n5 < 15) {
                n6 += cCodeDescriptor.Counts(n5);
                ++n5;
            }
            if (n6 > 1) {
                return;
            }
        }
        CZip.ClearArray(this.m_anValues, 0, this.m_anValues.length);
        CZip.ClearArray(this.m_abyLengths, 0, this.m_abyLengths.length);
        CZip.ClearArray(this.m_anTempCodes, 0, n + 1);
        n6 = 0;
        n5 = 0;
        int n8 = n;
        do {
            n4 = cCodeDescriptor.Length(n5);
            ++n5;
            if (n4 == 0) continue;
            n4 = (byte)(n4 - 1);
            n3 = this.m_anNextCode[n4];
            int n9 = n4;
            this.m_anNextCode[n9] = this.m_anNextCode[n9] + 1;
            n2 = 0;
            do {
                n2 <<= 1;
                n2 |= n3 & 1;
                n3 >>>= 1;
            } while ((n4 = (byte)(n4 - 1)) >= 0);
            this.m_anTempCodes[n6] = n2;
            ++n6;
        } while (--n8 >= 0);
        n4 = 0;
        do {
            if ((n3 = (int)cCodeDescriptor.Length(--n5)) == 0) continue;
            n2 = this.m_anTempCodes[--n6];
            int n10 = n2 & 0xFF;
            int n11 = 0;
            if (n3 < 9) {
                n11 = 1 << n3;
                do {
                    this.m_abyLengths[n10] = n3;
                    this.m_anValues[n10] = n;
                } while ((n10 += n11) < 256);
                continue;
            }
            n3 = (byte)(n3 - 8);
            int n12 = 0;
            if (this.m_anValues[n10] != 0) {
                n12 = this.m_anValues[n10] & 0xFFFF ^ 0xFFFF;
            } else {
                this.m_anValues[n10] = ~n4 & 0xFFFF;
                n12 = n4;
                this.m_anTree[n4++] = 0;
                this.m_anTree[n4++] = 0;
            }
            if (((n2 >>>= 1) & 0x80) != 0) {
                ++n12;
            }
            n3 = (byte)(n3 - 1);
            while (n3 > 0) {
                if (this.m_anTree[n12] != 0) {
                    n12 = this.m_anTree[n12] & 0xFFFF ^ 0xFFFF;
                } else {
                    this.m_anTree[n12] = ~n4 & 0xFFFF;
                    n12 = n4;
                    this.m_anTree[n4++] = 0;
                    this.m_anTree[n4++] = 0;
                }
                if (((n2 >>>= 1) & 0x80) != 0) {
                    ++n12;
                }
                n3 = (byte)(n3 - 1);
            }
            this.m_anTree[n12] = n;
        } while (--n >= 0);
    }

    public int GetTree(int n, int n2) {
        return this.m_anTree[(~(n | 0xFFFF0001) | n2 & 1) & 0xFFFF];
    }
}

