/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.jdbc;

import java.io.EOFException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import symantec.itools.db.jdbc.CallableStatement;
import symantec.itools.db.jdbc.DatabaseMetaData;
import symantec.itools.db.jdbc.PreparedStatement;
import symantec.itools.db.jdbc.ProxyObject;
import symantec.itools.db.jdbc.Statement;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.SQLServerConnException;
import symantec.itools.db.net.Warning;

public final class Connection
extends ProxyObject
implements java.sql.Connection {
    private String _url;
    private boolean _isClosed;
    ClientSession _session;
    private Vector _statements;
    private Vector _dbmetas;
    private final int METHOD_createStatement = 0;
    private final int METHOD_prepareStatement = 1;
    private final int METHOD_prepareCall = 2;
    private final int METHOD_nativeSQL = 3;
    private final int METHOD_setAutoCommit = 4;
    private final int METHOD_commit = 5;
    private final int METHOD_rollback = 6;
    private final int METHOD_close = 7;
    private final int METHOD_isClosed = 8;
    private final int METHOD_getMetaData = 9;
    private final int METHOD_setReadOnly = 10;
    private final int METHOD_isReadOnly = 11;
    private final int METHOD_setCatalog = 12;
    private final int METHOD_getCatalog = 13;
    private final int METHOD_setTransactionIsolation = 14;
    private final int METHOD_getTransactionIsolation = 15;
    private final int METHOD_getWarnings = 16;
    private final int METHOD_clearWarnings = 17;
    private final int METHOD_getAutoCommit = 18;
    int TRANSACTION_NONE;
    int TRANSACTION_READ_UNCOMMITTED = 1;
    int TRANSACTION_READ_COMMITTED = 2;
    int TRANSACTION_REPEATABLE_READ = 4;
    int TRANSACTION_SERIALIZABLE = 8;

    Connection(int n, ClientSession clientSession, String string) throws SQLException {
        super("SCALEConnection", n, clientSession);
        this._url = string;
        this._session = clientSession;
        this._isClosed = false;
        this._statements = new Vector();
        this._dbmetas = new Vector();
    }

    protected void finalize() {
        try {
            this.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public java.sql.Statement createStatement() throws SQLException {
        Vector vector = this.invokeMethod(0);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            Statement statement = new Statement(netData.getInt(), this.getSession());
            this._statements.addElement(statement);
            return statement;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        Vector vector = this.invokeMethod(1, string);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            PreparedStatement preparedStatement = new PreparedStatement(netData.getInt(), this.getSession());
            this._statements.addElement(preparedStatement);
            return preparedStatement;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public java.sql.CallableStatement prepareCall(String string) throws SQLException {
        Vector vector = this.invokeMethod(2, string);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            CallableStatement callableStatement = new CallableStatement(netData.getInt(), this.getSession());
            this._statements.addElement(callableStatement);
            return callableStatement;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public String nativeSQL(String string) throws SQLException {
        Vector vector = this.invokeMethod(3, string);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.invokeMethod(4, bl);
    }

    public boolean getAutoCommit() throws SQLException {
        Vector vector = this.invokeMethod(18);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void commit() throws SQLException {
        this.invokeMethod(5);
    }

    public void rollback() throws SQLException {
        this.invokeMethod(6);
    }

    public void close() throws SQLException {
        if (!this._isClosed) {
            int n = 0;
            while (n < this._statements.size()) {
                Statement statement = (Statement)this._statements.elementAt(n);
                statement.close();
                ++n;
            }
            this._statements.removeAllElements();
            int n2 = 0;
            while (n2 < this._dbmetas.size()) {
                DatabaseMetaData databaseMetaData = (DatabaseMetaData)this._dbmetas.elementAt(n2);
                databaseMetaData.close();
                ++n2;
            }
            this._dbmetas.removeAllElements();
            this.invokeMethod(7);
            this._session.close();
            this.disable();
            this._isClosed = true;
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            Vector vector = this.invokeMethod(8);
            NetData netData = (NetData)vector.elementAt(0);
            this._isClosed = netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
        catch (SQLServerConnException sQLServerConnException) {
            this._isClosed = true;
        }
        return this._isClosed;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        Vector vector = this.invokeMethod(9);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            DatabaseMetaData databaseMetaData = new DatabaseMetaData(netData.getInt(), this.getSession(), this._url);
            this._dbmetas.addElement(databaseMetaData);
            return databaseMetaData;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.invokeMethod(10, bl);
    }

    public boolean isReadOnly() throws SQLException {
        Vector vector = this.invokeMethod(11);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.invokeMethod(12, string);
    }

    public String getCatalog() throws SQLException {
        Vector vector = this.invokeMethod(13);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.invokeMethod(14, n);
    }

    public int getTransactionIsolation() throws SQLException {
        Vector vector = this.invokeMethod(15);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = null;
        SQLWarning sQLWarning2 = null;
        SQLWarning sQLWarning3 = null;
        Vector vector = this.invokeMethod(16);
        int n = 0;
        while (n < vector.size()) {
            Warning warning = (Warning)vector.elementAt(n);
            sQLWarning2 = warning.toSQLWarning();
            if (sQLWarning == null) {
                sQLWarning = sQLWarning2;
            } else {
                sQLWarning3.setNextWarning(sQLWarning2);
            }
            sQLWarning3 = sQLWarning2;
            ++n;
        }
        return sQLWarning;
    }

    public void clearWarnings() throws SQLException {
        this.invokeMethod(17);
    }
}

