/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.jdbc;

import java.io.EOFException;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import symantec.itools.db.jdbc.Connection;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.RemoteObject;
import symantec.itools.db.net.TextParam;

public final class Driver
implements java.sql.Driver {
    private final int METHOD_connect = 0;

    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        Connection connection;
        StringTokenizer stringTokenizer;
        Vector<TextParam> vector = new Vector<TextParam>();
        ClientSession clientSession = null;
        try {
            stringTokenizer = this.parseURL(string);
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.getMessage());
        }
        Properties properties2 = this.parseSubname(stringTokenizer);
        try {
            vector.addElement(new TextParam(0, properties2.getProperty("engine", "")));
            vector.addElement(new TextParam(0, properties2.getProperty("server", "")));
            vector.addElement(new TextParam(0, properties2.getProperty("database", "")));
            vector.addElement(new TextParam(0, properties.getProperty("user", "")));
            vector.addElement(new TextParam(0, properties.getProperty("password", "")));
            String string2 = properties2.getProperty("host", "");
            int n = Integer.parseInt(properties2.getProperty("port", "0"));
            clientSession = new ClientSession(string2, n, "", true);
            RemoteObject remoteObject = new RemoteObject("SCALEDriver", 0, clientSession);
            int n2 = remoteObject.invokeConstructor(1, vector);
            remoteObject.setObject("SCALEDriver", n2);
            Vector vector2 = remoteObject.invokeMethod(0, vector);
            NetData netData = (NetData)vector2.elementAt(0);
            try {
                connection = new Connection(netData.getInt(), clientSession, string);
            }
            catch (EOFException eOFException) {
                throw new SQLException(eOFException.getMessage());
            }
        }
        catch (Exception exception) {
            if (clientSession != null) {
                clientSession.close();
            }
            throw new SQLException(exception.getMessage());
        }
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        try {
            StringTokenizer stringTokenizer = this.parseURL(string);
            Properties properties = this.parseSubname(stringTokenizer);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[2];
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", null);
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 21;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private StringTokenizer parseURL(String string) throws SQLException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken(":");
            if (!string2.equals("jdbc")) {
                throw new SQLException("Unrecognized protocol.");
            }
            String string3 = stringTokenizer.nextToken(":");
            if (!string3.equals("dbaw")) {
                throw new SQLException("Unrecognized subprotocol.");
            }
            stringTokenizer.nextToken("/");
            String string4 = stringTokenizer.nextToken("");
            return new StringTokenizer(string4);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Invalid URL syntax.");
        }
    }

    private Properties parseSubname(StringTokenizer stringTokenizer) throws SQLException {
        String string;
        String string2;
        String string3;
        Properties properties = new Properties();
        try {
            string3 = stringTokenizer.nextToken(":").substring(2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Invalid subname syntax near <host>");
        }
        try {
            string2 = stringTokenizer.nextToken(":/");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Invalid subname syntax near <port>");
        }
        try {
            string = stringTokenizer.nextToken("/");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Invalid subname syntax near <engine>");
        }
        String string4 = "";
        String string5 = "";
        if (stringTokenizer.hasMoreTokens()) {
            try {
                string4 = stringTokenizer.nextToken("/");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SQLException("Invalid subname syntax near <server>");
            }
            string5 = string4;
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    string5 = stringTokenizer.nextToken("/");
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new SQLException("Invalid subname syntax near <database>");
                }
            }
        }
        ((Hashtable)properties).put("host", string3);
        ((Hashtable)properties).put("port", string2);
        ((Hashtable)properties).put("engine", string);
        ((Hashtable)properties).put("server", string4);
        ((Hashtable)properties).put("database", string5);
        return properties;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {}
    }
}

