/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.jdbc;

import java.io.EOFException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import symantec.itools.db.jdbc.ResultSetMetaData;
import symantec.itools.db.net.BinaryInputStream;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.Entity;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetRecord;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.Param;
import symantec.itools.db.net.RemoteObject;
import symantec.itools.db.net.Warning;

public final class ResultSet
implements java.sql.ResultSet {
    private final int METHOD_getStream = 0;
    private final int METHOD_next = 1;
    private final int METHOD_close = 2;
    private final int METHOD_getWarnings = 3;
    private final int METHOD_clearWarnings = 4;
    private final int METHOD_getCursorName = 5;
    private final int METHOD_getMetaData = 6;
    private final int METHOD_validateRows = 7;
    private RemoteObject _remObj;
    private Hashtable _colNames;
    private NetRecord _rec;
    private ClientSession _session;
    private InputStream _stream;
    private Vector _rows;
    private int _firstRow;
    private int _numRowstoRequest;
    private int _curRecNum;
    private boolean _allRowsRead;
    private int _firstValidRow;
    private Vector _validRows;
    private ResultSetMetaData _metadata;
    private boolean _isClosed;
    private boolean _getXXXCalled;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet(Vector vector, ClientSession clientSession) throws SQLException {
        int n;
        Object object;
        block10: {
            block12: {
                ResultSetMetaData resultSetMetaData;
                block11: {
                    block9: {
                        int n2;
                        this.METHOD_next = 1;
                        this.METHOD_close = 2;
                        this.METHOD_getWarnings = 3;
                        this.METHOD_clearWarnings = 4;
                        this.METHOD_getCursorName = 5;
                        this.METHOD_getMetaData = 6;
                        this.METHOD_validateRows = 7;
                        this._rec = null;
                        this._session = clientSession;
                        this._stream = null;
                        this._isClosed = false;
                        this._rows = null;
                        this._validRows = null;
                        this._metadata = null;
                        this._colNames = null;
                        this._getXXXCalled = false;
                        NetData netData = (NetData)vector.elementAt(0);
                        try {
                            n2 = netData.getInt();
                        }
                        catch (EOFException eOFException) {
                            throw new SQLException(eOFException.getMessage());
                        }
                        this._remObj = new RemoteObject("ProxyJDBCResultSet", n2, clientSession);
                        if (vector.size() > 1) break block9;
                        this._isClosed = true;
                        break block10;
                    }
                    object = (Entity)vector.elementAt(1);
                    this._metadata = new ResultSetMetaData((Entity)object);
                    this._colNames = new Hashtable();
                    n = 1;
                    if (!true) break block11;
                    resultSetMetaData = this._metadata;
                    if (n > resultSetMetaData._entity.getColumnCount()) break block12;
                }
                do {
                    resultSetMetaData = this._metadata;
                    this._colNames.put(resultSetMetaData._entity.getColumnName(n), new Integer(n));
                    ++n;
                    resultSetMetaData = this._metadata;
                } while (n <= resultSetMetaData._entity.getColumnCount());
            }
            this._rows = new Vector();
            this._validRows = new Vector();
            this._firstRow = 0;
            this._firstValidRow = 0;
            this._curRecNum = 0;
            this._allRowsRead = false;
        }
        object = this._metadata;
        if (object == null) {
            this._numRowstoRequest = 0;
        } else {
            n = object.getColumnCount();
            if (n > 0) {
                int n3 = 0;
                int n4 = 1;
                while (n4 <= n) {
                    n3 += object.getColumnDisplaySize(n4) + 20;
                    ++n4;
                }
                this._numRowstoRequest = 4096 / n3;
            }
        }
        if (this._numRowstoRequest == 0) {
            this._numRowstoRequest = 1;
        }
    }

    protected void finalize() {
        try {
            if (!this._isClosed) {
                this._remObj.invokeMethod(2);
                this._remObj.disable();
                this._isClosed = true;
                return;
            }
        }
        catch (SQLException sQLException) {}
    }

    public void closeStream() {
        if (this._stream != null) {
            try {
                this._stream.close();
            }
            catch (Exception exception) {}
            this._stream = null;
        }
        try {
            this._getXXXCalled = true;
            this.fetchRecord().closeStream();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    BinaryInputStream getRemoteStream(int n) throws SQLException {
        if (n < 0 || n > this._colNames.size()) {
            throw new SQLException("Column index is out-of-range: " + n);
        }
        this.closeStream();
        Vector<Param> vector = new Vector<Param>(2);
        vector.addElement(new Param(1, this._curRecNum));
        vector.addElement(new Param(1, n));
        Vector vector2 = this._remObj.invokeMethod(0, vector);
        NetData netData = null;
        try {
            netData = (NetData)vector2.elementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException("Attempting to access an invalid ResultSet");
        }
        try {
            return new BinaryInputStream(netData.getInt(), this._session);
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean wasNull() throws SQLException {
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        return netRecord.wasNull();
    }

    public String getString(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getString(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getString();
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getBoolean(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getBool();
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getByte(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getByte();
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getShort(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getShort();
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getInt(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getInt();
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getLong(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getLong();
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getFloat(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getFloat();
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getDouble(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getDouble();
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getBigDecimal(n, n2);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        String string = binaryInputStream.getString();
        return new BigDecimal(string);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getBytes(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        return binaryInputStream.getBytes();
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getDate(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        String string = binaryInputStream.getString();
        return Date.valueOf(string);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getTime(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        String string = binaryInputStream.getString();
        return Time.valueOf(string);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getTimestamp(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        String string = binaryInputStream.getString();
        return Timestamp.valueOf(string);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getAsciiStream(n);
        }
        return this.getRemoteStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getUnicodeStream(n);
        }
        return this.getRemoteStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getBinaryStream(n);
        }
        return this.getRemoteStream(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public boolean next() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Error: Remote object is closed.");
        }
        if (this._allRowsRead) {
            return false;
        }
        if (this._curRecNum >= this._numRowstoRequest && !this._getXXXCalled) {
            if (this._curRecNum + 1 >= this._firstValidRow && this._curRecNum + 1 < this._firstValidRow + this._validRows.size()) {
                ++this._curRecNum;
                boolean bl = false;
                NetData netData = (NetData)this._validRows.elementAt(this._curRecNum - this._firstValidRow);
                try {
                    bl = netData.getBool();
                }
                catch (EOFException eOFException) {
                    throw new SQLException(eOFException.getMessage());
                }
                if (!bl) {
                    this._allRowsRead = true;
                }
                this._rec = null;
                return bl;
            }
            Vector<Param> vector = new Vector<Param>(2);
            vector.addElement(new Param(1, this._numRowstoRequest * 2));
            vector.addElement(new Param(1, this._curRecNum + 1));
            this._validRows = this._remObj.invokeMethod(7, vector);
            this._firstValidRow = this._curRecNum + 1;
            return this.next();
        }
        this._rec = null;
        ++this._curRecNum;
        this.fetchRecord();
        if (this._allRowsRead) {
            this._rec = null;
        }
        return !this._allRowsRead;
    }

    NetRecord fetchRecord() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Error: Remote object is closed.");
        }
        if (this._rec != null) {
            return this._rec;
        }
        if (this._curRecNum == 0 || this._allRowsRead) {
            throw new SQLException("Error: Invalid Row position.");
        }
        if (this._curRecNum >= this._firstRow && this._curRecNum < this._firstRow + this._rows.size()) {
            this._rec = (NetRecord)this._rows.elementAt(this._curRecNum - this._firstRow);
            this._allRowsRead = this._rec.getState() == 105;
            return this._rec;
        }
        Vector<Param> vector = new Vector<Param>(2);
        vector.addElement(new Param(1, this._numRowstoRequest));
        vector.addElement(new Param(1, this._curRecNum));
        this._rows = this._remObj.invokeMethod(1, vector);
        this._firstRow = this._curRecNum;
        return this.fetchRecord();
    }

    NetRecord getRecord() throws SQLException {
        this._getXXXCalled = true;
        return this.fetchRecord();
    }

    public void close() throws SQLException {
        if (!this._isClosed) {
            this._remObj.invokeMethod(2);
            this._remObj.disable();
            this._isClosed = true;
        }
    }

    public String getCursorName() throws SQLException {
        Vector vector = this._remObj.invokeMethod(5);
        NetString netString = null;
        try {
            netString = (NetString)vector.elementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException("Attempting to access an invalid ResultSet");
        }
        return netString.getString();
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = null;
        SQLWarning sQLWarning2 = null;
        SQLWarning sQLWarning3 = null;
        Vector vector = this._remObj.invokeMethod(3);
        int n = 0;
        while (n < vector.size()) {
            Warning warning = (Warning)vector.elementAt(n);
            sQLWarning2 = warning.toSQLWarning();
            if (sQLWarning == null) {
                sQLWarning = sQLWarning2;
            } else {
                sQLWarning3.setNextWarning(sQLWarning2);
            }
            sQLWarning3 = sQLWarning2;
            ++n;
        }
        return sQLWarning;
    }

    public void clearWarnings() throws SQLException {
        this._remObj.invokeMethod(4);
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return this._metadata;
    }

    public Object getObject(int n) throws SQLException {
        this.closeStream();
        this._getXXXCalled = true;
        NetRecord netRecord = this.fetchRecord();
        if (netRecord.storesData(n)) {
            return netRecord.getObject(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteStream(n);
        if (netRecord.getSQLType(n) == -1) {
            return binaryInputStream.getString();
        }
        return binaryInputStream.getBytes();
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        if (string != null) {
            Integer n = (Integer)this._colNames.get(string);
            if (n != null) {
                return n;
            }
            throw new SQLException("Column not found.");
        }
        throw new SQLException("Invalid parameter: null columnName");
    }
}

