/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import symantec.itools.db.net.BinaryInputStream;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.Field;

abstract class BinaryField
extends Field {
    byte[] _binData;

    BinaryField() {
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        super.read(dataInputStream);
        this._binData = new byte[0];
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new String(this._binData, 0, 0, this._binData.length);
    }

    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return new byte[0];
        }
        return this._binData;
    }

    public InputStream getAsciiStream() throws SQLException {
        return new BinaryInputStream(this._binData);
    }

    public InputStream getUnicodeStream() throws SQLException {
        return new BinaryInputStream(this._binData);
    }

    public InputStream getBinaryStream() throws SQLException {
        return new BinaryInputStream(this._binData);
    }

    public void setString(String string) throws SQLException {
        this._binData = new byte[string.length()];
        string.getBytes(0, string.length() - 1, this._binData, 0);
        this._null = false;
    }

    public void setBytes(byte[] byArray) throws SQLException {
        this._binData = byArray;
        this._null = false;
    }

    public void setStream(InputStream inputStream, int n) throws SQLException {
        if (n < 0 || n > 255) {
            throw new SQLException("Stream length out of range.");
        }
        byte[] byArray = new byte[n];
        try {
            inputStream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        this._binData = byArray;
        this._null = false;
    }

    public void setAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.setStream(inputStream, n);
    }

    public void setUnicodeStream(InputStream inputStream, int n) throws SQLException {
        this.setStream(inputStream, n);
    }

    public void setBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.setStream(inputStream, n);
    }
}

