/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.RemoteObject;

public final class BinaryInputStream
extends InputStream {
    private final int METHOD_getData = 0;
    private final int METHOD_setData = 1;
    private final int METHOD_rewind = 2;
    private RemoteObject proxy;
    private byte[] data;
    private int length;
    private int offset;
    private boolean bClosed;
    private boolean bReadCalled;

    public BinaryInputStream(int n, ClientSession clientSession) throws SQLException {
        this.proxy = new RemoteObject("ProxyStream", n, clientSession);
        this.length = 0;
        this.offset = 0;
        this.bClosed = false;
        this.bReadCalled = false;
        this.proxy.invokeMethod(2);
    }

    public BinaryInputStream(byte[] byArray) throws SQLException {
        this.proxy = null;
        this.data = byArray;
        this.length = byArray.length;
        this.offset = 0;
        this.bClosed = false;
        this.bReadCalled = true;
    }

    public BinaryInputStream(String string) throws SQLException {
        this.proxy = null;
        this.length = string.length();
        this.data = new byte[string.length()];
        string.getBytes(0, string.length() - 1, this.data, 0);
        this.offset = 0;
        this.bClosed = false;
        this.bReadCalled = true;
    }

    public void close() throws IOException {
        this.bClosed = true;
    }

    public int read() throws IOException {
        if (this.bClosed) {
            return -1;
        }
        this.bReadCalled = true;
        if (this.offset >= this.length) {
            try {
                this.data = this.getData();
                this.length = this.data.length;
                if (this.length == 0) {
                    this.bClosed = true;
                    return -1;
                }
                this.offset = 0;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
        return this.data[this.offset++] & 0xFF;
    }

    byte[] getData() throws SQLException {
        byte[] byArray = new byte[]{};
        if (this.proxy == null) {
            return byArray;
        }
        Vector vector = this.proxy.invokeMethod(0);
        NetData netData = (NetData)vector.elementAt(0);
        byArray = netData.getBytes();
        return byArray;
    }

    public int getInt() throws SQLException {
        if (!this.bReadCalled) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        NetData netData = new NetData(this.data);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException("Can't convert data to request format");
        }
    }

    public short getShort() throws SQLException {
        if (!this.bReadCalled) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        NetData netData = new NetData(this.data);
        try {
            return netData.getShort();
        }
        catch (EOFException eOFException) {
            throw new SQLException("Can't convert data to request format");
        }
    }

    public boolean getBool() throws SQLException {
        if (!this.bReadCalled) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        NetData netData = new NetData(this.data);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException("Can't convert data to request format");
        }
    }

    public byte getByte() throws SQLException {
        if (!this.bReadCalled) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        NetData netData = new NetData(this.data);
        try {
            return netData.getByte();
        }
        catch (EOFException eOFException) {
            throw new SQLException("Can't convert data to request format");
        }
    }

    public long getLong() throws SQLException {
        if (!this.bReadCalled) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        NetData netData = new NetData(this.data);
        try {
            return netData.getLong();
        }
        catch (EOFException eOFException) {
            throw new SQLException("Can't convert data to request format");
        }
    }

    public float getFloat() throws SQLException {
        if (!this.bReadCalled) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        NetData netData = new NetData(this.data);
        try {
            return netData.getFloat();
        }
        catch (EOFException eOFException) {
            throw new SQLException("Can't convert data to request format");
        }
    }

    public double getDouble() throws SQLException {
        if (!this.bReadCalled) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        NetData netData = new NetData(this.data);
        try {
            return netData.getDouble();
        }
        catch (EOFException eOFException) {
            throw new SQLException("Can't convert data to request format");
        }
    }

    public byte[] getBytes() throws SQLException {
        byte[] byArray = new byte[]{};
        if (this.bClosed) {
            return byArray;
        }
        this.bReadCalled = true;
        try {
            byte[] byArray2;
            while ((byArray2 = this.getData()).length != 0) {
                if (byArray.length == 0) {
                    byArray = byArray2;
                    continue;
                }
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                byArray = byArray3;
                byArray3 = null;
                byArray2 = null;
            }
            this.bClosed = true;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        return byArray;
    }

    public String getString() throws SQLException {
        byte[] byArray = this.getBytes();
        return new String(byArray, 0, 0, byArray.length);
    }

    public int available() {
        return this.length - this.offset;
    }
}

