/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.Param;
import symantec.itools.db.net.RemoteObject;

public final class BinaryOutputStream
extends OutputStream {
    private final int METHOD_getData = 0;
    private final int METHOD_setData = 1;
    private final int METHOD_rewind = 2;
    private final int METHOD_setNull = 3;
    private RemoteObject proxy;
    private byte[] _data;
    private int offset;
    private boolean bClosed;
    private final int MAX_BUF_SIZE = 4000;

    public BinaryOutputStream(int n, ClientSession clientSession) throws SQLException {
        this.proxy = new RemoteObject("ProxyStream", n, clientSession);
        this._data = new byte[4000];
        this.offset = 0;
        this.bClosed = false;
        this.proxy.invokeMethod(2);
    }

    public void sendData(InputStream inputStream, int n) throws SQLException {
        if (this.bClosed) {
            throw new SQLException("Stream is closed.");
        }
        try {
            this.flush();
            while (n > 4000) {
                inputStream.read(this._data, 0, 4000);
                this.offset = 4000;
                this.flush();
                n -= 4000;
            }
            inputStream.read(this._data, 0, n);
            this.offset = n;
            this.flush();
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void close() throws IOException {
        this.bClosed = true;
    }

    public synchronized void write(int n) throws IOException {
        if (this.bClosed) {
            throw new IOException("Stream is closed.");
        }
        if (this.offset == this._data.length) {
            this.flush();
        }
        this._data[this.offset++] = (byte)n;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.bClosed) {
            throw new IOException("Stream is closed.");
        }
        int n3 = this._data.length - this.offset;
        if (n2 <= n3) {
            System.arraycopy(byArray, n, this._data, this.offset, n2);
            this.offset += n2;
            return;
        }
        this.flush();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, n, n2);
        this.setData(byArray2, n2);
    }

    public synchronized void flush() throws IOException {
        this.setData(this._data, this.offset);
        this.offset = 0;
    }

    void setData(byte[] byArray, int n) throws IOException {
        if (n == 0) {
            return;
        }
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, byArray, n));
        try {
            this.proxy.invokeMethod(1, vector);
            return;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void setNull() throws SQLException {
        this.proxy.invokeMethod(3);
    }

    public void setBytes(byte[] byArray) throws SQLException {
        try {
            this.flush();
            this.setData(byArray, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void setByte(byte by) throws SQLException {
        try {
            this.flush();
            byte[] byArray = new byte[]{by};
            this.setData(byArray, 1);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void setShort(short s) throws SQLException {
        try {
            this.flush();
            NetData netData = new NetData(s);
            byte[] byArray = netData.getBytes();
            this.setData(byArray, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void setBoolean(boolean bl) throws SQLException {
        try {
            this.flush();
            NetData netData = new NetData(bl);
            byte[] byArray = netData.getBytes();
            this.setData(byArray, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void setInt(int n) throws SQLException {
        try {
            this.flush();
            NetData netData = new NetData(n);
            byte[] byArray = netData.getBytes();
            this.setData(byArray, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void setLong(long l) throws SQLException {
        try {
            this.flush();
            NetData netData = new NetData(l);
            byte[] byArray = netData.getBytes();
            this.setData(byArray, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void setFloat(float f) throws SQLException {
        try {
            this.flush();
            NetData netData = new NetData(f);
            byte[] byArray = netData.getBytes();
            this.setData(byArray, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void setDouble(double d) throws SQLException {
        try {
            this.flush();
            NetData netData = new NetData(d);
            byte[] byArray = netData.getBytes();
            this.setData(byArray, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void setString(String string) throws SQLException {
        try {
            this.flush();
            NetData netData = new NetData(string);
            byte[] byArray = netData.getBytes();
            this.setData(byArray, byArray.length);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }
}

