/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NumberField;
import symantec.itools.db.net.ServerObject;

class Bit
extends NumberField {
    boolean _bVal;

    Bit() {
    }

    int getType() {
        return 87;
    }

    void readData(ServerObject serverObject) throws SQLException, IOException, ErrorException {
        this._bVal = ((NetData)serverObject).getBool();
    }

    void writeData(DataOutputStream dataOutputStream) throws IOException {
        NetData netData = new NetData(this._bVal);
        netData.write(dataOutputStream);
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this._bVal);
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this._bVal;
    }

    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        if (this._bVal) {
            return 1;
        }
        return 0;
    }

    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        if (this._bVal) {
            return 1;
        }
        return 0;
    }

    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        if (this._bVal) {
            return 1;
        }
        return 0;
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this._bVal ? 1 : 0;
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this._bVal ? 1 : 0;
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        if (this._bVal) {
            return 1.0;
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal((double)(this._bVal ? 1 : 0));
        return bigDecimal.setScale(n);
    }

    public void setBoolean(boolean bl) throws SQLException {
        this._bVal = bl;
        this._null = false;
    }

    public void setByte(byte by) throws SQLException {
        this._bVal = by != 0;
        this._null = false;
    }

    public void setShort(short s) throws SQLException {
        this._bVal = s != 0;
        this._null = false;
    }

    public void setInt(int n) throws SQLException {
        this._bVal = n != 0;
        this._null = false;
    }

    public void setLong(long l) throws SQLException {
        this._bVal = l != 0L;
        this._null = false;
    }

    public void setFloat(float f) throws SQLException {
        this._bVal = f != 0.0f;
        this._null = false;
    }

    public void setDouble(double d) throws SQLException {
        this._bVal = d != 0.0;
        this._null = false;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this._bVal = bigDecimal.intValue() != 0;
        this._null = false;
    }

    public void setString(String string) throws SQLException {
        Integer n = new Integer(string);
        this._bVal = n != 0;
        this._null = false;
    }

    public int getSQLType() {
        return -7;
    }

    public Object getObject() throws SQLException {
        return new Boolean(this._bVal);
    }

    public void setObject(Object object) throws SQLException {
        this.setBoolean((Boolean)object);
    }
}

