/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import symantec.itools.db.net.BinaryInputStream;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.Field;

abstract class CharField
extends Field {
    String _strVal;

    CharField() {
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        super.read(dataInputStream);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new String(this._strVal);
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        byte by = (byte)this._strVal.charAt(0);
        return by != 0;
    }

    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Double d = new Double(this._strVal);
            return (byte)d.intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Double d = new Double(this._strVal);
            return (short)d.intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Double d = new Double(this._strVal);
            return d.intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            Double d = new Double(this._strVal);
            return d.longValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            Double d = new Double(this._strVal);
            return d.floatValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            Double d = new Double(this._strVal);
            return d;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this._strVal);
        return bigDecimal.setScale(n);
    }

    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return new byte[0];
        }
        try {
            byte[] byArray = new byte[this._strVal.length()];
            this._strVal.getBytes(0, this._strVal.length(), byArray, 0);
            return byArray;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Date getDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return Date.valueOf(this._strVal);
    }

    public Time getTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return Time.valueOf(this._strVal);
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return Timestamp.valueOf(this._strVal);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BinaryInputStream(this._strVal);
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BinaryInputStream(this._strVal);
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BinaryInputStream(this._strVal);
    }

    public void setBoolean(boolean bl) throws SQLException {
        this._strVal = bl ? new String("true") : new String("false");
        this._null = false;
    }

    public void setByte(byte by) throws SQLException {
        this._strVal = Integer.toString(by);
        this._null = false;
    }

    public void setShort(short s) throws SQLException {
        this._strVal = Integer.toString(s);
        this._null = false;
    }

    public void setInt(int n) throws SQLException {
        this._strVal = Integer.toString(n);
        this._null = false;
    }

    public void setLong(long l) throws SQLException {
        this._strVal = Long.toString(l);
        this._null = false;
    }

    public void setFloat(float f) throws SQLException {
        this._strVal = Float.toString(f);
        this._null = false;
    }

    public void setDouble(double d) throws SQLException {
        this._strVal = Double.toString(d);
        this._null = false;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this._strVal = bigDecimal.toString();
        this._null = false;
    }

    public void setString(String string) throws SQLException {
        this._strVal = string;
        this._null = false;
    }

    public void setBytes(byte[] byArray) throws SQLException {
        this._strVal = new String(byArray, 0);
        this._null = false;
    }

    public void setDate(Date date) throws SQLException {
        this._strVal = date.toString();
        this._null = false;
    }

    public void setTime(Time time) throws SQLException {
        this._strVal = time.toString();
        this._null = false;
    }

    public void setTimestamp(Timestamp timestamp) throws SQLException {
        this._strVal = timestamp.toString();
        this._null = false;
    }

    public void setStream(InputStream inputStream, int n) throws SQLException {
        if (n < 0 || n > 255) {
            throw new SQLException("Stream length out of range.");
        }
        byte[] byArray = new byte[n];
        try {
            inputStream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        this._strVal = new String(byArray, 0, 0, byArray.length);
        this._null = false;
    }

    public void setAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.setStream(inputStream, n);
    }

    public void setUnicodeStream(InputStream inputStream, int n) throws SQLException {
        this.setStream(inputStream, n);
    }

    public void setBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.setStream(inputStream, n);
    }
}

