/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.Attribute;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetClass;
import symantec.itools.db.net.ServerList;
import symantec.itools.db.net.ServerObject;

public class Entity
extends ServerObject {
    Vector _attribs = new Vector();
    int _count;
    Vector _attribNames = new Vector();

    int getType() {
        return 64;
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        dataInputStream.readShort();
        this._count = dataInputStream.readShort();
        if (this._count > 0) {
            ServerObject serverObject = (ServerObject)NetClass.getNextObject(dataInputStream);
            if (serverObject.getType() != 54) {
                throw new SQLException("Object Stream error in Entity object");
            }
            this._attribs = ((ServerList)serverObject).getObjVector();
            this._count = this._attribs.size();
            this._attribNames = new Vector(this._count);
            int n = 1;
            while (n <= this._count) {
                this._attribNames.addElement(this.getColumnName(n));
                ++n;
            }
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        throw new IOException("Write not permitted on Entity object");
    }

    Attribute getAttribute(int n) throws SQLException {
        if (n < 1 || n > this._count) {
            throw new SQLException("Column index out of range");
        }
        return (Attribute)this._attribs.elementAt(n - 1);
    }

    public Vector getColumnList() throws SQLException {
        return this._attribNames;
    }

    public int getColumnCount() throws SQLException {
        return this._count;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return this.getAttribute(n).isAutoIncrement();
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return this.getAttribute(n).isCaseSensitive();
    }

    public boolean isSearchable(int n) throws SQLException {
        return this.getAttribute(n).isSearchable();
    }

    public boolean isCurrency(int n) throws SQLException {
        return this.getAttribute(n).isCurrency();
    }

    public int isNullable(int n) throws SQLException {
        return this.getAttribute(n).isNullable();
    }

    public boolean isSigned(int n) throws SQLException {
        return this.getAttribute(n).isSigned();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this.getAttribute(n).getColumnDisplaySize();
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getAttribute(n).getColumnLabel();
    }

    public String getColumnName(int n) throws SQLException {
        return this.getAttribute(n).getColumnName();
    }

    public String getSchemaName(int n) throws SQLException {
        return this.getAttribute(n).getSchemaName();
    }

    public int getPrecision(int n) throws SQLException {
        return this.getAttribute(n).getPrecision();
    }

    public int getScale(int n) throws SQLException {
        return this.getAttribute(n).getScale();
    }

    public String getTableName(int n) throws SQLException {
        return this.getAttribute(n).getTableName();
    }

    public String getCatalogName(int n) throws SQLException {
        return this.getAttribute(n).getCatalogName();
    }

    public int getColumnType(int n) throws SQLException {
        return this.getAttribute(n).getColumnType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.getAttribute(n).getColumnTypeName();
    }

    public boolean isReadOnly(int n) throws SQLException {
        return this.getAttribute(n).isReadOnly();
    }

    public boolean isWritable(int n) throws SQLException {
        return this.getAttribute(n).isWritable();
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.getAttribute(n).isDefinitelyWritable();
    }
}

