/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import symantec.itools.db.net.MPlex;
import symantec.itools.db.net.NetException;
import symantec.itools.db.net.NetOutputStream;
import symantec.itools.db.net.NetPipedInputStream;
import symantec.itools.db.net.NetPipedOutputStream;
import symantec.itools.db.net.SocketIS;
import symantec.itools.db.net.SocketWrapper;
import symantec.itools.db.net.SocketWriter;

class IO {
    SocketWrapper _sock;
    InputStream _userIS;
    OutputStream _readerOS;
    OutputStream _userOS;
    SocketWriter _writer;
    short _id;

    IO(MPlex mPlex, SocketWrapper socketWrapper, short s) throws NetException {
        try {
            this._sock = socketWrapper;
            this._id = s;
            this._userIS = new SocketIS(this._sock.getInputStream(), mPlex);
            this._writer = new SocketWriter(this._sock.getOutputStream());
            this._userOS = new NetOutputStream(this._writer, s);
            return;
        }
        catch (IOException iOException) {
            throw new NetException("Error constructing IO object");
        }
        catch (SQLException sQLException) {
            throw new NetException("Error constructing IO object");
        }
    }

    IO(SocketWriter socketWriter, short s) throws NetException {
        try {
            this._sock = null;
            this._id = s;
            this._userIS = new NetPipedInputStream();
            this._readerOS = new NetPipedOutputStream((NetPipedInputStream)this._userIS);
            this._userOS = new NetOutputStream(socketWriter, s);
            this._writer = socketWriter;
            return;
        }
        catch (IOException iOException) {
            throw new NetException("Error constructing IO object");
        }
    }

    IO(SocketWriter socketWriter, InputStream inputStream, short s) throws NetException {
        this._sock = null;
        this._id = s;
        this._userIS = inputStream;
        this._readerOS = null;
        this._userOS = new NetOutputStream(socketWriter, s);
        this._writer = socketWriter;
    }

    void close() {
        try {
            if (this._sock != null) {
                this._sock.close();
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    InputStream getInputStream() {
        return this._userIS;
    }

    OutputStream getOutputStream() {
        return this._userOS;
    }
}

