/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.NumberField;
import symantec.itools.db.net.ServerObject;

class NetBigDecimal
extends NumberField {
    BigDecimal _bigVal;

    NetBigDecimal() {
    }

    int getType() {
        return 83;
    }

    void readData(ServerObject serverObject) throws SQLException, IOException, ErrorException {
        String string = ((NetString)serverObject).getString();
        this._bigVal = new BigDecimal(string);
    }

    void writeData(DataOutputStream dataOutputStream) throws IOException {
        try {
            NetString netString = new NetString(this.getString());
            netString.write(dataOutputStream);
            return;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this._bigVal.toString();
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        int n = this._bigVal.intValue();
        return n != 0;
    }

    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        int n = this._bigVal.intValue();
        return (byte)n;
    }

    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        int n = this._bigVal.intValue();
        return (short)n;
    }

    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this._bigVal.intValue();
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this._bigVal.longValue();
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this._bigVal.floatValue();
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this._bigVal.doubleValue();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = this._bigVal;
        return bigDecimal.setScale(n);
    }

    public void setBoolean(boolean bl) throws SQLException {
        this._bigVal = bl ? new BigDecimal(1.0) : new BigDecimal(0.0);
        this._null = false;
    }

    public void setByte(byte by) throws SQLException {
        this._bigVal = new BigDecimal((double)by);
        this._null = false;
    }

    public void setShort(short s) throws SQLException {
        this._bigVal = new BigDecimal((double)s);
        this._null = false;
    }

    public void setInt(int n) throws SQLException {
        this._bigVal = new BigDecimal((double)n);
        this._null = false;
    }

    public void setLong(long l) throws SQLException {
        this._bigVal = new BigDecimal((double)l);
        this._null = false;
    }

    public void setFloat(float f) throws SQLException {
        this._bigVal = new BigDecimal(f);
        this._null = false;
    }

    public void setDouble(double d) throws SQLException {
        this._bigVal = new BigDecimal(d);
        this._null = false;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this._bigVal = bigDecimal;
        this._null = false;
    }

    public void setString(String string) throws SQLException {
        this._bigVal = new BigDecimal(string);
        this._null = false;
    }

    public int getSQLType() {
        return 2;
    }

    public Object getObject() throws SQLException {
        return new BigDecimal(this._bigVal.toString());
    }

    public void setObject(Object object) throws SQLException {
        this.setBigDecimal((BigDecimal)object);
    }
}

