/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import symantec.itools.db.net.DateTimeField;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetData;

class NetDate
extends DateTimeField {
    Date _dateVal;

    NetDate() {
    }

    int getType() {
        return 75;
    }

    void readData(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        int n = dataInputStream.readShort();
        n -= 1900;
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        if (!this._null) {
            try {
                this._dateVal = new Date(n, s - 1, s2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._dateVal = new Date(97, 3, 20);
                this._null = true;
                return;
            }
        }
        this._dateVal = new Date(97, 3, 20);
    }

    void writeData(DataOutputStream dataOutputStream) throws IOException {
        if (this._dateVal == null) {
            this._dateVal = new Date(97, 3, 20);
        }
        NetData netData = new NetData((short)(this._dateVal.getYear() + 1900));
        netData.write(dataOutputStream);
        netData = new NetData((short)(this._dateVal.getMonth() + 1));
        netData.write(dataOutputStream);
        netData = new NetData((short)this._dateVal.getDate());
        netData.write(dataOutputStream);
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this._dateVal.toString();
    }

    public Date getDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this._dateVal;
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this._dateVal.getYear(), this._dateVal.getMonth(), this._dateVal.getDate(), 0, 0, 0, 0);
    }

    public void setString(String string) throws SQLException {
        this._dateVal = Date.valueOf(string);
        this._null = false;
    }

    public void setDate(Date date) throws SQLException {
        this._dateVal = date;
        this._null = false;
    }

    public void setTimestamp(Timestamp timestamp) throws SQLException {
        this._dateVal.setYear(timestamp.getYear());
        this._dateVal.setMonth(timestamp.getMonth());
        this._dateVal.setDate(timestamp.getDate());
        this._null = false;
    }

    public int getSQLType() {
        return 91;
    }

    public Object getObject() throws SQLException {
        return this.getDate();
    }

    public void setObject(Object object) throws SQLException {
        this.setDate((Date)object);
    }
}

