/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NumberField;
import symantec.itools.db.net.ServerObject;

class NetFloat
extends NumberField {
    float _fVal;

    NetFloat() {
    }

    int getType() {
        return 81;
    }

    void readData(ServerObject serverObject) throws SQLException, IOException, ErrorException {
        this._fVal = ((NetData)serverObject).getFloat();
    }

    void writeData(DataOutputStream dataOutputStream) throws IOException {
        NetData netData = new NetData(this._fVal);
        netData.write(dataOutputStream);
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this._fVal);
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this._fVal != 0.0f;
    }

    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (byte)this._fVal;
    }

    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (short)this._fVal;
    }

    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (int)this._fVal;
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return (long)this._fVal;
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this._fVal;
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this._fVal;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this._fVal);
        return bigDecimal.setScale(n);
    }

    public void setBoolean(boolean bl) throws SQLException {
        this._fVal = bl ? 1.0f : 0.0f;
        this._null = false;
    }

    public void setByte(byte by) throws SQLException {
        this._fVal = by;
        this._null = false;
    }

    public void setShort(short s) throws SQLException {
        this._fVal = s;
        this._null = false;
    }

    public void setInt(int n) throws SQLException {
        this._fVal = n;
        this._null = false;
    }

    public void setLong(long l) throws SQLException {
        this._fVal = l;
        this._null = false;
    }

    public void setFloat(float f) throws SQLException {
        this._fVal = f;
        this._null = false;
    }

    public void setDouble(double d) throws SQLException {
        this._fVal = (float)d;
        this._null = false;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this._fVal = bigDecimal.floatValue();
        this._null = false;
    }

    public void setString(String string) throws SQLException {
        Float f = new Float(string);
        this._fVal = f.floatValue();
        this._null = false;
    }

    public int getSQLType() {
        return 6;
    }

    public Object getObject() throws SQLException {
        return new Double(this._fVal);
    }

    public void setObject(Object object) throws SQLException {
        this.setDouble((Double)object);
    }
}

