/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import symantec.itools.db.net.NetPipedOutputStream;

class NetPipedInputStream
extends InputStream {
    boolean closed = true;
    boolean connbroken = true;
    Thread readSide;
    Thread writeSide;
    private byte[] buffer = new byte[1024];
    int in = -1;
    int out;

    public NetPipedInputStream(NetPipedOutputStream netPipedOutputStream) throws IOException {
        this.connect(netPipedOutputStream);
    }

    public NetPipedInputStream() {
    }

    public void connect(NetPipedOutputStream netPipedOutputStream) throws IOException {
        netPipedOutputStream.connect(this);
    }

    synchronized void receive(int n) throws IOException {
        int n2 = 5;
        this.writeSide = Thread.currentThread();
        while (this.in == this.out) {
            if (this.readSide != null && !this.readSide.isAlive()) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            if (this.connbroken) {
                throw new IOException("Lost connection to server");
            }
            try {
                if (n2 < 640) {
                    n2 *= 2;
                }
                this.wait(n2);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (byte)(n & 0xFF);
        if (this.in >= this.buffer.length) {
            this.in = 0;
        }
    }

    synchronized void receive(byte[] byArray, int n, int n2) throws IOException {
        while (--n2 >= 0) {
            this.receive(byArray[n++]);
        }
    }

    synchronized void receivedLast() {
        this.closed = true;
        this.notifyAll();
    }

    synchronized void connBroken() {
        this.connbroken = true;
        this.notify();
    }

    public synchronized int read() throws IOException {
        int n = 2;
        int n2 = 5;
        while (this.in < 0) {
            this.readSide = Thread.currentThread();
            if (this.writeSide != null && !this.writeSide.isAlive() && --n < 0) {
                throw new IOException("Pipe broken");
            }
            if (this.closed) {
                return -1;
            }
            if (this.connbroken) {
                throw new IOException("Lost connection to server");
            }
            this.notifyAll();
            try {
                if (n2 < 640) {
                    n2 *= 2;
                }
                this.wait(n2);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        int n3 = this.buffer[this.out++] & 0xFF;
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        if (this.in == this.out) {
            this.in = -1;
        }
        return n3;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 < 0) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        while (this.in >= 0 && --n2 > 0) {
            byArray[n + n4] = this.buffer[this.out++];
            ++n4;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in != this.out) continue;
            this.in = -1;
        }
        return n4;
    }

    public void close() throws IOException {
        this.in = -1;
        this.closed = true;
    }

    public int available() {
        if (this.in < 0) {
            return 0;
        }
        return this.out - this.in;
    }
}

