/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import symantec.itools.db.net.EOT;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.Field;
import symantec.itools.db.net.NetClass;
import symantec.itools.db.net.ServerObject;

public class NetRecord
extends ServerObject {
    int _length = 0;
    byte _state = (byte)105;
    int _rowNum = 0;
    Vector _fields = new Vector();
    Vector _changedFields = new Vector();
    InputStream _stream = null;
    int _lastProj = 1;

    Vector getFields() {
        return this._fields;
    }

    public void setState(byte by) {
        this._state = by;
    }

    public byte getState() {
        return this._state;
    }

    public int getRecordNum() {
        return this._rowNum;
    }

    int getType() {
        return 59;
    }

    public synchronized void copy(NetRecord netRecord) {
        if (this._rowNum == netRecord.getRecordNum()) {
            this._state = netRecord.getState();
            this._fields.removeAllElements();
            this._changedFields.removeAllElements();
            this._fields = netRecord.getFields();
        }
    }

    private void checkState(boolean bl) throws SQLException {
        if (this._state == 105) {
            throw new SQLException("Record is invalid.");
        }
        if (bl) {
            if (this._state == 103) {
                throw new SQLException("Record has been marked for deletion.");
            }
            if (this._state == 104) {
                throw new SQLException("Record has been deleted.");
            }
        }
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        this._length = dataInputStream.readShort();
        this._state = dataInputStream.readByte();
        this._rowNum = dataInputStream.readInt();
        int n = dataInputStream.readShort();
        this._fields = new Vector(n);
        int n2 = 1;
        while (n2 <= n) {
            ServerObject serverObject = (ServerObject)NetClass.getNextObject(dataInputStream);
            if (serverObject.getBaseType() == 57) {
                this._fields.addElement(serverObject);
            } else {
                this.onObjectError(serverObject);
            }
            ++n2;
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        ServerObject serverObject;
        dataOutputStream.writeByte(this.getType());
        dataOutputStream.writeShort(9);
        dataOutputStream.writeBytes("ROW}");
        dataOutputStream.writeByte(this._state);
        dataOutputStream.writeInt(this._rowNum);
        int n = 0;
        while (n < this._changedFields.size()) {
            serverObject = (Field)this._changedFields.elementAt(n);
            ((Field)serverObject).write(dataOutputStream);
            ++n;
        }
        this._changedFields.removeAllElements();
        serverObject = new EOT();
        ((EOT)serverObject).write(dataOutputStream);
    }

    private void fieldChanged(Field field) {
        if (!this._changedFields.contains(field)) {
            this._changedFields.addElement(field);
        }
        if (this.getState() == 102 || this.getState() == 106) {
            this.setState((byte)106);
            return;
        }
        this.setState((byte)101);
    }

    public boolean storesData(int n) throws SQLException {
        return this.getField(n, false).storesData();
    }

    public void closeStream() {
        if (this._stream != null) {
            try {
                this._stream.close();
            }
            catch (Exception exception) {}
            this._stream = null;
        }
    }

    private Field getField(int n, boolean bl) throws SQLException {
        this.checkState(bl);
        this.closeStream();
        this._lastProj = n;
        try {
            return (Field)this._fields.elementAt(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException("Column index is out-of-range: " + n);
        }
        catch (Exception exception) {
            throw new SQLException("Record not initialized.");
        }
    }

    public synchronized boolean isNull(int n) throws SQLException {
        return this.getField(n, false).isNull();
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.isNull(this._lastProj);
    }

    public synchronized void setNotNull(int n) throws SQLException {
        Field field = null;
        try {
            field = (Field)this._fields.elementAt(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException("Column index is out-of-range: " + n);
        }
        catch (Exception exception) {
            throw new SQLException("Record not initialized.");
        }
        field.setNotNull();
    }

    public synchronized String getString(int n) throws SQLException {
        return this.getField(n, false).getString();
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        return this.getField(n, false).getBoolean();
    }

    public synchronized byte getByte(int n) throws SQLException {
        return this.getField(n, false).getByte();
    }

    public synchronized short getShort(int n) throws SQLException {
        return this.getField(n, false).getShort();
    }

    public synchronized int getInt(int n) throws SQLException {
        return this.getField(n, false).getInt();
    }

    public synchronized long getLong(int n) throws SQLException {
        return this.getField(n, false).getLong();
    }

    public synchronized float getFloat(int n) throws SQLException {
        return this.getField(n, false).getFloat();
    }

    public synchronized double getDouble(int n) throws SQLException {
        return this.getField(n, false).getDouble();
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getField(n, false).getBigDecimal(n2);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        return this.getField(n, false).getBytes();
    }

    public synchronized Date getDate(int n) throws SQLException {
        return this.getField(n, false).getDate();
    }

    public synchronized Time getTime(int n) throws SQLException {
        return this.getField(n, false).getTime();
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        return this.getField(n, false).getTimestamp();
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        return this.getField(n, false).getAsciiStream();
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        return this.getField(n, false).getUnicodeStream();
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        return this.getField(n, false).getBinaryStream();
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        Field field = this.getField(n, true);
        field.setNull(n2);
        this.fieldChanged(field);
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        Field field = this.getField(n, true);
        field.setBoolean(bl);
        this.fieldChanged(field);
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        Field field = this.getField(n, true);
        field.setByte(by);
        this.fieldChanged(field);
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        Field field = this.getField(n, true);
        field.setShort(s);
        this.fieldChanged(field);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        Field field = this.getField(n, true);
        field.setInt(n2);
        this.fieldChanged(field);
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        Field field = this.getField(n, true);
        field.setLong(l);
        this.fieldChanged(field);
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        Field field = this.getField(n, true);
        field.setFloat(f);
        this.fieldChanged(field);
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        Field field = this.getField(n, true);
        field.setDouble(d);
        this.fieldChanged(field);
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Field field = this.getField(n, true);
        field.setBigDecimal(bigDecimal);
        this.fieldChanged(field);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        Field field = this.getField(n, true);
        field.setString(string);
        this.fieldChanged(field);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        Field field = this.getField(n, true);
        field.setBytes(byArray);
        this.fieldChanged(field);
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        Field field = this.getField(n, true);
        field.setDate(date);
        this.fieldChanged(field);
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        Field field = this.getField(n, true);
        field.setTime(time);
        this.fieldChanged(field);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        Field field = this.getField(n, true);
        field.setTimestamp(timestamp);
        this.fieldChanged(field);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Field field = this.getField(n, true);
        field.setAsciiStream(inputStream, n2);
        this.fieldChanged(field);
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        Field field = this.getField(n, true);
        field.setUnicodeStream(inputStream, n2);
        this.fieldChanged(field);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Field field = this.getField(n, true);
        field.setBinaryStream(inputStream, n2);
        this.fieldChanged(field);
    }

    public synchronized int getSQLType(int n) throws SQLException {
        Field field = this.getField(n, false);
        return field.getSQLType();
    }

    public synchronized Object getObject(int n) throws SQLException {
        Field field = this.getField(n, false);
        return field.getObject();
    }

    synchronized void setObject(int n, Object object) throws SQLException {
        Field field = this.getField(n, true);
        field.setObject(object);
        this.fieldChanged(field);
    }
}

