/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.EOT;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.Field;
import symantec.itools.db.net.NetClass;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.ServerObject;

public class Param
extends Field {
    Vector _v;

    private NetData getFirstDataBlock() throws SQLException {
        try {
            return (NetData)this._v.elementAt(0);
        }
        catch (Exception exception) {
            throw new SQLException("Data field not initialized");
        }
    }

    public Param(int n, byte[] byArray) {
        this._id = n;
        this._type = 108;
        this._v = new Vector();
        this._v.addElement(new NetData(byArray));
    }

    public Param(int n, byte[] byArray, int n2) {
        this._id = n;
        this._type = 108;
        this._v = new Vector();
        this._v.addElement(new NetData(byArray, n2));
    }

    public Param(int n, short s) {
        this._id = n;
        this._type = 100;
        this._v = new Vector();
        this._v.addElement(new NetData(s));
    }

    public Param(int n, boolean bl) {
        this._id = n;
        this._type = 104;
        this._v = new Vector();
        this._v.addElement(new NetData(bl));
    }

    public Param(int n, int n2) {
        this._id = n;
        this._type = 101;
        this._v = new Vector();
        this._v.addElement(new NetData(n2));
    }

    public Param(int n, int n2, boolean bl) {
        this._id = n;
        this._type = bl ? 107 : 101;
        this._v = new Vector();
        this._v.addElement(new NetData(n2));
    }

    public Param(int n, long l) {
        this._id = n;
        this._type = 103;
        this._v = new Vector();
        this._v.addElement(new NetData(l));
    }

    public Param(int n, float f) {
        this._id = n;
        this._type = 105;
        this._v = new Vector();
        this._v.addElement(new NetData(f));
    }

    public Param(int n, double d) {
        this._id = n;
        this._type = 106;
        this._v = new Vector();
        this._v.addElement(new NetData(d));
    }

    public Param() {
        this._id = 0;
        this._type = 0;
        this._v = new Vector();
    }

    int getType() {
        return 57;
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        dataInputStream.readShort();
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray, 0, 4);
        this._id = dataInputStream.read();
        this._type = dataInputStream.read();
        this._v = new Vector();
        while (true) {
            ServerObject serverObject;
            if ((serverObject = (ServerObject)NetClass.getNextObject(dataInputStream)).getType() == 51) {
                this._v.addElement(serverObject);
                continue;
            }
            if (serverObject.getType() == 50) {
                return;
            }
            this.onObjectError(serverObject);
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        ServerObject serverObject;
        dataOutputStream.writeByte(this.getType());
        dataOutputStream.writeShort(6);
        dataOutputStream.writeBytes("FLD}");
        dataOutputStream.writeByte(this._id);
        dataOutputStream.writeByte(this._type);
        int n = 0;
        while (n < this._v.size()) {
            serverObject = (NetData)this._v.elementAt(n);
            ((NetData)serverObject).write(dataOutputStream);
            ++n;
        }
        serverObject = new EOT();
        ((EOT)serverObject).write(dataOutputStream);
    }
}

