/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetClass;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.Param;
import symantec.itools.db.net.Requester;
import symantec.itools.db.net.ServerList;
import symantec.itools.db.net.ServerObject;
import symantec.itools.db.net.TextParam;

public class RemoteObject
extends Requester {
    Vector _params;
    String _className;
    ServerList _results;
    NetString _reqStr;
    int _ctorID;
    int _mode;
    int _objectID;
    boolean _disabled = false;

    public RemoteObject(String string, int n, ClientSession clientSession) {
        super(clientSession);
        this.setObject(string, n);
    }

    public void setObject(String string, int n) {
        this._className = new String(string);
        this._objectID = n;
    }

    public void disable() {
        this._disabled = true;
    }

    protected void readResults(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        if (this._mode == 2) {
            return;
        }
        ServerObject serverObject = (ServerObject)NetClass.getNextObject(dataInputStream);
        if (this._mode == 0 && serverObject.getType() == 51) {
            try {
                this._ctorID = ((NetData)serverObject).getInt();
                return;
            }
            catch (EOFException eOFException) {
                throw new IOException("Invalid Server Object returned.");
            }
        }
        if (this._mode == 1 && serverObject.getType() == 54) {
            this._results = (ServerList)serverObject;
            return;
        }
        this.onObjectError(serverObject);
    }

    protected void writeRequest(DataOutputStream dataOutputStream) throws IOException {
        this._reqStr.write(dataOutputStream);
        int n = 0;
        while (n < this._params.size()) {
            ServerObject serverObject = (ServerObject)this._params.elementAt(n);
            serverObject.write(dataOutputStream);
            ++n;
        }
    }

    public synchronized int invokeConstructor(int n, Vector vector) throws SQLException {
        if (this._disabled) {
            throw new SQLException("Error: Remote Object closed");
        }
        this._mode = 0;
        this._reqStr = new NetString("proxy" + this._reqDelim + "new" + this._reqDelim + this._className + this._reqDelim + n);
        this._params = vector;
        this.execute();
        return this._ctorID;
    }

    public Vector invokeMethod(int n) throws SQLException {
        return this.invokeMethod(n, new Vector());
    }

    public Vector invokeMethod(int n, int n2) throws SQLException {
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n2));
        return this.invokeMethod(n, vector);
    }

    public Vector invokeMethod(int n, String string) throws SQLException {
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string));
        return this.invokeMethod(n, vector);
    }

    public Vector invokeMethod(int n, boolean bl) throws SQLException {
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, bl));
        return this.invokeMethod(n, vector);
    }

    public synchronized Vector invokeMethod(int n, Vector vector) throws SQLException {
        if (this._disabled) {
            throw new SQLException("Error: Remote Object closed");
        }
        this._mode = 1;
        this._reqStr = new NetString("proxy" + this._reqDelim + "invoke" + this._reqDelim + this._objectID + this._reqDelim + n);
        this._params = vector;
        this.execute();
        return this._results.getObjVector();
    }

    public synchronized void invokeDestructor(int n) throws SQLException {
        if (this._disabled) {
            throw new SQLException("Error: Remote Object closed");
        }
        this._mode = 2;
        this._reqStr = new NetString("proxy" + this._reqDelim + "delete" + this._reqDelim + n);
        this.execute();
    }
}

