/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.EOT;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.ExceptionList;
import symantec.itools.db.net.IO;
import symantec.itools.db.net.MPlex;
import symantec.itools.db.net.NetError;
import symantec.itools.db.net.NetException;
import symantec.itools.db.net.SQLServerConnException;
import symantec.itools.db.net.ServerObject;
import symantec.itools.db.net.SocketIS;

public abstract class Requester {
    String _reqDelim;
    MPlex _mplex;
    IO _io;
    ClientSession _sess;

    public Requester(ClientSession clientSession) {
        if (clientSession != null) {
            this._sess = clientSession;
            this._mplex = this._sess._mplex;
        }
        this._reqDelim = new String(",");
    }

    public ClientSession getSession() {
        return this._sess;
    }

    protected IO getIO() throws NetException, SQLException {
        return this._mplex.getIO();
    }

    protected void releaseIO() {
        this._mplex.releaseIO(this._io);
    }

    protected void onObjectError(ServerObject serverObject) throws SQLException {
        if (serverObject.getType() == 49) {
            throw ((NetError)serverObject).toSQLException();
        }
        if (serverObject.getType() == 68) {
            throw ((ExceptionList)serverObject).getSQLException();
        }
        throw new SQLException("SCALE object stream error.");
    }

    public void execute() throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            try {
                this._io = this.getIO();
            }
            catch (NetException netException) {
                throw new SQLException(netException.getMessage());
            }
            InputStream inputStream = this._io.getInputStream();
            synchronized (inputStream) {
                dataOutputStream.writeByte(56);
                dataOutputStream.writeShort(0);
                this.writeRequest(dataOutputStream);
                EOT eOT = new EOT();
                eOT.write(dataOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray.length > 32768) {
                    dataOutputStream.close();
                    throw new SQLException("Request exceeds max length of " + 32768);
                }
                OutputStream outputStream = this._io.getOutputStream();
                outputStream.write(byArray);
                dataOutputStream.close();
                SocketIS socketIS = (SocketIS)this._io.getInputStream();
                socketIS.reset();
                DataInputStream dataInputStream = new DataInputStream(this._io.getInputStream());
                this.readResults(dataInputStream);
                this.releaseIO();
                return;
            }
        }
        catch (IOException iOException) {
            this._mplex.connectionLost();
            throw new SQLServerConnException();
        }
        catch (ErrorException errorException) {
            throw new SQLException("SCALE Server error");
        }
        catch (NetException netException) {
            throw new SQLException("SCALE net error( " + netException.getMessage() + " )");
        }
    }

    protected abstract void readResults(DataInputStream var1) throws IOException, ErrorException, SQLException;

    protected abstract void writeRequest(DataOutputStream var1) throws IOException;
}

