/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.IO;
import symantec.itools.db.net.NetClass;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetException;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.Requester;
import symantec.itools.db.net.ServerList;
import symantec.itools.db.net.ServerObject;

class SessionRequest
extends Requester {
    int _id;
    Vector _v;
    int _mode;
    int _newPort;
    InetAddress _newHost;
    NetString _reqStr;

    SessionRequest(ClientSession clientSession) {
        super(clientSession);
    }

    protected IO getIO() throws NetException, SQLException {
        if (this._mode == 1) {
            return this._io;
        }
        return super.getIO();
    }

    protected void releaseIO() {
        if (this._mode == 1) {
            return;
        }
        super.releaseIO();
    }

    int connect() throws NetException {
        this._mode = 0;
        this._id = 0;
        this._reqStr = new NetString("session" + this._reqDelim + "connect" + this._reqDelim + 3 + this._reqDelim + 0);
        try {
            this.execute();
            return this._id;
        }
        catch (SQLException sQLException) {
            throw new NetException(sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new NetException("Unable to connect to server.");
        }
    }

    void reconnect(IO iO, int n) throws NetException {
        this._mode = 1;
        this._io = iO;
        this._reqStr = new NetString("session" + this._reqDelim + "reconnect" + this._reqDelim + n);
        try {
            this.execute();
            return;
        }
        catch (Exception exception) {
            throw new NetException("Error reconnecting IO object.");
        }
    }

    void loginPublic(String string, String string2) throws SQLException {
        this._mode = 2;
        this._reqStr = new NetString("session" + this._reqDelim + "loginpublic" + this._reqDelim + string + this._reqDelim + string2);
        this.execute();
    }

    void loginPrivate(String string, String string2, String string3) throws SQLException {
        this._mode = 3;
        this._reqStr = new NetString("session" + this._reqDelim + "loginprivate" + this._reqDelim + string + this._reqDelim + string2 + this._reqDelim + string3);
        this.execute();
    }

    Vector getRepositoryList() throws SQLException {
        this._mode = 4;
        this._v = null;
        this._reqStr = new NetString("session" + this._reqDelim + "getRepList");
        this.execute();
        if (this._v == null) {
            throw new SQLException("Error getting repository list.");
        }
        return this._v;
    }

    void disconnect() {
        this._mode = 5;
        this._reqStr = new NetString("session" + this._reqDelim + "disconnect");
        try {
            this.execute();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void readResults(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        if (this._mode == 5) {
            return;
        }
        ServerObject serverObject = (ServerObject)NetClass.getNextObject(dataInputStream);
        if ((this._mode == 0 || this._mode == 1 || this._mode == 2 || this._mode == 3) && serverObject.getType() == 51) {
            if (this._mode == 0) {
                try {
                    this._id = ((NetData)serverObject).getInt();
                    if (this._id == -2) {
                        ServerObject serverObject2 = (ServerObject)NetClass.getNextObject(dataInputStream);
                        String string = ((NetString)serverObject2).getString();
                        serverObject2 = (ServerObject)NetClass.getNextObject(dataInputStream);
                        this._newPort = ((NetData)serverObject2).getInt();
                        if (!string.equals("")) {
                            this._newHost = InetAddress.getByName(string);
                            return;
                        }
                    }
                }
                catch (EOFException eOFException) {
                    throw new IOException();
                }
            }
            return;
        }
        if (this._mode == 4 && serverObject.getType() == 54) {
            this._v = ((ServerList)serverObject).toStringVector();
            return;
        }
        this.onObjectError(serverObject);
    }

    protected void writeRequest(DataOutputStream dataOutputStream) throws IOException {
        this._reqStr.write(dataOutputStream);
    }

    public InetAddress getNewHost() {
        return this._newHost;
    }

    public int getNewPort() {
        return this._newPort;
    }
}

