/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import symantec.itools.db.net.MPlex;
import symantec.itools.db.net.SQLServerConnException;

public final class SocketIS
extends InputStream {
    private byte[] data;
    private int length;
    private int offset;
    InputStream _istrm;
    byte[] _header;
    int _msgnum;
    boolean bClosed = false;
    MPlex _mplex;

    public SocketIS(InputStream inputStream, MPlex mPlex) throws SQLException {
        this._mplex = mPlex;
        this.length = 0;
        this.offset = 0;
        this._istrm = inputStream;
        this._header = new byte[5];
    }

    public void close() throws IOException {
        this._istrm.close();
        this.bClosed = true;
    }

    public int read() throws IOException {
        if (this.offset >= this.length) {
            try {
                this.data = this.getData();
                this.length = this.data.length;
                if (this.length == 0) {
                    this._istrm.close();
                    this.bClosed = true;
                    return -1;
                }
                this.offset = 0;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
        return this.data[this.offset++] & 0xFF;
    }

    byte[] getData() throws SQLException {
        int n = Short.MAX_VALUE;
        try {
            int n2 = 0;
            int n3 = 0;
            while (n2 < 5 && n3 < 4) {
                n2 += this._istrm.read(this._header, n2, 5 - n2);
                ++n3;
            }
            if (this._header[0] != -69) {
                throw new SQLException("Ivalid Packet header");
            }
            int n4 = this._header[2];
            if (n4 < 0) {
                n4 += 256;
            }
            n4 += (this._header[1] << 8) - 2;
            n = this._header[4];
            if (n < 0) {
                n = (short)(n + 256);
            }
            n = (short)(n + (this._header[3] << 8));
            int n5 = 0;
            byte[] byArray = new byte[n4];
            while (n4 > 0) {
                n2 = this._istrm.read(byArray, n5, n4);
                n4 -= n2;
                n5 += n2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            this._mplex.connectionLost();
            throw new SQLServerConnException();
        }
    }

    public void reset() {
        this.length = 0;
        this.offset = 0;
    }

    public int available() {
        return this.length - this.offset;
    }
}

