/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NumberField;
import symantec.itools.db.net.ServerObject;

class TinyInt
extends NumberField {
    byte _iVal;

    TinyInt() {
    }

    int getType() {
        return 86;
    }

    void readData(ServerObject serverObject) throws SQLException, IOException, ErrorException {
        this._iVal = ((NetData)serverObject).getByte();
    }

    void writeData(DataOutputStream dataOutputStream) throws IOException {
        NetData netData = new NetData(this._iVal);
        netData.write(dataOutputStream);
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this._iVal);
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this._iVal != 0;
    }

    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this._iVal;
    }

    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this._iVal;
    }

    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this._iVal;
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this._iVal;
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this._iVal;
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this._iVal;
    }

    public BigDecimal BigDecimal(int n) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal((double)this._iVal);
        return bigDecimal.setScale(n);
    }

    public void setBoolean(boolean bl) throws SQLException {
        this._iVal = bl ? (byte)1 : 0;
        this._null = false;
    }

    public void setByte(byte by) throws SQLException {
        this._iVal = by;
        this._null = false;
    }

    public void setShort(short s) throws SQLException {
        this._iVal = (byte)s;
        this._null = false;
    }

    public void setInt(int n) throws SQLException {
        this._iVal = (byte)n;
        this._null = false;
    }

    public void setLong(long l) throws SQLException {
        this._iVal = (byte)l;
        this._null = false;
    }

    public void setFloat(float f) throws SQLException {
        this._iVal = (byte)f;
        this._null = false;
    }

    public void setDouble(double d) throws SQLException {
        this._iVal = (byte)d;
        this._null = false;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this._iVal = (byte)bigDecimal.intValue();
        this._null = false;
    }

    public void setString(String string) throws SQLException {
        Integer n = new Integer(string);
        this._iVal = (byte)n.intValue();
        this._null = false;
    }

    public int getSQLType() {
        return -6;
    }

    public Object getObject() throws SQLException {
        return new Integer(this._iVal);
    }

    public void setObject(Object object) throws SQLException {
        this.setInt((Integer)object);
    }
}

