/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.io.EOFException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.RemoteObject;
import symantec.itools.db.pro.ConnectionInfo;
import symantec.itools.db.pro.RecordSet;
import symantec.itools.db.pro.RecordTree;
import symantec.itools.db.pro.RelViewPos;
import symantec.itools.db.pro.RelationView;
import symantec.itools.db.pro.Session;

public class MultiView {
    private RelationView _rootRV;
    private RemoteObject _messgr;
    private byte _rvCurrentID = 0;
    private int _proxyID;
    RecordTree _rootRecord;
    boolean _closed = false;
    private Properties _rootRVCtorProperties;
    Session _session;
    final int METHOD_fetchRecords = 0;
    final int METHOD_OnDataChange = 1;
    final int METHOD_save = 2;
    final int METHOD_isDataChanged = 3;
    final int METHOD_undoChanges = 4;
    final int METHOD_undoRecord = 5;
    final int METHOD_deleteRecord = 6;
    final int METHOD_getNewRecord = 7;
    final int METHOD_close = 8;
    final int METHOD_getStream = 9;
    final int METHOD_restart = 10;

    MultiView(Session session, Vector vector, ConnectionInfo connectionInfo) throws SQLException {
        int n;
        this._session = session;
        this._rootRecord = new RecordTree();
        NetData netData = (NetData)vector.elementAt(0);
        try {
            n = netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
        this._proxyID = n;
        this._messgr = new RemoteObject("CSCLMultiView", n, session.getClientSession());
        if (this._session.isDesignTime()) {
            this._messgr.disable();
        }
        vector.removeElementAt(0);
        this.saveRootRVProperties(session, vector, connectionInfo);
    }

    private void saveRootRVProperties(Session session, Vector vector, ConnectionInfo connectionInfo) {
        this._rootRVCtorProperties = new Properties();
        ((Hashtable)this._rootRVCtorProperties).put("session", session);
        ((Hashtable)this._rootRVCtorProperties).put("ctorParams", vector);
        ((Hashtable)this._rootRVCtorProperties).put("conn", connectionInfo);
        this.getNextLevelID();
    }

    Properties getRootRVCtorProperties() {
        return this._rootRVCtorProperties;
    }

    void setRootRelView(RelationView relationView) {
        this._rootRV = relationView;
    }

    Session getSession() {
        return this._session;
    }

    byte getNextLevelID() {
        byte by = this._rvCurrentID;
        this._rvCurrentID = (byte)(by + 1);
        return by;
    }

    byte getCurrentLevelID() {
        return this._rvCurrentID;
    }

    private void checkClosed() throws SQLException {
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
    }

    void freeRecordBuffer(boolean bl) throws SQLException {
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
        this._rootRecord.freeRecordBlocks();
        this._rootRecord = new RecordTree();
        this.getRootRelView().resetRecordSet(bl);
    }

    public synchronized void close() throws SQLException {
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
        if (!this._session.isDesignTime()) {
            this._messgr.invokeMethod(8);
            this._messgr.disable();
        }
        this.freeRecordBuffer(true);
        this._closed = true;
    }

    public RelationView getRootRelView() throws SQLException {
        if (this._rootRV == null) {
            ConnectionInfo connectionInfo = (ConnectionInfo)((Hashtable)this._rootRVCtorProperties).get("conn");
            this._rootRV = new RelationView(this, 0, connectionInfo);
        }
        return this._rootRV;
    }

    public boolean isDataChanged() throws SQLException {
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
        if (!this.getRootRelView().notifySetData()) {
            return true;
        }
        if (this._session.isDesignTime()) {
            return false;
        }
        Vector vector = this._messgr.invokeMethod(3);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void save() throws SQLException {
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
        if (!this._session.isDesignTime() && this.getRootRelView().notifySetData()) {
            this._messgr.invokeMethod(2);
        }
        this.freeRecordBuffer(false);
    }

    public void restart() throws SQLException {
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
        if (!this._session.isDesignTime()) {
            this._messgr.invokeMethod(10);
        }
        this.freeRecordBuffer(false);
    }

    public void restart(String string) throws SQLException {
        String string2 = string;
        if (string2 == null) {
            string2 = new String();
        }
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
        if (!this._session.isDesignTime()) {
            new Vector(1);
            this._messgr.invokeMethod(10, string2);
        }
        this.freeRecordBuffer(false);
    }

    public void undoDataChanges() throws SQLException {
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
        if (!this._session.isDesignTime()) {
            this._messgr.invokeMethod(4);
        }
        this.freeRecordBuffer(false);
    }

    RecordSet getRecordSet(RelViewPos relViewPos) throws SQLException {
        if (this._closed) {
            throw new SQLException("MultiView has been closed");
        }
        relViewPos.setMVRemObj(this._messgr);
        return this._rootRecord.getRecordSet(relViewPos.reset());
    }
}

