/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import symantec.itools.db.pro.ProjLink;
import symantec.itools.db.pro.RelationView;
import symantec.itools.db.pro.RelationViewMetaData;

public class ProjBinder {
    Vector _links;
    int _id;
    RelationView _rv;
    boolean _inSetDataNotify;
    boolean _enabled;
    boolean _columnIsWriteable;
    public static final int DEFAULTSCALE = 0;
    public static final int SETBLANKTODEFAULT = 0;
    public static final int SETBLANKTONULL = 1;
    public static final int SETBLANKTOEMPTY = 2;

    ProjBinder(int n, RelationView relationView, boolean bl) {
        this._id = n;
        this._rv = relationView;
        this._links = new Vector();
        this._inSetDataNotify = false;
        this._enabled = bl;
        this._columnIsWriteable = true;
        try {
            RelationViewMetaData relationViewMetaData = relationView.getMetaData();
            int n2 = relationViewMetaData.getColumnType(n);
            if (n2 == 1111) {
                this._columnIsWriteable = false;
                return;
            }
        }
        catch (SQLException sQLException) {
            this._columnIsWriteable = false;
        }
    }

    void addLink(ProjLink projLink) {
        if (!this._links.contains(projLink)) {
            this._links.addElement(projLink);
        }
    }

    boolean bindsExist() {
        return this._links.size() > 0;
    }

    void removeLink(Object object) {
        this._links.removeElement(object);
    }

    void removeAllLinks() {
        this._links.removeAllElements();
    }

    void notifyDataChange() {
        if (this._enabled && !this._inSetDataNotify) {
            int n = 0;
            while (n < this._links.size()) {
                ProjLink projLink = (ProjLink)this._links.elementAt(n);
                projLink.notifyDataChange(this);
                ++n;
            }
        }
    }

    boolean notifySetData() throws SQLException {
        boolean bl = true;
        if (this._enabled) {
            this._inSetDataNotify = true;
            int n = 0;
            while (n < this._links.size()) {
                ProjLink projLink = (ProjLink)this._links.elementAt(n);
                if (!projLink.notifySetData(this)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            this._inSetDataNotify = false;
        }
        return bl;
    }

    void enable(boolean bl) {
        if (!this._rv.getSession().isDesignTime()) {
            this._enabled = bl;
        }
    }

    public boolean isWritable() throws SQLException {
        return this._rv.isCurrentRecordWritable() && this._columnIsWriteable;
    }

    public boolean isReadable() throws SQLException {
        return this._rv.isCurrentRecordReadable();
    }

    public String getColumnName() throws SQLException {
        if (!this._rv.getSession().isDesignTime()) {
            RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
            return relationViewMetaData.getColumnName(this._id);
        }
        return new String();
    }

    public RelationView getRelationView() throws SQLException {
        return this._rv;
    }

    public boolean isNull() throws SQLException {
        return this._rv.isNull(this._id);
    }

    public String getString() throws SQLException {
        return this._rv.getString(this._id);
    }

    public boolean getBoolean() throws SQLException {
        return this._rv.getBoolean(this._id);
    }

    public byte getByte() throws SQLException {
        return this._rv.getByte(this._id);
    }

    public short getShort() throws SQLException {
        return this._rv.getShort(this._id);
    }

    public int getInt() throws SQLException {
        return this._rv.getInt(this._id);
    }

    public long getLong() throws SQLException {
        return this._rv.getLong(this._id);
    }

    public float getFloat() throws SQLException {
        return this._rv.getFloat(this._id);
    }

    public double getDouble() throws SQLException {
        return this._rv.getDouble(this._id);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this._rv.getBigDecimal(this._id, n);
    }

    public byte[] getBytes() throws SQLException {
        return this._rv.getBytes(this._id);
    }

    public Date getDate() throws SQLException {
        return this._rv.getDate(this._id);
    }

    public Time getTime() throws SQLException {
        return this._rv.getTime(this._id);
    }

    public Timestamp getTimestamp() throws SQLException {
        return this._rv.getTimestamp(this._id);
    }

    public InputStream getAsciiStream() throws SQLException {
        return this._rv.getAsciiStream(this._id);
    }

    public InputStream getUnicodeStream() throws SQLException {
        return this._rv.getUnicodeStream(this._id);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this._rv.getBinaryStream(this._id);
    }

    public String getStringValue(int n) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n2 = relationViewMetaData.getColumnType(this._id);
        return this.getStringValue(n2, n, false);
    }

    public String getStringValue(int n, boolean bl) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n2 = relationViewMetaData.getColumnType(this._id);
        return this.getStringValue(n2, n, bl);
    }

    public String getStringValue() throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n = relationViewMetaData.getColumnType(this._id);
        return this.getStringValue(n, 0, false);
    }

    public String getStringValue(boolean bl) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n = relationViewMetaData.getColumnType(this._id);
        return this.getStringValue(n, 0, bl);
    }

    public String getStringValue(String string, int n) throws SQLException, IOException {
        int n2 = RelationView.sqlTypeConvert(string);
        return this.getStringValue(n2, n, false);
    }

    public String getStringValue(String string, int n, boolean bl) throws SQLException, IOException {
        int n2 = RelationView.sqlTypeConvert(string);
        return this.getStringValue(n2, n, bl);
    }

    public String getStringValue(int n, int n2) throws SQLException, IOException {
        return this.getStringValue(n, n2, false);
    }

    public String getStringValue(int n, int n2, boolean bl) throws SQLException, IOException {
        Object object;
        int n3 = n2;
        if (n2 == 0) {
            object = this._rv.getMetaData();
            n2 = ((RelationViewMetaData)object).getScale(this._id);
            n3 = ((RelationViewMetaData)object).getColumnDisplaySize(this._id);
        }
        object = "";
        if (!this.isNull()) {
            switch (n) {
                case -7: {
                    object = String.valueOf(this.getBoolean());
                    break;
                }
                case -6: {
                    object = String.valueOf(this.getShort());
                    break;
                }
                case 5: {
                    object = String.valueOf(this.getShort());
                    break;
                }
                case 4: {
                    object = String.valueOf(this.getInt());
                    break;
                }
                case -5: {
                    object = String.valueOf(this.getLong());
                    break;
                }
                case 6: {
                    object = this.getString();
                    break;
                }
                case 7: {
                    object = this.getString();
                    break;
                }
                case 8: {
                    object = this.getString();
                    break;
                }
                case 2: {
                    BigDecimal bigDecimal = this.getBigDecimal(n2);
                    if (bigDecimal == null) break;
                    object = String.valueOf(bigDecimal);
                    break;
                }
                case 3: {
                    BigDecimal bigDecimal = this.getBigDecimal(n2);
                    if (bigDecimal == null) break;
                    object = String.valueOf(bigDecimal);
                    break;
                }
                case 1: {
                    object = this.getString();
                    break;
                }
                case 12: {
                    object = this.getString();
                    break;
                }
                case -1: {
                    object = this.getString();
                    break;
                }
                case 91: {
                    Date date = this.getDate();
                    if (date == null) break;
                    object = date.toString();
                    break;
                }
                case 92: {
                    Time time = this.getTime();
                    if (time == null) break;
                    object = time.toString();
                    break;
                }
                case 93: {
                    Timestamp timestamp = this.getTimestamp();
                    if (timestamp == null) break;
                    object = timestamp.toString();
                    break;
                }
                case -2: {
                    if (bl) {
                        byte[] byArray = new byte[n3];
                        byArray = this.getBytes();
                        object = RelationView.binaryArraytoString(byArray);
                        break;
                    }
                    object = "<Binary Data>";
                    break;
                }
                case -3: {
                    if (bl) {
                        byte[] byArray = new byte[n3];
                        byArray = this.getBytes();
                        object = RelationView.binaryArraytoString(byArray);
                        break;
                    }
                    object = "<Binary Data>";
                    break;
                }
                case -4: {
                    if (bl) {
                        InputStream inputStream = this.getBinaryStream();
                        object = RelationView.binaryStreamtoString(inputStream, 0);
                        break;
                    }
                    object = "<Binary Data>";
                    break;
                }
                case 1111: {
                    if (bl) {
                        InputStream inputStream = this.getUnicodeStream();
                        object = RelationView.binaryStreamtoString(inputStream, 0);
                        break;
                    }
                    object = "<Other Data Type>";
                    break;
                }
                case 0: {
                    object = "";
                    break;
                }
                default: {
                    object = this.getString();
                }
            }
        }
        return object;
    }

    public void setNull(int n) throws SQLException {
        this._rv.setNull(this._id, n);
    }

    public void setBoolean(boolean bl) throws SQLException {
        this._rv.setBoolean(this._id, bl);
    }

    public void setByte(byte by) throws SQLException {
        this._rv.setByte(this._id, by);
    }

    public void setShort(short s) throws SQLException {
        this._rv.setShort(this._id, s);
    }

    public void setInt(int n) throws SQLException {
        this._rv.setInt(this._id, n);
    }

    public void setLong(long l) throws SQLException {
        this._rv.setLong(this._id, l);
    }

    public void setFloat(float f) throws SQLException {
        this._rv.setFloat(this._id, f);
    }

    public void setDouble(double d) throws SQLException {
        this._rv.setDouble(this._id, d);
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this._rv.setBigDecimal(this._id, bigDecimal);
    }

    public void setString(String string) throws SQLException {
        this._rv.setString(this._id, string);
    }

    public void setBytes(byte[] byArray) throws SQLException {
        this._rv.setBytes(this._id, byArray);
    }

    public void setDate(Date date) throws SQLException {
        this._rv.setDate(this._id, date);
    }

    public void setTime(Time time) throws SQLException {
        this._rv.setTime(this._id, time);
    }

    public void setTimestamp(Timestamp timestamp) throws SQLException {
        this._rv.setTimestamp(this._id, timestamp);
    }

    public void setAsciiStream(InputStream inputStream, int n) throws SQLException {
        this._rv.setAsciiStream(this._id, inputStream, n);
    }

    public void setUnicodeStream(InputStream inputStream, int n) throws SQLException {
        this._rv.setUnicodeStream(this._id, inputStream, n);
    }

    public void setBinaryStream(InputStream inputStream, int n) throws SQLException {
        this._rv.setBinaryStream(this._id, inputStream, n);
    }

    public void setValueFromString(String string, int n, int n2) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n3 = relationViewMetaData.getColumnType(this._id);
        this.setValueFromString(string, n3, n, n2);
    }

    public void setValueFromString(String string) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n = relationViewMetaData.getColumnType(this._id);
        this.setValueFromString(string, n, 0, 0);
    }

    public void setValueFromString(String string, int n) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n2 = relationViewMetaData.getColumnType(this._id);
        this.setValueFromString(string, n2, 0, n);
    }

    public void setValueFromString(String string, String string2, int n) throws SQLException, IOException {
        int n2 = RelationView.sqlTypeConvert(string2);
        this.setValueFromString(string, n2, n, 0);
    }

    public void setValueFromString(String string, String string2, int n, int n2) throws SQLException, IOException {
        int n3 = RelationView.sqlTypeConvert(string2);
        this.setValueFromString(string, n3, n, n2);
    }

    public void setValueFromString(String string, int n, int n2, int n3) throws SQLException, IOException {
        if ((string == null || string.compareTo("") == 0) && (string = RelationView.processEmptyStringData(string, this._rv, this._id, n, n3)) == null) {
            this.setNull(n);
            return;
        }
        switch (n) {
            case -7: {
                boolean bl = new Boolean(string);
                this.setBoolean(bl);
                return;
            }
            case -6: {
                short s = (short)Integer.valueOf(string).intValue();
                this.setShort(s);
                return;
            }
            case 5: {
                short s = (short)Integer.valueOf(string).intValue();
                this.setShort(s);
                return;
            }
            case 4: {
                int n4 = Integer.valueOf(string);
                this.setInt(n4);
                return;
            }
            case -5: {
                long l = Long.valueOf(string);
                this.setFloat(l);
                return;
            }
            case 6: {
                this.setString(string);
                return;
            }
            case 7: {
                this.setString(string);
                return;
            }
            case 8: {
                this.setString(string);
                return;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = new BigDecimal(string);
                if (n2 == 0) {
                    this.setBigDecimal(bigDecimal);
                    return;
                }
                this.setBigDecimal(bigDecimal.setScale(n2));
                return;
            }
            case 1: {
                this.setString(string);
                return;
            }
            case 12: {
                this.setString(string);
                return;
            }
            case -1: {
                StringBufferInputStream stringBufferInputStream;
                int n5 = string.length();
                StringBufferInputStream stringBufferInputStream2 = stringBufferInputStream = new StringBufferInputStream(string);
                this.setAsciiStream(stringBufferInputStream2, n5);
                return;
            }
            case 91: {
                Date date = null;
                date = Date.valueOf(string);
                this.setDate(date);
                return;
            }
            case 92: {
                Time time = null;
                time = Time.valueOf(string);
                this.setTime(time);
                return;
            }
            case 93: {
                Timestamp timestamp = null;
                timestamp = Timestamp.valueOf(string);
                this.setTimestamp(timestamp);
                return;
            }
            case -2: {
                byte[] byArray = new byte[string.length()];
                string.getBytes(0, string.length(), byArray, 0);
                this.setBytes(byArray);
                return;
            }
            case -3: {
                byte[] byArray = new byte[string.length()];
                string.getBytes(0, string.length(), byArray, 0);
                this.setBytes(byArray);
                return;
            }
            case -4: {
                StringBufferInputStream stringBufferInputStream;
                int n6 = string.length();
                StringBufferInputStream stringBufferInputStream3 = stringBufferInputStream = new StringBufferInputStream(string);
                this.setBinaryStream(stringBufferInputStream3, n6);
                return;
            }
            case 1111: {
                StringBufferInputStream stringBufferInputStream;
                int n7 = string.length();
                StringBufferInputStream stringBufferInputStream4 = stringBufferInputStream = new StringBufferInputStream(string);
                this.setBinaryStream(stringBufferInputStream4, n7);
                return;
            }
            case 0: {
                this.setNull(n);
                return;
            }
        }
        this.setString(string);
    }
}

